/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;

@InterfaceAudience.Private
public class DefaultCompactor
extends Compactor {
    private static final Log LOG = LogFactory.getLog(DefaultCompactor.class);

    public DefaultCompactor(Configuration conf, Store store) {
        super(conf, store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Path> compact(CompactionRequest request) throws IOException {
        IOException e;
        ArrayList<Path> newFiles;
        StoreFile.Writer writer;
        List<StoreFile> readersToClose;
        Compactor.FileDetails fd;
        block47: {
            boolean finished;
            InternalScanner scanner;
            boolean cleanSeqId;
            long smallestReadPoint;
            block45: {
                ArrayList<Path> arrayList;
                block46: {
                    List<StoreFileScanner> scanners;
                    fd = this.getFileDetails(request.getFiles(), request.isAllFiles());
                    this.progress = new CompactionProgress(fd.maxKeyCount);
                    smallestReadPoint = this.getSmallestReadPoint();
                    if (this.conf.getBoolean("hbase.regionserver.compaction.private.readers", false)) {
                        readersToClose = new ArrayList(request.getFiles().size());
                        for (StoreFile f : request.getFiles()) {
                            readersToClose.add(new StoreFile(f));
                        }
                        scanners = this.createFileScanners(readersToClose, smallestReadPoint);
                    } else {
                        readersToClose = Collections.emptyList();
                        scanners = this.createFileScanners(request.getFiles(), smallestReadPoint);
                    }
                    writer = null;
                    newFiles = new ArrayList<Path>();
                    cleanSeqId = false;
                    e = null;
                    scanner = null;
                    ScanType scanType = request.isRetainDeleteMarkers() ? ScanType.COMPACT_RETAIN_DELETES : ScanType.COMPACT_DROP_DELETES;
                    scanner = this.preCreateCoprocScanner(request, scanType, fd.earliestPutTs, scanners);
                    if (scanner == null) {
                        scanner = this.createScanner(this.store, scanners, scanType, smallestReadPoint, fd.earliestPutTs);
                    }
                    if ((scanner = this.postCreateCoprocScanner(request, scanType, scanner)) != null) break block45;
                    arrayList = newFiles;
                    if (scanner == null) break block46;
                    scanner.close();
                }
                try {
                    if (writer == null) return arrayList;
                    if (e != null) {
                        writer.close();
                        return arrayList;
                    } else {
                        writer.appendMetadata(fd.maxSeqId, request.isAllFiles());
                        writer.close();
                        newFiles.add(writer.getPath());
                    }
                    return arrayList;
                }
                finally {
                    for (StoreFile f : readersToClose) {
                        try {
                            f.closeReader(true);
                        }
                        catch (IOException ioe) {
                            LOG.warn((Object)("Exception closing " + f), (Throwable)ioe);
                        }
                    }
                }
            }
            if (fd.minSeqIdToKeep > 0L) {
                smallestReadPoint = Math.min(fd.minSeqIdToKeep, smallestReadPoint);
                cleanSeqId = true;
            }
            if (!(finished = this.performCompaction(fd, scanner, writer = this.createTmpWriter(fd, smallestReadPoint), smallestReadPoint, cleanSeqId, request.isAllFiles()))) {
                writer.close();
                this.store.getFileSystem().delete(writer.getPath(), false);
                writer = null;
                throw new InterruptedIOException("Aborting compaction of store " + this.store + " in region " + this.store.getRegionInfo().getRegionNameAsString() + " because it was interrupted.");
            }
            break block47;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        try {
            if (writer == null) return newFiles;
            if (e != null) {
                writer.close();
                return newFiles;
            }
            writer.appendMetadata(fd.maxSeqId, request.isAllFiles());
            writer.close();
            newFiles.add(writer.getPath());
            return newFiles;
        }
        finally {
            for (StoreFile f : readersToClose) {
                try {
                    f.closeReader(true);
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("Exception closing " + f), (Throwable)ioe);
                }
            }
        }
        catch (IOException ioe) {
            try {
                e = ioe;
                throw ioe;
            }
            catch (Throwable throwable) {
                try {
                    if (writer == null) throw throwable;
                    if (e != null) {
                        writer.close();
                        throw throwable;
                    } else {
                        writer.appendMetadata(fd.maxSeqId, request.isAllFiles());
                        writer.close();
                        newFiles.add(writer.getPath());
                    }
                    throw throwable;
                }
                finally {
                    for (StoreFile f : readersToClose) {
                        try {
                            f.closeReader(true);
                        }
                        catch (IOException ioe2) {
                            LOG.warn((Object)("Exception closing " + f), (Throwable)ioe2);
                        }
                    }
                }
            }
        }
    }

    protected StoreFile.Writer createTmpWriter(Compactor.FileDetails fd, long smallestReadPoint) throws IOException {
        StoreFile.Writer writer = this.store.createWriterInTmp(fd.maxKeyCount, this.compactionCompression, true, fd.maxMVCCReadpoint >= smallestReadPoint, fd.maxTagsLength > 0);
        return writer;
    }

    public List<Path> compactForTesting(Collection<StoreFile> filesToCompact, boolean isMajor) throws IOException {
        CompactionRequest cr = new CompactionRequest(filesToCompact);
        cr.setIsMajor(isMajor, isMajor);
        return this.compact(cr);
    }
}

