/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coordination.CloseRegionCoordination;
import org.apache.hadoop.hbase.coordination.OpenRegionCoordination;
import org.apache.hadoop.hbase.exceptions.FailedSanityCheckException;
import org.apache.hadoop.hbase.exceptions.MergeRegionException;
import org.apache.hadoop.hbase.exceptions.OperationConflictException;
import org.apache.hadoop.hbase.exceptions.OutOfOrderScannerNextException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.HBaseRPCErrorHandler;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcCallContext;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.quotas.OperationQuota;
import org.apache.hadoop.hbase.quotas.RegionServerQuotaManager;
import org.apache.hadoop.hbase.regionserver.AnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.LeaseException;
import org.apache.hadoop.hbase.regionserver.LeaseListener;
import org.apache.hadoop.hbase.regionserver.Leases;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.RegionAlreadyInTransitionException;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.regionserver.RpcSchedulerFactory;
import org.apache.hadoop.hbase.regionserver.SimpleRpcSchedulerFactory;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.handler.OpenMetaHandler;
import org.apache.hadoop.hbase.regionserver.handler.OpenRegionHandler;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Counter;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.hadoop.net.DNS;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class RSRpcServices
implements HBaseRPCErrorHandler,
AdminProtos.AdminService.BlockingInterface,
ClientProtos.ClientService.BlockingInterface,
PriorityFunction {
    protected static final Log LOG = LogFactory.getLog(RSRpcServices.class);
    public static final String REGION_SERVER_RPC_SCHEDULER_FACTORY_CLASS = "hbase.region.server.rpc.scheduler.factory.class";
    final Counter requestCount = new Counter();
    final RpcServerInterface rpcServer;
    final InetSocketAddress isa;
    private final HRegionServer regionServer;
    private final long maxScannerResultSize;
    private final PriorityFunction priority;
    private final AtomicLong scannerIdGen = new AtomicLong(0L);
    private final ConcurrentHashMap<String, RegionScannerHolder> scanners = new ConcurrentHashMap();
    private final int scannerLeaseTimeoutPeriod;

    private static ClientProtos.ResultOrException getResultOrException(ClientProtos.Result r, int index, ClientProtos.RegionLoadStats stats) {
        return RSRpcServices.getResultOrException(ResponseConverter.buildActionResult((ClientProtos.Result)r, (ClientProtos.RegionLoadStats)stats), index);
    }

    private static ClientProtos.ResultOrException getResultOrException(Exception e, int index) {
        return RSRpcServices.getResultOrException(ResponseConverter.buildActionResult((Throwable)e), index);
    }

    private static ClientProtos.ResultOrException getResultOrException(ClientProtos.ResultOrException.Builder builder, int index) {
        return builder.setIndex(index).build();
    }

    private long startNonceOperation(ClientProtos.MutationProto mutation, long nonceGroup) throws IOException, OperationConflictException {
        if (this.regionServer.nonceManager == null || !mutation.hasNonce()) {
            return 0L;
        }
        boolean canProceed = false;
        try {
            canProceed = this.regionServer.nonceManager.startOperation(nonceGroup, mutation.getNonce(), this.regionServer);
        }
        catch (InterruptedException ex) {
            throw new InterruptedIOException("Nonce start operation interrupted");
        }
        if (!canProceed) {
            String message = "The operation with nonce {" + nonceGroup + ", " + mutation.getNonce() + "} on row [" + Bytes.toString((byte[])mutation.getRow().toByteArray()) + "] may have already completed";
            throw new OperationConflictException(message);
        }
        return mutation.getNonce();
    }

    private void endNonceOperation(ClientProtos.MutationProto mutation, long nonceGroup, boolean success) {
        if (this.regionServer.nonceManager != null && mutation.hasNonce()) {
            this.regionServer.nonceManager.endOperation(nonceGroup, mutation.getNonce(), success);
        }
    }

    private boolean isClientCellBlockSupport() {
        RpcCallContext context = RpcServer.getCurrentCall();
        return context != null && context.isClientCellBlockSupport();
    }

    private void addResult(ClientProtos.MutateResponse.Builder builder, Result result, PayloadCarryingRpcController rpcc) {
        if (result == null) {
            return;
        }
        if (this.isClientCellBlockSupport()) {
            builder.setResult(ProtobufUtil.toResultNoData((Result)result));
            rpcc.setCellScanner(result.cellScanner());
        } else {
            ClientProtos.Result pbr = ProtobufUtil.toResult((Result)result);
            builder.setResult(pbr);
        }
    }

    private void addResults(ClientProtos.ScanResponse.Builder builder, List<Result> results, RpcController controller, boolean isDefaultRegion) {
        builder.setStale(!isDefaultRegion);
        if (results == null || results.isEmpty()) {
            return;
        }
        if (this.isClientCellBlockSupport()) {
            for (Result res : results) {
                builder.addCellsPerResult(res.size());
            }
            ((PayloadCarryingRpcController)controller).setCellScanner(CellUtil.createCellScanner(results));
        } else {
            for (Result res : results) {
                ClientProtos.Result pbr = ProtobufUtil.toResult((Result)res);
                builder.addResults(pbr);
            }
        }
    }

    private ClientProtos.RegionLoadStats mutateRows(HRegion region, List<ClientProtos.Action> actions, CellScanner cellScanner) throws IOException {
        if (!region.getRegionInfo().isMetaTable()) {
            this.regionServer.cacheFlusher.reclaimMemStoreMemory();
        }
        RowMutations rm = null;
        block4: for (ClientProtos.Action action : actions) {
            if (action.hasGet()) {
                throw new DoNotRetryIOException("Atomic put and/or delete only, not a Get=" + action.getGet());
            }
            ClientProtos.MutationProto.MutationType type = action.getMutation().getMutateType();
            if (rm == null) {
                rm = new RowMutations(action.getMutation().getRow().toByteArray());
            }
            switch (type) {
                case PUT: {
                    rm.add(ProtobufUtil.toPut((ClientProtos.MutationProto)action.getMutation(), (CellScanner)cellScanner));
                    continue block4;
                }
                case DELETE: {
                    rm.add(ProtobufUtil.toDelete((ClientProtos.MutationProto)action.getMutation(), (CellScanner)cellScanner));
                    continue block4;
                }
            }
            throw new DoNotRetryIOException("Atomic put and/or delete only, not " + type.name());
        }
        region.mutateRow(rm);
        return region.getRegionStats();
    }

    private boolean checkAndRowMutate(HRegion region, List<ClientProtos.Action> actions, CellScanner cellScanner, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator) throws IOException {
        if (!region.getRegionInfo().isMetaTable()) {
            this.regionServer.cacheFlusher.reclaimMemStoreMemory();
        }
        RowMutations rm = null;
        block4: for (ClientProtos.Action action : actions) {
            if (action.hasGet()) {
                throw new DoNotRetryIOException("Atomic put and/or delete only, not a Get=" + action.getGet());
            }
            ClientProtos.MutationProto.MutationType type = action.getMutation().getMutateType();
            if (rm == null) {
                rm = new RowMutations(action.getMutation().getRow().toByteArray());
            }
            switch (type) {
                case PUT: {
                    rm.add(ProtobufUtil.toPut((ClientProtos.MutationProto)action.getMutation(), (CellScanner)cellScanner));
                    continue block4;
                }
                case DELETE: {
                    rm.add(ProtobufUtil.toDelete((ClientProtos.MutationProto)action.getMutation(), (CellScanner)cellScanner));
                    continue block4;
                }
            }
            throw new DoNotRetryIOException("Atomic put and/or delete only, not " + type.name());
        }
        return region.checkAndRowMutate(row, family, qualifier, compareOp, comparator, rm, Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result append(HRegion region, OperationQuota quota, ClientProtos.MutationProto m, CellScanner cellScanner, long nonceGroup) throws IOException {
        long before = EnvironmentEdgeManager.currentTime();
        Append append = ProtobufUtil.toAppend((ClientProtos.MutationProto)m, (CellScanner)cellScanner);
        quota.addMutation((Mutation)append);
        Result r = null;
        if (region.getCoprocessorHost() != null) {
            r = region.getCoprocessorHost().preAppend(append);
        }
        if (r == null) {
            long nonce = this.startNonceOperation(m, nonceGroup);
            boolean success = false;
            try {
                r = region.append(append, nonceGroup, nonce);
                success = true;
            }
            finally {
                this.endNonceOperation(m, nonceGroup, success);
            }
            if (region.getCoprocessorHost() != null) {
                region.getCoprocessorHost().postAppend(append, r);
            }
        }
        if (this.regionServer.metricsRegionServer != null) {
            this.regionServer.metricsRegionServer.updateAppend(EnvironmentEdgeManager.currentTime() - before);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result increment(HRegion region, OperationQuota quota, ClientProtos.MutationProto mutation, CellScanner cells, long nonceGroup) throws IOException {
        long before = EnvironmentEdgeManager.currentTime();
        Increment increment = ProtobufUtil.toIncrement((ClientProtos.MutationProto)mutation, (CellScanner)cells);
        quota.addMutation((Mutation)increment);
        Result r = null;
        if (region.getCoprocessorHost() != null) {
            r = region.getCoprocessorHost().preIncrement(increment);
        }
        if (r == null) {
            long nonce = this.startNonceOperation(mutation, nonceGroup);
            boolean success = false;
            try {
                r = region.increment(increment, nonceGroup, nonce);
                success = true;
            }
            finally {
                this.endNonceOperation(mutation, nonceGroup, success);
            }
            if (region.getCoprocessorHost() != null) {
                r = region.getCoprocessorHost().postIncrement(increment, r);
            }
        }
        if (this.regionServer.metricsRegionServer != null) {
            this.regionServer.metricsRegionServer.updateIncrement(EnvironmentEdgeManager.currentTime() - before);
        }
        return r;
    }

    private List<CellScannable> doNonAtomicRegionMutation(HRegion region, OperationQuota quota, ClientProtos.RegionAction actions, CellScanner cellScanner, ClientProtos.RegionActionResult.Builder builder, List<CellScannable> cellsToReturn, long nonceGroup) {
        ArrayList<ClientProtos.Action> mutations = null;
        for (ClientProtos.Action action : actions.getActionList()) {
            ClientProtos.ResultOrException.Builder resultOrExceptionBuilder = null;
            try {
                Result r = null;
                if (action.hasGet()) {
                    Get get = ProtobufUtil.toGet((ClientProtos.Get)action.getGet());
                    r = region.get(get);
                } else if (action.hasServiceCall()) {
                    resultOrExceptionBuilder = ClientProtos.ResultOrException.newBuilder();
                    try {
                        Message result = this.execServiceOnRegion(region, action.getServiceCall());
                        ClientProtos.CoprocessorServiceResult.Builder serviceResultBuilder = ClientProtos.CoprocessorServiceResult.newBuilder();
                        resultOrExceptionBuilder.setServiceResult(serviceResultBuilder.setValue(serviceResultBuilder.getValueBuilder().setName(result.getClass().getName()).setValue(result.toByteString())));
                    }
                    catch (IOException ioe) {
                        resultOrExceptionBuilder.setException(ResponseConverter.buildException((Throwable)ioe));
                    }
                } else if (action.hasMutation()) {
                    ClientProtos.MutationProto.MutationType type = action.getMutation().getMutateType();
                    if (type != ClientProtos.MutationProto.MutationType.PUT && type != ClientProtos.MutationProto.MutationType.DELETE && mutations != null && !mutations.isEmpty()) {
                        this.doBatchOp(builder, region, quota, mutations, cellScanner);
                        mutations.clear();
                    }
                    switch (type) {
                        case APPEND: {
                            r = this.append(region, quota, action.getMutation(), cellScanner, nonceGroup);
                            break;
                        }
                        case INCREMENT: {
                            r = this.increment(region, quota, action.getMutation(), cellScanner, nonceGroup);
                            break;
                        }
                        case PUT: 
                        case DELETE: {
                            if (mutations == null) {
                                mutations = new ArrayList<ClientProtos.Action>(actions.getActionCount());
                            }
                            mutations.add(action);
                            break;
                        }
                        default: {
                            throw new DoNotRetryIOException("Unsupported mutate type: " + type.name());
                        }
                    }
                } else {
                    throw new HBaseIOException("Unexpected Action type");
                }
                if (r != null) {
                    ClientProtos.Result pbResult = null;
                    if (this.isClientCellBlockSupport()) {
                        pbResult = ProtobufUtil.toResultNoData((Result)r);
                        if (cellsToReturn == null) {
                            cellsToReturn = new ArrayList<CellScannable>();
                        }
                        cellsToReturn.add((CellScannable)r);
                    } else {
                        pbResult = ProtobufUtil.toResult((Result)r);
                    }
                    resultOrExceptionBuilder = ClientProtos.ResultOrException.newBuilder().setResult(pbResult);
                }
            }
            catch (IOException ie) {
                resultOrExceptionBuilder = ClientProtos.ResultOrException.newBuilder().setException(ResponseConverter.buildException((Throwable)ie));
            }
            if (resultOrExceptionBuilder == null) continue;
            resultOrExceptionBuilder.setIndex(action.getIndex());
            builder.addResultOrException(resultOrExceptionBuilder.build());
        }
        if (mutations != null && !mutations.isEmpty()) {
            this.doBatchOp(builder, region, quota, (List<ClientProtos.Action>)mutations, cellScanner);
        }
        return cellsToReturn;
    }

    private void doBatchOp(ClientProtos.RegionActionResult.Builder builder, HRegion region, OperationQuota quota, List<ClientProtos.Action> mutations, CellScanner cells) {
        Mutation[] mArray = new Mutation[mutations.size()];
        long before = EnvironmentEdgeManager.currentTime();
        boolean batchContainsPuts = false;
        boolean batchContainsDelete = false;
        try {
            int i = 0;
            for (ClientProtos.Action action : mutations) {
                Put mutation;
                ClientProtos.MutationProto m = action.getMutation();
                if (m.getMutateType() == ClientProtos.MutationProto.MutationType.PUT) {
                    mutation = ProtobufUtil.toPut((ClientProtos.MutationProto)m, (CellScanner)cells);
                    batchContainsPuts = true;
                } else {
                    mutation = ProtobufUtil.toDelete((ClientProtos.MutationProto)m, (CellScanner)cells);
                    batchContainsDelete = true;
                }
                mArray[i++] = mutation;
                quota.addMutation((Mutation)mutation);
            }
            if (!region.getRegionInfo().isMetaTable()) {
                this.regionServer.cacheFlusher.reclaimMemStoreMemory();
            }
            OperationStatus[] codes = region.batchMutate(mArray);
            block8: for (i = 0; i < codes.length; ++i) {
                int index = mutations.get(i).getIndex();
                NoSuchColumnFamilyException e = null;
                switch (codes[i].getOperationStatusCode()) {
                    case BAD_FAMILY: {
                        e = new NoSuchColumnFamilyException(codes[i].getExceptionMsg());
                        builder.addResultOrException(RSRpcServices.getResultOrException((Exception)e, index));
                        continue block8;
                    }
                    case SANITY_CHECK_FAILURE: {
                        e = new FailedSanityCheckException(codes[i].getExceptionMsg());
                        builder.addResultOrException(RSRpcServices.getResultOrException((Exception)e, index));
                        continue block8;
                    }
                    default: {
                        e = new DoNotRetryIOException(codes[i].getExceptionMsg());
                        builder.addResultOrException(RSRpcServices.getResultOrException((Exception)e, index));
                        continue block8;
                    }
                    case SUCCESS: {
                        builder.addResultOrException(RSRpcServices.getResultOrException(ClientProtos.Result.getDefaultInstance(), index, region.getRegionStats()));
                    }
                }
            }
        }
        catch (IOException ie) {
            for (int i = 0; i < mutations.size(); ++i) {
                builder.addResultOrException(RSRpcServices.getResultOrException(ie, mutations.get(i).getIndex()));
            }
        }
        if (this.regionServer.metricsRegionServer != null) {
            long after = EnvironmentEdgeManager.currentTime();
            if (batchContainsPuts) {
                this.regionServer.metricsRegionServer.updatePut(after - before);
            }
            if (batchContainsDelete) {
                this.regionServer.metricsRegionServer.updateDelete(after - before);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus[] doReplayBatchOp(HRegion region, List<WALSplitter.MutationReplay> mutations, long replaySeqId) throws IOException {
        long before = EnvironmentEdgeManager.currentTime();
        boolean batchContainsPuts = false;
        boolean batchContainsDelete = false;
        try {
            Iterator<WALSplitter.MutationReplay> it = mutations.iterator();
            while (it.hasNext()) {
                NavigableMap map;
                List metaCells;
                WALSplitter.MutationReplay m = it.next();
                if (m.type == ClientProtos.MutationProto.MutationType.PUT) {
                    batchContainsPuts = true;
                } else {
                    batchContainsDelete = true;
                }
                if ((metaCells = (List)(map = m.mutation.getFamilyCellMap()).get(WALEdit.METAFAMILY)) == null || metaCells.isEmpty()) continue;
                for (Cell metaCell : metaCells) {
                    WALProtos.CompactionDescriptor compactionDesc = WALEdit.getCompaction(metaCell);
                    boolean isDefaultReplica = RegionReplicaUtil.isDefaultReplica((HRegionInfo)region.getRegionInfo());
                    if (compactionDesc != null) {
                        region.replayWALCompactionMarker(compactionDesc, !isDefaultReplica, isDefaultReplica, replaySeqId);
                        continue;
                    }
                    WALProtos.FlushDescriptor flushDesc = WALEdit.getFlushDescriptor(metaCell);
                    if (flushDesc != null && !isDefaultReplica) {
                        region.replayWALFlushMarker(flushDesc);
                        continue;
                    }
                    WALProtos.RegionEventDescriptor regionEvent = WALEdit.getRegionEventDescriptor(metaCell);
                    if (regionEvent != null && !isDefaultReplica) {
                        region.replayWALRegionEventMarker(regionEvent);
                        continue;
                    }
                    WALProtos.BulkLoadDescriptor bulkLoadEvent = WALEdit.getBulkLoadDescriptor(metaCell);
                    if (bulkLoadEvent == null) continue;
                    region.replayWALBulkLoadEventMarker(bulkLoadEvent);
                }
                it.remove();
            }
            this.requestCount.add((long)mutations.size());
            if (!region.getRegionInfo().isMetaTable()) {
                this.regionServer.cacheFlusher.reclaimMemStoreMemory();
            }
            OperationStatus[] operationStatusArray = region.batchReplay(mutations.toArray(new WALSplitter.MutationReplay[mutations.size()]), replaySeqId);
            return operationStatusArray;
        }
        finally {
            if (this.regionServer.metricsRegionServer != null) {
                long after = EnvironmentEdgeManager.currentTime();
                if (batchContainsPuts) {
                    this.regionServer.metricsRegionServer.updatePut(after - before);
                }
                if (batchContainsDelete) {
                    this.regionServer.metricsRegionServer.updateDelete(after - before);
                }
            }
        }
    }

    private void closeAllScanners() {
        for (Map.Entry<String, RegionScannerHolder> e : this.scanners.entrySet()) {
            try {
                e.getValue().s.close();
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Closing scanner " + e.getKey()), (Throwable)ioe);
            }
        }
    }

    public RSRpcServices(HRegionServer rs) throws IOException {
        InetSocketAddress bindAddress;
        InetSocketAddress initialIsa;
        String hostname;
        RpcSchedulerFactory rpcSchedulerFactory;
        this.regionServer = rs;
        try {
            Class rpcSchedulerFactoryClass = rs.conf.getClass(REGION_SERVER_RPC_SCHEDULER_FACTORY_CLASS, SimpleRpcSchedulerFactory.class);
            rpcSchedulerFactory = (RpcSchedulerFactory)rpcSchedulerFactoryClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        if (this instanceof MasterRpcServices) {
            hostname = RSRpcServices.getHostname(rs.conf, true);
            int port = rs.conf.getInt("hbase.master.port", 60000);
            initialIsa = new InetSocketAddress(hostname, port);
            bindAddress = new InetSocketAddress(rs.conf.get("hbase.master.ipc.address", hostname), port);
        } else {
            hostname = RSRpcServices.getHostname(rs.conf, false);
            int port = rs.conf.getInt("hbase.regionserver.port", 60020);
            initialIsa = new InetSocketAddress(hostname, port);
            bindAddress = new InetSocketAddress(rs.conf.get("hbase.regionserver.ipc.address", hostname), port);
        }
        if (initialIsa.getAddress() == null) {
            throw new IllegalArgumentException("Failed resolve of " + initialIsa);
        }
        this.priority = new AnnotationReadingPriorityFunction(this);
        String name = rs.getProcessName() + "/" + initialIsa.toString();
        ConnectionUtils.setServerSideHConnectionRetriesConfig((Configuration)rs.conf, (String)name, (Log)LOG);
        this.rpcServer = new RpcServer(rs, name, this.getServices(), bindAddress, rs.conf, rpcSchedulerFactory.create(rs.conf, this, rs));
        this.scannerLeaseTimeoutPeriod = rs.conf.getInt("hbase.client.scanner.timeout.period", 60000);
        this.maxScannerResultSize = rs.conf.getLong("hbase.client.scanner.max.result.size", 0x200000L);
        this.isa = new InetSocketAddress(initialIsa.getHostName(), this.rpcServer.getListenerAddress().getPort());
        this.rpcServer.setErrorHandler(this);
        rs.setName(name);
    }

    public static String getHostname(Configuration conf, boolean isMaster) throws UnknownHostException {
        String masterOrRS = isMaster ? "master" : "regionserver";
        return Strings.domainNamePointerToHostName((String)DNS.getDefaultHost((String)conf.get("hbase." + masterOrRS + ".dns.interface", "default"), (String)conf.get("hbase." + masterOrRS + ".dns.nameserver", "default")));
    }

    RegionScanner getScanner(long scannerId) {
        String scannerIdString = Long.toString(scannerId);
        RegionScannerHolder scannerHolder = this.scanners.get(scannerIdString);
        if (scannerHolder != null) {
            return scannerHolder.s;
        }
        return null;
    }

    long getScannerVirtualTime(long scannerId) {
        String scannerIdString = Long.toString(scannerId);
        RegionScannerHolder scannerHolder = this.scanners.get(scannerIdString);
        if (scannerHolder != null) {
            return scannerHolder.nextCallSeq;
        }
        return 0L;
    }

    long addScanner(RegionScanner s, HRegion r) throws Leases.LeaseStillHeldException {
        long scannerId = this.scannerIdGen.incrementAndGet();
        String scannerName = String.valueOf(scannerId);
        RegionScannerHolder existing = this.scanners.putIfAbsent(scannerName, new RegionScannerHolder(s, r));
        assert (existing == null) : "scannerId must be unique within regionserver's whole lifecycle!";
        this.regionServer.leases.createLease(scannerName, this.scannerLeaseTimeoutPeriod, new ScannerListener(scannerName));
        return scannerId;
    }

    HRegion getRegion(HBaseProtos.RegionSpecifier regionSpecifier) throws IOException {
        return this.regionServer.getRegionByEncodedName(regionSpecifier.getValue().toByteArray(), ProtobufUtil.getRegionEncodedName((HBaseProtos.RegionSpecifier)regionSpecifier));
    }

    PriorityFunction getPriority() {
        return this.priority;
    }

    Configuration getConfiguration() {
        return this.regionServer.getConfiguration();
    }

    private RegionServerQuotaManager getQuotaManager() {
        return this.regionServer.getRegionServerQuotaManager();
    }

    void start() {
        this.rpcServer.start();
    }

    void stop() {
        this.closeAllScanners();
        this.rpcServer.stop();
    }

    protected void checkOpen() throws IOException {
        if (this.regionServer.isStopped() || this.regionServer.isAborted()) {
            throw new RegionServerStoppedException("Server " + this.regionServer.serverName + " not running" + (this.regionServer.isAborted() ? ", aborting" : ""));
        }
        if (!this.regionServer.fsOk) {
            throw new RegionServerStoppedException("File system not available");
        }
        if (!this.regionServer.isOnline()) {
            throw new ServerNotRunningYetException("Server is not running yet");
        }
    }

    protected List<RpcServer.BlockingServiceAndInterface> getServices() {
        ArrayList<RpcServer.BlockingServiceAndInterface> bssi = new ArrayList<RpcServer.BlockingServiceAndInterface>(2);
        bssi.add(new RpcServer.BlockingServiceAndInterface(ClientProtos.ClientService.newReflectiveBlockingService((ClientProtos.ClientService.BlockingInterface)this), ClientProtos.ClientService.BlockingInterface.class));
        bssi.add(new RpcServer.BlockingServiceAndInterface(AdminProtos.AdminService.newReflectiveBlockingService((AdminProtos.AdminService.BlockingInterface)this), AdminProtos.AdminService.BlockingInterface.class));
        return bssi;
    }

    public InetSocketAddress getSocketAddress() {
        return this.isa;
    }

    @Override
    public int getPriority(RPCProtos.RequestHeader header, Message param) {
        return this.priority.getPriority(header, param);
    }

    @Override
    public long getDeadline(RPCProtos.RequestHeader header, Message param) {
        return this.priority.getDeadline(header, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkOOME(Throwable e) {
        boolean stop = false;
        try {
            if (e instanceof OutOfMemoryError || e.getCause() != null && e.getCause() instanceof OutOfMemoryError || e.getMessage() != null && e.getMessage().contains("java.lang.OutOfMemoryError")) {
                stop = true;
                LOG.fatal((Object)("Run out of memory; " + this.getClass().getSimpleName() + " will abort itself immediately"), e);
            }
        }
        finally {
            if (stop) {
                Runtime.getRuntime().halt(1);
            }
        }
        return stop;
    }

    @QosPriority(priority=100)
    public AdminProtos.CloseRegionResponse closeRegion(RpcController controller, AdminProtos.CloseRegionRequest request) throws ServiceException {
        ServerName sn = request.hasDestinationServer() ? ProtobufUtil.toServerName((HBaseProtos.ServerName)request.getDestinationServer()) : null;
        try {
            String encodedRegionName;
            HRegion region;
            this.checkOpen();
            if (request.hasServerStartCode()) {
                long serverStartCode = request.getServerStartCode();
                if (this.regionServer.serverName.getStartcode() != serverStartCode) {
                    throw new ServiceException((Throwable)new DoNotRetryIOException("This RPC was intended for a different server with startCode: " + serverStartCode + ", this server is: " + this.regionServer.serverName));
                }
            }
            if ((region = this.regionServer.getFromOnlineRegions(encodedRegionName = ProtobufUtil.getRegionEncodedName((HBaseProtos.RegionSpecifier)request.getRegion()))) != null && region.getCoprocessorHost() != null) {
                region.getCoprocessorHost().preClose(false);
            }
            this.requestCount.increment();
            LOG.info((Object)("Close " + encodedRegionName + ", moving to " + sn));
            CloseRegionCoordination.CloseRegionDetails crd = this.regionServer.getCoordinatedStateManager().getCloseRegionCoordination().parseFromProtoRequest(request);
            boolean closed = this.regionServer.closeRegion(encodedRegionName, false, crd, sn);
            AdminProtos.CloseRegionResponse.Builder builder = AdminProtos.CloseRegionResponse.newBuilder().setClosed(closed);
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.CompactRegionResponse compactRegion(RpcController controller, AdminProtos.CompactRegionRequest request) throws ServiceException {
        try {
            String familyLogMsg;
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            region.startRegionOperation(HRegion.Operation.COMPACT_REGION);
            LOG.info((Object)("Compacting " + region.getRegionNameAsString()));
            boolean major = false;
            byte[] family = null;
            Store store = null;
            if (request.hasFamily() && (store = region.getStore(family = request.getFamily().toByteArray())) == null) {
                throw new ServiceException((Throwable)new IOException("column family " + Bytes.toString((byte[])family) + " does not exist in region " + region.getRegionNameAsString()));
            }
            if (request.hasMajor()) {
                major = request.getMajor();
            }
            if (major) {
                if (family != null) {
                    store.triggerMajorCompaction();
                } else {
                    region.triggerMajorCompaction();
                }
            }
            String string = familyLogMsg = family != null ? " for column family: " + Bytes.toString((byte[])family) : "";
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("User-triggered compaction requested for region " + region.getRegionNameAsString() + familyLogMsg));
            }
            String log = "User-triggered " + (major ? "major " : "") + "compaction" + familyLogMsg;
            if (family != null) {
                this.regionServer.compactSplitThread.requestCompaction(region, store, log, 1, null);
            } else {
                this.regionServer.compactSplitThread.requestCompaction(region, log, 1, null);
            }
            return AdminProtos.CompactRegionResponse.newBuilder().build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.FlushRegionResponse flushRegion(RpcController controller, AdminProtos.FlushRegionRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            LOG.info((Object)("Flushing " + region.getRegionNameAsString()));
            boolean shouldFlush = true;
            if (request.hasIfOlderThanTs()) {
                shouldFlush = region.getEarliestFlushTimeForAllStores() < request.getIfOlderThanTs();
            }
            AdminProtos.FlushRegionResponse.Builder builder = AdminProtos.FlushRegionResponse.newBuilder();
            if (shouldFlush) {
                boolean result;
                long startTime = EnvironmentEdgeManager.currentTime();
                HRegion.FlushResult flushResult = region.flushcache();
                if (flushResult.isFlushSucceeded()) {
                    long endTime = EnvironmentEdgeManager.currentTime();
                    this.regionServer.metricsRegionServer.updateFlushTime(endTime - startTime);
                }
                if (result = flushResult.isCompactionNeeded()) {
                    this.regionServer.compactSplitThread.requestSystemCompaction(region, "Compaction through user triggered flush");
                }
                builder.setFlushed(result);
            }
            builder.setLastFlushTime(region.getEarliestFlushTimeForAllStores());
            return builder.build();
        }
        catch (DroppedSnapshotException ex) {
            this.regionServer.abort("Replay of WAL required. Forcing server shutdown", ex);
            throw new ServiceException((Throwable)ex);
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.GetOnlineRegionResponse getOnlineRegion(RpcController controller, AdminProtos.GetOnlineRegionRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            Map<String, HRegion> onlineRegions = this.regionServer.onlineRegions;
            ArrayList<HRegionInfo> list = new ArrayList<HRegionInfo>(onlineRegions.size());
            for (HRegion region : onlineRegions.values()) {
                list.add(region.getRegionInfo());
            }
            Collections.sort(list);
            return ResponseConverter.buildGetOnlineRegionResponse(list);
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.GetRegionInfoResponse getRegionInfo(RpcController controller, AdminProtos.GetRegionInfoRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            HRegionInfo info = region.getRegionInfo();
            AdminProtos.GetRegionInfoResponse.Builder builder = AdminProtos.GetRegionInfoResponse.newBuilder();
            builder.setRegionInfo(HRegionInfo.convert((HRegionInfo)info));
            if (request.hasCompactionState() && request.getCompactionState()) {
                builder.setCompactionState(region.getCompactionState());
            }
            builder.setIsRecovering(region.isRecovering());
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.GetServerInfoResponse getServerInfo(RpcController controller, AdminProtos.GetServerInfoRequest request) throws ServiceException {
        try {
            this.checkOpen();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        this.requestCount.increment();
        int infoPort = this.regionServer.infoServer != null ? this.regionServer.infoServer.getPort() : -1;
        return ResponseConverter.buildGetServerInfoResponse((ServerName)this.regionServer.serverName, (int)infoPort);
    }

    @QosPriority(priority=100)
    public AdminProtos.GetStoreFileResponse getStoreFile(RpcController controller, AdminProtos.GetStoreFileRequest request) throws ServiceException {
        try {
            Set<byte[]> columnFamilies;
            this.checkOpen();
            HRegion region = this.getRegion(request.getRegion());
            this.requestCount.increment();
            if (request.getFamilyCount() == 0) {
                columnFamilies = region.getStores().keySet();
            } else {
                columnFamilies = new TreeSet<byte[]>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
                for (ByteString cf : request.getFamilyList()) {
                    columnFamilies.add(cf.toByteArray());
                }
            }
            int nCF = columnFamilies.size();
            List<String> fileList = region.getStoreFileList((byte[][])columnFamilies.toArray((T[])new byte[nCF][]));
            AdminProtos.GetStoreFileResponse.Builder builder = AdminProtos.GetStoreFileResponse.newBuilder();
            builder.addAllStoreFile(fileList);
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.MergeRegionsResponse mergeRegions(RpcController controller, AdminProtos.MergeRegionsRequest request) throws ServiceException {
        try {
            long endTime;
            this.checkOpen();
            this.requestCount.increment();
            HRegion regionA = this.getRegion(request.getRegionA());
            HRegion regionB = this.getRegion(request.getRegionB());
            boolean forcible = request.getForcible();
            regionA.startRegionOperation(HRegion.Operation.MERGE_REGION);
            regionB.startRegionOperation(HRegion.Operation.MERGE_REGION);
            if (regionA.getRegionInfo().getReplicaId() != 0 || regionB.getRegionInfo().getReplicaId() != 0) {
                throw new ServiceException((Throwable)new MergeRegionException("Can't merge non-default replicas"));
            }
            LOG.info((Object)("Receiving merging request for  " + regionA + ", " + regionB + ",forcible=" + forcible));
            long startTime = EnvironmentEdgeManager.currentTime();
            HRegion.FlushResult flushResult = regionA.flushcache();
            if (flushResult.isFlushSucceeded()) {
                endTime = EnvironmentEdgeManager.currentTime();
                this.regionServer.metricsRegionServer.updateFlushTime(endTime - startTime);
            }
            startTime = EnvironmentEdgeManager.currentTime();
            flushResult = regionB.flushcache();
            if (flushResult.isFlushSucceeded()) {
                endTime = EnvironmentEdgeManager.currentTime();
                this.regionServer.metricsRegionServer.updateFlushTime(endTime - startTime);
            }
            this.regionServer.compactSplitThread.requestRegionsMerge(regionA, regionB, forcible);
            return AdminProtos.MergeRegionsResponse.newBuilder().build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @QosPriority(priority=100)
    public AdminProtos.OpenRegionResponse openRegion(RpcController controller, AdminProtos.OpenRegionRequest request) throws ServiceException {
        this.requestCount.increment();
        if (request.hasServerStartCode()) {
            long serverStartCode = request.getServerStartCode();
            if (this.regionServer.serverName.getStartcode() != serverStartCode) {
                throw new ServiceException((Throwable)new DoNotRetryIOException("This RPC was intended for a different server with startCode: " + serverStartCode + ", this server is: " + this.regionServer.serverName));
            }
        }
        AdminProtos.OpenRegionResponse.Builder builder = AdminProtos.OpenRegionResponse.newBuilder();
        int regionCount = request.getOpenInfoCount();
        HashMap<TableName, HTableDescriptor> htds = new HashMap<TableName, HTableDescriptor>(regionCount);
        boolean isBulkAssign = regionCount > 1;
        try {
            this.checkOpen();
        }
        catch (IOException ie) {
            HBaseProtos.RegionInfo ri;
            TableName tableName = null;
            if (regionCount == 1 && (ri = request.getOpenInfo(0).getRegion()) != null) {
                tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)ri.getTableName());
            }
            if (!TableName.META_TABLE_NAME.equals(tableName)) {
                throw new ServiceException((Throwable)ie);
            }
            int timeout = this.regionServer.conf.getInt("hbase.rpc.timeout", 60000) >> 2;
            long endTime = System.currentTimeMillis() + (long)timeout;
            AtomicBoolean atomicBoolean = this.regionServer.online;
            synchronized (atomicBoolean) {
                try {
                    while (System.currentTimeMillis() <= endTime && !this.regionServer.isStopped() && !this.regionServer.isOnline()) {
                        this.regionServer.online.wait(this.regionServer.msgInterval);
                    }
                    this.checkOpen();
                }
                catch (InterruptedException t) {
                    Thread.currentThread().interrupt();
                    throw new ServiceException((Throwable)t);
                }
                catch (IOException e) {
                    throw new ServiceException((Throwable)e);
                }
            }
        }
        for (AdminProtos.OpenRegionRequest.RegionOpenInfo regionOpenInfo : request.getOpenInfoList()) {
            HRegionInfo region = HRegionInfo.convert((HBaseProtos.RegionInfo)regionOpenInfo.getRegion());
            OpenRegionCoordination coordination = this.regionServer.getCoordinatedStateManager().getOpenRegionCoordination();
            OpenRegionCoordination.OpenRegionDetails ord = coordination.parseFromProtoRequest(regionOpenInfo);
            try {
                Boolean previous;
                HRegion onlineRegion = this.regionServer.getFromOnlineRegions(region.getEncodedName());
                if (onlineRegion != null) {
                    Pair p;
                    if (onlineRegion.getCoprocessorHost() != null) {
                        onlineRegion.getCoprocessorHost().preOpen();
                    }
                    if (this.regionServer.serverName.equals((p = MetaTableAccessor.getRegion((Connection)this.regionServer.getConnection(), (byte[])region.getRegionName())).getSecond())) {
                        Boolean closing = (Boolean)this.regionServer.regionsInTransitionInRS.get(region.getEncodedNameAsBytes());
                        if (!Boolean.FALSE.equals(closing) && this.regionServer.getFromOnlineRegions(region.getEncodedName()) != null) {
                            LOG.warn((Object)("Attempted open of " + region.getEncodedName() + " but already online on this server"));
                            builder.addOpeningState(AdminProtos.OpenRegionResponse.RegionOpeningState.ALREADY_OPENED);
                            continue;
                        }
                    } else {
                        LOG.warn((Object)("The region " + region.getEncodedName() + " is online on this server" + " but hbase:meta does not have this server - continue opening."));
                        this.regionServer.removeFromOnlineRegions(onlineRegion, null);
                    }
                }
                LOG.info((Object)("Open " + region.getRegionNameAsString()));
                HTableDescriptor htd = (HTableDescriptor)htds.get(region.getTable());
                if (htd == null) {
                    htd = this.regionServer.tableDescriptors.get(region.getTable());
                    htds.put(region.getTable(), htd);
                }
                if (Boolean.FALSE.equals(previous = this.regionServer.regionsInTransitionInRS.putIfAbsent(region.getEncodedNameAsBytes(), Boolean.TRUE))) {
                    coordination.tryTransitionFromOfflineToFailedOpen(this.regionServer, region, ord);
                    throw new RegionAlreadyInTransitionException("Received OPEN for the region:" + region.getRegionNameAsString() + " , which we are already trying to CLOSE ");
                }
                if (Boolean.TRUE.equals(previous)) {
                    LOG.info((Object)("Receiving OPEN for the region:" + region.getRegionNameAsString() + " , which we are already trying to OPEN" + " - ignoring this new request for this region."));
                }
                this.regionServer.removeFromMovedRegions(region.getEncodedName());
                if (previous == null) {
                    if (ZKSplitLog.isRegionMarkedRecoveringInZK(this.regionServer.getZooKeeper(), region.getEncodedName())) {
                        if (!regionOpenInfo.hasOpenForDistributedLogReplay() || regionOpenInfo.getOpenForDistributedLogReplay()) {
                            this.regionServer.recoveringRegions.put(region.getEncodedName(), null);
                        } else {
                            ArrayList<String> tmpRegions = new ArrayList<String>();
                            tmpRegions.add(region.getEncodedName());
                            ZKSplitLog.deleteRecoveringRegionZNodes(this.regionServer.getZooKeeper(), tmpRegions);
                        }
                    }
                    if (region.isMetaRegion()) {
                        this.regionServer.service.submit(new OpenMetaHandler(this.regionServer, this.regionServer, region, htd, coordination, ord));
                    } else {
                        this.regionServer.updateRegionFavoredNodesMapping(region.getEncodedName(), regionOpenInfo.getFavoredNodesList());
                        this.regionServer.service.submit(new OpenRegionHandler(this.regionServer, this.regionServer, region, htd, coordination, ord));
                    }
                }
                builder.addOpeningState(AdminProtos.OpenRegionResponse.RegionOpeningState.OPENED);
            }
            catch (KeeperException zooKeeperEx) {
                LOG.error((Object)"Can't retrieve recovering state from zookeeper", (Throwable)zooKeeperEx);
                throw new ServiceException((Throwable)zooKeeperEx);
            }
            catch (IOException ie) {
                LOG.warn((Object)("Failed opening region " + region.getRegionNameAsString()), (Throwable)ie);
                if (isBulkAssign) {
                    builder.addOpeningState(AdminProtos.OpenRegionResponse.RegionOpeningState.FAILED_OPENING);
                    continue;
                }
                throw new ServiceException((Throwable)ie);
            }
        }
        return builder.build();
    }

    @QosPriority(priority=6)
    public AdminProtos.ReplicateWALEntryResponse replay(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
        long before = EnvironmentEdgeManager.currentTime();
        CellScanner cells = ((PayloadCarryingRpcController)controller).cellScanner();
        try {
            this.checkOpen();
            List entries = request.getEntryList();
            if (entries == null || entries.isEmpty()) {
                AdminProtos.ReplicateWALEntryResponse replicateWALEntryResponse = AdminProtos.ReplicateWALEntryResponse.newBuilder().build();
                return replicateWALEntryResponse;
            }
            ByteString regionName = ((AdminProtos.WALEntry)entries.get(0)).getKey().getEncodedRegionName();
            HRegion region = this.regionServer.getRegionByEncodedName(regionName.toStringUtf8());
            RegionCoprocessorHost coprocessorHost = ServerRegionReplicaUtil.isDefaultReplica((HRegionInfo)region.getRegionInfo()) ? region.getCoprocessorHost() : null;
            ArrayList<Pair> walEntries = new ArrayList<Pair>();
            boolean isPrimary = RegionReplicaUtil.isDefaultReplica((HRegionInfo)region.getRegionInfo());
            Durability durability = isPrimary ? Durability.USE_DEFAULT : Durability.SKIP_WAL;
            for (AdminProtos.WALEntry entry : entries) {
                if (!regionName.equals((Object)entry.getKey().getEncodedRegionName())) {
                    throw new NotServingRegionException("Replay request contains entries from multiple regions. First region:" + regionName.toStringUtf8() + " , other region:" + entry.getKey().getEncodedRegionName());
                }
                if (this.regionServer.nonceManager != null) {
                    long nonceGroup = entry.getKey().hasNonceGroup() ? entry.getKey().getNonceGroup() : 0L;
                    long nonce = entry.getKey().hasNonce() ? entry.getKey().getNonce() : 0L;
                    this.regionServer.nonceManager.reportOperationFromWal(nonceGroup, nonce, entry.getKey().getWriteTime());
                }
                Pair walEntry = coprocessorHost == null ? null : new Pair();
                List<WALSplitter.MutationReplay> edits = WALSplitter.getMutationsFromWALEntry(entry, cells, (Pair<WALKey, WALEdit>)walEntry, durability);
                if (coprocessorHost != null) {
                    if (coprocessorHost.preWALRestore(region.getRegionInfo(), (WALKey)walEntry.getFirst(), (WALEdit)walEntry.getSecond())) continue;
                    walEntries.add(walEntry);
                }
                if (edits == null || edits.isEmpty()) continue;
                long replaySeqId = entry.getKey().hasOrigSequenceNumber() ? entry.getKey().getOrigSequenceNumber() : entry.getKey().getLogSequenceNumber();
                OperationStatus[] result = this.doReplayBatchOp(region, edits, replaySeqId);
                for (int i = 0; result != null && i < result.length; ++i) {
                    if (result[i] == OperationStatus.SUCCESS) continue;
                    throw new IOException(result[i].getExceptionMsg());
                }
            }
            region.syncWal();
            if (coprocessorHost != null) {
                for (Pair wal : walEntries) {
                    coprocessorHost.postWALRestore(region.getRegionInfo(), (WALKey)wal.getFirst(), (WALEdit)wal.getSecond());
                }
            }
            AdminProtos.ReplicateWALEntryResponse replicateWALEntryResponse = AdminProtos.ReplicateWALEntryResponse.newBuilder().build();
            return replicateWALEntryResponse;
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        finally {
            if (this.regionServer.metricsRegionServer != null) {
                this.regionServer.metricsRegionServer.updateReplay(EnvironmentEdgeManager.currentTime() - before);
            }
        }
    }

    @QosPriority(priority=5)
    public AdminProtos.ReplicateWALEntryResponse replicateWALEntry(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
        try {
            if (this.regionServer.replicationSinkHandler != null) {
                this.checkOpen();
                this.requestCount.increment();
                List entries = request.getEntryList();
                CellScanner cellScanner = ((PayloadCarryingRpcController)controller).cellScanner();
                this.regionServer.getRegionServerCoprocessorHost().preReplicateLogEntries(entries, cellScanner);
                this.regionServer.replicationSinkHandler.replicateLogEntries(entries, cellScanner);
                this.regionServer.getRegionServerCoprocessorHost().postReplicateLogEntries(entries, cellScanner);
            }
            return AdminProtos.ReplicateWALEntryResponse.newBuilder().build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    public AdminProtos.RollWALWriterResponse rollWALWriter(RpcController controller, AdminProtos.RollWALWriterRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            this.regionServer.getRegionServerCoprocessorHost().preRollWALWriterRequest();
            this.regionServer.walRoller.requestRollAll();
            this.regionServer.getRegionServerCoprocessorHost().postRollWALWriterRequest();
            AdminProtos.RollWALWriterResponse.Builder builder = AdminProtos.RollWALWriterResponse.newBuilder();
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.SplitRegionResponse splitRegion(RpcController controller, AdminProtos.SplitRegionRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            region.startRegionOperation(HRegion.Operation.SPLIT_REGION);
            if (region.getRegionInfo().getReplicaId() != 0) {
                throw new IOException("Can't split replicas directly. Replicas are auto-split when their primary is split.");
            }
            LOG.info((Object)("Splitting " + region.getRegionNameAsString()));
            long startTime = EnvironmentEdgeManager.currentTime();
            HRegion.FlushResult flushResult = region.flushcache();
            if (flushResult.isFlushSucceeded()) {
                long endTime = EnvironmentEdgeManager.currentTime();
                this.regionServer.metricsRegionServer.updateFlushTime(endTime - startTime);
            }
            byte[] splitPoint = null;
            if (request.hasSplitPoint()) {
                splitPoint = request.getSplitPoint().toByteArray();
            }
            region.forceSplit(splitPoint);
            this.regionServer.compactSplitThread.requestSplit(region, region.checkSplit());
            return AdminProtos.SplitRegionResponse.newBuilder().build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.StopServerResponse stopServer(RpcController controller, AdminProtos.StopServerRequest request) throws ServiceException {
        this.requestCount.increment();
        String reason = request.getReason();
        this.regionServer.stop(reason);
        return AdminProtos.StopServerResponse.newBuilder().build();
    }

    public AdminProtos.UpdateFavoredNodesResponse updateFavoredNodes(RpcController controller, AdminProtos.UpdateFavoredNodesRequest request) throws ServiceException {
        List openInfoList = request.getUpdateInfoList();
        AdminProtos.UpdateFavoredNodesResponse.Builder respBuilder = AdminProtos.UpdateFavoredNodesResponse.newBuilder();
        for (AdminProtos.UpdateFavoredNodesRequest.RegionUpdateInfo regionUpdateInfo : openInfoList) {
            HRegionInfo hri = HRegionInfo.convert((HBaseProtos.RegionInfo)regionUpdateInfo.getRegion());
            this.regionServer.updateRegionFavoredNodesMapping(hri.getEncodedName(), regionUpdateInfo.getFavoredNodesList());
        }
        respBuilder.setResponse(openInfoList.size());
        return respBuilder.build();
    }

    public ClientProtos.BulkLoadHFileResponse bulkLoadHFile(RpcController controller, ClientProtos.BulkLoadHFileRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            ArrayList<Pair<byte[], String>> familyPaths = new ArrayList<Pair<byte[], String>>();
            for (ClientProtos.BulkLoadHFileRequest.FamilyPath familyPath : request.getFamilyPathList()) {
                familyPaths.add((Pair<byte[], String>)new Pair((Object)familyPath.getFamily().toByteArray(), (Object)familyPath.getPath()));
            }
            boolean bypass = false;
            if (region.getCoprocessorHost() != null) {
                bypass = region.getCoprocessorHost().preBulkLoadHFile(familyPaths);
            }
            boolean loaded = false;
            if (!bypass) {
                loaded = region.bulkLoadHFiles(familyPaths, request.getAssignSeqNum());
            }
            if (region.getCoprocessorHost() != null) {
                loaded = region.getCoprocessorHost().postBulkLoadHFile(familyPaths, loaded);
            }
            ClientProtos.BulkLoadHFileResponse.Builder builder = ClientProtos.BulkLoadHFileResponse.newBuilder();
            builder.setLoaded(loaded);
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    public ClientProtos.CoprocessorServiceResponse execService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            Message result = this.execServiceOnRegion(region, request.getCall());
            ClientProtos.CoprocessorServiceResponse.Builder builder = ClientProtos.CoprocessorServiceResponse.newBuilder();
            builder.setRegion(RequestConverter.buildRegionSpecifier((HBaseProtos.RegionSpecifier.RegionSpecifierType)HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, (byte[])region.getRegionName()));
            builder.setValue(builder.getValueBuilder().setName(result.getClass().getName()).setValue(result.toByteString()));
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    private Message execServiceOnRegion(HRegion region, ClientProtos.CoprocessorServiceCall serviceCall) throws IOException {
        ServerRpcController execController = new ServerRpcController();
        Message result = region.execService((RpcController)execController, serviceCall);
        if (execController.getFailedOn() != null) {
            throw execController.getFailedOn();
        }
        return result;
    }

    public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
        long before = EnvironmentEdgeManager.currentTime();
        OperationQuota quota = null;
        try {
            ClientProtos.Result pbr;
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            ClientProtos.GetResponse.Builder builder = ClientProtos.GetResponse.newBuilder();
            ClientProtos.Get get = request.getGet();
            Boolean existence = null;
            Result r = null;
            quota = this.getQuotaManager().checkQuota(region, OperationQuota.OperationType.GET);
            if (get.hasClosestRowBefore() && get.getClosestRowBefore()) {
                if (get.getColumnCount() != 1) {
                    throw new DoNotRetryIOException("get ClosestRowBefore supports one and only one family now, not " + get.getColumnCount() + " families");
                }
                byte[] row = get.getRow().toByteArray();
                byte[] family = get.getColumn(0).getFamily().toByteArray();
                r = region.getClosestRowBefore(row, family);
            } else {
                Get clientGet = ProtobufUtil.toGet((ClientProtos.Get)get);
                if (get.getExistenceOnly() && region.getCoprocessorHost() != null) {
                    existence = region.getCoprocessorHost().preExists(clientGet);
                }
                if (existence == null) {
                    r = region.get(clientGet);
                    if (get.getExistenceOnly()) {
                        boolean exists = r.getExists();
                        if (region.getCoprocessorHost() != null) {
                            exists = region.getCoprocessorHost().postExists(clientGet, exists);
                        }
                        existence = exists;
                    }
                }
            }
            if (existence != null) {
                pbr = ProtobufUtil.toResult((boolean)existence, (region.getRegionInfo().getReplicaId() != 0 ? 1 : 0) != 0);
                builder.setResult(pbr);
            } else if (r != null) {
                pbr = ProtobufUtil.toResult((Result)r);
                builder.setResult(pbr);
            }
            if (r != null) {
                quota.addGetResult(r);
            }
            ClientProtos.GetResponse getResponse = builder.build();
            return getResponse;
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        finally {
            if (this.regionServer.metricsRegionServer != null) {
                this.regionServer.metricsRegionServer.updateGet(EnvironmentEdgeManager.currentTime() - before);
            }
            if (quota != null) {
                quota.close();
            }
        }
    }

    public ClientProtos.MultiResponse multi(RpcController rpcc, ClientProtos.MultiRequest request) throws ServiceException {
        CellScanner cellScanner;
        try {
            this.checkOpen();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        PayloadCarryingRpcController controller = (PayloadCarryingRpcController)rpcc;
        CellScanner cellScanner2 = cellScanner = controller != null ? controller.cellScanner() : null;
        if (controller != null) {
            controller.setCellScanner(null);
        }
        long nonceGroup = request.hasNonceGroup() ? request.getNonceGroup() : 0L;
        List<CellScannable> cellsToReturn = null;
        ClientProtos.MultiResponse.Builder responseBuilder = ClientProtos.MultiResponse.newBuilder();
        ClientProtos.RegionActionResult.Builder regionActionResultBuilder = ClientProtos.RegionActionResult.newBuilder();
        Boolean processed = null;
        for (ClientProtos.RegionAction regionAction : request.getRegionActionList()) {
            OperationQuota quota;
            block14: {
                HRegion region;
                this.requestCount.add((long)regionAction.getActionCount());
                regionActionResultBuilder.clear();
                try {
                    region = this.getRegion(regionAction.getRegion());
                    quota = this.getQuotaManager().checkQuota(region, regionAction.getActionList());
                }
                catch (IOException e) {
                    regionActionResultBuilder.setException(ResponseConverter.buildException((Throwable)e));
                    responseBuilder.addRegionActionResult(regionActionResultBuilder.build());
                    continue;
                }
                if (regionAction.hasAtomic() && regionAction.getAtomic()) {
                    try {
                        if (request.hasCondition()) {
                            ClientProtos.Condition condition = request.getCondition();
                            byte[] row = condition.getRow().toByteArray();
                            byte[] family = condition.getFamily().toByteArray();
                            byte[] qualifier = condition.getQualifier().toByteArray();
                            CompareFilter.CompareOp compareOp = CompareFilter.CompareOp.valueOf((String)condition.getCompareType().name());
                            ByteArrayComparable comparator = ProtobufUtil.toComparator((ComparatorProtos.Comparator)condition.getComparator());
                            processed = this.checkAndRowMutate(region, regionAction.getActionList(), cellScanner, row, family, qualifier, compareOp, comparator);
                            break block14;
                        }
                        ClientProtos.RegionLoadStats stats = this.mutateRows(region, regionAction.getActionList(), cellScanner);
                        if (stats != null) {
                            responseBuilder.addRegionActionResult(ClientProtos.RegionActionResult.newBuilder().addResultOrException(ClientProtos.ResultOrException.newBuilder().setLoadStats(stats)));
                        }
                        processed = Boolean.TRUE;
                    }
                    catch (IOException e) {
                        regionActionResultBuilder.setException(ResponseConverter.buildException((Throwable)e));
                    }
                } else {
                    cellsToReturn = this.doNonAtomicRegionMutation(region, quota, regionAction, cellScanner, regionActionResultBuilder, cellsToReturn, nonceGroup);
                }
            }
            responseBuilder.addRegionActionResult(regionActionResultBuilder.build());
            quota.close();
        }
        if (cellsToReturn != null && !cellsToReturn.isEmpty() && controller != null) {
            controller.setCellScanner(CellUtil.createCellScanner((List)cellsToReturn));
        }
        if (processed != null) {
            responseBuilder.setProcessed(processed.booleanValue());
        }
        return responseBuilder.build();
    }

    public ClientProtos.MutateResponse mutate(RpcController rpcc, ClientProtos.MutateRequest request) throws ServiceException {
        PayloadCarryingRpcController controller = (PayloadCarryingRpcController)rpcc;
        CellScanner cellScanner = controller != null ? controller.cellScanner() : null;
        OperationQuota quota = null;
        if (controller != null) {
            controller.setCellScanner(null);
        }
        try {
            this.checkOpen();
            this.requestCount.increment();
            HRegion region = this.getRegion(request.getRegion());
            ClientProtos.MutateResponse.Builder builder = ClientProtos.MutateResponse.newBuilder();
            ClientProtos.MutationProto mutation = request.getMutation();
            if (!region.getRegionInfo().isMetaTable()) {
                this.regionServer.cacheFlusher.reclaimMemStoreMemory();
            }
            long nonceGroup = request.hasNonceGroup() ? request.getNonceGroup() : 0L;
            Result r = null;
            Boolean processed = null;
            ClientProtos.MutationProto.MutationType type = mutation.getMutateType();
            long mutationSize = 0L;
            quota = this.getQuotaManager().checkQuota(region, OperationQuota.OperationType.MUTATE);
            switch (type) {
                case APPEND: {
                    r = this.append(region, quota, mutation, cellScanner, nonceGroup);
                    break;
                }
                case INCREMENT: {
                    r = this.increment(region, quota, mutation, cellScanner, nonceGroup);
                    break;
                }
                case PUT: {
                    Put put = ProtobufUtil.toPut((ClientProtos.MutationProto)mutation, (CellScanner)cellScanner);
                    quota.addMutation((Mutation)put);
                    if (request.hasCondition()) {
                        ClientProtos.Condition condition = request.getCondition();
                        byte[] row = condition.getRow().toByteArray();
                        byte[] family = condition.getFamily().toByteArray();
                        byte[] qualifier = condition.getQualifier().toByteArray();
                        CompareFilter.CompareOp compareOp = CompareFilter.CompareOp.valueOf((String)condition.getCompareType().name());
                        ByteArrayComparable comparator = ProtobufUtil.toComparator((ComparatorProtos.Comparator)condition.getComparator());
                        if (region.getCoprocessorHost() != null) {
                            processed = region.getCoprocessorHost().preCheckAndPut(row, family, qualifier, compareOp, comparator, put);
                        }
                        if (processed != null) break;
                        boolean result = region.checkAndMutate(row, family, qualifier, compareOp, comparator, (Mutation)put, true);
                        if (region.getCoprocessorHost() != null) {
                            result = region.getCoprocessorHost().postCheckAndPut(row, family, qualifier, compareOp, comparator, put, result);
                        }
                        processed = result;
                        break;
                    }
                    region.put(put);
                    processed = Boolean.TRUE;
                    break;
                }
                case DELETE: {
                    Delete delete = ProtobufUtil.toDelete((ClientProtos.MutationProto)mutation, (CellScanner)cellScanner);
                    quota.addMutation((Mutation)delete);
                    if (request.hasCondition()) {
                        ClientProtos.Condition condition = request.getCondition();
                        byte[] row = condition.getRow().toByteArray();
                        byte[] family = condition.getFamily().toByteArray();
                        byte[] qualifier = condition.getQualifier().toByteArray();
                        CompareFilter.CompareOp compareOp = CompareFilter.CompareOp.valueOf((String)condition.getCompareType().name());
                        ByteArrayComparable comparator = ProtobufUtil.toComparator((ComparatorProtos.Comparator)condition.getComparator());
                        if (region.getCoprocessorHost() != null) {
                            processed = region.getCoprocessorHost().preCheckAndDelete(row, family, qualifier, compareOp, comparator, delete);
                        }
                        if (processed != null) break;
                        boolean result = region.checkAndMutate(row, family, qualifier, compareOp, comparator, (Mutation)delete, true);
                        if (region.getCoprocessorHost() != null) {
                            result = region.getCoprocessorHost().postCheckAndDelete(row, family, qualifier, compareOp, comparator, delete, result);
                        }
                        processed = result;
                        break;
                    }
                    region.delete(delete);
                    processed = Boolean.TRUE;
                    break;
                }
                default: {
                    throw new DoNotRetryIOException("Unsupported mutate type: " + type.name());
                }
            }
            if (processed != null) {
                builder.setProcessed(processed.booleanValue());
            }
            this.addResult(builder, r, controller);
            ClientProtos.MutateResponse mutateResponse = builder.build();
            return mutateResponse;
        }
        catch (IOException ie) {
            this.regionServer.checkFileSystem();
            throw new ServiceException((Throwable)ie);
        }
        finally {
            if (quota != null) {
                quota.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
        OperationQuota quota = null;
        Leases.Lease lease = null;
        String scannerName = null;
        try {
            ClientProtos.ScanResponse scanResponse;
            int rows;
            if (!request.hasScannerId() && !request.hasScan()) {
                throw new DoNotRetryIOException("Missing required input: scannerId or scan");
            }
            long scannerId = -1L;
            if (request.hasScannerId()) {
                scannerId = request.getScannerId();
                scannerName = String.valueOf(scannerId);
            }
            try {
                this.checkOpen();
            }
            catch (IOException e) {
                if (scannerName != null) {
                    LOG.debug((Object)("Server shutting down and client tried to access missing scanner " + scannerName));
                    if (this.regionServer.leases != null) {
                        try {
                            this.regionServer.leases.cancelLease(scannerName);
                        }
                        catch (LeaseException le) {
                            // empty catch block
                        }
                    }
                }
                throw e;
            }
            this.requestCount.increment();
            int ttl = 0;
            HRegion region = null;
            RegionScanner scanner = null;
            RegionScannerHolder rsh = null;
            boolean moreResults = true;
            boolean closeScanner = false;
            ClientProtos.ScanResponse.Builder builder = ClientProtos.ScanResponse.newBuilder();
            if (request.hasCloseScanner()) {
                closeScanner = request.getCloseScanner();
            }
            int n = rows = closeScanner ? 0 : 1;
            if (request.hasNumberOfRows()) {
                rows = request.getNumberOfRows();
            }
            if (request.hasScannerId()) {
                rsh = this.scanners.get(scannerName);
                if (rsh == null) {
                    LOG.info((Object)("Client tried to access missing scanner " + scannerName));
                    throw new UnknownScannerException("Name: " + scannerName + ", already closed?");
                }
                scanner = rsh.s;
                HRegionInfo hri = scanner.getRegionInfo();
                region = this.regionServer.getRegion(hri.getRegionName());
                if (region != rsh.r) {
                    throw new NotServingRegionException("Region was re-opened after the scanner" + scannerName + " was created: " + hri.getRegionNameAsString());
                }
            } else {
                region = this.getRegion(request.getRegion());
                ClientProtos.Scan protoScan = request.getScan();
                boolean isLoadingCfsOnDemandSet = protoScan.hasLoadColumnFamiliesOnDemand();
                Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)protoScan);
                if (!isLoadingCfsOnDemandSet) {
                    scan.setLoadColumnFamiliesOnDemand(region.isLoadingCfsOnDemandDefault());
                }
                region.prepareScanner(scan);
                if (region.getCoprocessorHost() != null) {
                    scanner = region.getCoprocessorHost().preScannerOpen(scan);
                }
                if (scanner == null) {
                    scanner = region.getScanner(scan);
                }
                if (region.getCoprocessorHost() != null) {
                    scanner = region.getCoprocessorHost().postScannerOpen(scan, scanner);
                }
                scannerId = this.addScanner(scanner, region);
                scannerName = String.valueOf(scannerId);
                ttl = this.scannerLeaseTimeoutPeriod;
            }
            quota = this.getQuotaManager().checkQuota(region, OperationQuota.OperationType.SCAN);
            long maxQuotaResultSize = Math.min(this.maxScannerResultSize, quota.getReadAvailable());
            if (rows > 0) {
                if (request.hasNextCallSeq()) {
                    if (rsh == null) {
                        rsh = this.scanners.get(scannerName);
                    }
                    if (rsh != null) {
                        if (request.getNextCallSeq() != rsh.nextCallSeq) {
                            throw new OutOfOrderScannerNextException("Expected nextCallSeq: " + rsh.nextCallSeq + " But the nextCallSeq got from client: " + request.getNextCallSeq() + "; request=" + TextFormat.shortDebugString((MessageOrBuilder)request));
                        }
                        rsh.nextCallSeq++;
                    }
                }
                try {
                    lease = this.regionServer.leases.removeLease(scannerName);
                    ArrayList<Result> results = new ArrayList<Result>(Math.min(rows, 100));
                    long currentScanResultSize = 0L;
                    long totalCellSize = 0L;
                    boolean done = false;
                    if (region != null && region.getCoprocessorHost() != null) {
                        Boolean bypass = region.getCoprocessorHost().preScannerNext(scanner, results, rows);
                        if (!results.isEmpty()) {
                            for (Result r : results) {
                                for (Cell cell : r.rawCells()) {
                                    currentScanResultSize += CellUtil.estimatedHeapSizeOf((Cell)cell);
                                    totalCellSize += (long)CellUtil.estimatedSerializedSizeOf((Cell)cell);
                                }
                            }
                        }
                        if (bypass != null && bypass.booleanValue()) {
                            done = true;
                        }
                    }
                    if (!done) {
                        long maxResultSize = Math.min(scanner.getMaxResultSize(), maxQuotaResultSize);
                        if (maxResultSize <= 0L) {
                            maxResultSize = maxQuotaResultSize;
                        }
                        ArrayList<Cell> values = new ArrayList<Cell>();
                        region.startRegionOperation(HRegion.Operation.SCAN);
                        try {
                            int i = 0;
                            RegionScanner regionScanner = scanner;
                            synchronized (regionScanner) {
                                boolean stale = region.getRegionInfo().getReplicaId() != 0;
                                boolean moreRows = false;
                                while (i < rows) {
                                    if (this.maxScannerResultSize < Long.MAX_VALUE && currentScanResultSize >= maxResultSize) {
                                        builder.setMoreResultsInRegion(true);
                                        break;
                                    }
                                    moreRows = scanner.nextRaw(values);
                                    if (!values.isEmpty()) {
                                        for (Cell cell : values) {
                                            currentScanResultSize += CellUtil.estimatedHeapSizeOf((Cell)cell);
                                            totalCellSize += (long)CellUtil.estimatedSerializedSizeOf((Cell)cell);
                                        }
                                        results.add(Result.create(values, null, (boolean)stale));
                                        ++i;
                                    }
                                    if (!moreRows) break;
                                    values.clear();
                                }
                                if (currentScanResultSize >= maxResultSize || i >= rows || moreRows) {
                                    builder.setMoreResultsInRegion(true);
                                } else {
                                    builder.setMoreResultsInRegion(false);
                                }
                            }
                            region.readRequestsCount.add((long)i);
                            region.getMetrics().updateScanNext(totalCellSize);
                        }
                        finally {
                            region.closeRegionOperation();
                        }
                        if (region != null && region.getCoprocessorHost() != null) {
                            region.getCoprocessorHost().postScannerNext(scanner, results, rows, true);
                        }
                    }
                    quota.addScanResult(results);
                    if (scanner.isFilterDone() && results.isEmpty()) {
                        moreResults = false;
                        results = null;
                    } else {
                        this.addResults(builder, results, controller, RegionReplicaUtil.isDefaultReplica((HRegionInfo)region.getRegionInfo()));
                    }
                }
                finally {
                    if (this.scanners.containsKey(scannerName)) {
                        if (lease != null) {
                            this.regionServer.leases.addLease(lease);
                        }
                        ttl = this.scannerLeaseTimeoutPeriod;
                    }
                }
            }
            if (!moreResults || closeScanner) {
                ttl = 0;
                moreResults = false;
                if (region != null && region.getCoprocessorHost() != null && region.getCoprocessorHost().preScannerClose(scanner)) {
                    scanResponse = builder.build();
                    return scanResponse;
                }
                rsh = this.scanners.remove(scannerName);
                if (rsh != null) {
                    scanner = rsh.s;
                    scanner.close();
                    this.regionServer.leases.cancelLease(scannerName);
                    if (region != null && region.getCoprocessorHost() != null) {
                        region.getCoprocessorHost().postScannerClose(scanner);
                    }
                }
            }
            if (ttl > 0) {
                builder.setTtl(ttl);
            }
            builder.setScannerId(scannerId);
            builder.setMoreResults(moreResults);
            scanResponse = builder.build();
            return scanResponse;
        }
        catch (IOException ie) {
            RegionScannerHolder rsh;
            if (scannerName != null && ie instanceof NotServingRegionException && (rsh = this.scanners.remove(scannerName)) != null) {
                try {
                    RegionScanner scanner = rsh.s;
                    LOG.warn((Object)(scannerName + " encountered " + ie.getMessage() + ", closing ..."));
                    scanner.close();
                    this.regionServer.leases.cancelLease(scannerName);
                }
                catch (IOException e) {
                    LOG.warn((Object)("Getting exception closing " + scannerName), (Throwable)e);
                }
            }
            throw new ServiceException((Throwable)ie);
        }
        finally {
            if (quota != null) {
                quota.close();
            }
        }
    }

    public ClientProtos.CoprocessorServiceResponse execRegionServerService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        return this.regionServer.execRegionServerService(controller, request);
    }

    public AdminProtos.UpdateConfigurationResponse updateConfiguration(RpcController controller, AdminProtos.UpdateConfigurationRequest request) throws ServiceException {
        try {
            this.regionServer.updateConfiguration();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        return AdminProtos.UpdateConfigurationResponse.getDefaultInstance();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface QosPriority {
        public int priority() default 0;
    }

    private class ScannerListener
    implements LeaseListener {
        private final String scannerName;

        ScannerListener(String n) {
            this.scannerName = n;
        }

        @Override
        public void leaseExpired() {
            RegionScannerHolder rsh = (RegionScannerHolder)RSRpcServices.this.scanners.remove(this.scannerName);
            if (rsh != null) {
                RegionScanner s = rsh.s;
                LOG.info((Object)("Scanner " + this.scannerName + " lease expired on region " + s.getRegionInfo().getRegionNameAsString()));
                try {
                    HRegion region = RSRpcServices.this.regionServer.getRegion(s.getRegionInfo().getRegionName());
                    if (region != null && region.getCoprocessorHost() != null) {
                        region.getCoprocessorHost().preScannerClose(s);
                    }
                    s.close();
                    if (region != null && region.getCoprocessorHost() != null) {
                        region.getCoprocessorHost().postScannerClose(s);
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)("Closing scanner for " + s.getRegionInfo().getRegionNameAsString()), (Throwable)e);
                }
            } else {
                LOG.warn((Object)("Scanner " + this.scannerName + " lease expired, but no related" + " scanner found, hence no chance to close that related scanner!"));
            }
        }
    }

    private static class RegionScannerHolder {
        private RegionScanner s;
        private long nextCallSeq = 0L;
        private HRegion r;

        public RegionScannerHolder(RegionScanner s, HRegion r) {
            this.s = s;
            this.r = r;
        }
    }
}

