/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.NavigableSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreScanner;

@InterfaceAudience.Private
public class MobStoreScanner
extends StoreScanner {
    private boolean cacheMobBlocks = false;
    private final HMobStore mobStore;

    public MobStoreScanner(Store store, ScanInfo scanInfo, Scan scan, NavigableSet<byte[]> columns, long readPt) throws IOException {
        super(store, scanInfo, scan, columns, readPt);
        this.cacheMobBlocks = MobUtils.isCacheMobBlocks(scan);
        if (!(store instanceof HMobStore)) {
            throw new IllegalArgumentException("The store " + store + " is not a HMobStore");
        }
        this.mobStore = (HMobStore)store;
    }

    @Override
    public boolean next(List<Cell> outResult, int limit) throws IOException {
        boolean result = super.next(outResult, limit);
        if (!MobUtils.isRawMobScan(this.scan)) {
            if (outResult.isEmpty()) {
                return result;
            }
            long mobKVCount = 0L;
            long mobKVSize = 0L;
            for (int i = 0; i < outResult.size(); ++i) {
                Cell cell = outResult.get(i);
                if (!MobUtils.isMobReferenceCell(cell)) continue;
                Cell mobCell = this.mobStore.resolve(cell, this.cacheMobBlocks);
                ++mobKVCount;
                mobKVSize += (long)mobCell.getValueLength();
                outResult.set(i, mobCell);
            }
            this.mobStore.updateMobScanCellsCount(mobKVCount);
            this.mobStore.updateMobScanCellsSize(mobKVSize);
        }
        return result;
    }
}

