/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;

@InterfaceAudience.Private
public class MobFile {
    private StoreFile sf;

    protected MobFile() {
    }

    protected MobFile(StoreFile sf) {
        this.sf = sf;
    }

    public StoreFileScanner getScanner() throws IOException {
        ArrayList<StoreFile> sfs = new ArrayList<StoreFile>();
        sfs.add(this.sf);
        List<StoreFileScanner> sfScanners = StoreFileScanner.getScannersForStoreFiles(sfs, false, true, false, null, this.sf.getMaxMemstoreTS());
        return sfScanners.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cell readCell(Cell search, boolean cacheMobBlocks) throws IOException {
        Cell result = null;
        StoreFileScanner scanner = null;
        ArrayList<StoreFile> sfs = new ArrayList<StoreFile>();
        sfs.add(this.sf);
        try {
            List<StoreFileScanner> sfScanners = StoreFileScanner.getScannersForStoreFiles(sfs, cacheMobBlocks, true, false, null, this.sf.getMaxMemstoreTS());
            if (!sfScanners.isEmpty() && (scanner = sfScanners.get(0)).seek(search)) {
                result = scanner.peek();
            }
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return result;
    }

    public String getFileName() {
        return this.sf.getPath().getName();
    }

    public void open() throws IOException {
        if (this.sf.getReader() == null) {
            this.sf.createReader();
        }
    }

    public void close() throws IOException {
        if (this.sf != null) {
            this.sf.closeReader(false);
            this.sf = null;
        }
    }

    public static MobFile create(FileSystem fs, Path path, Configuration conf, CacheConfig cacheConf) throws IOException {
        StoreFile sf = new StoreFile(fs, path, conf, cacheConf, BloomType.NONE);
        return new MobFile(sf);
    }
}

