/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.MobSnapshotTestingUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotDoesNotExistException;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestMobRestoreFlushSnapshotFromClient {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private final byte[] FAMILY = Bytes.toBytes((String)"cf");
    private byte[] snapshotName0;
    private byte[] snapshotName1;
    private byte[] snapshotName2;
    private int snapshot0Rows;
    private int snapshot1Rows;
    private TableName tableName;
    private Admin admin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
        UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        UTIL.getConfiguration().setBoolean("hbase.snapshot.enabled", true);
        UTIL.getConfiguration().setLong("hbase.snapshot.region.timeout", 120000L);
        UTIL.getConfiguration().setInt("hbase.mob.file.cache.size", 0);
        UTIL.getConfiguration().setInt("hfile.format.version", 3);
        UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
        this.admin = UTIL.getHBaseAdmin();
        long tid = System.currentTimeMillis();
        this.tableName = TableName.valueOf((String)("testtb-" + tid));
        this.snapshotName0 = Bytes.toBytes((String)("snaptb0-" + tid));
        this.snapshotName1 = Bytes.toBytes((String)("snaptb1-" + tid));
        this.snapshotName2 = Bytes.toBytes((String)("snaptb2-" + tid));
        MobSnapshotTestingUtils.createMobTable(UTIL, this.tableName, 1, (byte[][])new byte[][]{this.FAMILY});
        HTable table = new HTable(UTIL.getConfiguration(), this.tableName);
        SnapshotTestingUtils.loadData(UTIL, this.tableName, 500, (byte[][])new byte[][]{this.FAMILY});
        this.snapshot0Rows = MobSnapshotTestingUtils.countMobRows(table);
        this.LOG.info((Object)"=== before snapshot with 500 rows");
        this.logFSTree();
        this.admin.snapshot(Bytes.toString((byte[])this.snapshotName0), this.tableName, HBaseProtos.SnapshotDescription.Type.FLUSH);
        this.LOG.info((Object)"=== after snapshot with 500 rows");
        this.logFSTree();
        SnapshotTestingUtils.loadData(UTIL, this.tableName, 500, (byte[][])new byte[][]{this.FAMILY});
        this.snapshot1Rows = MobSnapshotTestingUtils.countMobRows(table);
        this.LOG.info((Object)"=== before snapshot with 1000 rows");
        this.logFSTree();
        this.admin.snapshot(Bytes.toString((byte[])this.snapshotName1), this.tableName, HBaseProtos.SnapshotDescription.Type.FLUSH);
        this.LOG.info((Object)"=== after snapshot with 1000 rows");
        this.logFSTree();
        table.close();
    }

    @After
    public void tearDown() throws Exception {
        SnapshotTestingUtils.deleteAllSnapshots((Admin)UTIL.getHBaseAdmin());
        SnapshotTestingUtils.deleteArchiveDirectory(UTIL);
    }

    @Test
    public void testTakeFlushSnapshot() throws IOException {
    }

    @Test
    public void testRestoreSnapshot() throws IOException {
        MobSnapshotTestingUtils.verifyMobRowCount(UTIL, this.tableName, this.snapshot1Rows);
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName0);
        this.logFSTree();
        this.admin.enableTable(this.tableName);
        this.LOG.info((Object)"=== after restore with 500 row snapshot");
        this.logFSTree();
        MobSnapshotTestingUtils.verifyMobRowCount(UTIL, this.tableName, this.snapshot0Rows);
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName1);
        this.admin.enableTable(this.tableName);
        MobSnapshotTestingUtils.verifyMobRowCount(UTIL, this.tableName, this.snapshot1Rows);
    }

    @Test(expected=SnapshotDoesNotExistException.class)
    public void testCloneNonExistentSnapshot() throws IOException, InterruptedException {
        String snapshotName = "random-snapshot-" + System.currentTimeMillis();
        TableName tableName = TableName.valueOf((String)("random-table-" + System.currentTimeMillis()));
        this.admin.cloneSnapshot(snapshotName, tableName);
    }

    @Test
    public void testCloneSnapshot() throws IOException, InterruptedException {
        TableName clonedTableName = TableName.valueOf((String)("clonedtb-" + System.currentTimeMillis()));
        this.testCloneSnapshot(clonedTableName, this.snapshotName0, this.snapshot0Rows);
        this.testCloneSnapshot(clonedTableName, this.snapshotName1, this.snapshot1Rows);
    }

    private void testCloneSnapshot(TableName tableName, byte[] snapshotName, int snapshotRows) throws IOException, InterruptedException {
        this.admin.cloneSnapshot(snapshotName, tableName);
        MobSnapshotTestingUtils.verifyMobRowCount(UTIL, tableName, snapshotRows);
        UTIL.deleteTable(tableName);
    }

    @Test
    public void testRestoreSnapshotOfCloned() throws IOException, InterruptedException {
        TableName clonedTableName = TableName.valueOf((String)("clonedtb-" + System.currentTimeMillis()));
        this.admin.cloneSnapshot(this.snapshotName0, clonedTableName);
        MobSnapshotTestingUtils.verifyMobRowCount(UTIL, clonedTableName, this.snapshot0Rows);
        this.admin.snapshot(Bytes.toString((byte[])this.snapshotName2), clonedTableName, HBaseProtos.SnapshotDescription.Type.FLUSH);
        UTIL.deleteTable(clonedTableName);
        this.admin.cloneSnapshot(this.snapshotName2, clonedTableName);
        MobSnapshotTestingUtils.verifyMobRowCount(UTIL, clonedTableName, this.snapshot0Rows);
        UTIL.deleteTable(clonedTableName);
    }

    private void logFSTree() throws IOException {
        MasterFileSystem mfs = UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        FSUtils.logFileSystemState((FileSystem)mfs.getFileSystem(), (Path)mfs.getRootDir(), (Log)this.LOG);
    }
}

