/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public abstract class TestVisibilityLabels {
    public static final String TOPSECRET = "topsecret";
    public static final String PUBLIC = "public";
    public static final String PRIVATE = "private";
    public static final String CONFIDENTIAL = "confidential";
    public static final String SECRET = "secret";
    public static final String COPYRIGHT = "\u00a9ABC";
    public static final String ACCENT = "\u0941";
    public static final String UNICODE_VIS_TAG = "\u00a9ABC\"\u0941\\secret\"'&\\";
    public static final String UC1 = "'\"+";
    public static final String UC2 = "-?";
    public static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    public static final byte[] row1 = Bytes.toBytes((String)"row1");
    public static final byte[] row2 = Bytes.toBytes((String)"row2");
    public static final byte[] row3 = Bytes.toBytes((String)"row3");
    public static final byte[] row4 = Bytes.toBytes((String)"row4");
    public static final byte[] fam = Bytes.toBytes((String)"info");
    public static final byte[] qual = Bytes.toBytes((String)"qual");
    public static final byte[] value = Bytes.toBytes((String)"value");
    public static Configuration conf;
    private volatile boolean killedRS = false;
    @Rule
    public final TestName TEST_NAME = new TestName();
    public static User SUPERUSER;
    public static User USER1;

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        this.killedRS = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleVisibilityLabels() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = TestVisibilityLabels.createTableAndWriteDataWithLabels(tableName, "secret|confidential", "private|confidential");){
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET, CONFIDENTIAL, PRIVATE}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleVisibilityLabelsWithUniCodeCharacters() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = TestVisibilityLabels.createTableAndWriteDataWithLabels(tableName, "secret|" + CellVisibility.quote((String)COPYRIGHT), "(" + CellVisibility.quote((String)COPYRIGHT) + "&" + CellVisibility.quote((String)ACCENT) + ")|" + CONFIDENTIAL, CellVisibility.quote((String)UNICODE_VIS_TAG) + "&" + SECRET);){
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET, CONFIDENTIAL, PRIVATE, COPYRIGHT, ACCENT, UNICODE_VIS_TAG}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 3 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            cellScanner = next[2].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row3, (int)0, (int)row3.length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthorizationsWithSpecialUnicodeCharacters() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = TestVisibilityLabels.createTableAndWriteDataWithLabels(tableName, CellVisibility.quote((String)UC1) + "|" + CellVisibility.quote((String)UC2), CellVisibility.quote((String)UC1), CellVisibility.quote((String)UNICODE_VIS_TAG));){
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{UC1, UC2, ACCENT, UNICODE_VIS_TAG}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 3 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row1, (int)0, (int)row1.length));
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            cellScanner = next[2].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row3, (int)0, (int)row3.length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsWithComplexLabels() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = TestVisibilityLabels.createTableAndWriteDataWithLabels(tableName, "(secret|confidential)&!topsecret", "(private&confidential&secret)", "(private&confidential&secret)", "(private&confidential&secret)");){
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{TOPSECRET, CONFIDENTIAL, PRIVATE, PUBLIC, SECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(4);
            Assert.assertEquals((long)3L, (long)next.length);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row2, (int)0, (int)row2.length));
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row3, (int)0, (int)row3.length));
            cellScanner = next[2].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getRowArray(), (int)current.getRowOffset(), (int)current.getRowLength(), (byte[])row4, (int)0, (int)row4.length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsThatDoesNotPassTheCriteria() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = TestVisibilityLabels.createTableAndWriteDataWithLabels(tableName, "(secret|confidential)", PRIVATE);){
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{PUBLIC}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testVisibilityLabelsInPutsThatDoesNotMatchAnyDefinedLabels() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try {
            TestVisibilityLabels.createTableAndWriteDataWithLabels(tableName, "SAMPLE_LABEL", "TEST");
            Assert.fail((String)"Should have failed with failed sanity check exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsInScanThatDoesNotMatchAnyDefinedLabels() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = TestVisibilityLabels.createTableAndWriteDataWithLabels(tableName, "(secret|confidential)", PRIVATE);){
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{"SAMPLE"}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 0 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsWithGet() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = TestVisibilityLabels.createTableAndWriteDataWithLabels(tableName, "secret&confidential&!private", "secret&confidential&private");){
            Get get = new Get(row1);
            get.setAuthorizations(new Authorizations(new String[]{SECRET, CONFIDENTIAL}));
            Result result = table.get(get);
            Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
            Cell cell = result.getColumnLatestCell(fam, qual);
            Assert.assertTrue((boolean)Bytes.equals((byte[])value, (int)0, (int)value.length, (byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsOnKillingOfRSContainingLabelsTable() throws Exception {
        List<JVMClusterUtil.RegionServerThread> regionServerThreads = TEST_UTIL.getHBaseCluster().getRegionServerThreads();
        int liveRS = 0;
        for (JVMClusterUtil.RegionServerThread rsThreads : regionServerThreads) {
            if (rsThreads.getRegionServer().isAborted()) continue;
            ++liveRS;
        }
        if (liveRS == 1) {
            TEST_UTIL.getHBaseCluster().startRegionServer();
        }
        Thread t1 = new Thread(){

            @Override
            public void run() {
                List<JVMClusterUtil.RegionServerThread> regionServerThreads = TEST_UTIL.getHBaseCluster().getRegionServerThreads();
                for (JVMClusterUtil.RegionServerThread rsThread : regionServerThreads) {
                    List onlineRegions = rsThread.getRegionServer().getOnlineRegions(VisibilityConstants.LABELS_TABLE_NAME);
                    if (onlineRegions.size() <= 0) continue;
                    rsThread.getRegionServer().abort("Aborting ");
                    TestVisibilityLabels.this.killedRS = true;
                    break;
                }
            }
        };
        t1.start();
        final TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    while (!TestVisibilityLabels.this.killedRS) {
                        Thread.sleep(1L);
                    }
                    TestVisibilityLabels.createTableAndWriteDataWithLabels(tableName, "(secret|confidential)", TestVisibilityLabels.PRIVATE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
        regionServerThreads = TEST_UTIL.getHBaseCluster().getRegionServerThreads();
        while (!this.killedRS) {
            Thread.sleep(10L);
        }
        regionServerThreads = TEST_UTIL.getHBaseCluster().getRegionServerThreads();
        for (JVMClusterUtil.RegionServerThread rsThread : regionServerThreads) {
            List onlineRegions;
            while (!rsThread.getRegionServer().isAborted() && (onlineRegions = rsThread.getRegionServer().getOnlineRegions(VisibilityConstants.LABELS_TABLE_NAME)).size() <= 0) {
                Thread.sleep(10L);
            }
        }
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        t.join();
        try (HTable table = null;){
            table = new HTable(TEST_UTIL.getConfiguration(), tableName);
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testVisibilityLabelsOnRSRestart() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        Table table = TestVisibilityLabels.createTableAndWriteDataWithLabels(tableName, "(secret|confidential)", PRIVATE);
        List<JVMClusterUtil.RegionServerThread> regionServerThreads = TEST_UTIL.getHBaseCluster().getRegionServerThreads();
        for (JVMClusterUtil.RegionServerThread rsThread : regionServerThreads) {
            rsThread.getRegionServer().abort("Aborting ");
        }
        JVMClusterUtil.RegionServerThread rs = TEST_UTIL.getHBaseCluster().startRegionServer();
        this.waitForLabelsRegionAvailability(rs.getRegionServer());
        try {
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    protected void waitForLabelsRegionAvailability(HRegionServer regionServer) {
        while (!regionServer.isOnline()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        while (regionServer.getOnlineRegions(VisibilityConstants.LABELS_TABLE_NAME).isEmpty()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        HRegion labelsTableRegion = (HRegion)regionServer.getOnlineRegions(VisibilityConstants.LABELS_TABLE_NAME).get(0);
        while (labelsTableRegion.isRecovering()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsInGetThatDoesNotMatchAnyDefinedLabels() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (Table table = TestVisibilityLabels.createTableAndWriteDataWithLabels(tableName, "(secret|confidential)", PRIVATE);){
            Get get = new Get(row1);
            get.setAuthorizations(new Authorizations(new String[]{"SAMPLE"}));
            Result result = table.get(get);
            Assert.assertTrue((boolean)result.isEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetAndGetUserAuths() throws Throwable {
        String user = "user1";
        PrivilegedExceptionAction<Void> action = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                String[] auths = new String[]{TestVisibilityLabels.SECRET, TestVisibilityLabels.CONFIDENTIAL};
                try {
                    VisibilityClient.setAuths((Configuration)conf, (String[])auths, (String)"user1");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
        try (HTable ht = null;){
            ht = new HTable(conf, VisibilityConstants.LABELS_TABLE_NAME);
            Scan scan = new Scan();
            scan.setAuthorizations(new Authorizations(new String[]{"system"}));
            ResultScanner scanner = ht.getScanner(scan);
            Result result = null;
            ArrayList<Result> results = new ArrayList<Result>();
            while ((result = scanner.next()) != null) {
                results.add(result);
            }
            List<String> auths = this.extractAuths("user1", results);
            Assert.assertTrue((boolean)auths.contains(SECRET));
            Assert.assertTrue((boolean)auths.contains(CONFIDENTIAL));
            Assert.assertEquals((long)2L, (long)auths.size());
        }
        action = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                VisibilityLabelsProtos.GetAuthsResponse authsResponse = null;
                try {
                    authsResponse = VisibilityClient.getAuths((Configuration)conf, (String)"user1");
                }
                catch (Throwable e) {
                    Assert.fail((String)"Should not have failed");
                }
                ArrayList<String> authsList = new ArrayList<String>();
                for (ByteString authBS : authsResponse.getAuthList()) {
                    authsList.add(Bytes.toString((byte[])authBS.toByteArray()));
                }
                Assert.assertEquals((long)2L, (long)authsList.size());
                Assert.assertTrue((boolean)authsList.contains(TestVisibilityLabels.SECRET));
                Assert.assertTrue((boolean)authsList.contains(TestVisibilityLabels.CONFIDENTIAL));
                return null;
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
        action = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                String[] auths1 = new String[]{TestVisibilityLabels.SECRET, TestVisibilityLabels.CONFIDENTIAL};
                VisibilityLabelsProtos.GetAuthsResponse authsResponse = null;
                try {
                    VisibilityClient.setAuths((Configuration)conf, (String[])auths1, (String)"user1");
                    try {
                        authsResponse = VisibilityClient.getAuths((Configuration)conf, (String)"user1");
                    }
                    catch (Throwable e) {
                        Assert.fail((String)"Should not have failed");
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                ArrayList<String> authsList = new ArrayList<String>();
                for (ByteString authBS : authsResponse.getAuthList()) {
                    authsList.add(Bytes.toString((byte[])authBS.toByteArray()));
                }
                Assert.assertEquals((long)2L, (long)authsList.size());
                Assert.assertTrue((boolean)authsList.contains(TestVisibilityLabels.SECRET));
                Assert.assertTrue((boolean)authsList.contains(TestVisibilityLabels.CONFIDENTIAL));
                return null;
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
    }

    protected List<String> extractAuths(String user, List<Result> results) {
        ArrayList<String> auths = new ArrayList<String>();
        for (Result result : results) {
            Cell labelCell = result.getColumnLatestCell(VisibilityConstants.LABELS_TABLE_FAMILY, VisibilityConstants.LABEL_QUALIFIER);
            Cell userAuthCell = result.getColumnLatestCell(VisibilityConstants.LABELS_TABLE_FAMILY, user.getBytes());
            if (userAuthCell == null) continue;
            auths.add(Bytes.toString((byte[])labelCell.getValueArray(), (int)labelCell.getValueOffset(), (int)labelCell.getValueLength()));
        }
        return auths;
    }

    @Test
    public void testClearUserAuths() throws Throwable {
        PrivilegedExceptionAction<Void> action = new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                String[] auths = new String[]{TestVisibilityLabels.SECRET, TestVisibilityLabels.CONFIDENTIAL, TestVisibilityLabels.PRIVATE};
                String user = "testUser";
                try {
                    VisibilityClient.setAuths((Configuration)conf, (String[])auths, (String)user);
                }
                catch (Throwable e) {
                    Assert.fail((String)"Should not have failed");
                }
                auths = new String[]{TestVisibilityLabels.SECRET, TestVisibilityLabels.PUBLIC, TestVisibilityLabels.CONFIDENTIAL};
                VisibilityLabelsProtos.VisibilityLabelsResponse response = null;
                try {
                    response = VisibilityClient.clearAuths((Configuration)conf, (String[])auths, (String)user);
                }
                catch (Throwable e) {
                    Assert.fail((String)"Should not have failed");
                }
                List resultList = response.getResultList();
                Assert.assertEquals((long)3L, (long)resultList.size());
                Assert.assertTrue((boolean)((ClientProtos.RegionActionResult)resultList.get(0)).getException().getValue().isEmpty());
                Assert.assertEquals((Object)"org.apache.hadoop.hbase.DoNotRetryIOException", (Object)((ClientProtos.RegionActionResult)resultList.get(1)).getException().getName());
                Assert.assertTrue((boolean)Bytes.toString((byte[])((ClientProtos.RegionActionResult)resultList.get(1)).getException().getValue().toByteArray()).contains("org.apache.hadoop.hbase.security.visibility.InvalidLabelException: Label 'public' is not set for the user testUser"));
                Assert.assertTrue((boolean)((ClientProtos.RegionActionResult)resultList.get(2)).getException().getValue().isEmpty());
                try (HTable ht = null;){
                    ht = new HTable(conf, VisibilityConstants.LABELS_TABLE_NAME);
                    ResultScanner scanner = ht.getScanner(new Scan());
                    Result result = null;
                    ArrayList<Result> results = new ArrayList<Result>();
                    while ((result = scanner.next()) != null) {
                        results.add(result);
                    }
                    List<String> curAuths = TestVisibilityLabels.this.extractAuths(user, results);
                    Assert.assertTrue((boolean)curAuths.contains(TestVisibilityLabels.PRIVATE));
                    Assert.assertEquals((long)1L, (long)curAuths.size());
                }
                VisibilityLabelsProtos.GetAuthsResponse authsResponse = null;
                try {
                    authsResponse = VisibilityClient.getAuths((Configuration)conf, (String)user);
                }
                catch (Throwable e) {
                    Assert.fail((String)"Should not have failed");
                }
                ArrayList<String> authsList = new ArrayList<String>();
                for (ByteString authBS : authsResponse.getAuthList()) {
                    authsList.add(Bytes.toString((byte[])authBS.toByteArray()));
                }
                Assert.assertEquals((long)1L, (long)authsList.size());
                Assert.assertTrue((boolean)authsList.contains(TestVisibilityLabels.PRIVATE));
                return null;
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLabelsWithCheckAndPut() throws Throwable {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (HTable table = null;){
            table = TEST_UTIL.createTable(tableName, fam);
            byte[] row1 = Bytes.toBytes((String)"row1");
            Put put = new Put(row1);
            put.add(fam, qual, Long.MAX_VALUE, value);
            put.setCellVisibility(new CellVisibility("secret & confidential"));
            table.checkAndPut(row1, fam, qual, null, put);
            byte[] row2 = Bytes.toBytes((String)"row2");
            put = new Put(row2);
            put.add(fam, qual, Long.MAX_VALUE, value);
            put.setCellVisibility(new CellVisibility(SECRET));
            table.checkAndPut(row2, fam, qual, null, put);
            Scan scan = new Scan();
            scan.setAuthorizations(new Authorizations(new String[]{SECRET}));
            ResultScanner scanner = table.getScanner(scan);
            Result result = scanner.next();
            Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])row2, (byte[])result.getRow()));
            result = scanner.next();
            Assert.assertNull((Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLabelsWithIncrement() throws Throwable {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (HTable table = null;){
            table = TEST_UTIL.createTable(tableName, fam);
            byte[] row1 = Bytes.toBytes((String)"row1");
            byte[] val = Bytes.toBytes((long)1L);
            Put put = new Put(row1);
            put.add(fam, qual, Long.MAX_VALUE, val);
            put.setCellVisibility(new CellVisibility("secret & confidential"));
            table.put(put);
            Get get = new Get(row1);
            get.setAuthorizations(new Authorizations(new String[]{SECRET}));
            Result result = table.get(get);
            Assert.assertTrue((boolean)result.isEmpty());
            table.incrementColumnValue(row1, fam, qual, 2L);
            result = table.get(get);
            Assert.assertTrue((boolean)result.isEmpty());
            Increment increment = new Increment(row1);
            increment.addColumn(fam, qual, 2L);
            increment.setCellVisibility(new CellVisibility(SECRET));
            table.increment(increment);
            result = table.get(get);
            Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLabelsWithAppend() throws Throwable {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        try (HTable table = null;){
            table = TEST_UTIL.createTable(tableName, fam);
            byte[] row1 = Bytes.toBytes((String)"row1");
            byte[] val = Bytes.toBytes((String)"a");
            Put put = new Put(row1);
            put.add(fam, qual, Long.MAX_VALUE, val);
            put.setCellVisibility(new CellVisibility("secret & confidential"));
            table.put(put);
            Get get = new Get(row1);
            get.setAuthorizations(new Authorizations(new String[]{SECRET}));
            Result result = table.get(get);
            Assert.assertTrue((boolean)result.isEmpty());
            Append append = new Append(row1);
            append.add(fam, qual, Bytes.toBytes((String)"b"));
            table.append(append);
            result = table.get(get);
            Assert.assertTrue((boolean)result.isEmpty());
            append = new Append(row1);
            append.add(fam, qual, Bytes.toBytes((String)"c"));
            append.setCellVisibility(new CellVisibility(SECRET));
            table.append(append);
            result = table.get(get);
            Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testUserShouldNotDoDDLOpOnLabelsTable() throws Exception {
        HColumnDescriptor hcd;
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        try {
            admin.disableTable(VisibilityConstants.LABELS_TABLE_NAME);
            Assert.fail((String)"Lables table should not get disabled by user.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            admin.deleteTable(VisibilityConstants.LABELS_TABLE_NAME);
            Assert.fail((String)"Lables table should not get disabled by user.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            hcd = new HColumnDescriptor("testFamily");
            admin.addColumn(VisibilityConstants.LABELS_TABLE_NAME, hcd);
            Assert.fail((String)"Lables table should not get altered by user.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            admin.deleteColumn(VisibilityConstants.LABELS_TABLE_NAME, VisibilityConstants.LABELS_TABLE_FAMILY);
            Assert.fail((String)"Lables table should not get altered by user.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            hcd = new HColumnDescriptor(VisibilityConstants.LABELS_TABLE_FAMILY);
            hcd.setBloomFilterType(BloomType.ROWCOL);
            admin.modifyColumn(VisibilityConstants.LABELS_TABLE_NAME, hcd);
            Assert.fail((String)"Lables table should not get altered by user.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            HTableDescriptor htd = new HTableDescriptor(VisibilityConstants.LABELS_TABLE_NAME);
            htd.addFamily(new HColumnDescriptor("f1"));
            htd.addFamily(new HColumnDescriptor("f2"));
            admin.modifyTable(VisibilityConstants.LABELS_TABLE_NAME, htd);
            Assert.fail((String)"Lables table should not get altered by user.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleVersions() throws Exception {
        byte[] r1 = Bytes.toBytes((String)"row1");
        byte[] r2 = Bytes.toBytes((String)"row2");
        byte[] v1 = Bytes.toBytes((String)"100");
        byte[] v2 = Bytes.toBytes((String)"101");
        byte[] fam2 = Bytes.toBytes((String)"info2");
        byte[] qual2 = Bytes.toBytes((String)"qual2");
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor col = new HColumnDescriptor(fam);
        desc.addFamily(col);
        col = new HColumnDescriptor(fam2);
        col.setMaxVersions(5);
        desc.addFamily(col);
        TEST_UTIL.getHBaseAdmin().createTable(desc);
        try (HTable table = null;){
            table = new HTable(TEST_UTIL.getConfiguration(), tableName);
            Put put = new Put(r1);
            put.add(fam, qual, 3L, v1);
            put.add(fam, qual2, 3L, v1);
            put.add(fam2, qual, 3L, v1);
            put.add(fam2, qual2, 3L, v1);
            put.setCellVisibility(new CellVisibility(SECRET));
            table.put(put);
            put = new Put(r1);
            put.add(fam, qual, 4L, v2);
            put.add(fam, qual2, 4L, v2);
            put.add(fam2, qual, 4L, v2);
            put.add(fam2, qual2, 4L, v2);
            put.setCellVisibility(new CellVisibility(PRIVATE));
            table.put(put);
            put = new Put(r2);
            put.add(fam, qual, 3L, v1);
            put.add(fam, qual2, 3L, v1);
            put.add(fam2, qual, 3L, v1);
            put.add(fam2, qual2, 3L, v1);
            put.setCellVisibility(new CellVisibility(SECRET));
            table.put(put);
            put = new Put(r2);
            put.add(fam, qual, 4L, v2);
            put.add(fam, qual2, 4L, v2);
            put.add(fam2, qual, 4L, v2);
            put.add(fam2, qual2, 4L, v2);
            put.setCellVisibility(new CellVisibility(SECRET));
            table.put(put);
            Scan s = new Scan();
            s.setMaxVersions(1);
            s.setAuthorizations(new Authorizations(new String[]{SECRET}));
            ResultScanner scanner = table.getScanner(s);
            Result result = scanner.next();
            Assert.assertTrue((boolean)Bytes.equals((byte[])r1, (byte[])result.getRow()));
            Assert.assertNull((Object)result.getColumnLatestCell(fam, qual));
            Assert.assertNull((Object)result.getColumnLatestCell(fam, qual2));
            Cell cell = result.getColumnLatestCell(fam2, qual);
            Assert.assertNotNull((Object)cell);
            Assert.assertTrue((boolean)Bytes.equals((byte[])v1, (int)0, (int)v1.length, (byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
            cell = result.getColumnLatestCell(fam2, qual2);
            Assert.assertNotNull((Object)cell);
            Assert.assertTrue((boolean)Bytes.equals((byte[])v1, (int)0, (int)v1.length, (byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
            result = scanner.next();
            Assert.assertTrue((boolean)Bytes.equals((byte[])r2, (byte[])result.getRow()));
            cell = result.getColumnLatestCell(fam, qual);
            Assert.assertNotNull((Object)cell);
            Assert.assertTrue((boolean)Bytes.equals((byte[])v2, (int)0, (int)v2.length, (byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
            cell = result.getColumnLatestCell(fam, qual2);
            Assert.assertNotNull((Object)cell);
            Assert.assertTrue((boolean)Bytes.equals((byte[])v2, (int)0, (int)v2.length, (byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
            cell = result.getColumnLatestCell(fam2, qual);
            Assert.assertNotNull((Object)cell);
            Assert.assertTrue((boolean)Bytes.equals((byte[])v2, (int)0, (int)v2.length, (byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
            cell = result.getColumnLatestCell(fam2, qual2);
            Assert.assertNotNull((Object)cell);
            Assert.assertTrue((boolean)Bytes.equals((byte[])v2, (int)0, (int)v2.length, (byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMutateRow() throws Exception {
        byte[] qual2 = Bytes.toBytes((String)"qual2");
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor col = new HColumnDescriptor(fam);
        desc.addFamily(col);
        TEST_UTIL.getHBaseAdmin().createTable(desc);
        try (HTable table = new HTable(TEST_UTIL.getConfiguration(), tableName);){
            Put p1 = new Put(row1);
            p1.add(fam, qual, value);
            p1.setCellVisibility(new CellVisibility(CONFIDENTIAL));
            Put p2 = new Put(row1);
            p2.add(fam, qual2, value);
            p2.setCellVisibility(new CellVisibility(SECRET));
            RowMutations rm = new RowMutations(row1);
            rm.add(p1);
            rm.add(p2);
            table.mutateRow(rm);
            Get get = new Get(row1);
            get.setAuthorizations(new Authorizations(new String[]{CONFIDENTIAL}));
            Result result = table.get(get);
            Assert.assertTrue((boolean)result.containsColumn(fam, qual));
            Assert.assertFalse((boolean)result.containsColumn(fam, qual2));
            get.setAuthorizations(new Authorizations(new String[]{SECRET}));
            result = table.get(get);
            Assert.assertFalse((boolean)result.containsColumn(fam, qual));
            Assert.assertTrue((boolean)result.containsColumn(fam, qual2));
        }
    }

    static Table createTableAndWriteDataWithLabels(TableName tableName, String ... labelExps) throws Exception {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < labelExps.length; ++i) {
            Put put = new Put(Bytes.toBytes((String)("row" + (i + 1))));
            put.add(fam, qual, Long.MAX_VALUE, value);
            put.setCellVisibility(new CellVisibility(labelExps[i]));
            puts.add(put);
        }
        HTable table = TEST_UTIL.createTable(tableName, fam);
        table.put(puts);
        return table;
    }

    public static void addLabels() throws Exception {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                String[] labels = new String[]{TestVisibilityLabels.SECRET, TestVisibilityLabels.TOPSECRET, TestVisibilityLabels.CONFIDENTIAL, TestVisibilityLabels.PUBLIC, TestVisibilityLabels.PRIVATE, TestVisibilityLabels.COPYRIGHT, TestVisibilityLabels.ACCENT, TestVisibilityLabels.UNICODE_VIS_TAG, TestVisibilityLabels.UC1, TestVisibilityLabels.UC2};
                try {
                    VisibilityClient.addLabels((Configuration)conf, (String[])labels);
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
                return null;
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
    }
}

