/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.HFilePrettyPrinter;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.TestMultiColumnScanner;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SmallTests.class})
public class TestScanWithBloomError {
    private static final Log LOG = LogFactory.getLog(TestScanWithBloomError.class);
    private static final String TABLE_NAME = "ScanWithBloomError";
    private static final String FAMILY = "myCF";
    private static final byte[] FAMILY_BYTES = Bytes.toBytes((String)"myCF");
    private static final String ROW = "theRow";
    private static final String QUALIFIER_PREFIX = "qual";
    private static final byte[] ROW_BYTES = Bytes.toBytes((String)"theRow");
    private static NavigableSet<Integer> allColIds = new TreeSet<Integer>();
    private HRegion region;
    private BloomType bloomType;
    private FileSystem fs;
    private Configuration conf;
    private static final HBaseTestingUtility TEST_UTIL = HBaseTestingUtility.createLocalHTU();

    @Parameterized.Parameters
    public static final Collection<Object[]> parameters() {
        ArrayList<Object[]> configurations = new ArrayList<Object[]>();
        for (BloomType bloomType : BloomType.values()) {
            configurations.add(new Object[]{bloomType});
        }
        return configurations;
    }

    public TestScanWithBloomError(BloomType bloomType) {
        this.bloomType = bloomType;
    }

    @Before
    public void setUp() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        this.fs = FileSystem.get((Configuration)this.conf);
    }

    @Test
    public void testThreeStoreFiles() throws IOException {
        this.region = TEST_UTIL.createTestRegion(TABLE_NAME, new HColumnDescriptor(FAMILY).setCompressionType(Compression.Algorithm.GZ).setBloomFilterType(this.bloomType).setMaxVersions(50));
        this.createStoreFile(new int[]{1, 2, 6});
        this.createStoreFile(new int[]{1, 2, 3, 7});
        this.createStoreFile(new int[]{1, 9});
        this.scanColSet(new int[]{1, 4, 6, 7}, new int[]{1, 6, 7});
        HRegion.closeHRegion((HRegion)this.region);
    }

    private void scanColSet(int[] colSet, int[] expectedResultCols) throws IOException {
        LOG.info((Object)("Scanning column set: " + Arrays.toString(colSet)));
        Scan scan = new Scan(ROW_BYTES, ROW_BYTES);
        this.addColumnSetToScan(scan, colSet);
        HRegion.RegionScannerImpl scanner = (HRegion.RegionScannerImpl)this.region.getScanner(scan);
        KeyValueHeap storeHeap = scanner.getStoreHeapForTesting();
        Assert.assertEquals((long)0L, (long)storeHeap.getHeap().size());
        StoreScanner storeScanner = (StoreScanner)storeHeap.getCurrentForTesting();
        List scanners = storeScanner.getAllScannersForTesting();
        Collections.sort(scanners, new Comparator<StoreFileScanner>(){

            @Override
            public int compare(StoreFileScanner s1, StoreFileScanner s2) {
                long t2;
                long t1;
                Path p1 = s1.getReader().getHFileReader().getPath();
                Path p2 = s2.getReader().getHFileReader().getPath();
                try {
                    t1 = TestScanWithBloomError.this.fs.getFileStatus(p1).getModificationTime();
                    t2 = TestScanWithBloomError.this.fs.getFileStatus(p2).getModificationTime();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                return t1 < t2 ? -1 : (t1 == t2 ? 1 : 0);
            }
        });
        StoreFile.Reader lastStoreFileReader = null;
        for (StoreFileScanner sfScanner : scanners) {
            lastStoreFileReader = sfScanner.getReader();
        }
        new HFilePrettyPrinter(this.conf).run(new String[]{"-m", "-p", "-f", lastStoreFileReader.getHFileReader().getPath().toString()});
        LOG.info((Object)("Disabling Bloom filter for: " + lastStoreFileReader.getHFileReader().getName()));
        lastStoreFileReader.disableBloomFilterForTesting();
        ArrayList allResults = new ArrayList();
        ArrayList results = new ArrayList();
        while (scanner.next(results) || results.size() > 0) {
            allResults.addAll(results);
            results.clear();
        }
        ArrayList<Integer> actualIds = new ArrayList<Integer>();
        for (Cell kv : allResults) {
            String qual = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kv));
            Assert.assertTrue((boolean)qual.startsWith(QUALIFIER_PREFIX));
            actualIds.add(Integer.valueOf(qual.substring(QUALIFIER_PREFIX.length())));
        }
        ArrayList<Integer> expectedIds = new ArrayList<Integer>();
        for (int expectedId : expectedResultCols) {
            expectedIds.add(expectedId);
        }
        LOG.info((Object)("Column ids returned: " + actualIds + ", expected: " + expectedIds));
        Assert.assertEquals((Object)((Object)expectedIds).toString(), (Object)((Object)actualIds).toString());
    }

    private void addColumnSetToScan(Scan scan, int[] colIds) {
        for (int colId : colIds) {
            scan.addColumn(FAMILY_BYTES, Bytes.toBytes((String)this.qualFromId(colId)));
        }
    }

    private String qualFromId(int colId) {
        return QUALIFIER_PREFIX + colId;
    }

    private void createStoreFile(int[] colIds) throws IOException {
        Put p = new Put(ROW_BYTES);
        for (int colId : colIds) {
            long ts = Long.MAX_VALUE;
            String qual = this.qualFromId(colId);
            allColIds.add(colId);
            KeyValue kv = KeyValueTestUtil.create((String)ROW, (String)FAMILY, (String)qual, (long)ts, (String)TestMultiColumnScanner.createValue(ROW, qual, ts));
            p.add((Cell)kv);
        }
        this.region.put(p);
        this.region.flushcache();
    }
}

