/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestMobCompaction {
    @Rule
    public TestName name = new TestName();
    static final Log LOG = LogFactory.getLog((String)TestMobCompaction.class.getName());
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private Configuration conf = null;
    private HRegion region = null;
    private HTableDescriptor htd = null;
    private HColumnDescriptor hcd = null;
    private long mobCellThreshold = 1000L;
    private FileSystem fs;
    private static final byte[] COLUMN_FAMILY = HBaseTestingUtility.fam1;
    private final byte[] STARTROW = Bytes.toBytes((String)HBaseTestingUtility.START_KEY);
    private int compactionThreshold;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.getConfiguration().setInt("hfile.format.version", 3);
        UTIL.getConfiguration().setInt("hbase.master.info.port", 0);
        UTIL.getConfiguration().setBoolean("hbase.regionserver.info.port.auto", true);
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    private void init(Configuration conf, long mobThreshold) throws Exception {
        this.conf = conf;
        this.mobCellThreshold = mobThreshold;
        HBaseTestingUtility UTIL = new HBaseTestingUtility(conf);
        this.compactionThreshold = conf.getInt("hbase.hstore.compactionThreshold", 3);
        this.htd = UTIL.createTableDescriptor(this.name.getMethodName());
        this.hcd = this.htd.getFamily(COLUMN_FAMILY);
        this.hcd.setMobEnabled(true);
        this.hcd.setMobThreshold(mobThreshold);
        this.hcd.setMaxVersions(1);
        this.region = UTIL.createLocalHRegion(this.htd, null, null);
        this.fs = FileSystem.get((Configuration)conf);
    }

    @After
    public void tearDown() throws Exception {
        this.region.close();
        this.fs.delete(UTIL.getDataTestDir(), true);
    }

    @Test
    public void testSmallerValue() throws Exception {
        this.init(UTIL.getConfiguration(), 500L);
        byte[] dummyData = this.makeDummyData(300);
        HBaseTestCase.HRegionIncommon loader = new HBaseTestCase.HRegionIncommon(this.region);
        for (int i = 0; i < this.compactionThreshold; ++i) {
            Put p = this.createPut(i, dummyData);
            loader.put(p);
            loader.flushcache();
        }
        Assert.assertEquals((String)"Before compaction: store files", (long)this.compactionThreshold, (long)this.countStoreFiles());
        Assert.assertEquals((String)"Before compaction: mob file count", (long)0L, (long)this.countMobFiles());
        Assert.assertEquals((String)"Before compaction: rows", (long)this.compactionThreshold, (long)this.countRows());
        Assert.assertEquals((String)"Before compaction: mob rows", (long)0L, (long)this.countMobRows());
        this.region.compactStores();
        Assert.assertEquals((String)"After compaction: store files", (long)1L, (long)this.countStoreFiles());
        Assert.assertEquals((String)"After compaction: mob file count", (long)0L, (long)this.countMobFiles());
        Assert.assertEquals((String)"After compaction: referenced mob file count", (long)0L, (long)this.countReferencedMobFiles());
        Assert.assertEquals((String)"After compaction: rows", (long)this.compactionThreshold, (long)this.countRows());
        Assert.assertEquals((String)"After compaction: mob rows", (long)0L, (long)this.countMobRows());
    }

    @Test
    public void testLargerValue() throws Exception {
        this.init(UTIL.getConfiguration(), 200L);
        byte[] dummyData = this.makeDummyData(300);
        HBaseTestCase.HRegionIncommon loader = new HBaseTestCase.HRegionIncommon(this.region);
        for (int i = 0; i < this.compactionThreshold; ++i) {
            Put p = this.createPut(i, dummyData);
            loader.put(p);
            loader.flushcache();
        }
        Assert.assertEquals((String)"Before compaction: store files", (long)this.compactionThreshold, (long)this.countStoreFiles());
        Assert.assertEquals((String)"Before compaction: mob file count", (long)this.compactionThreshold, (long)this.countMobFiles());
        Assert.assertEquals((String)"Before compaction: rows", (long)this.compactionThreshold, (long)this.countRows());
        Assert.assertEquals((String)"Before compaction: mob rows", (long)this.compactionThreshold, (long)this.countMobRows());
        Assert.assertEquals((String)"Before compaction: number of mob cells", (long)this.compactionThreshold, (long)this.countMobCellsInMetadata());
        this.region.getTableDesc().getFamily(COLUMN_FAMILY).setMobThreshold(500L);
        this.region.initialize();
        this.region.compactStores();
        Assert.assertEquals((String)"After compaction: store files", (long)1L, (long)this.countStoreFiles());
        Assert.assertEquals((String)"After compaction: mob file count", (long)this.compactionThreshold, (long)this.countMobFiles());
        Assert.assertEquals((String)"After compaction: referenced mob file count", (long)0L, (long)this.countReferencedMobFiles());
        Assert.assertEquals((String)"After compaction: rows", (long)this.compactionThreshold, (long)this.countRows());
        Assert.assertEquals((String)"After compaction: mob rows", (long)0L, (long)this.countMobRows());
    }

    @Test
    public void testMobCompactionWithBulkload() throws Exception {
        this.init(UTIL.getConfiguration(), 300L);
        byte[] dummyData = this.makeDummyData(600);
        Path hbaseRootDir = FSUtils.getRootDir((Configuration)this.conf);
        Path basedir = new Path(hbaseRootDir, this.htd.getNameAsString());
        ArrayList<Pair> hfiles = new ArrayList<Pair>(1);
        for (int i = 0; i < this.compactionThreshold; ++i) {
            Path hpath = new Path(basedir, "hfile" + i);
            hfiles.add(Pair.newPair((Object)COLUMN_FAMILY, (Object)hpath.toString()));
            this.createHFile(hpath, i, dummyData);
        }
        boolean result = this.region.bulkLoadHFiles(hfiles, true);
        Assert.assertTrue((String)"Bulkload result:", (boolean)result);
        Assert.assertEquals((String)"Before compaction: store files", (long)this.compactionThreshold, (long)this.countStoreFiles());
        Assert.assertEquals((String)"Before compaction: mob file count", (long)0L, (long)this.countMobFiles());
        Assert.assertEquals((String)"Before compaction: rows", (long)this.compactionThreshold, (long)this.countRows());
        Assert.assertEquals((String)"Before compaction: mob rows", (long)0L, (long)this.countMobRows());
        Assert.assertEquals((String)"Before compaction: referenced mob file count", (long)0L, (long)this.countReferencedMobFiles());
        this.region.compactStores();
        Assert.assertEquals((String)"After compaction: store files", (long)1L, (long)this.countStoreFiles());
        Assert.assertEquals((String)"After compaction: mob file count:", (long)1L, (long)this.countMobFiles());
        Assert.assertEquals((String)"After compaction: rows", (long)this.compactionThreshold, (long)this.countRows());
        Assert.assertEquals((String)"After compaction: mob rows", (long)this.compactionThreshold, (long)this.countMobRows());
        Assert.assertEquals((String)"After compaction: referenced mob file count", (long)1L, (long)this.countReferencedMobFiles());
        Assert.assertEquals((String)"After compaction: number of mob cells", (long)this.compactionThreshold, (long)this.countMobCellsInMetadata());
    }

    @Test
    public void testMajorCompactionAfterDelete() throws Exception {
        this.init(UTIL.getConfiguration(), 100L);
        byte[] dummyData = this.makeDummyData(200);
        HBaseTestCase.HRegionIncommon loader = new HBaseTestCase.HRegionIncommon(this.region);
        int numHfiles = this.compactionThreshold - 1;
        byte[] deleteRow = Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)0));
        for (int i = 0; i < numHfiles; ++i) {
            Put p = this.createPut(i, dummyData);
            loader.put(p);
            loader.flushcache();
        }
        Assert.assertEquals((String)"Before compaction: store files", (long)numHfiles, (long)this.countStoreFiles());
        Assert.assertEquals((String)"Before compaction: mob file count", (long)numHfiles, (long)this.countMobFiles());
        Assert.assertEquals((String)"Before compaction: rows", (long)numHfiles, (long)this.countRows());
        Assert.assertEquals((String)"Before compaction: mob rows", (long)numHfiles, (long)this.countMobRows());
        Assert.assertEquals((String)"Before compaction: number of mob cells", (long)numHfiles, (long)this.countMobCellsInMetadata());
        Delete delete = new Delete(deleteRow);
        delete.deleteFamily(COLUMN_FAMILY);
        this.region.delete(delete);
        loader.flushcache();
        Assert.assertEquals((String)"Before compaction: store files", (long)(numHfiles + 1), (long)this.countStoreFiles());
        Assert.assertEquals((String)"Before compaction: mob files", (long)numHfiles, (long)this.countMobFiles());
        this.region.compactStores(true);
        Assert.assertEquals((String)"After compaction: store files", (long)1L, (long)this.countStoreFiles());
        Assert.assertEquals((String)"After compaction: mob files", (long)(numHfiles + 1), (long)this.countMobFiles());
        Scan scan = new Scan();
        scan.setRaw(true);
        RegionScanner scanner = this.region.getScanner(scan);
        ArrayList results = new ArrayList();
        scanner.next(results);
        int deleteCount = 0;
        while (!results.isEmpty()) {
            for (Cell c : results) {
                if (c.getTypeByte() != KeyValue.Type.DeleteFamily.getCode()) continue;
                ++deleteCount;
                Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)c), (byte[])deleteRow));
            }
            results.clear();
            scanner.next(results);
        }
        Assert.assertEquals((long)0L, (long)deleteCount);
        scanner.close();
        Assert.assertEquals((String)"The cells in mob files", (long)(numHfiles - 1), (long)this.countMobCellsInMobFiles(1));
    }

    private int countStoreFiles() throws IOException {
        Store store = this.region.getStore(COLUMN_FAMILY);
        return store.getStorefilesCount();
    }

    private int countMobFiles() throws IOException {
        Path mobDirPath = new Path(MobUtils.getMobRegionPath((Configuration)this.conf, (TableName)this.htd.getTableName()), this.hcd.getNameAsString());
        if (this.fs.exists(mobDirPath)) {
            FileStatus[] files = UTIL.getTestFileSystem().listStatus(mobDirPath);
            return files.length;
        }
        return 0;
    }

    private long countMobCellsInMetadata() throws IOException {
        long mobCellsCount = 0L;
        Path mobDirPath = new Path(MobUtils.getMobRegionPath((Configuration)this.conf, (TableName)this.htd.getTableName()), this.hcd.getNameAsString());
        Configuration copyOfConf = new Configuration(this.conf);
        copyOfConf.setFloat("hfile.block.cache.size", 0.0f);
        CacheConfig cacheConfig = new CacheConfig(copyOfConf);
        if (this.fs.exists(mobDirPath)) {
            FileStatus[] files;
            for (FileStatus file : files = UTIL.getTestFileSystem().listStatus(mobDirPath)) {
                StoreFile sf = new StoreFile(this.fs, file.getPath(), this.conf, cacheConfig, BloomType.NONE);
                Map fileInfo = sf.createReader().loadFileInfo();
                byte[] count = (byte[])fileInfo.get(StoreFile.MOB_CELLS_COUNT);
                Assert.assertTrue((count != null ? 1 : 0) != 0);
                mobCellsCount += Bytes.toLong((byte[])count);
            }
        }
        return mobCellsCount;
    }

    private Put createPut(int rowIdx, byte[] dummyData) throws IOException {
        Put p = new Put(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)rowIdx)));
        p.setDurability(Durability.SKIP_WAL);
        p.add(COLUMN_FAMILY, Bytes.toBytes((String)"colX"), dummyData);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHFile(Path path, int rowIdx, byte[] dummyData) throws IOException {
        HFileContext meta = new HFileContextBuilder().build();
        HFile.Writer writer = HFile.getWriterFactory((Configuration)this.conf, (CacheConfig)new CacheConfig(this.conf)).withPath(this.fs, path).withFileContext(meta).create();
        long now = System.currentTimeMillis();
        try {
            KeyValue kv = new KeyValue(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)rowIdx)), COLUMN_FAMILY, Bytes.toBytes((String)"colX"), now, dummyData);
            writer.append((Cell)kv);
        }
        finally {
            writer.appendFileInfo(StoreFile.BULKLOAD_TIME_KEY, Bytes.toBytes((long)System.currentTimeMillis()));
            writer.close();
        }
    }

    private int countMobRows() throws IOException {
        Scan scan = new Scan();
        scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        RegionScanner scanner = this.region.getScanner(scan);
        int scannedCount = 0;
        ArrayList results = new ArrayList();
        boolean hasMore = true;
        while (hasMore) {
            hasMore = scanner.next(results);
            for (Cell c : results) {
                if (!MobUtils.isMobReferenceCell((Cell)c)) continue;
                ++scannedCount;
            }
            results.clear();
        }
        scanner.close();
        return scannedCount;
    }

    private int countRows() throws IOException {
        Scan scan = new Scan();
        RegionScanner scanner = this.region.getScanner(scan);
        int scannedCount = 0;
        ArrayList results = new ArrayList();
        boolean hasMore = true;
        while (hasMore) {
            hasMore = scanner.next(results);
            scannedCount += results.size();
            results.clear();
        }
        scanner.close();
        return scannedCount;
    }

    private byte[] makeDummyData(int size) {
        byte[] dummyData = new byte[size];
        new Random().nextBytes(dummyData);
        return dummyData;
    }

    private int countReferencedMobFiles() throws IOException {
        Scan scan = new Scan();
        scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        RegionScanner scanner = this.region.getScanner(scan);
        ArrayList kvs = new ArrayList();
        boolean hasMore = true;
        HashSet<String> files = new HashSet<String>();
        do {
            kvs.clear();
            hasMore = scanner.next(kvs);
            for (Cell c : kvs) {
                String fileName;
                int size;
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)c);
                if (!MobUtils.isMobReferenceCell((Cell)kv) || !MobUtils.hasValidMobRefCellValue((Cell)kv) || (long)(size = MobUtils.getMobValueLength((Cell)kv)) <= this.mobCellThreshold || (fileName = MobUtils.getMobFileName((Cell)kv)).isEmpty()) continue;
                files.add(fileName);
                Path familyPath = MobUtils.getMobFamilyPath((Configuration)this.conf, (TableName)this.htd.getTableName(), (String)this.hcd.getNameAsString());
                Assert.assertTrue((boolean)this.fs.exists(new Path(familyPath, fileName)));
            }
        } while (hasMore);
        scanner.close();
        return files.size();
    }

    private int countMobCellsInMobFiles(int expectedNumDelfiles) throws IOException {
        Configuration copyOfConf = new Configuration(this.conf);
        copyOfConf.setFloat("hfile.block.cache.size", 0.0f);
        CacheConfig cacheConfig = new CacheConfig(copyOfConf);
        Path mobDirPath = new Path(MobUtils.getMobRegionPath((Configuration)this.conf, (TableName)this.htd.getTableName()), this.hcd.getNameAsString());
        ArrayList<StoreFile> sfs = new ArrayList<StoreFile>();
        int numDelfiles = 0;
        int size = 0;
        if (this.fs.exists(mobDirPath)) {
            for (FileStatus f : this.fs.listStatus(mobDirPath)) {
                StoreFile sf = new StoreFile(this.fs, f.getPath(), this.conf, cacheConfig, BloomType.NONE);
                sfs.add(sf);
                if (!StoreFileInfo.isDelFile((Path)sf.getPath())) continue;
                ++numDelfiles;
            }
            List scanners = StoreFileScanner.getScannersForStoreFiles(sfs, (boolean)false, (boolean)true, (boolean)false, null, (long)Long.MAX_VALUE);
            Scan scan = new Scan();
            scan.setMaxVersions(this.hcd.getMaxVersions());
            long timeToPurgeDeletes = Math.max(this.conf.getLong("hbase.hstore.time.to.purge.deletes", 0L), 0L);
            long ttl = HStore.determineTTLFromFamily((HColumnDescriptor)this.hcd);
            ScanInfo scanInfo = new ScanInfo(this.hcd, ttl, timeToPurgeDeletes, KeyValue.COMPARATOR);
            StoreScanner scanner = new StoreScanner(scan, scanInfo, ScanType.COMPACT_DROP_DELETES, null, scanners, 0L, Long.MAX_VALUE);
            ArrayList results = new ArrayList();
            boolean hasMore = true;
            while (hasMore) {
                hasMore = scanner.next(results);
                size += results.size();
                results.clear();
            }
        }
        Assert.assertEquals((long)expectedNumDelfiles, (long)numDelfiles);
        return size;
    }
}

