/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob.mapreduce;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.mob.mapreduce.SweepJob;
import org.apache.hadoop.hbase.mob.mapreduce.SweepMapper;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class})
public class TestMobSweepMapper {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.master.info.port", 0);
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.info.port.auto", true);
        TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestMap() throws Exception {
        String prefix = "0000";
        String fileName = "19691231f2cd014ea28f42788214560a21a44cef";
        String mobFilePath = prefix + "19691231f2cd014ea28f42788214560a21a44cef";
        ImmutableBytesWritable r = new ImmutableBytesWritable(Bytes.toBytes((String)"r"));
        final KeyValue[] kvList = new KeyValue[]{new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"column"), Bytes.toBytes((String)mobFilePath))};
        Result columns = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)columns.raw()).thenReturn((Object)kvList);
        Configuration configuration = new Configuration(TEST_UTIL.getConfiguration());
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(configuration, "1", (Abortable)new SweepJob.DummyMobAbortable());
        TableName tn = TableName.valueOf((String)"testSweepMapper");
        TableName lockName = MobUtils.getTableLockName((TableName)tn);
        String znode = ZKUtil.joinZNode((String)zkw.tableLockZNode, (String)lockName.getNameAsString());
        configuration.set("mob.sweep.job.id", "1");
        configuration.set("mob.sweep.job.table.node", znode);
        ServerName serverName = SweepJob.getCurrentServerName((Configuration)configuration);
        configuration.set("mob.sweep.job.servername", serverName.toString());
        TableLockManager tableLockManager = TableLockManager.createTableLockManager((Configuration)configuration, (ZooKeeperWatcher)zkw, (ServerName)serverName);
        TableLockManager.TableLock lock = tableLockManager.writeLock(lockName, "Run sweep tool");
        lock.acquire();
        try {
            Mapper.Context ctx = (Mapper.Context)Mockito.mock(Mapper.Context.class);
            Mockito.when((Object)ctx.getConfiguration()).thenReturn((Object)configuration);
            SweepMapper map = new SweepMapper();
            ((Mapper.Context)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) throws Throwable {
                    Text text = (Text)invocation.getArguments()[0];
                    KeyValue kv = (KeyValue)invocation.getArguments()[1];
                    Assert.assertEquals((Object)Bytes.toString((byte[])text.getBytes(), (int)0, (int)text.getLength()), (Object)"19691231f2cd014ea28f42788214560a21a44cef");
                    Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])kv.getKey(), (byte[])kvList[0].getKey()));
                    return null;
                }
            }).when((Object)ctx)).write(Matchers.any(Text.class), Matchers.any(KeyValue.class));
            map.map(r, columns, ctx);
        }
        finally {
            lock.release();
        }
    }
}

