/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob.mapreduce;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.mob.mapreduce.SweepJob;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.serializer.JavaSerialization;
import org.apache.hadoop.io.serializer.WritableSerialization;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMobSweepJob {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.master.info.port", 0);
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.info.port.auto", true);
        TEST_UTIL.getConfiguration().set("io.serializations", JavaSerialization.class.getName() + "," + WritableSerialization.class.getName());
        TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileNames(FileSystem fs, Configuration conf, Path path, String[] filesNames) throws IOException {
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)path, String.class, String.class);
        try {
            for (String fileName : filesNames) {
                writer.append((Object)fileName, (Object)"");
            }
        }
        finally {
            IOUtils.closeStream((Closeable)writer);
        }
    }

    @Test
    public void testSweeperJobWithOutUnusedFile() throws Exception {
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Configuration configuration = new Configuration(TEST_UTIL.getConfiguration());
        Path vistiedFileNamesPath = new Path(MobUtils.getMobHome((Configuration)configuration), "/hbase/mobcompaction/SweepJob/working/names/0/visited");
        Path allFileNamesPath = new Path(MobUtils.getMobHome((Configuration)configuration), "/hbase/mobcompaction/SweepJob/working/names/0/all");
        configuration.set("mob.sweep.job.visited.dir", vistiedFileNamesPath.toString());
        configuration.set("mob.sweep.job.all.file", allFileNamesPath.toString());
        this.writeFileNames(fs, configuration, allFileNamesPath, new String[]{"1", "2", "3", "4", "5", "6"});
        Path r0 = new Path(vistiedFileNamesPath, "r0");
        this.writeFileNames(fs, configuration, r0, new String[]{"1", "2", "3"});
        Path r1 = new Path(vistiedFileNamesPath, "r1");
        this.writeFileNames(fs, configuration, r1, new String[]{"1", "4", "5"});
        Path r2 = new Path(vistiedFileNamesPath, "r2");
        this.writeFileNames(fs, configuration, r2, new String[]{"2", "3", "6"});
        SweepJob sweepJob = new SweepJob(configuration, fs);
        List toBeArchived = sweepJob.getUnusedFiles(configuration);
        Assert.assertEquals((long)0L, (long)toBeArchived.size());
    }

    @Test
    public void testSweeperJobWithUnusedFile() throws Exception {
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Configuration configuration = new Configuration(TEST_UTIL.getConfiguration());
        Path vistiedFileNamesPath = new Path(MobUtils.getMobHome((Configuration)configuration), "/hbase/mobcompaction/SweepJob/working/names/1/visited");
        Path allFileNamesPath = new Path(MobUtils.getMobHome((Configuration)configuration), "/hbase/mobcompaction/SweepJob/working/names/1/all");
        configuration.set("mob.sweep.job.visited.dir", vistiedFileNamesPath.toString());
        configuration.set("mob.sweep.job.all.file", allFileNamesPath.toString());
        this.writeFileNames(fs, configuration, allFileNamesPath, new String[]{"1", "2", "3", "4", "5", "6"});
        Path r0 = new Path(vistiedFileNamesPath, "r0");
        this.writeFileNames(fs, configuration, r0, new String[]{"1", "2", "3"});
        Path r1 = new Path(vistiedFileNamesPath, "r1");
        this.writeFileNames(fs, configuration, r1, new String[]{"1", "5"});
        Path r2 = new Path(vistiedFileNamesPath, "r2");
        this.writeFileNames(fs, configuration, r2, new String[]{"2", "3"});
        SweepJob sweepJob = new SweepJob(configuration, fs);
        List toBeArchived = sweepJob.getUnusedFiles(configuration);
        Assert.assertEquals((long)2L, (long)toBeArchived.size());
        Assert.assertEquals((Object[])new String[]{"4", "6"}, (Object[])toBeArchived.toArray(new String[0]));
    }

    @Test
    public void testSweeperJobWithRedundantFile() throws Exception {
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Configuration configuration = new Configuration(TEST_UTIL.getConfiguration());
        Path vistiedFileNamesPath = new Path(MobUtils.getMobHome((Configuration)configuration), "/hbase/mobcompaction/SweepJob/working/names/2/visited");
        Path allFileNamesPath = new Path(MobUtils.getMobHome((Configuration)configuration), "/hbase/mobcompaction/SweepJob/working/names/2/all");
        configuration.set("mob.sweep.job.visited.dir", vistiedFileNamesPath.toString());
        configuration.set("mob.sweep.job.all.file", allFileNamesPath.toString());
        this.writeFileNames(fs, configuration, allFileNamesPath, new String[]{"1", "2", "3", "4", "5", "6"});
        Path r0 = new Path(vistiedFileNamesPath, "r0");
        this.writeFileNames(fs, configuration, r0, new String[]{"1", "2", "3"});
        Path r1 = new Path(vistiedFileNamesPath, "r1");
        this.writeFileNames(fs, configuration, r1, new String[]{"1", "5", "6", "7"});
        Path r2 = new Path(vistiedFileNamesPath, "r2");
        this.writeFileNames(fs, configuration, r2, new String[]{"2", "3", "4"});
        SweepJob sweepJob = new SweepJob(configuration, fs);
        List toBeArchived = sweepJob.getUnusedFiles(configuration);
        Assert.assertEquals((long)0L, (long)toBeArchived.size());
    }
}

