/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob.filecompactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.mob.MobFileName;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.mob.filecompactions.MobFileCompactionRequest;
import org.apache.hadoop.hbase.mob.filecompactions.PartitionedMobFileCompactionRequest;
import org.apache.hadoop.hbase.mob.filecompactions.PartitionedMobFileCompactor;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestPartitionedMobFileCompactor {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String family = "family";
    private static final String qf = "qf";
    private HColumnDescriptor hcd = new HColumnDescriptor("family");
    private Configuration conf = TEST_UTIL.getConfiguration();
    private CacheConfig cacheConf = new CacheConfig(this.conf);
    private FileSystem fs;
    private List<FileStatus> mobFiles = new ArrayList<FileStatus>();
    private List<FileStatus> delFiles = new ArrayList<FileStatus>();
    private List<FileStatus> allFiles = new ArrayList<FileStatus>();
    private Path basePath;
    private String mobSuffix;
    private String delSuffix;
    private static ExecutorService pool;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.master.info.port", 0);
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.info.port.auto", true);
        TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        TEST_UTIL.startMiniCluster(1);
        pool = TestPartitionedMobFileCompactor.createThreadPool(TEST_UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        pool.shutdown();
        TEST_UTIL.shutdownMiniCluster();
    }

    private void init(String tableName) throws Exception {
        this.fs = FileSystem.get((Configuration)this.conf);
        Path testDir = FSUtils.getRootDir((Configuration)this.conf);
        Path mobTestDir = new Path(testDir, "mobdir");
        this.basePath = new Path(new Path(mobTestDir, tableName), family);
        this.mobSuffix = UUID.randomUUID().toString().replaceAll("-", "");
        this.delSuffix = UUID.randomUUID().toString().replaceAll("-", "") + "_del";
    }

    @Test
    public void testCompactionSelectWithAllFiles() throws Exception {
        this.resetConf();
        String tableName = "testCompactionSelectWithAllFiles";
        this.init(tableName);
        int count = 10;
        this.createStoreFiles(this.basePath, family, qf, count, KeyValue.Type.Put);
        this.createStoreFiles(this.basePath, family, qf, count, KeyValue.Type.Delete);
        this.listFiles();
        long mergeSize = 0xC000000L;
        ArrayList<String> expectedStartKeys = new ArrayList<String>();
        for (FileStatus file : this.mobFiles) {
            if (file.getLen() >= mergeSize) continue;
            String fileName = file.getPath().getName();
            String startKey = fileName.substring(0, 32);
            expectedStartKeys.add(startKey);
        }
        this.testSelectFiles(tableName, MobFileCompactionRequest.CompactionType.ALL_FILES, false, expectedStartKeys);
    }

    @Test
    public void testCompactionSelectWithPartFiles() throws Exception {
        this.resetConf();
        String tableName = "testCompactionSelectWithPartFiles";
        this.init(tableName);
        int count = 10;
        this.createStoreFiles(this.basePath, family, qf, count, KeyValue.Type.Put);
        this.createStoreFiles(this.basePath, family, qf, count, KeyValue.Type.Delete);
        this.listFiles();
        long mergeSize = 4000L;
        ArrayList<String> expectedStartKeys = new ArrayList<String>();
        for (FileStatus file : this.mobFiles) {
            if (file.getLen() >= 4000L) continue;
            String fileName = file.getPath().getName();
            String startKey = fileName.substring(0, 32);
            expectedStartKeys.add(startKey);
        }
        this.conf.setLong("hbase.mob.file.compaction.mergeable.threshold", mergeSize);
        this.testSelectFiles(tableName, MobFileCompactionRequest.CompactionType.PART_FILES, false, expectedStartKeys);
    }

    @Test
    public void testCompactionSelectWithForceAllFiles() throws Exception {
        this.resetConf();
        String tableName = "testCompactionSelectWithForceAllFiles";
        this.init(tableName);
        int count = 10;
        this.createStoreFiles(this.basePath, family, qf, count, KeyValue.Type.Put);
        this.createStoreFiles(this.basePath, family, qf, count, KeyValue.Type.Delete);
        this.listFiles();
        long mergeSize = 4000L;
        ArrayList<String> expectedStartKeys = new ArrayList<String>();
        for (FileStatus file : this.mobFiles) {
            String fileName = file.getPath().getName();
            String startKey = fileName.substring(0, 32);
            expectedStartKeys.add(startKey);
        }
        this.conf.setLong("hbase.mob.file.compaction.mergeable.threshold", mergeSize);
        this.testSelectFiles(tableName, MobFileCompactionRequest.CompactionType.ALL_FILES, true, expectedStartKeys);
    }

    @Test
    public void testCompactDelFilesWithDefaultBatchSize() throws Exception {
        this.resetConf();
        String tableName = "testCompactDelFilesWithDefaultBatchSize";
        this.init(tableName);
        this.createStoreFiles(this.basePath, family, qf, 20, KeyValue.Type.Put);
        this.createStoreFiles(this.basePath, family, qf, 13, KeyValue.Type.Delete);
        this.listFiles();
        this.testCompactDelFiles(tableName, 1, 13, false);
    }

    @Test
    public void testCompactDelFilesWithSmallBatchSize() throws Exception {
        this.resetConf();
        String tableName = "testCompactDelFilesWithSmallBatchSize";
        this.init(tableName);
        this.createStoreFiles(this.basePath, family, qf, 20, KeyValue.Type.Put);
        this.createStoreFiles(this.basePath, family, qf, 13, KeyValue.Type.Delete);
        this.listFiles();
        this.conf.setInt("hbase.mob.file.compaction.batch.size", 4);
        this.testCompactDelFiles(tableName, 1, 13, false);
    }

    @Test
    public void testCompactDelFilesChangeMaxDelFileCount() throws Exception {
        this.resetConf();
        String tableName = "testCompactDelFilesWithSmallBatchSize";
        this.init(tableName);
        this.createStoreFiles(this.basePath, family, qf, 20, KeyValue.Type.Put);
        this.createStoreFiles(this.basePath, family, qf, 13, KeyValue.Type.Delete);
        this.listFiles();
        this.conf.setInt("hbase.mob.delfile.max.count", 5);
        this.conf.setInt("hbase.mob.file.compaction.batch.size", 2);
        this.testCompactDelFiles(tableName, 4, 13, false);
    }

    private void testSelectFiles(String tableName, final MobFileCompactionRequest.CompactionType type, boolean isForceAllFiles, final List<String> expected) throws IOException {
        PartitionedMobFileCompactor compactor = new PartitionedMobFileCompactor(this.conf, this.fs, TableName.valueOf((String)tableName), this.hcd, pool){

            public List<Path> compact(List<FileStatus> files, boolean isForceAllFiles) throws IOException {
                if (files == null || files.isEmpty()) {
                    return null;
                }
                PartitionedMobFileCompactionRequest request = this.select(files, isForceAllFiles);
                Assert.assertEquals((Object)type, (Object)request.type);
                TestPartitionedMobFileCompactor.this.compareCompactedPartitions(expected, request.compactionPartitions);
                TestPartitionedMobFileCompactor.this.compareDelFiles(request.delFiles);
                return null;
            }
        };
        compactor.compact(this.allFiles, isForceAllFiles);
    }

    private void testCompactDelFiles(String tableName, final int expectedFileCount, final int expectedCellCount, boolean isForceAllFiles) throws IOException {
        PartitionedMobFileCompactor compactor = new PartitionedMobFileCompactor(this.conf, this.fs, TableName.valueOf((String)tableName), this.hcd, pool){

            protected List<Path> performCompaction(PartitionedMobFileCompactionRequest request) throws IOException {
                ArrayList<Path> delFilePaths = new ArrayList<Path>();
                for (FileStatus delFile : request.delFiles) {
                    delFilePaths.add(delFile.getPath());
                }
                List newDelPaths = this.compactDelFiles(request, delFilePaths);
                Assert.assertEquals((long)expectedFileCount, (long)newDelPaths.size());
                Assert.assertEquals((long)expectedCellCount, (long)TestPartitionedMobFileCompactor.this.countDelCellsInDelFiles(newDelPaths));
                return null;
            }
        };
        compactor.compact(this.allFiles, isForceAllFiles);
    }

    private void listFiles() throws IOException {
        for (FileStatus file : this.fs.listStatus(this.basePath)) {
            this.allFiles.add(file);
            if (file.getPath().getName().endsWith("_del")) {
                this.delFiles.add(file);
                continue;
            }
            this.mobFiles.add(file);
        }
    }

    private void compareCompactedPartitions(List<String> expected, Collection<PartitionedMobFileCompactionRequest.CompactionPartition> partitions) {
        ArrayList<String> actualKeys = new ArrayList<String>();
        for (PartitionedMobFileCompactionRequest.CompactionPartition partition : partitions) {
            actualKeys.add(partition.getPartitionId().getStartKey());
        }
        Collections.sort(expected);
        Collections.sort(actualKeys);
        Assert.assertEquals((long)expected.size(), (long)actualKeys.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i), actualKeys.get(i));
        }
    }

    private void compareDelFiles(Collection<FileStatus> allDelFiles) {
        int i = 0;
        for (FileStatus file : allDelFiles) {
            Assert.assertEquals((Object)this.delFiles.get(i), (Object)file);
            ++i;
        }
    }

    private void createStoreFiles(Path basePath, String family, String qualifier, int count, KeyValue.Type type) throws IOException {
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        String startKey = "row_";
        MobFileName mobFileName = null;
        for (int i = 0; i < count; ++i) {
            byte[] startRow = Bytes.toBytes((String)(startKey + i));
            if (type.equals((Object)KeyValue.Type.Delete)) {
                mobFileName = MobFileName.create((byte[])startRow, (String)MobUtils.formatDate((Date)new Date()), (String)this.delSuffix);
            }
            if (type.equals((Object)KeyValue.Type.Put)) {
                mobFileName = MobFileName.create((byte[])Bytes.toBytes((String)(startKey + i)), (String)MobUtils.formatDate((Date)new Date()), (String)this.mobSuffix);
            }
            StoreFile.Writer mobFileWriter = new StoreFile.WriterBuilder(this.conf, this.cacheConf, this.fs).withFileContext(meta).withFilePath(new Path(basePath, mobFileName.getFileName())).build();
            TestPartitionedMobFileCompactor.writeStoreFile(mobFileWriter, startRow, Bytes.toBytes((String)family), Bytes.toBytes((String)qualifier), type, (i + 1) * 1000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStoreFile(StoreFile.Writer writer, byte[] row, byte[] family, byte[] qualifier, KeyValue.Type type, int size) throws IOException {
        long now = System.currentTimeMillis();
        try {
            byte[] dummyData = new byte[size];
            new Random().nextBytes(dummyData);
            writer.append((Cell)new KeyValue(row, family, qualifier, now, type, dummyData));
        }
        finally {
            writer.close();
        }
    }

    private int countDelCellsInDelFiles(List<Path> paths) throws IOException {
        ArrayList<StoreFile> sfs = new ArrayList<StoreFile>();
        int size = 0;
        for (Path path : paths) {
            StoreFile sf = new StoreFile(this.fs, path, this.conf, this.cacheConf, BloomType.NONE);
            sfs.add(sf);
        }
        List scanners = StoreFileScanner.getScannersForStoreFiles(sfs, (boolean)false, (boolean)true, (boolean)false, null, (long)Long.MAX_VALUE);
        Scan scan = new Scan();
        scan.setMaxVersions(this.hcd.getMaxVersions());
        long timeToPurgeDeletes = Math.max(this.conf.getLong("hbase.hstore.time.to.purge.deletes", 0L), 0L);
        long ttl = HStore.determineTTLFromFamily((HColumnDescriptor)this.hcd);
        ScanInfo scanInfo = new ScanInfo(this.hcd, ttl, timeToPurgeDeletes, KeyValue.COMPARATOR);
        StoreScanner scanner = new StoreScanner(scan, scanInfo, ScanType.COMPACT_RETAIN_DELETES, null, scanners, 0L, Long.MAX_VALUE);
        ArrayList results = new ArrayList();
        boolean hasMore = true;
        while (hasMore) {
            hasMore = scanner.next(results);
            size += results.size();
            results.clear();
        }
        scanner.close();
        return size;
    }

    private static ExecutorService createThreadPool(Configuration conf) {
        int maxThreads = 10;
        long keepAliveTime = 60L;
        final SynchronousQueue<Runnable> queue = new SynchronousQueue<Runnable>();
        ThreadPoolExecutor pool = new ThreadPoolExecutor(1, maxThreads, keepAliveTime, TimeUnit.SECONDS, queue, Threads.newDaemonThreadFactory((String)"MobFileCompactionChore"), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    queue.put(r);
                }
                catch (InterruptedException e) {
                    throw new RejectedExecutionException(e);
                }
            }
        });
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    private void resetConf() {
        this.conf.setLong("hbase.mob.file.compaction.mergeable.threshold", 0xC000000L);
        this.conf.setInt("hbase.mob.delfile.max.count", 3);
        this.conf.setInt("hbase.mob.file.compaction.batch.size", 100);
    }
}

