/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob.filecompactions;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.mob.filecompactions.PartitionedMobFileCompactionRequest;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestPartitionedMobFileCompactionRequest {
    @Test
    public void testCompactedPartitionId() {
        String startKey1 = "startKey1";
        String startKey2 = "startKey2";
        String date1 = "date1";
        String date2 = "date2";
        PartitionedMobFileCompactionRequest.CompactionPartitionId partitionId1 = new PartitionedMobFileCompactionRequest.CompactionPartitionId(startKey1, date1);
        PartitionedMobFileCompactionRequest.CompactionPartitionId partitionId2 = new PartitionedMobFileCompactionRequest.CompactionPartitionId(startKey2, date2);
        PartitionedMobFileCompactionRequest.CompactionPartitionId partitionId3 = new PartitionedMobFileCompactionRequest.CompactionPartitionId(startKey1, date2);
        Assert.assertTrue((boolean)partitionId1.equals((Object)partitionId1));
        Assert.assertFalse((boolean)partitionId1.equals((Object)partitionId2));
        Assert.assertFalse((boolean)partitionId1.equals((Object)partitionId3));
        Assert.assertFalse((boolean)partitionId2.equals((Object)partitionId3));
        Assert.assertEquals((Object)startKey1, (Object)partitionId1.getStartKey());
        Assert.assertEquals((Object)date1, (Object)partitionId1.getDate());
    }

    @Test
    public void testCompactedPartition() {
        PartitionedMobFileCompactionRequest.CompactionPartitionId partitionId = new PartitionedMobFileCompactionRequest.CompactionPartitionId("startKey1", "date1");
        PartitionedMobFileCompactionRequest.CompactionPartition partition = new PartitionedMobFileCompactionRequest.CompactionPartition(partitionId);
        FileStatus file = new FileStatus(1L, false, 1, 1024L, 1L, new Path("/test"));
        partition.addFile(file);
        Assert.assertEquals((Object)file, partition.listFiles().get(0));
    }
}

