/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.util.Date;
import java.util.Random;
import java.util.UUID;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.mob.MobFileName;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestMobFileName
extends TestCase {
    private String uuid;
    private Date date;
    private String dateStr;
    private byte[] startKey;

    public void setUp() {
        Random random = new Random();
        this.uuid = UUID.randomUUID().toString().replaceAll("-", "");
        this.date = new Date();
        this.dateStr = MobUtils.formatDate((Date)this.date);
        this.startKey = Bytes.toBytes((int)random.nextInt());
    }

    @Test
    public void testHashCode() {
        TestMobFileName.assertEquals((int)MobFileName.create((byte[])this.startKey, (String)this.dateStr, (String)this.uuid).hashCode(), (int)MobFileName.create((byte[])this.startKey, (String)this.dateStr, (String)this.uuid).hashCode());
        TestMobFileName.assertNotSame((Object)MobFileName.create((byte[])this.startKey, (String)this.dateStr, (String)this.uuid).hashCode(), (Object)MobFileName.create((byte[])this.startKey, (String)this.dateStr, (String)this.uuid).hashCode());
    }

    @Test
    public void testCreate() {
        MobFileName mobFileName = MobFileName.create((byte[])this.startKey, (String)this.dateStr, (String)this.uuid);
        TestMobFileName.assertEquals((Object)mobFileName, (Object)MobFileName.create((String)mobFileName.getFileName()));
    }

    @Test
    public void testGet() {
        MobFileName mobFileName = MobFileName.create((byte[])this.startKey, (String)this.dateStr, (String)this.uuid);
        TestMobFileName.assertEquals((String)MD5Hash.getMD5AsHex((byte[])this.startKey, (int)0, (int)this.startKey.length), (String)mobFileName.getStartKey());
        TestMobFileName.assertEquals((String)this.dateStr, (String)mobFileName.getDate());
        TestMobFileName.assertEquals((String)mobFileName.getFileName(), (String)(MD5Hash.getMD5AsHex((byte[])this.startKey, (int)0, (int)this.startKey.length) + this.dateStr + this.uuid));
    }

    @Test
    public void testEquals() {
        MobFileName mobFileName = MobFileName.create((byte[])this.startKey, (String)this.dateStr, (String)this.uuid);
        TestMobFileName.assertTrue((boolean)mobFileName.equals((Object)mobFileName));
        TestMobFileName.assertFalse((boolean)mobFileName.equals((Object)this));
        TestMobFileName.assertTrue((boolean)mobFileName.equals((Object)MobFileName.create((byte[])this.startKey, (String)this.dateStr, (String)this.uuid)));
    }
}

