/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.util.List;
import java.util.Random;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMobDataBlockEncoding {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] row1 = Bytes.toBytes((String)"row1");
    private static final byte[] family = Bytes.toBytes((String)"family");
    private static final byte[] qf1 = Bytes.toBytes((String)"qualifier1");
    private static final byte[] qf2 = Bytes.toBytes((String)"qualifier2");
    protected final byte[] qf3 = Bytes.toBytes((String)"qualifier3");
    private static HTable table;
    private static HBaseAdmin admin;
    private static HColumnDescriptor hcd;
    private static HTableDescriptor desc;
    private static Random random;
    private static long defaultThreshold;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        TEST_UTIL.getConfiguration().setInt("hbase.master.info.port", 0);
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.info.port.auto", true);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    public void setUp(long threshold, String TN, DataBlockEncoding encoding) throws Exception {
        desc = new HTableDescriptor(TableName.valueOf((String)TN));
        hcd = new HColumnDescriptor(family);
        hcd.setMobEnabled(true);
        hcd.setMobThreshold(threshold);
        hcd.setMaxVersions(4);
        hcd.setDataBlockEncoding(encoding);
        desc.addFamily(hcd);
        admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        admin.createTable(desc);
        table = new HTable(TEST_UTIL.getConfiguration(), TN);
    }

    private static byte[] generateMobValue(int size) {
        byte[] mobVal = new byte[size];
        random.nextBytes(mobVal);
        return mobVal;
    }

    @Test
    public void testDataBlockEncoding() throws Exception {
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            this.testDataBlockEncoding(encoding);
        }
    }

    public void testDataBlockEncoding(DataBlockEncoding encoding) throws Exception {
        String TN = "testDataBlockEncoding" + encoding;
        this.setUp(defaultThreshold, TN, encoding);
        long ts1 = System.currentTimeMillis();
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        byte[] value = TestMobDataBlockEncoding.generateMobValue((int)defaultThreshold + 1);
        Put put1 = new Put(row1);
        put1.add(family, qf1, ts3, value);
        put1.add(family, qf2, ts2, value);
        put1.add(family, this.qf3, ts1, value);
        table.put(put1);
        table.flushCommits();
        admin.flush(TN);
        Scan scan = new Scan();
        scan.setMaxVersions(4);
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            List cells = res.listCells();
            for (Cell cell : cells) {
                Assert.assertEquals((Object)Bytes.toString((byte[])value), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell)));
                ++count;
            }
        }
        results.close();
        Assert.assertEquals((long)3L, (long)count);
    }

    static {
        random = new Random();
        defaultThreshold = 10L;
    }
}

