/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.mob.CachedMobFile;
import org.apache.hadoop.hbase.mob.MobTestUtil;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCachedMobFile
extends TestCase {
    static final Log LOG = LogFactory.getLog(TestCachedMobFile.class);
    private Configuration conf = HBaseConfiguration.create();
    private CacheConfig cacheConf = new CacheConfig(this.conf);
    private final String TABLE = "tableName";
    private final String FAMILY = "familyName";
    private final String FAMILY1 = "familyName1";
    private final String FAMILY2 = "familyName2";
    private final long EXPECTED_REFERENCE_ZERO = 0L;
    private final long EXPECTED_REFERENCE_ONE = 1L;
    private final long EXPECTED_REFERENCE_TWO = 2L;

    @Test
    public void testOpenClose() throws Exception {
        String caseName = this.getName();
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path testDir = FSUtils.getRootDir((Configuration)this.conf);
        Path outputDir = new Path(new Path(testDir, "tableName"), "familyName");
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, fs).withOutputDir(outputDir).withFileContext(meta).build();
        MobTestUtil.writeStoreFile(writer, caseName);
        CachedMobFile cachedMobFile = CachedMobFile.create((FileSystem)fs, (Path)writer.getPath(), (Configuration)this.conf, (CacheConfig)this.cacheConf);
        Assert.assertEquals((long)0L, (long)cachedMobFile.getReferenceCount());
        cachedMobFile.open();
        Assert.assertEquals((long)1L, (long)cachedMobFile.getReferenceCount());
        cachedMobFile.open();
        Assert.assertEquals((long)2L, (long)cachedMobFile.getReferenceCount());
        cachedMobFile.close();
        Assert.assertEquals((long)1L, (long)cachedMobFile.getReferenceCount());
        cachedMobFile.close();
        Assert.assertEquals((long)0L, (long)cachedMobFile.getReferenceCount());
    }

    @Test
    public void testCompare() throws Exception {
        String caseName = this.getName();
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path testDir = FSUtils.getRootDir((Configuration)this.conf);
        Path outputDir1 = new Path(new Path(testDir, "tableName"), "familyName1");
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFile.Writer writer1 = new StoreFile.WriterBuilder(this.conf, this.cacheConf, fs).withOutputDir(outputDir1).withFileContext(meta).build();
        MobTestUtil.writeStoreFile(writer1, caseName);
        CachedMobFile cachedMobFile1 = CachedMobFile.create((FileSystem)fs, (Path)writer1.getPath(), (Configuration)this.conf, (CacheConfig)this.cacheConf);
        Path outputDir2 = new Path(new Path(testDir, "tableName"), "familyName2");
        StoreFile.Writer writer2 = new StoreFile.WriterBuilder(this.conf, this.cacheConf, fs).withOutputDir(outputDir2).withFileContext(meta).build();
        MobTestUtil.writeStoreFile(writer2, caseName);
        CachedMobFile cachedMobFile2 = CachedMobFile.create((FileSystem)fs, (Path)writer2.getPath(), (Configuration)this.conf, (CacheConfig)this.cacheConf);
        cachedMobFile1.access(1L);
        cachedMobFile2.access(2L);
        Assert.assertEquals((long)cachedMobFile1.compareTo(cachedMobFile2), (long)1L);
        Assert.assertEquals((long)cachedMobFile2.compareTo(cachedMobFile1), (long)-1L);
        Assert.assertEquals((long)cachedMobFile1.compareTo(cachedMobFile1), (long)0L);
    }

    @Test
    public void testReadKeyValue() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path testDir = FSUtils.getRootDir((Configuration)this.conf);
        Path outputDir = new Path(new Path(testDir, "tableName"), "familyname");
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, fs).withOutputDir(outputDir).withFileContext(meta).build();
        String caseName = this.getName();
        MobTestUtil.writeStoreFile(writer, caseName);
        CachedMobFile cachedMobFile = CachedMobFile.create((FileSystem)fs, (Path)writer.getPath(), (Configuration)this.conf, (CacheConfig)this.cacheConf);
        byte[] family = Bytes.toBytes((String)caseName);
        byte[] qualify = Bytes.toBytes((String)caseName);
        byte[] startKey = Bytes.toBytes((String)"aa");
        KeyValue expectedKey = new KeyValue(startKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, startKey);
        KeyValue seekKey = expectedKey.createKeyOnly(false);
        KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cachedMobFile.readCell((Cell)seekKey, false));
        MobTestUtil.assertKeyValuesEquals(expectedKey, kv);
        byte[] endKey = Bytes.toBytes((String)"zz");
        expectedKey = new KeyValue(endKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, endKey);
        seekKey = expectedKey.createKeyOnly(false);
        kv = KeyValueUtil.ensureKeyValue((Cell)cachedMobFile.readCell((Cell)seekKey, false));
        MobTestUtil.assertKeyValuesEquals(expectedKey, kv);
        byte[] randomKey = Bytes.toBytes((String)MobTestUtil.generateRandomString(2));
        expectedKey = new KeyValue(randomKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, randomKey);
        seekKey = expectedKey.createKeyOnly(false);
        kv = KeyValueUtil.ensureKeyValue((Cell)cachedMobFile.readCell((Cell)seekKey, false));
        MobTestUtil.assertKeyValuesEquals(expectedKey, kv);
        byte[] lowerKey = Bytes.toBytes((String)"a1");
        expectedKey = new KeyValue(startKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, startKey);
        seekKey = new KeyValue(lowerKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, lowerKey);
        kv = KeyValueUtil.ensureKeyValue((Cell)cachedMobFile.readCell((Cell)seekKey, false));
        MobTestUtil.assertKeyValuesEquals(expectedKey, kv);
        byte[] upperKey = Bytes.toBytes((String)"z{");
        seekKey = new KeyValue(upperKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, upperKey);
        kv = KeyValueUtil.ensureKeyValue((Cell)cachedMobFile.readCell((Cell)seekKey, false));
        Assert.assertNull((Object)kv);
    }
}

