/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;

public class MobTestUtil {
    protected static final char FIRST_CHAR = 'a';
    protected static final char LAST_CHAR = 'z';

    protected static String generateRandomString(int demoLength) {
        String base = "abcdefghijklmnopqrstuvwxyz";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < demoLength; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    protected static void writeStoreFile(StoreFile.Writer writer, String caseName) throws IOException {
        MobTestUtil.writeStoreFile(writer, Bytes.toBytes((String)caseName), Bytes.toBytes((String)caseName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStoreFile(StoreFile.Writer writer, byte[] fam, byte[] qualifier) throws IOException {
        long now = System.currentTimeMillis();
        try {
            for (int d = 97; d <= 122; d = (int)((char)(d + 1))) {
                for (int e = 97; e <= 122; e = (int)((char)(e + 1))) {
                    byte[] b = new byte[]{(byte)d, (byte)e};
                    writer.append((Cell)new KeyValue(b, fam, qualifier, now, b));
                }
            }
        }
        finally {
            writer.close();
        }
    }

    public static void assertKeyValuesEquals(KeyValue firstKeyValue, KeyValue secondKeyValue) {
        Assert.assertEquals((Object)Bytes.toString((byte[])CellUtil.cloneRow((Cell)firstKeyValue)), (Object)Bytes.toString((byte[])CellUtil.cloneRow((Cell)secondKeyValue)));
        Assert.assertEquals((Object)Bytes.toString((byte[])CellUtil.cloneFamily((Cell)firstKeyValue)), (Object)Bytes.toString((byte[])CellUtil.cloneFamily((Cell)secondKeyValue)));
        Assert.assertEquals((Object)Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)firstKeyValue)), (Object)Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)secondKeyValue)));
        Assert.assertEquals((Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)firstKeyValue)), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)secondKeyValue)));
    }
}

