/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.mapreduce.MutationSerialization;
import org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serializer;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={SmallTests.class})
public class TestSerialization {
    @Rule
    public TestName name = new TestName();
    private static final Log LOG = LogFactory.getLog(TestSerialization.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    private static final byte[] row;
    private static final byte[] qualifier;
    private static final byte[] family;
    private static final byte[] value;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.client.keyvalue.maxsize", Integer.MAX_VALUE);
    }

    @Test
    public void testLargeMutation() throws Exception {
        Put put = new Put(row);
        put.add(family, qualifier, value);
        MutationSerialization serialization = new MutationSerialization();
        Serializer serializer = serialization.getSerializer(Mutation.class);
        Deserializer deserializer = serialization.getDeserializer(Mutation.class);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ByteArrayInputStream is = null;
        try {
            serializer.open((OutputStream)os);
            serializer.serialize((Object)put);
            os.flush();
            is = new ByteArrayInputStream(os.toByteArray());
            deserializer.open((InputStream)is);
            deserializer.deserialize(null);
        }
        catch (InvalidProtocolBufferException e) {
            Assert.assertTrue((String)("Got InvalidProtocolBufferException in " + this.name.getMethodName()), (boolean)(e.getCause() instanceof InvalidProtocolBufferException));
        }
        catch (Exception e) {
            Assert.fail((String)("Got an invalid exception: " + e));
        }
    }

    @Test
    public void testLargeResult() throws Exception {
        Result res = Result.create((Cell[])new KeyValue[]{new KeyValue(row, family, qualifier, 0L, value)});
        ResultSerialization serialization = new ResultSerialization();
        Serializer serializer = serialization.getSerializer(Result.class);
        Deserializer deserializer = serialization.getDeserializer(Result.class);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ByteArrayInputStream is = null;
        try {
            serializer.open((OutputStream)os);
            serializer.serialize((Object)res);
            os.flush();
            is = new ByteArrayInputStream(os.toByteArray());
            deserializer.open((InputStream)is);
            deserializer.deserialize(null);
        }
        catch (InvalidProtocolBufferException e) {
            Assert.assertTrue((String)("Got InvalidProtocolBufferException in " + this.name.getMethodName()), (boolean)(e.getCause() instanceof InvalidProtocolBufferException));
        }
        catch (Exception e) {
            Assert.fail((String)("Got an invalid exception: " + e));
        }
    }

    private static String getName() {
        return "TestSerialization";
    }

    static {
        row = Bytes.toBytes((String)"row1");
        qualifier = Bytes.toBytes((String)"qualifier1");
        family = Bytes.toBytes((String)"family1");
        value = new byte[0x6400000];
    }
}

