/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.hadoop.hbase.ipc.RpcClientImpl;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={SmallTests.class})
public class TestRpcClientLeaks {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    public static final Log LOG = LogFactory.getLog(TestRpcClientLeaks.class);

    @BeforeClass
    public static void setup() throws Exception {
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void teardown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test(expected=RetriesExhaustedException.class)
    public void testSocketClosed() throws IOException, InterruptedException {
        String tableName = "testSocketClosed";
        TableName name = TableName.valueOf((String)tableName);
        UTIL.createTable(name, HBaseTestingUtility.fam1).close();
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.set("hbase.rpc.client.impl", MyRpcClientImpl.class.getName());
        conf.setInt("hbase.client.retries.number", 2);
        Connection connection = ConnectionFactory.createConnection((Configuration)conf);
        Table table = connection.getTable(TableName.valueOf((String)tableName));
        table.get(new Get("asd".getBytes()));
        connection.close();
        for (Socket socket : MyRpcClientImpl.savedSockets) {
            Assert.assertTrue((String)("Socket + " + socket + " is not closed"), (boolean)socket.isClosed());
        }
    }

    public static class MyRpcClientImpl
    extends RpcClientImpl {
        public static List<Socket> savedSockets = Lists.newArrayList();
        @Rule
        public ExpectedException thrown = ExpectedException.none();

        public MyRpcClientImpl(Configuration conf, String clusterId) {
            super(conf, clusterId);
        }

        public MyRpcClientImpl(Configuration conf, String clusterId, SocketAddress address) {
            super(conf, clusterId, address);
        }

        protected RpcClientImpl.Connection createConnection(ConnectionId remoteId, Codec codec, CompressionCodec compressor) throws IOException {
            return new RpcClientImpl.Connection(remoteId, codec, compressor){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected synchronized void setupConnection() throws IOException {
                    super.setupConnection();
                    List<Socket> list = savedSockets;
                    synchronized (list) {
                        savedSockets.add(this.socket);
                    }
                    throw new IOException("Sample exception for verifying socket closure in case of exceptions.");
                }
            };
        }
    }
}

