/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestSizeFailures {
    final Log LOG = LogFactory.getLog(this.getClass());
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    protected static int SLAVES = 1;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.table.sanity.checks", true);
        TEST_UTIL.startMiniCluster(SLAVES);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testScannerSeesAllRecords() throws Exception {
        int NUM_ROWS = 1000000;
        int NUM_COLS = 10;
        TableName TABLENAME = TableName.valueOf((String)"testScannerSeesAllRecords");
        ArrayList<byte[]> qualifiers = new ArrayList<byte[]>();
        for (int i = 1; i <= 10; ++i) {
            qualifiers.add(Bytes.toBytes((String)Integer.toString(i)));
        }
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        HTableDescriptor desc = new HTableDescriptor(TABLENAME);
        desc.addFamily(hcd);
        byte[][] splits = new byte[9][2];
        for (int i = 1; i < 10; ++i) {
            int split = 48 + i;
            splits[i - 1][0] = (byte)(split >>> 8);
            splits[i - 1][0] = (byte)split;
        }
        TEST_UTIL.getHBaseAdmin().createTable(desc, splits);
        Connection conn = TEST_UTIL.getConnection();
        try (Table table = conn.getTable(TABLENAME);){
            LinkedList<Put> puts = new LinkedList<Put>();
            for (int i = 0; i < 1000000; ++i) {
                Put p = new Put(Bytes.toBytes((String)Integer.toString(i)));
                for (int j = 0; j < 10; ++j) {
                    byte[] value = new byte[50];
                    Bytes.random((byte[])value);
                    p.addColumn(FAMILY, Bytes.toBytes((String)Integer.toString(j)), value);
                }
                puts.add(p);
                if (puts.size() != 1000) continue;
                Object[] results = new Object[1000];
                try {
                    table.batch(puts, results);
                }
                catch (IOException e) {
                    this.LOG.error((Object)"Failed to write data", (Throwable)e);
                    this.LOG.debug((Object)("Errors: " + Arrays.toString(results)));
                }
                puts.clear();
            }
            if (puts.size() > 0) {
                Object[] results = new Object[puts.size()];
                try {
                    table.batch(puts, results);
                }
                catch (IOException e) {
                    this.LOG.error((Object)"Failed to write data", (Throwable)e);
                    this.LOG.debug((Object)("Errors: " + Arrays.toString(results)));
                }
            }
            TEST_UTIL.getHBaseAdmin().flush(TABLENAME);
            TreeSet<Integer> rows = new TreeSet<Integer>();
            long rowsObserved = 0L;
            long entriesObserved = 0L;
            Scan s = new Scan();
            s.addFamily(FAMILY);
            s.setMaxResultSize(-1L);
            s.setBatch(-1);
            s.setCaching(500);
            ResultScanner scanner = table.getScanner(s);
            for (Result result : scanner) {
                ++rowsObserved;
                String row = new String(result.getRow());
                rows.add(Integer.parseInt(row));
                while (result.advance()) {
                    ++entriesObserved;
                }
            }
            Assert.assertEquals((long)1000000L, (long)rowsObserved);
            Assert.assertEquals((long)10000000L, (long)entriesObserved);
        }
        conn.close();
    }
}

