/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.MobSnapshotTestingUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestMobRestoreSnapshotFromClient {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final byte[] FAMILY = Bytes.toBytes((String)"cf");
    private byte[] emptySnapshot;
    private byte[] snapshotName0;
    private byte[] snapshotName1;
    private byte[] snapshotName2;
    private int snapshot0Rows;
    private int snapshot1Rows;
    private TableName tableName;
    private Admin admin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.snapshot.enabled", true);
        TEST_UTIL.getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compactionThreshold", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.getConfiguration().setInt("hbase.mob.file.cache.size", 0);
        TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
        this.admin = TEST_UTIL.getHBaseAdmin();
        long tid = System.currentTimeMillis();
        this.tableName = TableName.valueOf((String)("testtb-" + tid));
        this.emptySnapshot = Bytes.toBytes((String)("emptySnaptb-" + tid));
        this.snapshotName0 = Bytes.toBytes((String)("snaptb0-" + tid));
        this.snapshotName1 = Bytes.toBytes((String)("snaptb1-" + tid));
        this.snapshotName2 = Bytes.toBytes((String)("snaptb2-" + tid));
        MobSnapshotTestingUtils.createMobTable(TEST_UTIL, this.tableName, this.getNumReplicas(), (byte[][])new byte[][]{this.FAMILY});
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.emptySnapshot, this.tableName);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), this.tableName);
        this.admin.enableTable(this.tableName);
        SnapshotTestingUtils.loadData(TEST_UTIL, this.tableName, 500, (byte[][])new byte[][]{this.FAMILY});
        this.snapshot0Rows = MobSnapshotTestingUtils.countMobRows(table);
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.snapshotName0, this.tableName);
        this.admin.enableTable(this.tableName);
        SnapshotTestingUtils.loadData(TEST_UTIL, this.tableName, 500, (byte[][])new byte[][]{this.FAMILY});
        this.snapshot1Rows = MobSnapshotTestingUtils.countMobRows(table);
        table.close();
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.deleteTable(this.tableName);
        SnapshotTestingUtils.deleteAllSnapshots((Admin)TEST_UTIL.getHBaseAdmin());
        SnapshotTestingUtils.deleteArchiveDirectory(TEST_UTIL);
    }

    @Test
    public void testRestoreSnapshot() throws IOException {
        MobSnapshotTestingUtils.verifyMobRowCount(TEST_UTIL, this.tableName, this.snapshot1Rows);
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.snapshotName1, this.tableName);
        this.admin.restoreSnapshot(this.snapshotName0);
        this.admin.enableTable(this.tableName);
        MobSnapshotTestingUtils.verifyMobRowCount(TEST_UTIL, this.tableName, this.snapshot0Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(this.tableName, this.admin, this.getNumReplicas());
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.emptySnapshot);
        this.admin.enableTable(this.tableName);
        MobSnapshotTestingUtils.verifyMobRowCount(TEST_UTIL, this.tableName, 0L);
        SnapshotTestingUtils.verifyReplicasCameOnline(this.tableName, this.admin, this.getNumReplicas());
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName1);
        this.admin.enableTable(this.tableName);
        MobSnapshotTestingUtils.verifyMobRowCount(TEST_UTIL, this.tableName, this.snapshot1Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(this.tableName, this.admin, this.getNumReplicas());
        TEST_UTIL.deleteTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName1);
        MobSnapshotTestingUtils.verifyMobRowCount(TEST_UTIL, this.tableName, this.snapshot1Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(this.tableName, this.admin, this.getNumReplicas());
    }

    protected int getNumReplicas() {
        return 1;
    }

    @Test
    public void testRestoreSchemaChange() throws Exception {
        byte[] TEST_FAMILY2 = Bytes.toBytes((String)"cf2");
        HTable table = new HTable(TEST_UTIL.getConfiguration(), this.tableName);
        this.admin.disableTable(this.tableName);
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY2);
        hcd.setMobEnabled(true);
        hcd.setMobThreshold(3L);
        this.admin.addColumn(this.tableName, hcd);
        this.admin.enableTable(this.tableName);
        Assert.assertEquals((long)2L, (long)table.getTableDescriptor().getFamilies().size());
        HTableDescriptor htd = this.admin.getTableDescriptor(this.tableName);
        Assert.assertEquals((long)2L, (long)htd.getFamilies().size());
        SnapshotTestingUtils.loadData(TEST_UTIL, this.tableName, 500, (byte[][])new byte[][]{TEST_FAMILY2});
        long snapshot2Rows = this.snapshot1Rows + 500;
        Assert.assertEquals((long)snapshot2Rows, (long)MobSnapshotTestingUtils.countMobRows(table));
        Assert.assertEquals((long)500L, (long)MobSnapshotTestingUtils.countMobRows(table, new byte[][]{TEST_FAMILY2}));
        Set<String> fsFamilies = this.getFamiliesFromFS(this.tableName);
        Assert.assertEquals((long)2L, (long)fsFamilies.size());
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.snapshotName2, this.tableName);
        this.admin.restoreSnapshot(this.snapshotName0);
        this.admin.enableTable(this.tableName);
        Assert.assertEquals((long)1L, (long)table.getTableDescriptor().getFamilies().size());
        try {
            MobSnapshotTestingUtils.countMobRows(table, new byte[][]{TEST_FAMILY2});
            Assert.fail((String)("family '" + Bytes.toString((byte[])TEST_FAMILY2) + "' should not exists"));
        }
        catch (NoSuchColumnFamilyException e) {
            // empty catch block
        }
        Assert.assertEquals((long)this.snapshot0Rows, (long)MobSnapshotTestingUtils.countMobRows(table));
        htd = this.admin.getTableDescriptor(this.tableName);
        Assert.assertEquals((long)1L, (long)htd.getFamilies().size());
        fsFamilies = this.getFamiliesFromFS(this.tableName);
        Assert.assertEquals((long)1L, (long)fsFamilies.size());
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName2);
        this.admin.enableTable(this.tableName);
        htd = this.admin.getTableDescriptor(this.tableName);
        Assert.assertEquals((long)2L, (long)htd.getFamilies().size());
        Assert.assertEquals((long)2L, (long)table.getTableDescriptor().getFamilies().size());
        Assert.assertEquals((long)500L, (long)MobSnapshotTestingUtils.countMobRows(table, new byte[][]{TEST_FAMILY2}));
        Assert.assertEquals((long)snapshot2Rows, (long)MobSnapshotTestingUtils.countMobRows(table));
        fsFamilies = this.getFamiliesFromFS(this.tableName);
        Assert.assertEquals((long)2L, (long)fsFamilies.size());
        table.close();
    }

    @Test
    public void testCloneSnapshotOfCloned() throws IOException, InterruptedException {
        TableName clonedTableName = TableName.valueOf((String)("clonedtb-" + System.currentTimeMillis()));
        this.admin.cloneSnapshot(this.snapshotName0, clonedTableName);
        MobSnapshotTestingUtils.verifyMobRowCount(TEST_UTIL, clonedTableName, this.snapshot0Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(clonedTableName, this.admin, this.getNumReplicas());
        this.admin.disableTable(clonedTableName);
        this.admin.snapshot(this.snapshotName2, clonedTableName);
        TEST_UTIL.deleteTable(clonedTableName);
        this.waitCleanerRun();
        this.admin.cloneSnapshot(this.snapshotName2, clonedTableName);
        MobSnapshotTestingUtils.verifyMobRowCount(TEST_UTIL, clonedTableName, this.snapshot0Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(clonedTableName, this.admin, this.getNumReplicas());
        TEST_UTIL.deleteTable(clonedTableName);
    }

    @Test
    public void testCloneAndRestoreSnapshot() throws IOException, InterruptedException {
        TEST_UTIL.deleteTable(this.tableName);
        this.waitCleanerRun();
        this.admin.cloneSnapshot(this.snapshotName0, this.tableName);
        MobSnapshotTestingUtils.verifyMobRowCount(TEST_UTIL, this.tableName, this.snapshot0Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(this.tableName, this.admin, this.getNumReplicas());
        this.waitCleanerRun();
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName0);
        this.admin.enableTable(this.tableName);
        MobSnapshotTestingUtils.verifyMobRowCount(TEST_UTIL, this.tableName, this.snapshot0Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(this.tableName, this.admin, this.getNumReplicas());
    }

    @Test
    public void testCorruptedSnapshot() throws IOException, InterruptedException {
        SnapshotTestingUtils.corruptSnapshot(TEST_UTIL, Bytes.toString((byte[])this.snapshotName0));
        TableName cloneName = TableName.valueOf((String)("corruptedClone-" + System.currentTimeMillis()));
        try {
            this.admin.cloneSnapshot(this.snapshotName0, cloneName);
            Assert.fail((String)"Expected CorruptedSnapshotException, got succeeded cloneSnapshot()");
        }
        catch (CorruptedSnapshotException e) {
            Assert.assertFalse((boolean)this.admin.tableExists(cloneName));
        }
        catch (Exception e) {
            Assert.fail((String)("Expected CorruptedSnapshotException got: " + e));
        }
    }

    private void waitCleanerRun() throws InterruptedException {
        TEST_UTIL.getMiniHBaseCluster().getMaster().getHFileCleaner().choreForTesting();
    }

    private Set<String> getFamiliesFromFS(TableName tableName) throws IOException {
        MasterFileSystem mfs = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        HashSet<String> families = new HashSet<String>();
        Path tableDir = FSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)tableName);
        for (Path regionDir : FSUtils.getRegionDirs((FileSystem)mfs.getFileSystem(), (Path)tableDir)) {
            for (Path familyDir : FSUtils.getFamilyDirs((FileSystem)mfs.getFileSystem(), (Path)regionDir)) {
                families.add(familyDir.getName());
            }
        }
        return families;
    }
}

