/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMetaTableAccessor {
    private static final Log LOG = LogFactory.getLog(TestMetaTableAccessor.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static Connection connection;
    private Random random = new Random();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster(3);
        Configuration c = new Configuration(UTIL.getConfiguration());
        c.setLong("hbase.client.pause", 1000L);
        c.setInt("hbase.client.retries.number", 10);
        connection = ConnectionFactory.createConnection((Configuration)c);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        connection.close();
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRetrying() throws IOException, InterruptedException {
        TableName name = TableName.valueOf((String)"testRetrying");
        LOG.info((Object)("Started " + name));
        HTable t = UTIL.createTable(name, HConstants.CATALOG_FAMILY);
        int regionCount = UTIL.createMultiRegions(t, HConstants.CATALOG_FAMILY);
        final List<HRegionInfo> regions = TestMetaTableAccessor.testGettingTableRegions(connection, name, regionCount);
        MetaTask reader = new MetaTask(connection, "reader"){

            @Override
            void metaTask() throws Throwable {
                TestMetaTableAccessor.testGetRegion(this.connection, (HRegionInfo)regions.get(0));
                LOG.info((Object)("Read " + ((HRegionInfo)regions.get(0)).getEncodedName()));
            }
        };
        MetaTask writer = new MetaTask(connection, "writer"){

            @Override
            void metaTask() throws Throwable {
                MetaTableAccessor.addRegionToMeta((Connection)this.connection, (HRegionInfo)((HRegionInfo)regions.get(0)));
                LOG.info((Object)("Wrote " + ((HRegionInfo)regions.get(0)).getEncodedName()));
            }
        };
        reader.start();
        writer.start();
        long timeOut = 180000L;
        long startTime = System.currentTimeMillis();
        try {
            Assert.assertTrue((boolean)reader.isProgressing());
            Assert.assertTrue((boolean)writer.isProgressing());
            for (int i = 0; i < 2; ++i) {
                LOG.info((Object)("Restart=" + i));
                UTIL.ensureSomeRegionServersAvailable(2);
                int index = -1;
                while ((index = UTIL.getMiniHBaseCluster().getServerWithMeta()) == -1 && startTime + 180000L < System.currentTimeMillis()) {
                }
                if (index == -1) continue;
                UTIL.getMiniHBaseCluster().abortRegionServer(index);
                UTIL.getMiniHBaseCluster().waitOnRegionServer(index);
            }
            Assert.assertTrue((String)("reader: " + reader.toString()), (boolean)reader.isProgressing());
            Assert.assertTrue((String)("writer: " + writer.toString()), (boolean)writer.isProgressing());
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            reader.stop = true;
            writer.stop = true;
            reader.join();
            writer.join();
            t.close();
        }
        long exeTime = System.currentTimeMillis() - startTime;
        Assert.assertTrue((String)("Timeout: test took " + exeTime / 1000L + " sec"), (exeTime < 180000L ? 1 : 0) != 0);
    }

    @Test
    public void testGetRegionsCatalogTables() throws IOException, InterruptedException {
        List regions = MetaTableAccessor.getTableRegions((ZooKeeperWatcher)UTIL.getZooKeeperWatcher(), (Connection)connection, (TableName)TableName.META_TABLE_NAME);
        Assert.assertTrue((regions.size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((MetaTableAccessor.getTableRegionsAndLocations((ZooKeeperWatcher)UTIL.getZooKeeperWatcher(), (Connection)connection, (TableName)TableName.META_TABLE_NAME).size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testTableExists() throws IOException {
        TableName name = TableName.valueOf((String)"testTableExists");
        Assert.assertFalse((boolean)MetaTableAccessor.tableExists((Connection)connection, (TableName)name));
        UTIL.createTable(name, HConstants.CATALOG_FAMILY);
        Assert.assertTrue((boolean)MetaTableAccessor.tableExists((Connection)connection, (TableName)name));
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        admin.disableTable(name);
        admin.deleteTable(name);
        Assert.assertFalse((boolean)MetaTableAccessor.tableExists((Connection)connection, (TableName)name));
        Assert.assertTrue((boolean)MetaTableAccessor.tableExists((Connection)connection, (TableName)TableName.META_TABLE_NAME));
    }

    @Test
    public void testGetRegion() throws IOException, InterruptedException {
        String name = "testGetRegion";
        LOG.info((Object)"Started testGetRegion");
        Pair pair = MetaTableAccessor.getRegion((Connection)connection, (byte[])Bytes.toBytes((String)"nonexistent-region"));
        Assert.assertNull((Object)pair);
        LOG.info((Object)"Finished testGetRegion");
    }

    @Test
    public void testScanMetaForTable() throws IOException, InterruptedException {
        TableName name = TableName.valueOf((String)"testScanMetaForTable");
        LOG.info((Object)("Started " + name));
        UTIL.createTable(name, HConstants.CATALOG_FAMILY);
        TableName greaterName = TableName.valueOf((String)"testScanMetaForTablf");
        UTIL.createTable(greaterName, HConstants.CATALOG_FAMILY);
        Assert.assertEquals((long)1L, (long)MetaTableAccessor.getTableRegions((ZooKeeperWatcher)UTIL.getZooKeeperWatcher(), (Connection)connection, (TableName)name).size());
        Assert.assertEquals((long)1L, (long)MetaTableAccessor.getTableRegions((ZooKeeperWatcher)UTIL.getZooKeeperWatcher(), (Connection)connection, (TableName)greaterName).size());
    }

    private static List<HRegionInfo> testGettingTableRegions(Connection connection, TableName name, int regionCount) throws IOException, InterruptedException {
        List regions = MetaTableAccessor.getTableRegions((ZooKeeperWatcher)UTIL.getZooKeeperWatcher(), (Connection)connection, (TableName)name);
        Assert.assertEquals((long)regionCount, (long)regions.size());
        Pair pair = MetaTableAccessor.getRegion((Connection)connection, (byte[])((HRegionInfo)regions.get(0)).getRegionName());
        Assert.assertEquals((Object)((HRegionInfo)regions.get(0)).getEncodedName(), (Object)((HRegionInfo)pair.getFirst()).getEncodedName());
        return regions;
    }

    private static void testGetRegion(Connection connection, HRegionInfo region) throws IOException, InterruptedException {
        Pair pair = MetaTableAccessor.getRegion((Connection)connection, (byte[])region.getRegionName());
        Assert.assertEquals((Object)region.getEncodedName(), (Object)((HRegionInfo)pair.getFirst()).getEncodedName());
    }

    @Test
    public void testParseReplicaIdFromServerColumn() {
        String column1 = "server";
        Assert.assertEquals((long)0L, (long)MetaTableAccessor.parseReplicaIdFromServerColumn((byte[])Bytes.toBytes((String)column1)));
        String column2 = column1 + '_';
        Assert.assertEquals((long)-1L, (long)MetaTableAccessor.parseReplicaIdFromServerColumn((byte[])Bytes.toBytes((String)column2)));
        String column3 = column2 + "00";
        Assert.assertEquals((long)-1L, (long)MetaTableAccessor.parseReplicaIdFromServerColumn((byte[])Bytes.toBytes((String)column3)));
        String column4 = column3 + "2A";
        Assert.assertEquals((long)42L, (long)MetaTableAccessor.parseReplicaIdFromServerColumn((byte[])Bytes.toBytes((String)column4)));
        String column5 = column4 + "2A";
        Assert.assertEquals((long)-1L, (long)MetaTableAccessor.parseReplicaIdFromServerColumn((byte[])Bytes.toBytes((String)column5)));
        String column6 = "serverstartcode";
        Assert.assertEquals((long)-1L, (long)MetaTableAccessor.parseReplicaIdFromServerColumn((byte[])Bytes.toBytes((String)column6)));
    }

    @Test
    public void testMetaReaderGetColumnMethods() {
        Assert.assertArrayEquals((byte[])HConstants.SERVER_QUALIFIER, (byte[])MetaTableAccessor.getServerColumn((int)0));
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"server_002A"), (byte[])MetaTableAccessor.getServerColumn((int)42));
        Assert.assertArrayEquals((byte[])HConstants.STARTCODE_QUALIFIER, (byte[])MetaTableAccessor.getStartCodeColumn((int)0));
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"serverstartcode_002A"), (byte[])MetaTableAccessor.getStartCodeColumn((int)42));
        Assert.assertArrayEquals((byte[])HConstants.SEQNUM_QUALIFIER, (byte[])MetaTableAccessor.getSeqNumColumn((int)0));
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"seqnumDuringOpen_002A"), (byte[])MetaTableAccessor.getSeqNumColumn((int)42));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaLocationsForRegionReplicas() throws IOException {
        ServerName serverName0 = ServerName.valueOf((String)"foo", (int)60010, (long)this.random.nextLong());
        ServerName serverName1 = ServerName.valueOf((String)"bar", (int)60010, (long)this.random.nextLong());
        ServerName serverName100 = ServerName.valueOf((String)"baz", (int)60010, (long)this.random.nextLong());
        long regionId = System.currentTimeMillis();
        HRegionInfo primary = new HRegionInfo(TableName.valueOf((String)"table_foo"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, regionId, 0);
        HRegionInfo replica1 = new HRegionInfo(TableName.valueOf((String)"table_foo"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, regionId, 1);
        HRegionInfo replica100 = new HRegionInfo(TableName.valueOf((String)"table_foo"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, regionId, 100);
        long seqNum0 = this.random.nextLong();
        long seqNum1 = this.random.nextLong();
        long seqNum100 = this.random.nextLong();
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)connection);){
            MetaTableAccessor.updateRegionLocation((Connection)connection, (HRegionInfo)primary, (ServerName)serverName0, (long)seqNum0);
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName0, seqNum0, 0, true);
            MetaTableAccessor.updateRegionLocation((Connection)connection, (HRegionInfo)replica1, (ServerName)serverName1, (long)seqNum1);
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName0, seqNum0, 0, true);
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName1, seqNum1, 1, true);
            MetaTableAccessor.updateRegionLocation((Connection)connection, (HRegionInfo)replica100, (ServerName)serverName100, (long)seqNum100);
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName0, seqNum0, 0, true);
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName1, seqNum1, 1, true);
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName100, seqNum100, 100, true);
        }
    }

    public static void assertMetaLocation(Table meta, byte[] row, ServerName serverName, long seqNum, int replicaId, boolean checkSeqNum) throws IOException {
        Get get = new Get(row);
        Result result = meta.get(get);
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn((int)replicaId)), (byte[])Bytes.toBytes((String)serverName.getHostAndPort())));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn((int)replicaId)), (byte[])Bytes.toBytes((long)serverName.getStartcode())));
        if (checkSeqNum) {
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, MetaTableAccessor.getSeqNumColumn((int)replicaId)), (byte[])Bytes.toBytes((long)seqNum)));
        }
    }

    public static void assertEmptyMetaLocation(Table meta, byte[] row, int replicaId) throws IOException {
        Get get = new Get(row);
        Result result = meta.get(get);
        Cell serverCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn((int)replicaId));
        Cell startCodeCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn((int)replicaId));
        Assert.assertNotNull((Object)serverCell);
        Assert.assertNotNull((Object)startCodeCell);
        Assert.assertEquals((long)0L, (long)serverCell.getValueLength());
        Assert.assertEquals((long)0L, (long)startCodeCell.getValueLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaLocationForRegionReplicasIsAddedAtTableCreation() throws IOException {
        long regionId = System.currentTimeMillis();
        HRegionInfo primary = new HRegionInfo(TableName.valueOf((String)"table_foo"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, regionId, 0);
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)connection);){
            ArrayList regionInfos = Lists.newArrayList((Object[])new HRegionInfo[]{primary});
            MetaTableAccessor.addRegionsToMeta((Connection)connection, (List)regionInfos, (int)3);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, primary.getRegionName(), 1);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, primary.getRegionName(), 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaLocationForRegionReplicasIsAddedAtRegionSplit() throws IOException {
        long regionId = System.currentTimeMillis();
        ServerName serverName0 = ServerName.valueOf((String)"foo", (int)60010, (long)this.random.nextLong());
        HRegionInfo parent = new HRegionInfo(TableName.valueOf((String)"table_foo"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, regionId, 0);
        HRegionInfo splitA = new HRegionInfo(TableName.valueOf((String)"table_foo"), HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"a"), false, regionId + 1L, 0);
        HRegionInfo splitB = new HRegionInfo(TableName.valueOf((String)"table_foo"), Bytes.toBytes((String)"a"), HConstants.EMPTY_END_ROW, false, regionId + 1L, 0);
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)connection);){
            ArrayList regionInfos = Lists.newArrayList((Object[])new HRegionInfo[]{parent});
            MetaTableAccessor.addRegionsToMeta((Connection)connection, (List)regionInfos, (int)3);
            MetaTableAccessor.splitRegion((Connection)connection, (HRegionInfo)parent, (HRegionInfo)splitA, (HRegionInfo)splitB, (ServerName)serverName0, (int)3);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, splitA.getRegionName(), 1);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, splitA.getRegionName(), 2);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, splitB.getRegionName(), 1);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, splitB.getRegionName(), 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaLocationForRegionReplicasIsAddedAtRegionMerge() throws IOException {
        long regionId = System.currentTimeMillis();
        ServerName serverName0 = ServerName.valueOf((String)"foo", (int)60010, (long)this.random.nextLong());
        HRegionInfo parentA = new HRegionInfo(TableName.valueOf((String)"table_foo"), Bytes.toBytes((String)"a"), HConstants.EMPTY_END_ROW, false, regionId, 0);
        HRegionInfo parentB = new HRegionInfo(TableName.valueOf((String)"table_foo"), HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"a"), false, regionId, 0);
        HRegionInfo merged = new HRegionInfo(TableName.valueOf((String)"table_foo"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, regionId + 1L, 0);
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)connection);){
            ArrayList regionInfos = Lists.newArrayList((Object[])new HRegionInfo[]{parentA, parentB});
            MetaTableAccessor.addRegionsToMeta((Connection)connection, (List)regionInfos, (int)3);
            MetaTableAccessor.mergeRegions((Connection)connection, (HRegionInfo)merged, (HRegionInfo)parentA, (HRegionInfo)parentB, (ServerName)serverName0, (int)3);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, merged.getRegionName(), 1);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, merged.getRegionName(), 2);
        }
    }

    static abstract class MetaTask
    extends Thread {
        boolean stop = false;
        int count = 0;
        Throwable t = null;
        final Connection connection;

        MetaTask(Connection connection, String name) {
            super(name);
            this.connection = connection;
        }

        @Override
        public void run() {
            try {
                while (!this.stop) {
                    LOG.info((Object)("Before " + this.getName() + ", count=" + this.count));
                    this.metaTask();
                    ++this.count;
                    LOG.info((Object)("After " + this.getName() + ", count=" + this.count));
                    Thread.sleep(100L);
                }
            }
            catch (Throwable t) {
                LOG.info((Object)(this.getName() + " failed"), t);
                this.t = t;
            }
        }

        boolean isProgressing() throws InterruptedException {
            int currentCount = this.count;
            while (currentCount == this.count) {
                if (!this.isAlive()) {
                    return false;
                }
                if (this.t != null) {
                    return false;
                }
                Thread.sleep(10L);
            }
            return true;
        }

        @Override
        public String toString() {
            return "count=" + this.count + ", t=" + (this.t == null ? "null" : this.t.toString());
        }

        abstract void metaTask() throws Throwable;
    }
}

