// Autogenerated Jamon implementation
// /var/lib/jenkins/workspace/generic-binary-tarball-and-maven-deploy/CDH5.4.8-Packaging-HBase-2015-11-03_00-36-20/hbase-1.0.0-cdh5.4.8/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/MasterStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 32, 1
import java.util.*;
// 33, 1
import org.apache.hadoop.util.StringUtils;
// 34, 1
import org.apache.hadoop.hbase.util.Bytes;
// 35, 1
import org.apache.hadoop.hbase.util.JvmVersion;
// 36, 1
import org.apache.hadoop.hbase.util.FSUtils;
// 37, 1
import org.apache.hadoop.hbase.master.HMaster;
// 38, 1
import org.apache.hadoop.hbase.master.AssignmentManager;
// 39, 1
import org.apache.hadoop.hbase.master.ServerManager;
// 40, 1
import org.apache.hadoop.hbase.HConstants;
// 41, 1
import org.apache.hadoop.hbase.NamespaceDescriptor;
// 42, 1
import org.apache.hadoop.hbase.ServerLoad;
// 43, 1
import org.apache.hadoop.hbase.ServerName;
// 44, 1
import org.apache.hadoop.hbase.client.Admin;
// 45, 1
import org.apache.hadoop.hbase.client.HConnectionManager;
// 46, 1
import org.apache.hadoop.hbase.HTableDescriptor;
// 47, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 48, 1
import org.apache.hadoop.hbase.TableName;
// 49, 1
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos.SnapshotDescription;
// 50, 1
import org.apache.hadoop.hbase.master.DeadServer;
// 51, 1
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 52, 1
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
// 53, 1
import org.apache.hadoop.hbase.security.access.AccessControlLists;

public class MasterStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.Intf

{
  private final HMaster master;
  private final Set<ServerName> deadServers;
  private final boolean catalogJanitorEnabled;
  private final String format;
  private final ServerName metaLocation;
  private final Map<String,Integer> frags;
  private final AssignmentManager assignmentManager;
  private final List<ServerName> servers;
  private final ServerManager serverManager;
  private final String filter;
  // 65, 1
  
  public String formatZKString() {
    StringBuilder quorums = new StringBuilder();
    String zkQuorum = master.getZooKeeper().getQuorum();

    if (null == zkQuorum) {
      return quorums.toString();
    }

    String[] zks = zkQuorum.split(",");

    if (zks.length == 0) {
      return quorums.toString();
    }

    for(int i = 0; i < zks.length; ++i) {
      quorums.append(zks[i].trim()).append(",");

      if ((i+1) % 4 == 0 && i != (zks.length - 1)) {
        quorums.append("<br/>");
      }
    }

    quorums.setLength(quorums.length() - 1);
    return quorums.toString();
  }

  protected static org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getDeadServers__IsNotDefault())
    {
      p_implData.setDeadServers(null);
    }
    if(! p_implData.getCatalogJanitorEnabled__IsNotDefault())
    {
      p_implData.setCatalogJanitorEnabled(true);
    }
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    if(! p_implData.getMetaLocation__IsNotDefault())
    {
      p_implData.setMetaLocation(null);
    }
    if(! p_implData.getFrags__IsNotDefault())
    {
      p_implData.setFrags(null);
    }
    if(! p_implData.getAssignmentManager__IsNotDefault())
    {
      p_implData.setAssignmentManager(null);
    }
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    if(! p_implData.getServerManager__IsNotDefault())
    {
      p_implData.setServerManager(null);
    }
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    return p_implData;
  }
  public MasterStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    deadServers = p_implData.getDeadServers();
    catalogJanitorEnabled = p_implData.getCatalogJanitorEnabled();
    format = p_implData.getFormat();
    metaLocation = p_implData.getMetaLocation();
    frags = p_implData.getFrags();
    assignmentManager = p_implData.getAssignmentManager();
    servers = p_implData.getServers();
    serverManager = p_implData.getServerManager();
    filter = p_implData.getFilter();
  }
  
  public void renderNoFlush(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 56, 1
    if (format.equals("json") )
    {
      // 56, 30
      jamonWriter.write("\n  ");
      // 57, 3
      {
        org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_0 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_0.setFilter(filter);
        __jamon__var_0.setFormat("json" );
        __jamon__var_0.renderNoFlush(jamonWriter);
      }
      // 57, 68
      jamonWriter.write("\n  ");
      // 58, 3
      return; 
    }
    // 59, 7
    jamonWriter.write("\n");
    // 60, 1
    
ServerManager serverManager = master.getServerManager();
AssignmentManager assignmentManager = master.getAssignmentManager();

    // 93, 1
    jamonWriter.write("<!--[if IE]>\n<!DOCTYPE html>\n<![endif]-->\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>");
    // 100, 12
    if (master.isActiveMaster() )
    {
      // 100, 43
      jamonWriter.write("Master: ");
    }
    // 100, 51
    else
    {
      // 100, 58
      jamonWriter.write("Backup Master: ");
    }
    // 100, 79
    jamonWriter.write("\n    ");
    // 101, 5
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
    // 101, 47
    jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n\n    <div class=\"navbar  navbar-fixed-top navbar-default\">\n        <div class=\"container\">\n            <div class=\"navbar-header\">\n                <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                </button>\n                <a class=\"navbar-brand\" href=\"/master-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n            </div>\n            <div class=\"collapse navbar-collapse\">\n                <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/\">Home</a></li>\n                <li><a href=\"/tablesDetailed.jsp\">Table Details</a></li>\n                <li><a href=\"/logs/\">Local Logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug Dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                ");
    // 129, 17
    if (HBaseConfiguration.isShowConfInServlet())
    {
      // 129, 64
      jamonWriter.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
    }
    // 131, 23
    jamonWriter.write("\n               </ul>\n            </div><!--/.nav-collapse -->\n        </div>\n    </div>\n\n    <div class=\"container\">\n\t");
    // 138, 2
    if (master.isActiveMaster() )
    {
      // 138, 33
      jamonWriter.write("\n        <div class=\"row inner_header\">\n            <div class=\"page-header\">\n                <h1>Master <small>");
      // 141, 35
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
      // 141, 77
      jamonWriter.write("</small></h1>\n            </div>\n        </div>\n\n        <div class=\"row\">\n        <!-- Various warnings that cluster admins should be aware of -->\n        ");
      // 147, 9
      if (JvmVersion.isBadJvmVersion() )
      {
        // 147, 45
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Your current JVM version ");
        // 149, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(System.getProperty("java.version")), jamonWriter);
        // 149, 76
        jamonWriter.write(" is known to be\n          unstable with HBase. Please see the\n          <a href=\"http://wiki.apache.org/hadoop/Hbase/Troubleshooting#A18\">HBase wiki</a>\n          for details.\n          </div>\n        ");
      }
      // 154, 15
      jamonWriter.write("\n        ");
      // 155, 9
      if (master.isInitialized() && !catalogJanitorEnabled )
      {
        // 155, 65
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Please note that your cluster is running with the CatalogJanitor disabled. It can be\n          re-enabled from the hbase shell by running the command 'catalogjanitor_switch true'\n          </div>\n        ");
      }
      // 160, 15
      jamonWriter.write("\n\n        <section>\n            <h2>Region Servers</h2>\n            ");
      // 164, 13
      {
        org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl __jamon__var_1 = new org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl(this.getTemplateManager());
        __jamon__var_1.setServers(servers );
        __jamon__var_1.renderNoFlush(jamonWriter, master);
      }
      // 164, 74
      jamonWriter.write("\n\n            ");
      // 166, 13
      if ((deadServers != null) )
      {
        // 166, 42
        jamonWriter.write("\n                ");
        // 167, 17
        {
          // 167, 17
          __jamon_innerUnit__deadRegionServers(jamonWriter);
        }
        // 167, 40
        jamonWriter.write("\n            ");
      }
      // 168, 19
      jamonWriter.write("\n        </section>\n        <section>\n            ");
      // 171, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_2 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_2.renderNoFlush(jamonWriter, master );
      }
      // 171, 58
      jamonWriter.write("\n        </section>\n        <section>\n            <h2>Tables</h2>\n            <div class=\"tabbable\">\n                <ul class=\"nav nav-pills\">\n                    <li class=\"active\">\n                        <a href=\"#tab_userTables\" data-toggle=\"tab\">User Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_catalogTables\" data-toggle=\"tab\">System Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_userSnapshots\" data-toggle=\"tab\">Snapshots</a>\n                    </li>\n                </ul>\n                <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n                    <div class=\"tab-pane active\" id=\"tab_userTables\">\n                        ");
      // 189, 25
      if ((metaLocation != null) )
      {
        // 189, 55
        jamonWriter.write("\n                            ");
        // 190, 29
        {
          // 190, 29
          __jamon_innerUnit__userTables(jamonWriter);
        }
        // 190, 45
        jamonWriter.write("\n                        ");
      }
      // 191, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_catalogTables\">\n                        ");
      // 194, 25
      if ((metaLocation != null) )
      {
        // 194, 55
        jamonWriter.write("\n                            ");
        // 195, 29
        {
          // 195, 29
          __jamon_innerUnit__catalogTables(jamonWriter);
        }
        // 195, 48
        jamonWriter.write("\n                        ");
      }
      // 196, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_userSnapshots\">\n                        ");
      // 199, 25
      {
        // 199, 25
        __jamon_innerUnit__userSnapshots(jamonWriter);
      }
      // 199, 44
      jamonWriter.write("\n                    </div>\n                </div>\n            </div>\n        </section>\n        ");
      // 204, 9
      if (master.getAssignmentManager() != null )
      {
        // 204, 54
        jamonWriter.write("\n        ");
        // 205, 9
        {
          org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl __jamon__var_3 = new org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl(this.getTemplateManager());
          __jamon__var_3.renderNoFlush(jamonWriter, master.getAssignmentManager());
        }
        // 205, 90
        jamonWriter.write("\n        ");
      }
      // 206, 15
      jamonWriter.write("\n\t");
    }
    // 207, 2
    else
    {
      // 207, 9
      jamonWriter.write("\n        <section>\n            ");
      // 209, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_4 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_4.renderNoFlush(jamonWriter, master );
      }
      // 209, 58
      jamonWriter.write("\n        </section>\n\t");
    }
    // 211, 8
    jamonWriter.write("    \n\n\n        <section>\n            ");
    // 215, 13
    {
      org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_5 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
      __jamon__var_5.setFilter(filter );
      __jamon__var_5.renderNoFlush(jamonWriter);
    }
    // 215, 61
    jamonWriter.write("\n        </section>\n\n        <section>\n            <h2>Software Attributes</h2>\n            <table id=\"attributes_table\" class=\"table table-striped\">\n                <tr>\n                    <th>Attribute Name</th>\n                    <th>Value</th>\n                    <th>Description</th>\n                </tr>\n                <tr>\n                    <td>HBase Version</td>\n                    <td>");
    // 228, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getVersion()), jamonWriter);
    // 228, 84
    jamonWriter.write(", revision=");
    // 228, 95
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getRevision()), jamonWriter);
    // 228, 155
    jamonWriter.write("</td><td>HBase version and revision</td>\n                </tr>\n                <tr>\n                    <td>HBase Compiled</td>\n                    <td>");
    // 232, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getDate()), jamonWriter);
    // 232, 81
    jamonWriter.write(", ");
    // 232, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getUser()), jamonWriter);
    // 232, 139
    jamonWriter.write("</td>\n                    <td>When HBase version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>HBase Source Checksum</td>\n                    <td>");
    // 237, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 237, 82
    jamonWriter.write("</td>\n                    <td>HBase source MD5 checksum</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Version</td>\n                    <td>");
    // 242, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
    // 242, 78
    jamonWriter.write(", revision=");
    // 242, 89
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
    // 242, 143
    jamonWriter.write("</td>\n                    <td>Hadoop version and revision</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Compiled</td>\n                    <td>");
    // 247, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
    // 247, 75
    jamonWriter.write(", ");
    // 247, 77
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
    // 247, 127
    jamonWriter.write("</td>\n                    <td>When Hadoop version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>Zookeeper Quorum</td>\n                    <td> ");
    // 253, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(formatZKString()), jamonWriter);
    // 253, 48
    jamonWriter.write(" </td>\n                    <td>Addresses of all registered ZK servers. For more, see <a href=\"/zk.jsp\">zk dump</a>.</td>\n                </tr>\n                <tr>\n                    <td>Zookeeper Base Path</td>\n                    <td> ");
    // 258, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getZooKeeper().getBaseZNode()), jamonWriter);
    // 258, 68
    jamonWriter.write("</td>\n                    <td>Root node of this cluster in ZK.</td>\n                </tr>\n                <tr>\n                    <td>HBase Root Directory</td>\n                    <td>");
    // 263, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(FSUtils.getRootDir(master.getConfiguration()).toString()), jamonWriter);
    // 263, 87
    jamonWriter.write("</td>\n                    <td>Location of HBase home directory</td>\n                </tr>\n                <tr>\n                    <td>HMaster Start Time</td>\n                    <td>");
    // 268, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterStartTime())), jamonWriter);
    // 268, 68
    jamonWriter.write("</td>\n                    <td>Date stamp of when this HMaster was started</td>\n                </tr>\n                ");
    // 271, 17
    if (master.isActiveMaster() )
    {
      // 271, 48
      jamonWriter.write("\n\t                <tr>\n\t                    <td>HMaster Active Time</td>\n\t                    <td>");
      // 274, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterActiveTime())), jamonWriter);
      // 274, 70
      jamonWriter.write("</td>\n\t                    <td>Date stamp of when this HMaster became active</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>HBase Cluster ID</td>\n\t                    <td>");
      // 279, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getClusterId() != null ? master.getClusterId() : "Not set"), jamonWriter);
      // 279, 97
      jamonWriter.write("</td>\n\t                    <td>Unique identifier generated for each HBase cluster</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>Load average</td>\n\t                    <td>");
      // 284, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerManager() == null ? "0.00" :
	                      StringUtils.limitDecimalTo2(master.getServerManager().getAverageLoad())), jamonWriter);
      // 285, 98
      jamonWriter.write("</td>\n\t                    <td>Average number of regions per regionserver. Naive computation.</td>\n\t                </tr>\n\t                ");
      // 288, 18
      if (frags != null )
      {
        // 288, 39
        jamonWriter.write("\n\t                <tr>\n\t                    <td>Fragmentation</td>\n\t                    <td>");
        // 291, 26
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get("-TOTAL-") != null ? frags.get("-TOTAL-").intValue() + "%" : "n/a"), jamonWriter);
        // 291, 108
        jamonWriter.write("</td>\n\t                    <td>Overall fragmentation of all tables, including hbase:meta</td>\n\t                </tr>\n\t                ");
      }
      // 294, 24
      jamonWriter.write("\n\t                <tr>\n\t                    <td>Coprocessors</td>\n\t                    <td>");
      // 297, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getMasterCoprocessorHost() == null ? "[]" :
	                      java.util.Arrays.toString(master.getMasterCoprocessors())), jamonWriter);
      // 298, 84
      jamonWriter.write("</td>\n\t                    <td>Coprocessors currently loaded by the master</td>\n\t                </tr>\n                ");
    }
    // 301, 23
    jamonWriter.write("\n            </table>\n        </section>\n        </div>\n    </div> <!-- /container -->\n\n    <script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n  </body>\n</html>\n\n");
  }
  
  
  // 391, 1
  private void __jamon_innerUnit__userSnapshots(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 392, 1
    
   List<SnapshotDescription> snapshots = null;
   try (Admin admin = master.getConnection().getAdmin()) {
     snapshots = master.isInitialized() ? admin.listSnapshots() : null;
   }

    // 398, 1
    if ((snapshots != null && snapshots.size() > 0))
    {
      // 398, 51
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Snapshot Name</th>\n        <th>Table</th>\n        <th>Creation Time</th>\n    </tr>\n    ");
      // 405, 5
      for (SnapshotDescription snapshotDesc : snapshots)
      {
        // 405, 57
        jamonWriter.write("\n    ");
        // 406, 5
        
        TableName snapshotTable = TableName.valueOf(snapshotDesc.getTable());
    
        // 409, 5
        jamonWriter.write("<tr>\n        <td><a href=\"snapshot.jsp?name=");
        // 410, 40
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 410, 68
        jamonWriter.write("\">");
        // 410, 70
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 410, 98
        jamonWriter.write("</a> </td>\n        <td><a href=\"table.jsp?name=");
        // 411, 37
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
        // 411, 74
        jamonWriter.write("\">");
        // 411, 76
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
        // 411, 113
        jamonWriter.write("</a>\n        </td>\n        <td>");
        // 413, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(snapshotDesc.getCreationTime())), jamonWriter);
        // 413, 59
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 415, 12
      jamonWriter.write("\n    <p>");
      // 416, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshots.size()), jamonWriter);
      // 416, 30
      jamonWriter.write(" snapshot(s) in set.</p>\n</table>\n");
    }
    // 418, 7
    jamonWriter.write("\n");
  }
  
  
  // 313, 1
  private void __jamon_innerUnit__catalogTables(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 314, 1
    
 HTableDescriptor[] sysTables = null;
 try (Admin admin = master.getConnection().getAdmin()) {
   sysTables = master.isInitialized() ? admin.listTableDescriptorsByNamespace(
     NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR) : null;
 }

    // 321, 1
    if ((sysTables != null && sysTables.length > 0))
    {
      // 321, 51
      jamonWriter.write("\n<table class=\"table table-striped\">\n<tr>\n    <th>Table Name</th>\n    ");
      // 325, 5
      if ((frags != null) )
      {
        // 325, 28
        jamonWriter.write("\n        <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n    ");
      }
      // 327, 11
      jamonWriter.write("\n    <th>Description</th>\n</tr>\n");
      // 330, 1
      for (HTableDescriptor systemTable : sysTables)
      {
        // 330, 49
        jamonWriter.write("\n<tr>\n");
        // 332, 1
        TableName tableName = systemTable.getTableName();
        // 333, 5
        jamonWriter.write("<td><a href=\"table.jsp?name=");
        // 333, 33
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
        // 333, 48
        jamonWriter.write("\">");
        // 333, 50
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
        // 333, 65
        jamonWriter.write("</a></td>\n    ");
        // 334, 5
        if ((frags != null))
        {
          // 334, 27
          jamonWriter.write("\n        <td align=\"center\">");
          // 335, 28
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(tableName.getNameAsString()) != null ? frags.get(tableName.getNameAsString())
        .intValue() + "%" : "n/a"), jamonWriter);
          // 336, 37
          jamonWriter.write("</td>\n    ");
        }
        // 337, 11
        jamonWriter.write("\n    ");
        // 338, 5
        String description = null;
        if (tableName.equals(TableName.META_TABLE_NAME)){
            description = "The hbase:meta table holds references to all User Table regions";
        } else if (tableName.equals(AccessControlLists.ACL_TABLE_NAME)){
            description = "The hbase:acl table holds information about acl";
	 } else if (tableName.equals(VisibilityConstants.LABELS_TABLE_NAME)){
	     description = "The hbase:labels table holds information about visibility labels";
        } else {
            description = "The .NAMESPACE. table holds information about namespaces.";
        }
    
        // 349, 5
        jamonWriter.write("<td>");
        // 349, 9
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(description), jamonWriter);
        // 349, 26
        jamonWriter.write("</td>\n</tr>\n");
      }
      // 351, 8
      jamonWriter.write("\n</table>\n");
    }
    // 353, 7
    jamonWriter.write("\n");
  }
  
  
  // 356, 1
  private void __jamon_innerUnit__userTables(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 357, 1
    
   HTableDescriptor[] tables = null; 
   try (Admin admin = master.getConnection().getAdmin()) {
     tables = master.isInitialized() ? admin.listTables() : null;
   }

    // 363, 1
    if ((tables != null && tables.length > 0))
    {
      // 363, 45
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Namespace</th>\n        <th>Table Name</th>\n        ");
      // 368, 9
      if ((frags != null) )
      {
        // 368, 32
        jamonWriter.write("\n            <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n        ");
      }
      // 370, 15
      jamonWriter.write("\n        <th>Online Regions</th>\n        <th>Description</th>\n    </tr>\n    ");
      // 374, 5
      for (HTableDescriptor htDesc : tables)
      {
        // 374, 45
        jamonWriter.write("\n    <tr>\n        <td>");
        // 376, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.getTableName().getNamespaceAsString()), jamonWriter);
        // 376, 63
        jamonWriter.write("</td>\n        <td><a href=table.jsp?name=");
        // 377, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.getTableName().getNameAsString()), jamonWriter);
        // 377, 81
        jamonWriter.write(">");
        // 377, 82
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.getTableName().getQualifierAsString()), jamonWriter);
        // 377, 132
        jamonWriter.write("</a> </td>\n        ");
        // 378, 9
        if ((frags != null) )
        {
          // 378, 32
          jamonWriter.write("\n            <td align=\"center\">");
          // 379, 32
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(htDesc.getTableName().getNameAsString()) != null ? frags.get(htDesc.getTableName().getQualifierAsString()).intValue() + "%" : "n/a"), jamonWriter);
          // 379, 179
          jamonWriter.write("</td>\n        ");
        }
        // 380, 15
        jamonWriter.write("\n        <td>");
        // 381, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getAssignmentManager().getRegionStates().getRegionsOfTable(htDesc
        .getTableName()).size()), jamonWriter);
        // 382, 35
        jamonWriter.write("\n        <td>");
        // 383, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.toStringCustomizedValues()), jamonWriter);
        // 383, 52
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 385, 12
      jamonWriter.write("\n    <p>");
      // 386, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tables.length), jamonWriter);
      // 386, 27
      jamonWriter.write(" table(s) in set. [<a href=tablesDetailed.jsp>Details</a>]</p>\n</table>\n");
    }
    // 388, 7
    jamonWriter.write("\n");
  }
  
  
  // 422, 1
  private void __jamon_innerUnit__deadRegionServers(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 424, 1
    if ((deadServers != null && deadServers.size() > 0))
    {
      // 424, 55
      jamonWriter.write("\n<h2>Dead Region Servers</h2>\n<table class=\"table table-striped\">\n    <tr>\n        <th></th>\n        <th>ServerName</th>\n        <th>Stop time</th>\n    </tr>\n    ");
      // 432, 5
      
       DeadServer deadServerUtil = master.getServerManager().getDeadServers();
       ServerName [] deadServerNames = deadServers.toArray(new ServerName[deadServers.size()]);
         Arrays.sort(deadServerNames);
         for (ServerName deadServerName: deadServerNames) {
    
      // 438, 5
      jamonWriter.write("<tr>\n    \t<th></th>\n        <td>");
      // 440, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerName), jamonWriter);
      // 440, 33
      jamonWriter.write("</td>\n        <td>");
      // 441, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerUtil.getTimeOfDeath(deadServerName)), jamonWriter);
      // 441, 64
      jamonWriter.write("</td>\n    </tr>\n    ");
      // 443, 5
      
        }
    
      // 446, 5
      jamonWriter.write("<tr>\n        <th>Total: </th>\n        <td>servers: ");
      // 448, 22
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServers.size()), jamonWriter);
      // 448, 46
      jamonWriter.write("</td>\n        <th></th>\n    </tr>\n</table>\n");
    }
    // 452, 7
    jamonWriter.write("\n");
  }
  
  
}
