/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class AppBlock
extends HtmlBlock {
    private final Configuration conf;
    private final ResourceManager rm;

    @Inject
    AppBlock(ResourceManager rm, View.ViewContext ctx, Configuration conf) {
        super(ctx);
        this.conf = conf;
        this.rm = rm;
    }

    protected void render(HtmlBlock.Block html) {
        String aid = this.$("app.id");
        if (aid.isEmpty()) {
            this.puts(new Object[]{"Bad request: requires application ID"});
            return;
        }
        ApplicationId appID = null;
        try {
            appID = Apps.toAppID((String)aid);
        }
        catch (Exception e) {
            this.puts(new Object[]{"Invalid Application ID: " + aid});
            return;
        }
        RMContext context = this.rm.getRMContext();
        RMApp rmApp = (RMApp)context.getRMApps().get(appID);
        if (rmApp == null) {
            this.puts(new Object[]{"Application not found: " + aid});
            return;
        }
        AppInfo app = new AppInfo(rmApp, true, WebAppUtils.getHttpSchemePrefix((Configuration)this.conf));
        String remoteUser = this.request().getRemoteUser();
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        if (callerUGI != null && !this.rm.getApplicationACLsManager().checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, app.getUser(), appID) && !this.rm.getQueueACLsManager().checkAccess(callerUGI, QueueACL.ADMINISTER_QUEUE, app.getQueue())) {
            this.puts(new Object[]{"You (User " + remoteUser + ") are not authorized to view application " + appID});
            return;
        }
        this.setTitle(StringHelper.join((Object[])new Object[]{"Application ", aid}));
        RMAppMetrics appMerics = rmApp.getRMAppMetrics();
        RMAppAttemptMetrics attemptMetrics = null == rmApp.getCurrentAppAttempt() ? null : rmApp.getCurrentAppAttempt().getRMAppAttemptMetrics();
        Resource attemptResourcePreempted = attemptMetrics == null ? Resources.none() : attemptMetrics.getResourcePreempted();
        int attemptNumNonAMContainerPreempted = attemptMetrics == null ? 0 : attemptMetrics.getNumNonAMContainersPreempted();
        this.info("Application Overview")._("User:", (Object)app.getUser())._("Name:", (Object)app.getName())._("Application Type:", (Object)app.getApplicationType())._("Application Tags:", (Object)app.getApplicationTags())._("State:", (Object)app.getState())._("FinalStatus:", (Object)app.getFinalStatus())._("Started:", (Object)Times.format((long)app.getStartTime()))._("Elapsed:", (Object)StringUtils.formatTime((long)Times.elapsed((long)app.getStartTime(), (long)app.getFinishTime())))._("Tracking URL:", !app.isTrackingUrlReady() ? "#" : app.getTrackingUrlPretty(), (Object)app.getTrackingUI())._("Diagnostics:", (Object)app.getNote());
        Hamlet.DIV pdiv = html._(InfoBlock.class).div(".info-wrap.ui-widget-content.ui-corner-bottom");
        this.info("Application Overview").clear();
        this.info("Application Metrics")._("Total Resource Preempted:", (Object)appMerics.getResourcePreempted())._("Total Number of Non-AM Containers Preempted:", (Object)String.valueOf(appMerics.getNumNonAMContainersPreempted()))._("Total Number of AM Containers Preempted:", (Object)String.valueOf(appMerics.getNumAMContainersPreempted()))._("Resource Preempted from Current Attempt:", (Object)attemptResourcePreempted)._("Number of Non-AM Containers Preempted from Current Attempt:", (Object)attemptNumNonAMContainerPreempted)._("Aggregate Resource Allocation:", (Object)String.format("%d MB-seconds, %d vcore-seconds", appMerics.getMemorySeconds(), appMerics.getVcoreSeconds()));
        pdiv._();
        Collection<RMAppAttempt> attempts = rmApp.getAppAttempts().values();
        String amString = attempts.size() == 1 ? "ApplicationMaster" : "ApplicationMasters";
        Hamlet.DIV div = html._(InfoBlock.class).div(".info-wrap.ui-widget-content.ui-corner-bottom");
        Hamlet.TABLE table = div.table("#app");
        ((Hamlet.TABLE)table.tr().th(amString)._()).tr().th(".ui-state-default", "Attempt Number").th(".ui-state-default", "Start Time").th(".ui-state-default", "Node").th(".ui-state-default", "Logs")._();
        boolean odd = false;
        for (RMAppAttempt attempt : attempts) {
            AppAttemptInfo attemptInfo = new AppAttemptInfo(attempt, app.getUser());
            odd = !odd;
            ((Hamlet.TR)((Hamlet.TR)table.tr(odd ? ".odd" : ".even").td(String.valueOf(attemptInfo.getAttemptId())).td(Times.format((long)attemptInfo.getStartTime())).td().a(".nodelink", this.url(new String[]{"//", attemptInfo.getNodeHttpAddress()}), attemptInfo.getNodeHttpAddress())._()).td().a(".logslink", this.url(new String[]{attemptInfo.getLogsLink()}), "logs")._())._();
        }
        table._();
        div._();
    }
}

