/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AbstractEvent;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRejectedEvent;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DelegationTokenRenewer
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(DelegationTokenRenewer.class);
    @VisibleForTesting
    public static final Text HDFS_DELEGATION_KIND = new Text("HDFS_DELEGATION_TOKEN");
    public static final String SCHEME = "hdfs";
    private Timer renewalTimer;
    private RMContext rmContext;
    private DelegationTokenCancelThread dtCancelThread = new DelegationTokenCancelThread();
    private ThreadPoolExecutor renewerService;
    private ConcurrentMap<ApplicationId, Set<DelegationTokenToRenew>> appTokens = new ConcurrentHashMap<ApplicationId, Set<DelegationTokenToRenew>>();
    private ConcurrentMap<Token<?>, DelegationTokenToRenew> allTokens = new ConcurrentHashMap();
    private final ConcurrentMap<ApplicationId, Long> delayedRemovalMap = new ConcurrentHashMap<ApplicationId, Long>();
    private long tokenRemovalDelayMs;
    private Thread delayedRemovalThread;
    private ReadWriteLock serviceStateLock = new ReentrantReadWriteLock();
    private volatile boolean isServiceStarted;
    private LinkedBlockingQueue<DelegationTokenRenewerEvent> pendingEventQueue;
    private boolean tokenKeepAliveEnabled;
    private boolean hasProxyUserPrivileges;
    private long credentialsValidTimeRemaining;
    public static final String RM_SYSTEM_CREDENTIALS_VALID_TIME_REMAINING = "yarn.resourcemanager.system-credentials.valid-time-remaining";
    public static final long DEFAULT_RM_SYSTEM_CREDENTIALS_VALID_TIME_REMAINING = 10800000L;

    public DelegationTokenRenewer() {
        super(DelegationTokenRenewer.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.hasProxyUserPrivileges = conf.getBoolean("yarn.resourcemanager.proxy-user-privileges.enabled", YarnConfiguration.DEFAULT_RM_PROXY_USER_PRIVILEGES_ENABLED);
        this.tokenKeepAliveEnabled = conf.getBoolean("yarn.log-aggregation-enable", false);
        this.tokenRemovalDelayMs = conf.getInt("yarn.nm.liveness-monitor.expiry-interval-ms", 600000);
        this.credentialsValidTimeRemaining = conf.getLong(RM_SYSTEM_CREDENTIALS_VALID_TIME_REMAINING, 10800000L);
        this.setLocalSecretManagerAndServiceAddr();
        this.renewerService = this.createNewThreadPoolService(conf);
        this.pendingEventQueue = new LinkedBlockingQueue();
        this.renewalTimer = new Timer(true);
        super.serviceInit(conf);
    }

    protected ThreadPoolExecutor createNewThreadPoolService(Configuration conf) {
        int nThreads = conf.getInt("yarn.resourcemanager.delegation-token-renewer.thread-count", 50);
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("DelegationTokenRenewer #%d").build();
        ThreadPoolExecutor pool = new ThreadPoolExecutor(nThreads, nThreads, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        pool.setThreadFactory(tf);
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    private void setLocalSecretManagerAndServiceAddr() {
        RMDelegationTokenIdentifier.Renewer.setSecretManager((AbstractDelegationTokenSecretManager)this.rmContext.getRMDelegationTokenSecretManager(), (InetSocketAddress)this.rmContext.getClientRMService().getBindAddress());
    }

    protected void serviceStart() throws Exception {
        this.dtCancelThread.start();
        if (this.tokenKeepAliveEnabled) {
            this.delayedRemovalThread = new Thread((Runnable)new DelayedTokenRemovalRunnable(this.getConfig()), "DelayedTokenCanceller");
            this.delayedRemovalThread.start();
        }
        this.setLocalSecretManagerAndServiceAddr();
        this.serviceStateLock.writeLock().lock();
        this.isServiceStarted = true;
        this.serviceStateLock.writeLock().unlock();
        while (!this.pendingEventQueue.isEmpty()) {
            this.processDelegationTokenRenewerEvent(this.pendingEventQueue.take());
        }
        super.serviceStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDelegationTokenRenewerEvent(DelegationTokenRenewerEvent evt) {
        this.serviceStateLock.readLock().lock();
        try {
            if (this.isServiceStarted) {
                this.renewerService.execute(new DelegationTokenRenewerRunnable(evt));
            } else {
                this.pendingEventQueue.add(evt);
            }
        }
        finally {
            this.serviceStateLock.readLock().unlock();
        }
    }

    protected void serviceStop() {
        if (this.renewalTimer != null) {
            this.renewalTimer.cancel();
        }
        this.appTokens.clear();
        this.allTokens.clear();
        this.renewerService.shutdown();
        this.dtCancelThread.interrupt();
        try {
            this.dtCancelThread.join(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.tokenKeepAliveEnabled && this.delayedRemovalThread != null) {
            this.delayedRemovalThread.interrupt();
            try {
                this.delayedRemovalThread.join(1000L);
            }
            catch (InterruptedException e) {
                LOG.info((Object)"Interrupted while joining on delayed removal thread.", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    public Set<Token<?>> getDelegationTokens() {
        HashSet tokens = new HashSet();
        for (Set tokenList : this.appTokens.values()) {
            for (DelegationTokenToRenew token : tokenList) {
                tokens.add(token.token);
            }
        }
        return tokens;
    }

    public void addApplicationAsync(ApplicationId applicationId, Credentials ts, boolean shouldCancelAtEnd, String user) {
        this.processDelegationTokenRenewerEvent(new DelegationTokenRenewerAppSubmitEvent(applicationId, ts, shouldCancelAtEnd, user));
    }

    public void addApplicationAsyncDuringRecovery(ApplicationId applicationId, Credentials ts, boolean shouldCancelAtEnd, String user) {
        this.processDelegationTokenRenewerEvent(new DelegationTokenRenewerAppRecoverEvent(applicationId, ts, shouldCancelAtEnd, user));
    }

    public void addApplicationSync(ApplicationId applicationId, Credentials ts, boolean shouldCancelAtEnd, String user) throws IOException, InterruptedException {
        this.handleAppSubmitEvent(new DelegationTokenRenewerAppSubmitEvent(applicationId, ts, shouldCancelAtEnd, user));
    }

    private void handleAppSubmitEvent(AbstractDelegationTokenRenewerAppEvent evt) throws IOException, InterruptedException {
        ApplicationId applicationId = evt.getApplicationId();
        Credentials ts = evt.getCredentials();
        boolean shouldCancelAtEnd = evt.shouldCancelAtEnd();
        if (ts == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registering tokens for renewal for: appId = " + applicationId));
        }
        Collection tokens = ts.getAllTokens();
        long now = System.currentTimeMillis();
        this.appTokens.put(applicationId, Collections.synchronizedSet(new HashSet()));
        HashSet<DelegationTokenToRenew> tokenList = new HashSet<DelegationTokenToRenew>();
        boolean hasHdfsToken = false;
        for (Token token : tokens) {
            if (!token.isManaged()) continue;
            if (token.getKind().equals((Object)HDFS_DELEGATION_KIND)) {
                LOG.info((Object)(applicationId + " found existing hdfs token " + token));
                hasHdfsToken = true;
            }
            if (this.skipTokenRenewal(token)) continue;
            DelegationTokenToRenew dttr = (DelegationTokenToRenew)this.allTokens.get(token);
            if (dttr == null) {
                dttr = new DelegationTokenToRenew(Arrays.asList(applicationId), token, this.getConfig(), now, shouldCancelAtEnd, evt.getUser());
                try {
                    this.renewToken(dttr);
                }
                catch (IOException ioe) {
                    throw new IOException("Failed to renew token: " + dttr.token, ioe);
                }
            }
            tokenList.add(dttr);
        }
        if (!tokenList.isEmpty()) {
            for (DelegationTokenToRenew dtr : tokenList) {
                DelegationTokenToRenew currentDtr = this.allTokens.putIfAbsent(dtr.token, dtr);
                if (currentDtr != null) {
                    currentDtr.referringAppIds.add(applicationId);
                    ((Set)this.appTokens.get(applicationId)).add(currentDtr);
                    continue;
                }
                ((Set)this.appTokens.get(applicationId)).add(dtr);
                this.setTimerForTokenRenewal(dtr);
            }
        }
        if (!hasHdfsToken) {
            this.requestNewHdfsDelegationToken(Arrays.asList(applicationId), evt.getUser(), shouldCancelAtEnd);
        }
    }

    private boolean skipTokenRenewal(Token<?> token) throws IOException {
        AbstractDelegationTokenIdentifier identifier = (AbstractDelegationTokenIdentifier)token.decodeIdentifier();
        if (identifier == null) {
            return false;
        }
        Text renewer = identifier.getRenewer();
        return renewer != null && renewer.toString().equals("");
    }

    @VisibleForTesting
    protected void setTimerForTokenRenewal(DelegationTokenToRenew token) throws IOException {
        long expiresIn = token.expirationDate - System.currentTimeMillis();
        long renewIn = token.expirationDate - expiresIn / 10L;
        RenewalTimerTask tTask = new RenewalTimerTask(token);
        token.setTimerTask(tTask);
        this.renewalTimer.schedule((TimerTask)token.timerTask, new Date(renewIn));
        LOG.info((Object)("Renew " + token + " in " + expiresIn + " ms, appId = " + token.referringAppIds));
    }

    @VisibleForTesting
    protected void renewToken(final DelegationTokenToRenew dttr) throws IOException {
        try {
            dttr.expirationDate = (Long)UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Long>(){

                @Override
                public Long run() throws Exception {
                    return dttr.token.renew(dttr.conf);
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        LOG.info((Object)("Renewed delegation-token= [" + dttr + "], for " + dttr.referringAppIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestNewHdfsDelegationTokenIfNeeded(DelegationTokenToRenew dttr) throws IOException, InterruptedException {
        if (this.hasProxyUserPrivileges && dttr.maxDate - dttr.expirationDate < this.credentialsValidTimeRemaining && dttr.token.getKind().equals((Object)HDFS_DELEGATION_KIND)) {
            HashSet<ApplicationId> applicationIds;
            Collection<ApplicationId> collection = dttr.referringAppIds;
            synchronized (collection) {
                applicationIds = new HashSet<ApplicationId>(dttr.referringAppIds);
                dttr.referringAppIds.clear();
            }
            for (ApplicationId appId : applicationIds) {
                Set tokenSet = (Set)this.appTokens.get(appId);
                if (tokenSet == null || tokenSet.isEmpty()) continue;
                Iterator iter = tokenSet.iterator();
                Set set = tokenSet;
                synchronized (set) {
                    while (iter.hasNext()) {
                        DelegationTokenToRenew t = (DelegationTokenToRenew)iter.next();
                        if (!t.token.getKind().equals((Object)HDFS_DELEGATION_KIND)) continue;
                        iter.remove();
                        this.allTokens.remove(t.token);
                        t.cancelTimer();
                        LOG.info((Object)("Removed expiring token " + t));
                    }
                }
            }
            LOG.info((Object)("Token= (" + dttr + ") is expiring, request new token."));
            this.requestNewHdfsDelegationToken(applicationIds, dttr.user, dttr.shouldCancelAtEnd);
        }
    }

    private void requestNewHdfsDelegationToken(Collection<ApplicationId> referringAppIds, String user, boolean shouldCancelAtEnd) throws IOException, InterruptedException {
        if (!this.hasProxyUserPrivileges) {
            LOG.info((Object)"RM proxy-user privilege is not enabled. Skip requesting hdfs tokens.");
            return;
        }
        Credentials credentials = new Credentials();
        Token<?>[] newTokens = this.obtainSystemTokensForUser(user, credentials);
        LOG.info((Object)("Received new tokens for " + referringAppIds + ". Received " + newTokens.length + " tokens."));
        if (newTokens.length > 0) {
            for (Token<?> token : newTokens) {
                if (!token.isManaged()) continue;
                DelegationTokenToRenew tokenToRenew = new DelegationTokenToRenew(referringAppIds, token, this.getConfig(), Time.now(), shouldCancelAtEnd, user);
                this.renewToken(tokenToRenew);
                this.setTimerForTokenRenewal(tokenToRenew);
                for (ApplicationId applicationId : referringAppIds) {
                    ((Set)this.appTokens.get(applicationId)).add(tokenToRenew);
                }
                LOG.info((Object)("Received new token " + token));
            }
        }
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        ByteBuffer byteBuffer = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        for (ApplicationId applicationId : referringAppIds) {
            this.rmContext.getSystemCredentialsForApps().put(applicationId, byteBuffer);
        }
    }

    @VisibleForTesting
    protected Token<?>[] obtainSystemTokensForUser(String user, final Credentials credentials) throws IOException, InterruptedException {
        UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser());
        Token[] newTokens = (Token[])proxyUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Token<?>[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Token<?>[] run() throws Exception {
                try (FileSystem fs = FileSystem.get((Configuration)DelegationTokenRenewer.this.getConfig());){
                    Token[] tokenArray = fs.addDelegationTokens(UserGroupInformation.getLoginUser().getUserName(), credentials);
                    return tokenArray;
                }
            }
        });
        return newTokens;
    }

    private void cancelToken(DelegationTokenToRenew t) {
        if (t.shouldCancelAtEnd) {
            this.dtCancelThread.cancelToken(t.token, t.conf);
        } else {
            LOG.info((Object)("Did not cancel " + t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFailedDelegationToken(DelegationTokenToRenew t) {
        Collection<ApplicationId> applicationIds;
        Collection<ApplicationId> collection = applicationIds = t.referringAppIds;
        synchronized (collection) {
            LOG.error((Object)("removing failed delegation token for appid=" + applicationIds + ";t=" + t.token.getService()));
            for (ApplicationId applicationId : applicationIds) {
                ((Set)this.appTokens.get(applicationId)).remove(t);
            }
        }
        this.allTokens.remove(t.token);
        t.cancelTimer();
    }

    public void applicationFinished(ApplicationId applicationId) {
        this.processDelegationTokenRenewerEvent(new DelegationTokenRenewerEvent(applicationId, DelegationTokenRenewerEventType.FINISH_APPLICATION));
    }

    private void handleAppFinishEvent(DelegationTokenRenewerEvent evt) {
        if (!this.tokenKeepAliveEnabled) {
            this.removeApplicationFromRenewal(evt.getApplicationId());
        } else {
            this.delayedRemovalMap.put(evt.getApplicationId(), System.currentTimeMillis() + this.tokenRemovalDelayMs);
        }
    }

    public void updateKeepAliveApplications(List<ApplicationId> appIds) {
        if (this.tokenKeepAliveEnabled && appIds != null && appIds.size() > 0) {
            for (ApplicationId appId : appIds) {
                this.delayedRemovalMap.put(appId, System.currentTimeMillis() + this.tokenRemovalDelayMs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeApplicationFromRenewal(ApplicationId applicationId) {
        this.rmContext.getSystemCredentialsForApps().remove(applicationId);
        Set tokens = (Set)this.appTokens.get(applicationId);
        if (tokens != null && !tokens.isEmpty()) {
            Set set = tokens;
            synchronized (set) {
                Iterator it = tokens.iterator();
                while (it.hasNext()) {
                    DelegationTokenToRenew dttr = (DelegationTokenToRenew)it.next();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Removing delegation token for appId=" + applicationId + "; token=" + dttr.token.getService()));
                    }
                    Collection<ApplicationId> collection = dttr.referringAppIds;
                    synchronized (collection) {
                        dttr.referringAppIds.remove(applicationId);
                        if (!dttr.referringAppIds.isEmpty()) {
                            continue;
                        }
                    }
                    dttr.cancelTimer();
                    this.cancelToken(dttr);
                    it.remove();
                    this.allTokens.remove(dttr.token);
                }
            }
        }
        if (tokens != null && tokens.isEmpty()) {
            this.appTokens.remove(applicationId);
        }
    }

    public void setRMContext(RMContext rmContext) {
        this.rmContext = rmContext;
    }

    private void handleDTRenewerAppRecoverEvent(DelegationTokenRenewerAppRecoverEvent event) {
        try {
            this.handleAppSubmitEvent(event);
        }
        catch (Throwable t) {
            LOG.warn((Object)"Unable to add the application to the delegation token renewer.", t);
        }
    }

    protected ConcurrentMap<Token<?>, DelegationTokenToRenew> getAllTokens() {
        return this.allTokens;
    }

    private static class DelegationTokenRenewerEvent
    extends AbstractEvent<DelegationTokenRenewerEventType> {
        private ApplicationId appId;

        public DelegationTokenRenewerEvent(ApplicationId appId, DelegationTokenRenewerEventType type) {
            super((Enum)type);
            this.appId = appId;
        }

        public ApplicationId getApplicationId() {
            return this.appId;
        }
    }

    static enum DelegationTokenRenewerEventType {
        VERIFY_AND_START_APPLICATION,
        RECOVER_APPLICATION,
        FINISH_APPLICATION;

    }

    static class AbstractDelegationTokenRenewerAppEvent
    extends DelegationTokenRenewerEvent {
        private Credentials credentials;
        private boolean shouldCancelAtEnd;
        private String user;

        public AbstractDelegationTokenRenewerAppEvent(ApplicationId appId, Credentials credentails, boolean shouldCancelAtEnd, String user, DelegationTokenRenewerEventType type) {
            super(appId, type);
            this.credentials = credentails;
            this.shouldCancelAtEnd = shouldCancelAtEnd;
            this.user = user;
        }

        public Credentials getCredentials() {
            return this.credentials;
        }

        public boolean shouldCancelAtEnd() {
            return this.shouldCancelAtEnd;
        }

        public String getUser() {
            return this.user;
        }
    }

    static class DelegationTokenRenewerAppRecoverEvent
    extends AbstractDelegationTokenRenewerAppEvent {
        public DelegationTokenRenewerAppRecoverEvent(ApplicationId appId, Credentials credentails, boolean shouldCancelAtEnd, String user) {
            super(appId, credentails, shouldCancelAtEnd, user, DelegationTokenRenewerEventType.RECOVER_APPLICATION);
        }
    }

    static class DelegationTokenRenewerAppSubmitEvent
    extends AbstractDelegationTokenRenewerAppEvent {
        public DelegationTokenRenewerAppSubmitEvent(ApplicationId appId, Credentials credentails, boolean shouldCancelAtEnd, String user) {
            super(appId, credentails, shouldCancelAtEnd, user, DelegationTokenRenewerEventType.VERIFY_AND_START_APPLICATION);
        }
    }

    private final class DelegationTokenRenewerRunnable
    implements Runnable {
        private DelegationTokenRenewerEvent evt;

        public DelegationTokenRenewerRunnable(DelegationTokenRenewerEvent evt) {
            this.evt = evt;
        }

        @Override
        public void run() {
            if (this.evt instanceof DelegationTokenRenewerAppSubmitEvent) {
                DelegationTokenRenewerAppSubmitEvent appSubmitEvt = (DelegationTokenRenewerAppSubmitEvent)this.evt;
                this.handleDTRenewerAppSubmitEvent(appSubmitEvt);
            } else if (this.evt instanceof DelegationTokenRenewerAppRecoverEvent) {
                DelegationTokenRenewerAppRecoverEvent appRecoverEvt = (DelegationTokenRenewerAppRecoverEvent)this.evt;
                DelegationTokenRenewer.this.handleDTRenewerAppRecoverEvent(appRecoverEvt);
            } else if (((DelegationTokenRenewerEventType)this.evt.getType()).equals((Object)DelegationTokenRenewerEventType.FINISH_APPLICATION)) {
                DelegationTokenRenewer.this.handleAppFinishEvent(this.evt);
            }
        }

        private void handleDTRenewerAppSubmitEvent(DelegationTokenRenewerAppSubmitEvent event) {
            try {
                DelegationTokenRenewer.this.handleAppSubmitEvent(event);
                DelegationTokenRenewer.this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(event.getApplicationId(), RMAppEventType.START));
            }
            catch (Throwable t) {
                LOG.warn((Object)"Unable to add the application to the delegation token renewer.", t);
                DelegationTokenRenewer.this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppRejectedEvent(event.getApplicationId(), t.getMessage()));
            }
        }
    }

    private class DelayedTokenRemovalRunnable
    implements Runnable {
        private long waitTimeMs;

        DelayedTokenRemovalRunnable(Configuration conf) {
            this.waitTimeMs = conf.getLong("yarn.resourcemanager.delayed.delegation-token.removal-interval-ms", 30000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList toCancel = new ArrayList();
            while (!Thread.currentThread().isInterrupted()) {
                Iterator it = DelegationTokenRenewer.this.delayedRemovalMap.entrySet().iterator();
                toCancel.clear();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    if ((Long)e.getValue() >= System.currentTimeMillis()) continue;
                    toCancel.add(e.getKey());
                }
                for (ApplicationId appId : toCancel) {
                    DelegationTokenRenewer.this.removeApplicationFromRenewal(appId);
                    DelegationTokenRenewer.this.delayedRemovalMap.remove(appId);
                }
                DelayedTokenRemovalRunnable delayedTokenRemovalRunnable = this;
                synchronized (delayedTokenRemovalRunnable) {
                    try {
                        this.wait(this.waitTimeMs);
                    }
                    catch (InterruptedException e) {
                        LOG.info((Object)"Delayed Deletion Thread Interrupted. Shutting it down");
                        return;
                    }
                }
            }
        }
    }

    private class RenewalTimerTask
    extends TimerTask {
        private DelegationTokenToRenew dttr;
        private AtomicBoolean cancelled = new AtomicBoolean(false);

        RenewalTimerTask(DelegationTokenToRenew t) {
            this.dttr = t;
        }

        @Override
        public void run() {
            if (this.cancelled.get()) {
                return;
            }
            Token<?> token = this.dttr.token;
            try {
                DelegationTokenRenewer.this.requestNewHdfsDelegationTokenIfNeeded(this.dttr);
                if (!this.dttr.isTimerCancelled()) {
                    DelegationTokenRenewer.this.renewToken(this.dttr);
                    DelegationTokenRenewer.this.setTimerForTokenRenewal(this.dttr);
                } else {
                    LOG.info((Object)("The token was removed already. Token = [" + this.dttr + "]"));
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Exception renewing token" + token + ". Not rescheduled"), (Throwable)e);
                DelegationTokenRenewer.this.removeFailedDelegationToken(this.dttr);
            }
        }

        @Override
        public boolean cancel() {
            this.cancelled.set(true);
            return super.cancel();
        }
    }

    private static class DelegationTokenCancelThread
    extends Thread {
        private LinkedBlockingQueue<TokenWithConf> queue = new LinkedBlockingQueue();

        public DelegationTokenCancelThread() {
            super("Delegation Token Canceler");
            this.setDaemon(true);
        }

        public void cancelToken(Token<?> token, Configuration conf) {
            TokenWithConf tokenWithConf = new TokenWithConf(token, conf);
            while (!this.queue.offer(tokenWithConf)) {
                LOG.warn((Object)("Unable to add token " + token + " for cancellation. " + "Will retry.."));
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void run() {
            TokenWithConf tokenWithConf = null;
            while (true) {
                try {
                    while (true) {
                        final TokenWithConf current = tokenWithConf = this.queue.take();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Cancelling token " + tokenWithConf.token.getService()));
                        }
                        UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                current.token.cancel(current.conf);
                                return null;
                            }
                        });
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed to cancel token " + tokenWithConf.token + " " + StringUtils.stringifyException((Throwable)e)));
                    continue;
                }
                catch (RuntimeException e) {
                    LOG.warn((Object)("Failed to cancel token " + tokenWithConf.token + " " + StringUtils.stringifyException((Throwable)e)));
                    continue;
                }
                catch (InterruptedException ie) {
                    return;
                }
                catch (Throwable t) {
                    LOG.warn((Object)("Got exception " + StringUtils.stringifyException((Throwable)t) + ". Exiting.."));
                    System.exit(-1);
                    continue;
                }
                break;
            }
        }

        private static class TokenWithConf {
            Token<?> token;
            Configuration conf;

            TokenWithConf(Token<?> token, Configuration conf) {
                this.token = token;
                this.conf = conf;
            }
        }
    }

    @VisibleForTesting
    protected static class DelegationTokenToRenew {
        public final Token<?> token;
        public final Collection<ApplicationId> referringAppIds;
        public final Configuration conf;
        public long expirationDate;
        public RenewalTimerTask timerTask;
        public volatile boolean shouldCancelAtEnd;
        public long maxDate;
        public String user;

        public DelegationTokenToRenew(Collection<ApplicationId> applicationIds, Token<?> token, Configuration conf, long expirationDate, boolean shouldCancelAtEnd, String user) {
            this.token = token;
            this.user = user;
            if (token.getKind().equals((Object)HDFS_DELEGATION_KIND)) {
                try {
                    AbstractDelegationTokenIdentifier identifier = (AbstractDelegationTokenIdentifier)token.decodeIdentifier();
                    this.maxDate = identifier.getMaxDate();
                }
                catch (IOException e) {
                    throw new YarnRuntimeException((Throwable)e);
                }
            }
            this.referringAppIds = Collections.synchronizedSet(new HashSet<ApplicationId>(applicationIds));
            this.conf = conf;
            this.expirationDate = expirationDate;
            this.timerTask = null;
            this.shouldCancelAtEnd = shouldCancelAtEnd;
        }

        public void setTimerTask(RenewalTimerTask tTask) {
            this.timerTask = tTask;
        }

        @VisibleForTesting
        public void cancelTimer() {
            if (this.timerTask != null) {
                this.timerTask.cancel();
            }
        }

        @VisibleForTesting
        public boolean isTimerCancelled() {
            return this.timerTask != null && this.timerTask.cancelled.get();
        }

        public String toString() {
            return this.token + ";exp=" + this.expirationDate + "; apps=" + this.referringAppIds;
        }

        public boolean equals(Object obj) {
            return obj instanceof DelegationTokenToRenew && this.token.equals(((DelegationTokenToRenew)obj).token);
        }

        public int hashCode() {
            return this.token.hashCode();
        }
    }
}

