/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.PiEstimator;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestUserlogsRetentionAcrossRestarts {
    private Configuration conf = new Configuration();
    private MiniDFSCluster dfs = null;
    private MiniMRCluster mr = null;
    private static final int numDir = 1;
    private static final int numDataNodes = 1;
    private static final int numTaskTrackers = 1;

    public TestUserlogsRetentionAcrossRestarts() {
        String testName = System.getProperty("testcase");
        Assume.assumeTrue((testName != null && testName.contains(TestUserlogsRetentionAcrossRestarts.class.getSimpleName()) ? 1 : 0) != 0);
    }

    @Before
    public void startCluster() throws IOException {
        this.dfs = new MiniDFSCluster(this.conf, 1, true, null);
        this.mr = new MiniMRCluster(1, this.dfs.getFileSystem().getUri().toString(), 1);
        this.mr.waitUntilIdle();
    }

    @After
    public void stopCluster() {
        if (this.dfs != null) {
            this.dfs.shutdown();
        }
        if (this.mr != null) {
            this.mr.shutdown();
        }
    }

    private void runPiEstimator() throws IOException {
        JobConf jobConf = this.mr.createJobConf();
        PiEstimator.estimate((int)2, (long)100L, (JobConf)jobConf);
    }

    private void restartTaskTracker(int id) throws IOException {
        this.mr.stopTaskTracker(id);
        this.mr.startTaskTracker(null, null, id, 1);
        this.mr.waitUntilIdle();
    }

    @Test
    public void testOnTaskTrackerRestart() throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.conf);
        String ttDir = this.mr.getTaskTrackerLocalDirs(0)[0];
        Path userlogsPath = new Path(ttDir, "userlogs");
        this.runPiEstimator();
        Assert.assertTrue((String)"Userlogs should exist before TT shutdown", (boolean)localFs.exists(userlogsPath));
        this.restartTaskTracker(0);
        Assert.assertTrue((String)"Userlogs should not be deleted on restart", (boolean)localFs.exists(userlogsPath));
    }

    @Test
    public void testOnJobTrackerRestart() throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.conf);
        String ttDir = this.mr.getTaskTrackerLocalDirs(0)[0];
        Path userlogsPath = new Path(ttDir, "userlogs");
        this.runPiEstimator();
        Assert.assertTrue((String)"Userlogs should exist before JT shutdown", (boolean)localFs.exists(userlogsPath));
        this.mr.stopJobTracker();
        this.mr.startJobTracker(true);
        Assert.assertTrue((String)"Userlogs should not be deleted on restart", (boolean)localFs.exists(userlogsPath));
    }
}

