/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskLogServlet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mortbay.jetty.testing.HttpTester;
import org.mortbay.jetty.testing.ServletTester;

public class TestTaskLogServlet {
    private static final Log LOG = LogFactory.getLog(TestTaskLogServlet.class);
    private ServletTester tester;

    @Before
    public void setup() throws Exception {
        this.tester = new ServletTester();
        this.tester.setContextPath("/");
        this.tester.addServlet(TaskLogServlet.class, "/tasklog");
        this.tester.start();
    }

    @Test
    public void testMissingParameters() throws Exception {
        HttpTester request = new HttpTester();
        request.setMethod("GET");
        request.setURI("/tasklog");
        request.setVersion("HTTP/1.0");
        HttpTester response = new HttpTester();
        response.parse(this.tester.getResponses(request.generate()));
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    private void setupValidLogs(String attemptIdStr) throws IOException {
        TaskAttemptID attemptId = TaskAttemptID.forName((String)attemptIdStr);
        File logDir = TaskLog.getAttemptDir((TaskAttemptID)attemptId, (boolean)false);
        FileUtil.fullyDelete((File)logDir);
        logDir.mkdirs();
        Assert.assertTrue((boolean)logDir.exists());
        TaskLog.syncLogs((String)logDir.getAbsolutePath(), (TaskAttemptID)attemptId, (boolean)false, (boolean)false);
        this.makeLog(new File(logDir, "stderr"), "<b>this is stderr");
        this.makeLog(new File(logDir, "stdout"), "<b>this is stdout");
        this.makeLog(new File(logDir, "syslog"), "<b>this is syslog");
        TaskLog.syncLogs((String)logDir.getAbsolutePath(), (TaskAttemptID)attemptId, (boolean)false, (boolean)false);
    }

    @Test
    public void testHtmlLogs() throws Exception {
        String attemptIdStr = "attempt_123_0001_m_000001_0";
        this.setupValidLogs(attemptIdStr);
        HttpTester request = new HttpTester();
        request.setMethod("GET");
        request.setURI("/tasklog?attemptid=" + attemptIdStr);
        request.setVersion("HTTP/1.0");
        HttpTester response = this.doRequest(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/html; charset=utf-8", (Object)response.getHeader("content-type"));
        Assert.assertTrue((boolean)response.getContent().contains("&lt;b&gt;this is stderr"));
        Assert.assertTrue((boolean)response.getContent().contains("&lt;b&gt;this is stdout"));
        Assert.assertTrue((boolean)response.getContent().contains("&lt;b&gt;this is syslog"));
        request.setURI("/tasklog?attemptid=" + attemptIdStr + "&start=1&end=6");
        response = this.doRequest(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/html; charset=utf-8", (Object)response.getHeader("content-type"));
        Assert.assertFalse((boolean)response.getContent().contains("&lt;b"));
        Assert.assertFalse((boolean)response.getContent().contains("this is"));
        Assert.assertTrue((boolean)response.getContent().contains("b&gt;thi</pre>"));
    }

    @Test
    public void testPlaintextLogs() throws Exception {
        String attemptIdStr = "attempt_123_0001_m_000001_0";
        this.setupValidLogs(attemptIdStr);
        HttpTester request = new HttpTester();
        request.setMethod("GET");
        request.setURI("/tasklog?plaintext=true&attemptid=" + attemptIdStr);
        request.setVersion("HTTP/1.0");
        HttpTester response = this.doRequest(request);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        request.setURI("/tasklog?plaintext=true&filter=stdout&attemptid=" + attemptIdStr);
        response = this.doRequest(request);
        Assert.assertEquals((Object)"text/plain; charset=utf-8", (Object)response.getHeader("content-type"));
        Assert.assertEquals((Object)"<b>this is stdout", (Object)response.getContent());
        request.setURI("/tasklog?plaintext=true&filter=stdout&attemptid=" + attemptIdStr + "&start=1&end=6");
        response = this.doRequest(request);
        Assert.assertEquals((Object)"text/plain; charset=utf-8", (Object)response.getHeader("content-type"));
        Assert.assertEquals((Object)"b>thi", (Object)response.getContent());
    }

    private HttpTester doRequest(HttpTester request) throws Exception {
        String reqStr = request.generate();
        LOG.info((Object)("Testing request: " + reqStr));
        String respStr = this.tester.getResponses(reqStr);
        LOG.info((Object)("Response: " + respStr));
        HttpTester response = new HttpTester();
        response.parse(respStr);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeLog(File f, String contents) throws IOException {
        LOG.info((Object)("Creating log at " + f));
        try (FileWriter fw = new FileWriter(f);){
            fw.write(contents);
        }
    }
}

