/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.SleepJob;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobQueueTaskScheduler;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskScheduler;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapreduce.server.jobtracker.TaskTracker;
import org.apache.hadoop.util.DummyResourceCalculatorPlugin;
import org.apache.hadoop.util.LinuxResourceCalculatorPlugin;
import org.apache.hadoop.util.ResourceCalculatorPlugin;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestTTResourceReporting
extends TestCase {
    static final Log LOG = LogFactory.getLog(TestTTResourceReporting.class);
    private MiniMRCluster miniMRCluster;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultResourceValues() throws Exception {
        JobConf conf = new JobConf();
        try {
            conf.setClass("mapreduce.tasktracker.resourcecalculatorplugin", DummyResourceCalculatorPlugin.class, ResourceCalculatorPlugin.class);
            this.setUpCluster(conf);
            JobConf jobConf = this.miniMRCluster.createJobConf();
            jobConf.setClass("mapreduce.tasktracker.resourcecalculatorplugin", DummyResourceCalculatorPlugin.class, ResourceCalculatorPlugin.class);
            this.runSleepJob(jobConf);
            this.verifyTestResults();
        }
        finally {
            this.tearDownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConfiguredResourceValues() throws Exception {
        JobConf conf = new JobConf();
        conf.setLong("totalVmemOnTT", 0x100000000L);
        conf.setLong("totalPmemOnTT", 0x80000000L);
        conf.setLong("mapSlotMemorySize", 512L);
        conf.setLong("reduceSlotMemorySize", 1024L);
        conf.setLong("availableVmemOnTT", 0x100000000L);
        conf.setLong("availablePmemOnTT", 0x80000000L);
        conf.setLong("cumulativeCpuTime", 10000L);
        conf.setLong("cpuFrequency", 2000000L);
        conf.setInt("numProcessors", 8);
        conf.setFloat("cpuUsage", 15.5f);
        conf.setLong("procCumulativeCpuTime", 1000L);
        conf.setLong("procVirtualMemorySize", 0x80000000L);
        conf.setLong("procPhysicalMemorySize", 0x40000000L);
        conf.setClass("mapreduce.tasktracker.resourcecalculatorplugin", DummyResourceCalculatorPlugin.class, ResourceCalculatorPlugin.class);
        conf.setLong("mapred.tasktracker.maxvmem.testing", 0x100000000L);
        conf.setLong("mapred.tasktracker.maxpmem.testing", 0x80000000L);
        conf.setLong("mapred.cluster.map.memory.mb", 512L);
        conf.setLong("mapred.cluster.reduce.memory.mb", 1024L);
        conf.setLong("mapred.tasktracker.cumulativecputime.testing", 10000L);
        conf.setLong("mapred.tasktracker.cpufrequency.testing", 2000000L);
        conf.setInt("mapred.tasktracker.numprocessors.testing", 8);
        conf.setFloat("mapred.tasktracker.cpuusage.testing", 15.5f);
        try {
            this.setUpCluster(conf);
            JobConf jobConf = this.miniMRCluster.createJobConf();
            jobConf.setMemoryForMapTask(1024L);
            jobConf.setMemoryForReduceTask(2048L);
            jobConf.setClass("mapreduce.tasktracker.resourcecalculatorplugin", DummyResourceCalculatorPlugin.class, ResourceCalculatorPlugin.class);
            jobConf.setLong("mapred.tasktracker.proccumulativecputime.testing", 1000L);
            jobConf.setLong("mapred.tasktracker.procvmem.testing", 0x80000000L);
            jobConf.setLong("mapred.tasktracker.procpmem.testing", 0x40000000L);
            this.runSleepJob(jobConf);
            this.verifyTestResults();
        }
        finally {
            this.tearDownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceValuesOnLinux() throws Exception {
        if (!System.getProperty("os.name").startsWith("Linux")) {
            return;
        }
        JobConf conf = new JobConf();
        LinuxResourceCalculatorPlugin plugin = new LinuxResourceCalculatorPlugin();
        conf.setLong("totalVmemOnTT", plugin.getVirtualMemorySize());
        conf.setLong("totalPmemOnTT", plugin.getPhysicalMemorySize());
        conf.setLong("numProcessors", (long)plugin.getNumProcessors());
        try {
            this.setUpCluster(conf);
            this.runSleepJob(this.miniMRCluster.createJobConf());
            this.verifyTestResults(true);
        }
        finally {
            this.tearDownCluster();
        }
    }

    private void setUpCluster(JobConf conf) throws Exception {
        conf.setClass("mapred.jobtracker.taskScheduler", FakeTaskScheduler.class, TaskScheduler.class);
        conf.set("mapred.job.tracker.handler.count", "1");
        this.miniMRCluster = new MiniMRCluster(1, "file:///", 3, null, null, conf);
    }

    private void runSleepJob(JobConf conf) throws Exception {
        String[] args = new String[]{"-m", "1", "-r", "1", "-mt", "10", "-rt", "10"};
        ToolRunner.run((Configuration)conf, (Tool)new SleepJob(), (String[])args);
    }

    private void verifyTestResults() {
        this.verifyTestResults(false);
    }

    private void verifyTestResults(boolean excludeDynamic) {
        FakeTaskScheduler scheduler = (FakeTaskScheduler)this.miniMRCluster.getJobTrackerRunner().getJobTracker().getTaskScheduler();
        TestTTResourceReporting.assertTrue((String)scheduler.getFailureMessage(), (boolean)scheduler.hasTestPassed());
        if (!excludeDynamic) {
            TestTTResourceReporting.assertTrue((String)scheduler.getFailureMessage(), (boolean)scheduler.hasDynamicTestPassed());
        }
    }

    private void tearDownCluster() {
        if (this.miniMRCluster != null) {
            this.miniMRCluster.shutdown();
        }
    }

    public static class FakeTaskScheduler
    extends JobQueueTaskScheduler {
        private boolean hasPassed = true;
        private boolean hasDynamicValuePassed = true;
        private String message;

        public boolean hasTestPassed() {
            return this.hasPassed;
        }

        public boolean hasDynamicTestPassed() {
            return this.hasDynamicValuePassed;
        }

        public String getFailureMessage() {
            return this.message;
        }

        public List<Task> assignTasks(TaskTracker taskTracker) throws IOException {
            TaskTrackerStatus status = taskTracker.getStatus();
            long totalVirtualMemoryOnTT = this.getConf().getLong("totalVmemOnTT", -1L);
            long totalPhysicalMemoryOnTT = this.getConf().getLong("totalPmemOnTT", -1L);
            long mapSlotMemorySize = this.getConf().getLong("mapSlotMemorySize", -1L);
            long reduceSlotMemorySize = this.getConf().getLong("reduceSlotMemorySize", -1L);
            long availableVirtualMemoryOnTT = this.getConf().getLong("availableVmemOnTT", -1L);
            long availablePhysicalMemoryOnTT = this.getConf().getLong("availablePmemOnTT", -1L);
            long cumulativeCpuTime = this.getConf().getLong("cumulativeCpuTime", -1L);
            long cpuFrequency = this.getConf().getLong("cpuFrequency", -1L);
            int numProcessors = this.getConf().getInt("numProcessors", -1);
            float cpuUsage = this.getConf().getFloat("cpuUsage", -1.0f);
            long reportedTotalVirtualMemoryOnTT = status.getResourceStatus().getTotalVirtualMemory();
            long reportedTotalPhysicalMemoryOnTT = status.getResourceStatus().getTotalPhysicalMemory();
            long reportedMapSlotMemorySize = status.getResourceStatus().getMapSlotMemorySizeOnTT();
            long reportedReduceSlotMemorySize = status.getResourceStatus().getReduceSlotMemorySizeOnTT();
            long reportedAvailableVirtualMemoryOnTT = status.getResourceStatus().getAvailableVirtualMemory();
            long reportedAvailablePhysicalMemoryOnTT = status.getResourceStatus().getAvailablePhysicalMemory();
            long reportedCumulativeCpuTime = status.getResourceStatus().getCumulativeCpuTime();
            long reportedCpuFrequency = status.getResourceStatus().getCpuFrequency();
            int reportedNumProcessors = status.getResourceStatus().getNumProcessors();
            float reportedCpuUsage = status.getResourceStatus().getCpuUsage();
            this.message = "expected memory values : (totalVirtualMemoryOnTT, totalPhysicalMemoryOnTT, availableVirtualMemoryOnTT, availablePhysicalMemoryOnTT, mapSlotMemSize, reduceSlotMemorySize, cumulativeCpuTime, cpuFrequency, numProcessors, cpuUsage) = (" + totalVirtualMemoryOnTT + ", " + totalPhysicalMemoryOnTT + "," + availableVirtualMemoryOnTT + ", " + availablePhysicalMemoryOnTT + "," + mapSlotMemorySize + "," + reduceSlotMemorySize + "," + cumulativeCpuTime + "," + cpuFrequency + "," + numProcessors + "," + cpuUsage + ")";
            this.message = this.message + "\nreported memory values : (totalVirtualMemoryOnTT, totalPhysicalMemoryOnTT, availableVirtualMemoryOnTT, availablePhysicalMemoryOnTT, reportedMapSlotMemorySize, reportedReduceSlotMemorySize, reportedCumulativeCpuTime, reportedCpuFrequency, reportedNumProcessors, cpuUsage) = (" + reportedTotalVirtualMemoryOnTT + ", " + reportedTotalPhysicalMemoryOnTT + "," + reportedAvailableVirtualMemoryOnTT + ", " + reportedAvailablePhysicalMemoryOnTT + "," + reportedMapSlotMemorySize + "," + reportedReduceSlotMemorySize + "," + reportedCumulativeCpuTime + "," + reportedCpuFrequency + "," + reportedNumProcessors + "," + reportedCpuUsage + ")";
            LOG.info((Object)this.message);
            this.hasDynamicValuePassed = true;
            for (TaskStatus taskStatus : status.getTaskReports()) {
                Counters counters = taskStatus.getCounters();
                long procCumulativeCpuTime = 0L;
                long procVirtualMemorySize = this.getConf().getLong("procVirtualMemorySize", -1L);
                long procPhysicalMemorySize = this.getConf().getLong("procPhysicalMemorySize", -1L);
                long reportedProcCumulativeCpuTime = ((Counters.Counter)counters.findCounter((Enum)Task.Counter.CPU_MILLISECONDS)).getValue();
                long reportedProcVirtualMemorySize = ((Counters.Counter)counters.findCounter((Enum)Task.Counter.VIRTUAL_MEMORY_BYTES)).getValue();
                long reportedProcPhysicalMemorySize = ((Counters.Counter)counters.findCounter((Enum)Task.Counter.PHYSICAL_MEMORY_BYTES)).getValue();
                String procMessage = "expected values : (procCumulativeCpuTime, procVirtualMemorySize, procPhysicalMemorySize) = (" + procCumulativeCpuTime + ", " + procVirtualMemorySize + ", " + procPhysicalMemorySize + ")";
                procMessage = procMessage + "\nreported values : (procCumulativeCpuTime, procVirtualMemorySize, procPhysicalMemorySize) = (" + reportedProcCumulativeCpuTime + ", " + reportedProcVirtualMemorySize + ", " + reportedProcPhysicalMemorySize + ")";
                LOG.info((Object)procMessage);
                this.message = this.message + "\n" + procMessage;
                if (procCumulativeCpuTime == reportedProcCumulativeCpuTime && procVirtualMemorySize == reportedProcVirtualMemorySize && procPhysicalMemorySize == reportedProcPhysicalMemorySize) continue;
                this.hasDynamicValuePassed = false;
            }
            this.hasPassed = true;
            if (totalVirtualMemoryOnTT != reportedTotalVirtualMemoryOnTT || totalPhysicalMemoryOnTT != reportedTotalPhysicalMemoryOnTT || mapSlotMemorySize != reportedMapSlotMemorySize || reduceSlotMemorySize != reportedReduceSlotMemorySize || numProcessors != reportedNumProcessors) {
                this.hasPassed = false;
            }
            if (availableVirtualMemoryOnTT != reportedAvailableVirtualMemoryOnTT || availablePhysicalMemoryOnTT != reportedAvailablePhysicalMemoryOnTT || cumulativeCpuTime != reportedCumulativeCpuTime || cpuFrequency != reportedCpuFrequency || cpuUsage != reportedCpuUsage) {
                this.hasDynamicValuePassed = false;
            }
            return super.assignTasks(taskTracker);
        }
    }
}

