/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.metrics.ContextFactory;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.spi.OutputRecord;
import org.junit.Assert;
import org.junit.Test;

public class TestShuffleExceptionCount {
    @Test
    public void testCheckException() throws IOException, InterruptedException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        TestMapOutputServlet testServlet = new TestMapOutputServlet();
        JobConf conf = new JobConf();
        conf.setUser("testuser");
        conf.setJobName("testJob");
        conf.setSessionId("testSession");
        ContextFactory factory = ContextFactory.getFactory();
        factory.setAttribute("mapred.class", (Object)"org.apache.hadoop.metrics.spi.NoEmitMetricsContext");
        TaskTracker tt = new TaskTracker();
        tt.setConf(conf);
        TaskTracker taskTracker = tt;
        taskTracker.getClass();
        TaskTracker.ShuffleServerMetrics shuffleMetrics = new TaskTracker.ShuffleServerMetrics(taskTracker, conf);
        String exceptionMsgRegex = "Broken pipe";
        String exceptionStackRegex = null;
        IOException ie = new IOException("EOFException");
        testServlet.checkException(ie, exceptionMsgRegex, exceptionStackRegex, shuffleMetrics);
        MetricsContext context = factory.getContext("mapred");
        shuffleMetrics.doUpdates(context);
        Map records = context.getAllRecords();
        Collection col = (Collection)records.get("shuffleOutput");
        OutputRecord outputRecord = (OutputRecord)col.iterator().next();
        Assert.assertEquals((long)0L, (long)outputRecord.getMetric("shuffle_exceptions_caught").intValue());
        ie = new IOException("Broken pipe");
        testServlet.checkException(ie, exceptionMsgRegex, exceptionStackRegex, shuffleMetrics);
        shuffleMetrics.doUpdates(context);
        Assert.assertEquals((long)1L, (long)outputRecord.getMetric("shuffle_exceptions_caught").intValue());
        exceptionStackRegex = null;
        exceptionMsgRegex = null;
        testServlet.checkException(ie, exceptionMsgRegex, exceptionStackRegex, shuffleMetrics);
        shuffleMetrics.doUpdates(context);
        Assert.assertEquals((long)2L, (long)outputRecord.getMetric("shuffle_exceptions_caught").intValue());
        exceptionStackRegex = ".*\\.doesnt\\$SelectSet\\.wakeup.*";
        exceptionMsgRegex = null;
        ie.setStackTrace(this.constructStackTrace());
        testServlet.checkException(ie, exceptionMsgRegex, exceptionStackRegex, shuffleMetrics);
        shuffleMetrics.doUpdates(context);
        Assert.assertEquals((long)2L, (long)outputRecord.getMetric("shuffle_exceptions_caught").intValue());
        exceptionStackRegex = ".*\\.SelectorManager\\$SelectSet\\.wakeup.*";
        testServlet.checkException(ie, exceptionMsgRegex, exceptionStackRegex, shuffleMetrics);
        shuffleMetrics.doUpdates(context);
        Assert.assertEquals((long)3L, (long)outputRecord.getMetric("shuffle_exceptions_caught").intValue());
        exceptionMsgRegex = "Broken pipe";
        ie.setStackTrace(this.constructStackTraceTwo());
        testServlet.checkException(ie, exceptionMsgRegex, exceptionStackRegex, shuffleMetrics);
        shuffleMetrics.doUpdates(context);
        Assert.assertEquals((long)4L, (long)outputRecord.getMetric("shuffle_exceptions_caught").intValue());
        exceptionStackRegex = ".*[1-9]+BOGUSREGEX";
        testServlet.checkException(ie, exceptionMsgRegex, exceptionStackRegex, shuffleMetrics);
        shuffleMetrics.doUpdates(context);
        Assert.assertEquals((long)4L, (long)outputRecord.getMetric("shuffle_exceptions_caught").intValue());
        exceptionStackRegex = ".*\\.SelectorManager\\$SelectSet\\.wakeup.*";
        exceptionMsgRegex = "EOFException";
        testServlet.checkException(ie, exceptionMsgRegex, exceptionStackRegex, shuffleMetrics);
        shuffleMetrics.doUpdates(context);
        Assert.assertEquals((long)4L, (long)outputRecord.getMetric("shuffle_exceptions_caught").intValue());
    }

    private StackTraceElement[] constructStackTrace() {
        StackTraceElement[] stack = new StackTraceElement[]{new StackTraceElement("sun.nio.ch.EPollArrayWrapper", "interrupt", "", -2), new StackTraceElement("sun.nio.ch.EPollArrayWrapper", "interrupt", "EPollArrayWrapper.java", 256), new StackTraceElement("sun.nio.ch.EPollSelectorImpl", "wakeup", "EPollSelectorImpl.java", 175), new StackTraceElement("org.mortbay.io.nio.SelectorManager$SelectSet", "wakeup", "SelectorManager.java", 831), new StackTraceElement("org.mortbay.io.nio.SelectorManager$SelectSet", "doSelect", "SelectorManager.java", 709), new StackTraceElement("org.mortbay.io.nio.SelectorManager", "doSelect", "SelectorManager.java", 192), new StackTraceElement("org.mortbay.jetty.nio.SelectChannelConnector", "accept", "SelectChannelConnector.java", 124), new StackTraceElement("org.mortbay.jetty.AbstractConnector$Acceptor", "run", "AbstractConnector.java", 708), new StackTraceElement("org.mortbay.thread.QueuedThreadPool$PoolThread", "run", "QueuedThreadPool.java", 582)};
        return stack;
    }

    private StackTraceElement[] constructStackTraceTwo() {
        StackTraceElement[] stack = new StackTraceElement[]{new StackTraceElement("sun.nio.ch.EPollArrayWrapper", "interrupt", "", -2), new StackTraceElement("sun.nio.ch.EPollArrayWrapper", "interrupt", "EPollArrayWrapper.java", 256), new StackTraceElement("sun.nio.ch.EPollSelectorImpl", "wakeup", "EPollSelectorImpl.java", 175), new StackTraceElement("org.mortbay.io.nio.SelectorManager$SelectSet", "wakeup", "SelectorManager.java", 831), new StackTraceElement("org.mortbay.io.nio.SelectChannelEndPoint", "updateKey", "SelectChannelEndPoint.java", 335), new StackTraceElement("org.mortbay.io.nio.SelectChannelEndPoint", "blockWritable", "SelectChannelEndPoint.java", 278), new StackTraceElement("org.mortbay.jetty.AbstractGenerator$Output", "blockForOutput", "AbstractGenerator.java", 545), new StackTraceElement("org.mortbay.jetty.AbstractGenerator$Output", "flush", "AbstractGenerator.java", 572), new StackTraceElement("org.mortbay.jetty.HttpConnection$Output", "flush", "HttpConnection.java", 1012), new StackTraceElement("org.mortbay.jetty.AbstractGenerator$Output", "write", "AbstractGenerator.java", 651), new StackTraceElement("org.mortbay.jetty.AbstractGenerator$Output", "write", "AbstractGenerator.java", 580)};
        return stack;
    }

    public static class TestMapOutputServlet
    extends TaskTracker.MapOutputServlet {
        public void checkException(IOException ie, String exceptionMsgRegex, String exceptionStackRegex, TaskTracker.ShuffleServerMetrics shuffleMetrics) {
            super.checkException(ie, exceptionMsgRegex, exceptionStackRegex, shuffleMetrics);
        }
    }
}

