/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.TaskScheduler;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapred.TestClusterStatus;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRpcTimeout {
    private static String[] trackers = new String[]{"tracker_tracker1:1000", "tracker_tracker2:1000", "tracker_tracker3:1000"};
    private JobTracker jobTracker;
    private MiniMRCluster mr;

    @Before
    public void setUp() throws Exception {
        JobConf conf = new JobConf();
        conf.setClass("mapred.jobtracker.taskScheduler", TestClusterStatus.FakeTaskScheduler.class, TaskScheduler.class);
        this.mr = new MiniMRCluster(0, 0, 0, "file:///", 1, null, null, null, conf);
        this.jobTracker = this.mr.getJobTrackerRunner().getJobTracker();
        for (String tracker : trackers) {
            TestRpcTimeout.establishFirstContact(this.jobTracker, tracker);
        }
    }

    @After
    public void tearDown() throws Exception {
        this.mr.shutdown();
        this.mr = null;
        this.jobTracker = null;
    }

    static short sendHeartBeat(JobTracker jt, TaskTrackerStatus status, boolean initialContact, boolean acceptNewTasks, String tracker, short responseId) throws IOException {
        if (status == null) {
            status = new TaskTrackerStatus(tracker, JobInProgress.convertTrackerNameToHostName((String)tracker));
        }
        jt.heartbeat(status, false, initialContact, acceptNewTasks, responseId);
        responseId = (short)(responseId + 1);
        return responseId;
    }

    static void establishFirstContact(JobTracker jt, String tracker) throws IOException {
        TestRpcTimeout.sendHeartBeat(jt, null, true, false, tracker, (short)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRpcTimeout() throws IOException {
        JobConf conf = this.mr.createJobConf();
        conf.set("mapreduce.jobclient.rpc.timeout", "1");
        JobClient clientWithTimeout = new JobClient(conf);
        try {
            for (Thread thread : Thread.getAllStackTraces().keySet()) {
                if (!thread.getName().contains("IPC Server")) continue;
                thread.suspend();
            }
            clientWithTimeout.getClusterStatus();
            Assert.fail();
        }
        catch (SocketTimeoutException ex) {
            for (Thread thread : Thread.getAllStackTraces().keySet()) {
                if (!thread.getName().contains("IPC Server")) continue;
                thread.resume();
            }
        }
        finally {
            for (Thread thread : Thread.getAllStackTraces().keySet()) {
                if (!thread.getName().contains("IPC Server")) continue;
                thread.resume();
            }
        }
    }
}

