/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.util.HashSet;
import javax.net.SocketFactory;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.mapred.AdminOperationsProtocol;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;

public class TestNodeRefresh
extends TestCase {
    private String namenode = null;
    private MiniDFSCluster dfs = null;
    private MiniMRCluster mr = null;
    private JobTracker jt = null;
    private String[] hosts = null;
    private String[] trackerHosts = null;
    private UserGroupInformation owner;
    private UserGroupInformation user1;
    private UserGroupInformation user2;
    private UserGroupInformation user3;
    private UserGroupInformation user4;
    private UserGroupInformation user5;
    private static final Log LOG = LogFactory.getLog(TestNodeRefresh.class);

    private String getHostname(int i) {
        return "host" + i + ".com";
    }

    private void startCluster(int numHosts, int numTrackerPerHost, int numExcluded, UserGroupInformation clusterUgi, Configuration conf) throws IOException {
        try {
            int i;
            this.owner = UserGroupInformation.getLoginUser();
            this.user1 = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[]{"user1"});
            this.user2 = UserGroupInformation.createUserForTesting((String)"user2", (String[])new String[]{"user2"});
            this.user3 = UserGroupInformation.createUserForTesting((String)"user3", (String[])new String[]{"abc"});
            this.user4 = UserGroupInformation.createUserForTesting((String)"user4", (String[])new String[]{"supergroup"});
            this.user5 = UserGroupInformation.createUserForTesting((String)"user5", (String[])new String[]{"user5"});
            conf.setBoolean("dfs.replication.considerLoad", false);
            this.hosts = new String[numHosts];
            for (i = 1; i <= numHosts; ++i) {
                this.hosts[i - 1] = this.getHostname(i);
            }
            this.dfs = new MiniDFSCluster(conf, 1, true, null, this.hosts);
            this.dfs.waitActive();
            this.dfs.startDataNodes(conf, numHosts, true, null, null, this.hosts, null);
            this.dfs.waitActive();
            FileSystem.mkdirs((FileSystem)this.dfs.getFileSystem(), (Path)new Path("/"), (FsPermission)new FsPermission(511));
            this.namenode = this.dfs.getFileSystem().getUri().getHost() + ":" + this.dfs.getFileSystem().getUri().getPort();
            this.trackerHosts = new String[numHosts * numTrackerPerHost];
            for (i = 1; i <= numHosts * numTrackerPerHost; ++i) {
                this.trackerHosts[i - 1] = this.getHostname(i);
            }
            JobConf jtConf = new JobConf(conf);
            this.mr = new MiniMRCluster(0, 0, numHosts * numTrackerPerHost, this.namenode, 1, null, this.trackerHosts, clusterUgi, jtConf, numExcluded * numTrackerPerHost);
            this.jt = this.mr.getJobTrackerRunner().getJobTracker();
            HashSet<String> hostsSeen = new HashSet<String>();
            for (TaskTrackerStatus status : this.jt.taskTrackers()) {
                hostsSeen.add(status.getHost());
            }
            TestNodeRefresh.assertEquals((String)"Not all hosts are up", (int)(numHosts - numExcluded), (int)hostsSeen.size());
        }
        catch (IOException ioe) {
            this.stopCluster();
        }
    }

    private void stopCluster() {
        this.hosts = null;
        this.trackerHosts = null;
        if (this.dfs != null) {
            this.dfs.shutdown();
            this.dfs = null;
            this.namenode = null;
        }
        if (this.mr != null) {
            this.mr.shutdown();
            this.mr = null;
            this.jt = null;
        }
    }

    private AdminOperationsProtocol getClient(Configuration conf, UserGroupInformation ugi) throws IOException {
        return (AdminOperationsProtocol)RPC.getProxy(AdminOperationsProtocol.class, (long)3L, (InetSocketAddress)JobTracker.getAddress((Configuration)conf), (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getSocketFactory((Configuration)conf, AdminOperationsProtocol.class));
    }

    public void testMRRefreshDefault() throws IOException {
        Configuration conf = new Configuration();
        conf.set("mapred.hosts.exclude", "");
        this.startCluster(2, 1, 0, UserGroupInformation.getLoginUser(), conf);
        conf = this.mr.createJobConf(new JobConf(conf));
        AdminOperationsProtocol client = this.getClient(conf, this.user1);
        boolean success = false;
        try {
            client.refreshNodes();
            success = true;
        }
        catch (IOException ioe) {
            // empty catch block
        }
        TestNodeRefresh.assertFalse((String)"Invalid user performed privileged refresh operation", (boolean)success);
        success = false;
        client = this.getClient(conf, this.owner);
        try {
            client.refreshNodes();
            success = true;
        }
        catch (IOException ioe) {
            // empty catch block
        }
        TestNodeRefresh.assertTrue((String)"Privileged user denied permission for refresh operation", (boolean)success);
        success = false;
        client = this.getClient(conf, this.user4);
        try {
            client.refreshNodes();
            success = true;
        }
        catch (IOException ioe) {
            // empty catch block
        }
        TestNodeRefresh.assertFalse((String)"Invalid user performed privileged refresh operation", (boolean)success);
        TestNodeRefresh.assertEquals((String)"Trackers are lost upon refresh with empty hosts.exclude", (int)2, (int)this.jt.getClusterStatus(false).getTaskTrackers());
        TestNodeRefresh.assertEquals((String)"Excluded node count is incorrect", (int)0, (int)this.jt.getClusterStatus(false).getNumExcludedNodes());
        HashSet<String> hosts = new HashSet<String>();
        for (TaskTrackerStatus status : this.jt.taskTrackers()) {
            hosts.add(status.getHost());
        }
        TestNodeRefresh.assertEquals((String)"Host is excluded upon refresh with empty hosts.exclude", (int)2, (int)hosts.size());
        this.stopCluster();
    }

    public void testMRSuperUsers() throws IOException {
        Configuration conf = new Configuration();
        conf.set("mapreduce.cluster.administrators", "user5 abc");
        this.startCluster(2, 1, 0, UserGroupInformation.createRemoteUser((String)"user1"), conf);
        conf = this.mr.createJobConf(new JobConf(conf));
        AdminOperationsProtocol client = this.getClient(conf, this.user2);
        boolean success = false;
        try {
            client.refreshNodes();
            success = true;
        }
        catch (IOException ioe) {
            // empty catch block
        }
        TestNodeRefresh.assertFalse((String)"Invalid user performed privileged refresh operation", (boolean)success);
        success = false;
        client = this.getClient(conf, this.user1);
        try {
            client.refreshNodes();
            success = true;
        }
        catch (IOException ioe) {
            // empty catch block
        }
        TestNodeRefresh.assertTrue((String)"Privileged user denied permission for refresh operation", (boolean)success);
        success = false;
        client = this.getClient(conf, this.user3);
        try {
            client.refreshNodes();
            success = true;
        }
        catch (IOException ioe) {
            // empty catch block
        }
        TestNodeRefresh.assertTrue((String)"Admin group member denied permission for refresh operation", (boolean)success);
        success = false;
        client = this.getClient(conf, this.user5);
        try {
            client.refreshNodes();
            success = true;
        }
        catch (IOException ioe) {
            // empty catch block
        }
        TestNodeRefresh.assertTrue((String)"Admin user denied permission for refresh operation", (boolean)success);
        this.stopCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMRRefreshDecommissioning() throws IOException {
        Configuration conf = new Configuration();
        conf.set("mapred.hosts.exclude", "hosts.exclude");
        File file = new File("hosts.exclude");
        file.delete();
        file.createNewFile();
        this.startCluster(2, 1, 0, UserGroupInformation.getLoginUser(), conf);
        String hostToDecommission = this.getHostname(1);
        conf = this.mr.createJobConf(new JobConf(conf));
        FileOutputStream out = new FileOutputStream(file);
        LOG.info((Object)("Writing excluded nodes to log file " + file.toString()));
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(out));
            writer.write(hostToDecommission + "\n");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            out.close();
        }
        file.deleteOnExit();
        Configuration.addDefaultResource((String)"extra.xml");
        this.writeToFile(new File("build/test/classes/extra.xml"), "<configuration><property><name>mapred.hosts.exclude</name><value>hosts.exclude</value></property></configuration>");
        AdminOperationsProtocol client = this.getClient(conf, this.owner);
        try {
            client.refreshNodes();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        TestNodeRefresh.assertEquals((String)"Tracker is not lost upon host decommissioning", (int)1, (int)this.jt.getClusterStatus(false).getTaskTrackers());
        TestNodeRefresh.assertEquals((String)"Excluded node count is incorrect", (int)1, (int)this.jt.getClusterStatus(false).getNumExcludedNodes());
        for (TaskTrackerStatus status : this.jt.taskTrackers()) {
            TestNodeRefresh.assertFalse((String)"Tracker from decommissioned host still exist", (boolean)status.getHost().equals(hostToDecommission));
        }
        this.stopCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMRRefreshRecommissioning() throws IOException {
        String hostToInclude = this.getHostname(1);
        Configuration conf = new Configuration();
        File file = new File("hosts.exclude");
        file.delete();
        FileOutputStream out = new FileOutputStream(file);
        LOG.info((Object)("Writing excluded nodes to log file " + file.toString()));
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(out));
            writer.write(hostToInclude + "\n");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            out.close();
        }
        this.startCluster(2, 1, 1, UserGroupInformation.getLoginUser(), conf);
        file.delete();
        out = new FileOutputStream(file);
        LOG.info((Object)("Clearing hosts.exclude file " + file.toString()));
        writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(out));
            writer.write("\n");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            out.close();
        }
        file.deleteOnExit();
        conf = this.mr.createJobConf(new JobConf(conf));
        AdminOperationsProtocol client = this.getClient(conf, this.owner);
        try {
            client.refreshNodes();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.mr.startTaskTracker(hostToInclude, null, 2, 1);
        while (this.jt.taskTrackers().size() < 2) {
            UtilsForTests.waitFor(100L);
        }
        TestNodeRefresh.assertEquals((String)"Excluded node count is incorrect", (int)0, (int)this.jt.getClusterStatus(false).getNumExcludedNodes());
        boolean seen = false;
        for (TaskTrackerStatus status : this.jt.taskTrackers()) {
            if (!status.getHost().equals(hostToInclude)) continue;
            seen = true;
            break;
        }
        TestNodeRefresh.assertTrue((String)"Tracker from excluded host doesnt exist", (boolean)seen);
        this.stopCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(File file, String contents) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(out));
            writer.write(contents);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            out.close();
        }
    }
}

