/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MRCaching;
import org.apache.hadoop.mapred.MiniMRCluster;

public class TestMiniMRDFSCaching
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithDFS() throws IOException {
        MiniMRCluster mr = null;
        MiniDFSCluster dfs = null;
        DistributedFileSystem fileSys = null;
        try {
            JobConf conf = new JobConf();
            dfs = new MiniDFSCluster((Configuration)conf, 1, true, null);
            fileSys = dfs.getFileSystem();
            mr = new MiniMRCluster(2, fileSys.getName(), 4);
            MRCaching.setupCache("/cachedir", (FileSystem)fileSys);
            MRCaching.TestResult ret = MRCaching.launchMRCache("/testing/wc/input", "/testing/wc/output", "/cachedir", mr.createJobConf(), "The quick brown fox\nhas many silly\nred fox sox\n", false);
            TestMiniMRDFSCaching.assertTrue((String)"Archives not matching", (boolean)ret.isOutputOk);
            ret = MRCaching.launchMRCache("/testing/wc/input", "/testing/wc/output", "/cachedir", mr.createJobConf(), "The quick brown fox\nhas many silly\nred fox sox\n", true);
            TestMiniMRDFSCaching.assertTrue((String)"Archives not matching", (boolean)ret.isOutputOk);
        }
        finally {
            if (fileSys != null) {
                fileSys.close();
            }
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    public static void main(String[] argv) throws Exception {
        TestMiniMRDFSCaching td = new TestMiniMRDFSCaching();
        td.testWithDFS();
    }
}

