/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.BindException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.TestHDFSServerPorts;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.TaskTracker;

public class TestMRServerPorts
extends TestCase {
    private static final String NAME_NODE_HOST = "localhost:";
    private static final String NAME_NODE_HTTP_HOST = "0.0.0.0:";
    TestHDFSServerPorts hdfs = new TestHDFSServerPorts();

    private JobTracker startJobTracker(JobConf conf, JTRunner runner) throws IOException {
        conf.set("mapred.job.tracker", "localhost:0");
        conf.set("mapred.job.tracker.http.address", "0.0.0.0:0");
        JobTracker jt = null;
        try {
            jt = JobTracker.startTracker((JobConf)conf);
            runner.setJobTracker(jt);
            runner.start();
            conf.set("mapred.job.tracker", NAME_NODE_HOST + jt.getTrackerPort());
            conf.set("mapred.job.tracker.http.address", NAME_NODE_HTTP_HOST + jt.getInfoPort());
        }
        catch (InterruptedException e) {
            throw new IOException(e.getLocalizedMessage());
        }
        return jt;
    }

    private void setDataNodePorts(Configuration conf) {
        conf.set("dfs.datanode.address", "localhost:0");
        conf.set("dfs.datanode.http.address", "0.0.0.0:0");
        conf.set("dfs.datanode.ipc.address", "localhost:0");
    }

    private boolean canStartJobTracker(JobConf conf) throws IOException, InterruptedException {
        JobTracker jt = null;
        try {
            jt = JobTracker.startTracker((JobConf)conf);
        }
        catch (IOException e) {
            if (e instanceof BindException) {
                return false;
            }
            throw e;
        }
        jt.fs.close();
        jt.stopTracker();
        return true;
    }

    private boolean canStartTaskTracker(JobConf conf) throws IOException, InterruptedException {
        TaskTracker tt = null;
        try {
            tt = new TaskTracker(conf);
        }
        catch (IOException e) {
            if (e instanceof BindException) {
                return false;
            }
            throw e;
        }
        tt.shutdown();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJobTrackerPorts() throws Exception {
        NameNode nn = null;
        DataNode dn = null;
        try {
            nn = this.hdfs.startNameNode();
            this.setDataNodePorts(this.hdfs.getConfig());
            dn = this.hdfs.startDataNode(1, this.hdfs.getConfig());
            JobConf conf2 = new JobConf(this.hdfs.getConfig());
            conf2.set("mapred.job.tracker", FileSystem.getDefaultUri((Configuration)this.hdfs.getConfig()).toString());
            conf2.set("mapred.job.tracker.http.address", "0.0.0.0:0");
            boolean started = this.canStartJobTracker(conf2);
            TestMRServerPorts.assertFalse((boolean)started);
            conf2.set("mapred.job.tracker", "localhost:0");
            conf2.set("mapred.job.tracker.http.address", this.hdfs.getConfig().get("dfs.http.address"));
            started = this.canStartJobTracker(conf2);
            TestMRServerPorts.assertFalse((boolean)started);
            conf2.set("mapred.job.tracker", "localhost:0");
            conf2.set("mapred.job.tracker.http.address", "0.0.0.0:0");
            started = this.canStartJobTracker(conf2);
            TestMRServerPorts.assertTrue((boolean)started);
        }
        catch (Throwable throwable) {
            this.hdfs.stopDataNode(dn);
            this.hdfs.stopNameNode(nn);
            throw throwable;
        }
        this.hdfs.stopDataNode(dn);
        this.hdfs.stopNameNode(nn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testTaskTrackerPorts() throws Exception {
        DataNode dn;
        NameNode nn;
        block3: {
            nn = null;
            dn = null;
            JobTracker jt = null;
            Thread runner = null;
            try {
                nn = this.hdfs.startNameNode();
                this.setDataNodePorts(this.hdfs.getConfig());
                dn = this.hdfs.startDataNode(2, this.hdfs.getConfig());
                JobConf conf2 = new JobConf(this.hdfs.getConfig());
                runner = new JTRunner();
                jt = this.startJobTracker(conf2, (JTRunner)runner);
                conf2.set("mapred.task.tracker.report.address", FileSystem.getDefaultUri((Configuration)this.hdfs.getConfig()).toString());
                conf2.set("mapred.task.tracker.http.address", "0.0.0.0:0");
                boolean started = this.canStartTaskTracker(conf2);
                TestMRServerPorts.assertFalse((boolean)started);
                conf2.set("mapred.task.tracker.report.address", "localhost:0");
                conf2.set("mapred.task.tracker.http.address", this.hdfs.getConfig().get("dfs.http.address"));
                started = this.canStartTaskTracker(conf2);
                TestMRServerPorts.assertFalse((boolean)started);
                conf2.set("mapred.task.tracker.report.address", "localhost:0");
                conf2.set("mapred.task.tracker.http.address", "0.0.0.0:0");
                started = this.canStartTaskTracker(conf2);
                TestMRServerPorts.assertTrue((boolean)started);
                if (jt == null) break block3;
            }
            catch (Throwable throwable) {
                if (jt != null) {
                    jt.fs.close();
                    jt.stopTracker();
                    runner.interrupt();
                    runner.join();
                }
                this.hdfs.stopDataNode(dn);
                this.hdfs.stopNameNode(nn);
                throw throwable;
            }
            jt.fs.close();
            jt.stopTracker();
            runner.interrupt();
            runner.join();
        }
        this.hdfs.stopDataNode(dn);
        this.hdfs.stopNameNode(nn);
    }

    private static class JTRunner
    extends Thread {
        JobTracker jt;

        private JTRunner() {
        }

        void setJobTracker(JobTracker jt) {
            this.jt = jt;
        }

        @Override
        public void run() {
            if (this.jt != null) {
                try {
                    this.jt.offerService();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

