/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.ClusterMapReduceTestCase;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestJobTrackerXmlJsp
extends ClusterMapReduceTestCase {
    private static final Log LOG = LogFactory.getLog(TestJobTrackerXmlJsp.class);

    public void testXmlWellFormed() throws IOException, ParserConfigurationException, SAXException {
        String l;
        MiniMRCluster cluster = this.getMRCluster();
        int infoPort = cluster.getJobTrackerRunner().getJobTrackerInfoPort();
        String xmlJspUrl = "http://localhost:" + infoPort + "/jobtracker.jspx";
        LOG.info((Object)("Retrieving XML from URL: " + xmlJspUrl));
        HttpURLConnection connection = (HttpURLConnection)new URL("http://localhost:" + infoPort + "/jobtracker.jspx").openConnection();
        connection.setRequestMethod("GET");
        connection.connect();
        InputStream stream = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        while ((l = br.readLine()) != null) {
            System.out.println(l);
        }
        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = parser.parse(xmlJspUrl);
        LOG.info((Object)"Document received and parsed.");
        NodeList clusterNodes = doc.getElementsByTagName("cluster");
        TestJobTrackerXmlJsp.assertEquals((String)"There should be exactly 1 <cluster> element", (int)1, (int)clusterNodes.getLength());
    }
}

