/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.mapred.JobTrackerHAServiceProtocol;
import org.apache.hadoop.mapred.MiniMRHACluster;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestJobTrackerHealthCheck {
    private Configuration conf;
    private MiniMRHACluster cluster;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.cluster = new MiniMRHACluster(this.conf);
        this.cluster.getJobTrackerHaDaemon(0).makeActive();
        this.cluster.waitActive();
    }

    @After
    public void tearDown() {
        this.cluster.shutdown();
    }

    @Test(timeout=60000L)
    public void test() throws Exception {
        JobTrackerHAServiceProtocol haServiceProtocol = this.cluster.getJobTrackerHaDaemon(0).getJobTrackerHAServiceProtocol();
        haServiceProtocol.monitorHealth();
        haServiceProtocol.getJobTrackerThread().stop();
        haServiceProtocol.getJobTrackerThread().join();
        try {
            haServiceProtocol.monitorHealth();
            Assert.fail((String)"Should not have succeeded in calling monitorHealth");
        }
        catch (HealthCheckFailedException hcfe) {
            GenericTestUtils.assertExceptionContains((String)"The JobTracker thread is not running", (Throwable)hcfe);
        }
    }
}

