/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTrackerHAServiceProtocol;
import org.apache.hadoop.mapred.MiniMRHACluster;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestJobTrackerHAServiceProtocol {
    private static final Path TEST_DIR = new Path("/tmp/tst");
    private Configuration conf;
    private FileSystem fs;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        MiniMRHACluster.configureLogicalName(this.conf);
        this.conf.set("mapred.ha.jobtracker.id", "jt1");
        this.conf.set("mapred.system.dir", TEST_DIR.toString());
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.fs.delete(TEST_DIR, true);
    }

    @Test
    public void testRollSystemDirectory() throws IOException {
        JobTrackerHAServiceProtocol jt = new JobTrackerHAServiceProtocol(this.conf, null);
        JobConf jobConf = new JobConf(this.conf);
        Path sysDir = jt.rollSystemDirectory(jobConf);
        Path sysDir0 = this.sysDirPath("000000000000");
        Assert.assertEquals((Object)sysDir0.toString(), (Object)jobConf.get("mapred.system.dir"));
        Assert.assertEquals((Object)sysDir0.toString(), (Object)sysDir.toString());
        Assert.assertFalse((String)"New sys dir 0 should not exist", (boolean)this.fs.exists(sysDir0));
        this.fs.mkdirs(sysDir0);
        Assert.assertTrue((String)"New sys dir 0 should now exist", (boolean)this.fs.exists(sysDir0));
        jobConf = new JobConf(this.conf);
        sysDir = jt.rollSystemDirectory(jobConf);
        Path sysDir1 = this.sysDirPath("000000000001");
        Assert.assertEquals((Object)sysDir1.toString(), (Object)jobConf.get("mapred.system.dir"));
        Assert.assertEquals((Object)sysDir1.toString(), (Object)sysDir.toString());
        Assert.assertFalse((String)"Old sys dir 0 should no longer exist", (boolean)this.fs.exists(sysDir0));
        Assert.assertTrue((String)"New sys dir 1 should exist", (boolean)this.fs.exists(sysDir1));
        Path sysDir10 = this.sysDirPath("000000000010");
        this.fs.mkdirs(sysDir10);
        jobConf = new JobConf(this.conf);
        sysDir = jt.rollSystemDirectory(jobConf);
        Path sysDir11 = this.sysDirPath("000000000011");
        Assert.assertEquals((Object)sysDir11.toString(), (Object)jobConf.get("mapred.system.dir"));
        Assert.assertEquals((Object)sysDir11.toString(), (Object)sysDir.toString());
        Assert.assertTrue((String)"Old sys dir 1 should still exist", (boolean)this.fs.exists(sysDir1));
        Assert.assertFalse((String)"Old sys dir 10 should no longer exist", (boolean)this.fs.exists(sysDir10));
        Assert.assertTrue((String)"New sys dir 11 should exist", (boolean)this.fs.exists(sysDir11));
        this.fs.mkdirs(new Path(TEST_DIR, "zzz"));
        jobConf = new JobConf(this.conf);
        sysDir = jt.rollSystemDirectory(jobConf);
        Path sysDir12 = this.sysDirPath("000000000012");
        Assert.assertEquals((Object)sysDir12.toString(), (Object)jobConf.get("mapred.system.dir"));
        Assert.assertEquals((Object)sysDir12.toString(), (Object)sysDir.toString());
        Assert.assertFalse((String)"Old sys dir 11 should no longer exist", (boolean)this.fs.exists(sysDir11));
        Assert.assertTrue((String)"New sys dir 12 should exist", (boolean)this.fs.exists(sysDir12));
    }

    private Path sysDirPath(String counter) {
        Path sysDir = new Path(TEST_DIR, "seq-" + counter);
        sysDir = this.fs.makeQualified(sysDir);
        return sysDir;
    }
}

