/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ClusterMapReduceTestCase;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;

public class TestJobStatusPersistency
extends ClusterMapReduceTestCase {
    static final Path TEST_DIR = new Path(System.getProperty("test.build.data", "/tmp"), "job-status-persistence");

    @Override
    protected void setUp() throws Exception {
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new JobConf());
        fs.delete(TEST_DIR, true);
    }

    private JobID runJob() throws Exception {
        FSDataOutputStream os = this.getFileSystem().create(new Path(this.getInputDir(), "text.txt"));
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os);
        wr.write("hello1\n");
        wr.write("hello2\n");
        wr.write("hello3\n");
        wr.write("hello4\n");
        ((Writer)wr).close();
        JobConf conf = this.createJobConf();
        conf.setJobName("mr");
        conf.setInputFormat(TextInputFormat.class);
        conf.setMapOutputKeyClass(LongWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{this.getInputDir()});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)this.getOutputDir());
        return JobClient.runJob((JobConf)conf).getID();
    }

    public void testNonPersistency() throws Exception {
        this.startCluster(true, null);
        JobID jobId = this.runJob();
        JobClient jc = new JobClient(this.createJobConf());
        RunningJob rj = jc.getJob(jobId);
        TestJobStatusPersistency.assertNotNull((Object)rj);
        this.stopCluster();
        this.startCluster(true, null);
        jc = new JobClient(this.createJobConf());
        rj = jc.getJob(jobId);
        TestJobStatusPersistency.assertNull((Object)rj);
    }

    public void testPersistency() throws Exception {
        Properties config = new Properties();
        config.setProperty("mapred.job.tracker.persist.jobstatus.active", "true");
        config.setProperty("mapred.job.tracker.persist.jobstatus.hours", "1");
        this.startCluster(true, config);
        JobID jobId = this.runJob();
        JobClient jc = new JobClient(this.createJobConf());
        RunningJob rj0 = jc.getJob(jobId);
        TestJobStatusPersistency.assertNotNull((Object)rj0);
        boolean sucessfull0 = rj0.isSuccessful();
        String jobName0 = rj0.getJobName();
        Counters counters0 = rj0.getCounters();
        TaskCompletionEvent[] events0 = rj0.getTaskCompletionEvents(0);
        this.stopCluster();
        this.startCluster(false, config);
        jc = new JobClient(this.createJobConf());
        RunningJob rj1 = jc.getJob(jobId);
        TestJobStatusPersistency.assertNotNull((Object)rj1);
        TestJobStatusPersistency.assertEquals((boolean)sucessfull0, (boolean)rj1.isSuccessful());
        TestJobStatusPersistency.assertEquals((String)jobName0, (String)rj0.getJobName());
        TestJobStatusPersistency.assertEquals((int)counters0.size(), (int)rj1.getCounters().size());
        TaskCompletionEvent[] events1 = rj1.getTaskCompletionEvents(0);
        TestJobStatusPersistency.assertEquals((int)events0.length, (int)events1.length);
        for (int i = 0; i < events0.length; ++i) {
            TestJobStatusPersistency.assertEquals((Object)events0[i].getTaskAttemptId(), (Object)events1[i].getTaskAttemptId());
            TestJobStatusPersistency.assertEquals((Object)events0[i].getTaskStatus(), (Object)events1[i].getTaskStatus());
        }
    }

    public void testLocalPersistency() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new JobConf());
        Properties config = new Properties();
        config.setProperty("mapred.job.tracker.persist.jobstatus.active", "true");
        config.setProperty("mapred.job.tracker.persist.jobstatus.hours", "1");
        config.setProperty("mapred.job.tracker.persist.jobstatus.dir", fs.makeQualified(TEST_DIR).toString());
        this.startCluster(true, config);
        JobID jobId = this.runJob();
        JobClient jc = new JobClient(this.createJobConf());
        RunningJob rj = jc.getJob(jobId);
        TestJobStatusPersistency.assertNotNull((Object)rj);
        Path jobInfo = new Path(TEST_DIR, rj.getID() + ".info");
        TestJobStatusPersistency.assertTrue((String)"Missing job info from the local fs", (boolean)fs.exists(jobInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJobStoreDisablingWithInvalidPath() throws Exception {
        Object mr = null;
        Path parent = new Path(TEST_DIR, "parent");
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)new JobConf());
            if (fs.mkdirs(new Path(TEST_DIR, parent))) {
                if (!new File(parent.toUri().getPath()).setWritable(false, false)) {
                    TestJobStatusPersistency.fail((String)"Cannot chmod parent!");
                }
            } else {
                TestJobStatusPersistency.fail((String)"Cannot create parent dir!");
            }
            JobConf config = new JobConf();
            config.set("mapred.job.tracker.persist.jobstatus.active", "true");
            config.set("mapred.job.tracker.persist.jobstatus.hours", "1");
            config.set("mapred.job.tracker.persist.jobstatus.dir", new Path(parent, "child").toUri().getPath());
            boolean started = true;
            JobConf conf = MiniMRCluster.configureJobConf(config, "file:///", 0, 0, null);
            try {
                JobTracker jt = JobTracker.startTracker((JobConf)conf);
            }
            catch (IOException ex) {
                started = false;
            }
        }
        finally {
            new File(parent.toUri().getPath()).setWritable(true, false);
        }
    }
}

