/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobInProgressListener;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobQueueTaskScheduler;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskScheduler;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerManager;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.server.jobtracker.TaskTracker;
import org.apache.hadoop.mapreduce.split.JobSplit;

public class TestJobQueueTaskScheduler
extends TestCase {
    private static int jobCounter;
    private static int taskCounter;
    protected JobConf jobConf;
    protected TaskScheduler scheduler;
    private FakeTaskTrackerManager taskTrackerManager;

    static void resetCounters() {
        jobCounter = 0;
        taskCounter = 0;
    }

    protected void setUp() throws Exception {
        TestJobQueueTaskScheduler.resetCounters();
        this.jobConf = new JobConf();
        this.jobConf.setNumMapTasks(10);
        this.jobConf.setNumReduceTasks(10);
        this.taskTrackerManager = new FakeTaskTrackerManager();
        this.scheduler = this.createTaskScheduler();
        this.scheduler.setConf((Configuration)this.jobConf);
        this.scheduler.setTaskTrackerManager((TaskTrackerManager)this.taskTrackerManager);
        this.scheduler.start();
    }

    protected void tearDown() throws Exception {
        if (this.scheduler != null) {
            this.scheduler.terminate();
        }
    }

    protected TaskScheduler createTaskScheduler() {
        return new JobQueueTaskScheduler();
    }

    static void submitJobs(FakeTaskTrackerManager taskTrackerManager, JobConf jobConf, int numJobs, int state) throws IOException {
        for (int i = 0; i < numJobs; ++i) {
            FakeJobInProgress job = new FakeJobInProgress(jobConf, taskTrackerManager, UtilsForTests.getJobTracker());
            job.getStatus().setRunState(state);
            taskTrackerManager.submitJob(job);
        }
    }

    public void testTaskNotAssignedWhenNoJobsArePresent() throws IOException {
        TestJobQueueTaskScheduler.assertEquals((int)0, (int)this.scheduler.assignTasks(TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt1")).size());
    }

    public void testNonRunningJobsAreIgnored() throws IOException {
        TestJobQueueTaskScheduler.submitJobs(this.taskTrackerManager, this.jobConf, 1, 4);
        TestJobQueueTaskScheduler.submitJobs(this.taskTrackerManager, this.jobConf, 1, 2);
        TestJobQueueTaskScheduler.submitJobs(this.taskTrackerManager, this.jobConf, 1, 3);
        TestJobQueueTaskScheduler.submitJobs(this.taskTrackerManager, this.jobConf, 1, 5);
        TestJobQueueTaskScheduler.assertEquals((int)0, (int)this.scheduler.assignTasks(TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt1")).size());
    }

    public void testDefaultTaskAssignment() throws IOException {
        TestJobQueueTaskScheduler.submitJobs(this.taskTrackerManager, this.jobConf, 2, 1);
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt1"), new String[]{"attempt_test_0001_m_000001_0 on tt1", "attempt_test_0001_m_000002_0 on tt1", "attempt_test_0001_r_000003_0 on tt1"});
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt1"), new String[]{"attempt_test_0001_r_000004_0 on tt1"});
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt1"), new String[0]);
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt2"), new String[]{"attempt_test_0001_m_000005_0 on tt2", "attempt_test_0001_m_000006_0 on tt2", "attempt_test_0001_r_000007_0 on tt2"});
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt2"), new String[]{"attempt_test_0001_r_000008_0 on tt2"});
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt2"), new String[0]);
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt1"), new String[0]);
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt2"), new String[0]);
    }

    static TaskTracker tracker(FakeTaskTrackerManager taskTrackerManager, String taskTrackerName) {
        return taskTrackerManager.getTaskTracker(taskTrackerName);
    }

    static void checkAssignment(TaskScheduler scheduler, TaskTracker taskTracker, String[] expectedTaskStrings) throws IOException {
        List tasks = scheduler.assignTasks(taskTracker);
        TestJobQueueTaskScheduler.assertNotNull((Object)tasks);
        TestJobQueueTaskScheduler.assertEquals((int)expectedTaskStrings.length, (int)tasks.size());
        for (int i = 0; i < expectedTaskStrings.length; ++i) {
            TestJobQueueTaskScheduler.assertEquals((String)expectedTaskStrings[i], (String)((Task)tasks.get(i)).toString());
        }
    }

    static class FakeTaskTrackerManager
    implements TaskTrackerManager {
        int maps = 0;
        int reduces = 0;
        int maxMapTasksPerTracker = 2;
        int maxReduceTasksPerTracker = 2;
        List<JobInProgressListener> listeners = new ArrayList<JobInProgressListener>();
        QueueManager queueManager;
        private Map<String, TaskTracker> trackers = new HashMap<String, TaskTracker>();

        public FakeTaskTrackerManager() {
            JobConf conf = new JobConf();
            this.queueManager = new QueueManager((Configuration)conf);
            TaskTracker tt1 = new TaskTracker("tt1");
            tt1.setStatus(new TaskTrackerStatus("tt1", "http", "tt1.host", 1, new ArrayList(), 0, 0, this.maxMapTasksPerTracker, this.maxReduceTasksPerTracker));
            this.trackers.put("tt1", tt1);
            TaskTracker tt2 = new TaskTracker("tt2");
            tt2.setStatus(new TaskTrackerStatus("tt2", "http", "tt2.host", 2, new ArrayList(), 0, 0, this.maxMapTasksPerTracker, this.maxReduceTasksPerTracker));
            this.trackers.put("tt2", tt2);
        }

        public ClusterStatus getClusterStatus() {
            int numTrackers = this.trackers.size();
            return new ClusterStatus(numTrackers, 0, JobTracker.TASKTRACKER_EXPIRY_INTERVAL, this.maps, this.reduces, numTrackers * this.maxMapTasksPerTracker, numTrackers * this.maxReduceTasksPerTracker, Cluster.JobTrackerStatus.RUNNING);
        }

        public int getNumberOfUniqueHosts() {
            return 0;
        }

        public Collection<TaskTrackerStatus> taskTrackers() {
            ArrayList<TaskTrackerStatus> taskTrackers = new ArrayList<TaskTrackerStatus>();
            for (TaskTracker tt : this.trackers.values()) {
                taskTrackers.add(tt.getStatus());
            }
            return taskTrackers;
        }

        public void addJobInProgressListener(JobInProgressListener listener) {
            this.listeners.add(listener);
        }

        public void removeJobInProgressListener(JobInProgressListener listener) {
            this.listeners.remove(listener);
        }

        public QueueManager getQueueManager() {
            return this.queueManager;
        }

        public int getNextHeartbeatInterval() {
            return 300;
        }

        public void killJob(JobID jobid) {
        }

        public JobInProgress getJob(JobID jobid) {
            return null;
        }

        public void initJob(JobInProgress job) {
        }

        public void failJob(JobInProgress job) {
        }

        public boolean killTask(TaskAttemptID attemptId, boolean shouldFail) {
            return true;
        }

        public void submitJob(JobInProgress job) throws IOException {
            for (JobInProgressListener listener : this.listeners) {
                listener.jobAdded(job);
            }
        }

        public TaskTracker getTaskTracker(String trackerID) {
            return this.trackers.get(trackerID);
        }

        public void update(String taskTrackerName, final Task t) {
            if (t.isMapTask()) {
                ++this.maps;
            } else {
                ++this.reduces;
            }
            TaskStatus status = new TaskStatus(){

                public boolean getIsMap() {
                    return t.isMapTask();
                }
            };
            status.setRunState(TaskStatus.State.RUNNING);
            this.trackers.get(taskTrackerName).getStatus().getTaskReports().add(status);
        }
    }

    static class FakeJobInProgress
    extends JobInProgress {
        private FakeTaskTrackerManager taskTrackerManager;

        public FakeJobInProgress(JobConf jobConf, FakeTaskTrackerManager taskTrackerManager, JobTracker jt) throws IOException {
            super(new JobID("test", ++jobCounter), jobConf, jt);
            this.taskTrackerManager = taskTrackerManager;
            this.startTime = System.currentTimeMillis();
            this.status.setJobPriority(JobPriority.NORMAL);
            this.status.setStartTime(this.startTime);
        }

        public synchronized void initTasks() throws IOException {
        }

        public Task obtainNewLocalMapTask(TaskTrackerStatus tts, int clusterSize, int ignored) throws IOException {
            return this.obtainNewMapTask(tts, clusterSize, ignored);
        }

        public Task obtainNewNonLocalMapTask(TaskTrackerStatus tts, int clusterSize, int ignored) throws IOException {
            return this.obtainNewMapTask(tts, clusterSize, ignored);
        }

        public Task obtainNewMapTask(final TaskTrackerStatus tts, int clusterSize, int ignored) throws IOException {
            TaskAttemptID attemptId = this.getTaskAttemptID(true);
            MapTask task = new MapTask("", attemptId, 0, new JobSplit.TaskSplitIndex(), 1){

                public String toString() {
                    return String.format("%s on %s", this.getTaskID(), tts.getTrackerName());
                }
            };
            this.taskTrackerManager.update(tts.getTrackerName(), (Task)task);
            ++this.runningMapTasks;
            return task;
        }

        public Task obtainNewReduceTask(final TaskTrackerStatus tts, int clusterSize, int ignored) throws IOException {
            TaskAttemptID attemptId = this.getTaskAttemptID(false);
            ReduceTask task = new ReduceTask("", attemptId, 0, 10, 1){

                public String toString() {
                    return String.format("%s on %s", this.getTaskID(), tts.getTrackerName());
                }
            };
            this.taskTrackerManager.update(tts.getTrackerName(), (Task)task);
            ++this.runningReduceTasks;
            return task;
        }

        private TaskAttemptID getTaskAttemptID(boolean isMap) {
            JobID jobId = this.getJobID();
            return new TaskAttemptID(jobId.getJtIdentifier(), jobId.getId(), isMap, ++taskCounter, 0);
        }
    }
}

