/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.SleepJob;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ha.FailoverController;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.TestNodeFencer;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.JobTrackerHADaemon;
import org.apache.hadoop.mapred.JobTrackerHAServiceTarget;
import org.apache.hadoop.mapred.MiniMRHACluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.util.ExitUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestHAStateTransitions {
    private static final Log LOG = LogFactory.getLog(TestHAStateTransitions.class);
    private static final Path TEST_DIR = new Path("/tmp/tst");
    private static final HAServiceProtocol.StateChangeRequestInfo REQ_INFO = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER_FORCED);
    private MiniMRHACluster cluster;
    private JobTrackerHADaemon jt1;
    private JobTrackerHADaemon jt2;
    private JobTrackerHAServiceTarget target1;
    private JobTrackerHAServiceTarget target2;
    private Configuration conf;

    private void startCluster() throws Exception {
        this.startCluster(new Configuration());
    }

    private void startCluster(Configuration conf) throws Exception {
        FileUtil.fullyDelete((File)new File("/tmp/tst"));
        ExitUtil.disableSystemExit();
        this.conf = conf;
        conf.set("mapred.ha.fencing.methods", TestNodeFencer.AlwaysSucceedFencer.class.getName());
        this.cluster = new MiniMRHACluster(conf);
        this.cluster.getJobTrackerHaDaemon(0).makeActive();
        this.cluster.startTaskTracker(0, 1);
        this.cluster.waitActive();
        this.jt1 = this.cluster.getJobTrackerHaDaemon(0);
        this.jt2 = this.cluster.getJobTrackerHaDaemon(1);
        this.target1 = new JobTrackerHAServiceTarget(this.jt1.getConf());
        this.target2 = new JobTrackerHAServiceTarget(this.jt2.getConf());
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test(timeout=60000L)
    public void testClientFailover() throws Exception {
        LOG.info((Object)"Running testClientFailover");
        this.startCluster();
        JobClient jc = new JobClient(this.conf);
        Assert.assertEquals((String)"client sees jt running", (Object)Cluster.JobTrackerStatus.RUNNING, (Object)jc.getClusterStatus().getJobTrackerStatus());
        FailoverController fc = new FailoverController(this.conf, HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        fc.failover((HAServiceTarget)this.target1, (HAServiceTarget)this.target2, false, false);
        this.cluster.waitActive();
        Assert.assertEquals((String)"jt2 running", (Object)Cluster.JobTrackerStatus.RUNNING, (Object)this.jt2.getJobTracker().getClusterStatus().getJobTrackerStatus());
        Assert.assertNull((String)"jt1 not running", (Object)this.jt1.getJobTracker());
        Assert.assertEquals((String)"client still sees jt running", (Object)Cluster.JobTrackerStatus.RUNNING, (Object)jc.getClusterStatus().getJobTrackerStatus());
    }

    @Test(timeout=60000L)
    public void testFailoverWhileRunningJob() throws Exception {
        LOG.info((Object)"Running testFailoverWhileRunningJob");
        this.startCluster();
        JobConf job1 = new JobConf(this.conf);
        String signalFile = new Path(TEST_DIR, "signal").toString();
        UtilsForTests.configureWaitingJobConf(job1, new Path(TEST_DIR, "input"), new Path(TEST_DIR, "output3"), 2, 0, "test-resubmission", signalFile, signalFile);
        JobClient jc = new JobClient(job1);
        RunningJob rJob1 = jc.submitJob(job1);
        while (rJob1.mapProgress() < 0.5f) {
            LOG.info((Object)("Waiting for job " + rJob1.getID() + " to be 50% done: " + rJob1.mapProgress()));
            UtilsForTests.waitFor(500L);
        }
        LOG.info((Object)("Waiting for job " + rJob1.getID() + " to be 50% done: " + rJob1.mapProgress()));
        FailoverController fc = new FailoverController(this.conf, HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        fc.failover((HAServiceTarget)this.target1, (HAServiceTarget)this.target2, false, false);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        fs.create(new Path(TEST_DIR, "signal"));
        while (!rJob1.isComplete()) {
            LOG.info((Object)("Waiting for job " + rJob1.getID() + " to be successful: " + rJob1.mapProgress()));
            UtilsForTests.waitFor(500L);
        }
        Assert.assertTrue((String)"Job should be successful", (boolean)rJob1.isSuccessful());
    }

    @Test(timeout=60000L)
    public void testTransitionToCurrentStateIsANop() throws Exception {
        LOG.info((Object)"Running testTransitionToCurrentStateIsANop");
        this.startCluster();
        JobTracker existingJt = this.jt1.getJobTracker();
        this.jt1.getJobTrackerHAServiceProtocol().transitionToActive(REQ_INFO);
        Assert.assertSame((String)"Should not create a new JobTracker", (Object)existingJt, (Object)this.jt1.getJobTracker());
        this.jt1.getJobTrackerHAServiceProtocol().transitionToStandby(REQ_INFO);
        this.jt1.getJobTrackerHAServiceProtocol().transitionToStandby(REQ_INFO);
    }

    @Test(timeout=60000L)
    public void testSecondActiveFencesFirst() throws Exception {
        LOG.info((Object)"Running testSecondActiveFencesFirst");
        this.startCluster();
        JobConf job1 = new JobConf(this.conf);
        String signalFile = new Path(TEST_DIR, "signal").toString();
        UtilsForTests.configureWaitingJobConf(job1, new Path(TEST_DIR, "input"), new Path(TEST_DIR, "output3"), 2, 0, "test-resubmission", signalFile, signalFile);
        JobClient jc = new JobClient(job1);
        RunningJob rJob1 = jc.submitJob(job1);
        while (rJob1.mapProgress() < 0.5f) {
            LOG.info((Object)("Waiting for job " + rJob1.getID() + " to be 50% done: " + rJob1.mapProgress()));
            UtilsForTests.waitFor(500L);
        }
        LOG.info((Object)("Waiting for job " + rJob1.getID() + " to be 50% done: " + rJob1.mapProgress()));
        this.jt2.getJobTrackerHAServiceProtocol().transitionToActive(REQ_INFO);
        UtilsForTests.waitFor(1500L);
        Assert.assertTrue((boolean)ExitUtil.terminateCalled());
        this.jt1.getJobTracker().close();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        fs.create(new Path(TEST_DIR, "signal"));
        while (!rJob1.isComplete()) {
            LOG.info((Object)("Waiting for job " + rJob1.getID() + " to be successful: " + rJob1.mapProgress()));
            UtilsForTests.waitFor(500L);
        }
        Assert.assertTrue((String)"Job should be successful", (boolean)rJob1.isSuccessful());
    }

    @Test(timeout=60000L)
    public void testSecondActiveCausesFirstToRejectJob() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("mapred.ha.jobtracker.active-check.millis", Long.MAX_VALUE);
        this.startCluster(conf);
        conf.set("mapred.job.tracker", this.jt1.getJobTracker().getConf().get("mapred.job.tracker"));
        SleepJob job = new SleepJob();
        job.setConf(conf);
        Assert.assertEquals((String)"Job succeeded", (long)0L, (long)job.run(1, 0, 1L, 1, 1L, 1));
        this.jt2.getJobTrackerHAServiceProtocol().transitionToActive(REQ_INFO);
        job = new SleepJob();
        job.setConf(conf);
        JobConf jobConf = job.setupJobConf(1, 0, 1L, 1, 1L, 1);
        JobClient jc = new JobClient(jobConf);
        try {
            jc.submitJob(jobConf);
            Assert.fail((String)"Job submission should fail");
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

