/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.CleanupQueue;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Test;

public class TestCleanupQueue {
    @Test(timeout=2000L)
    public void testCleanupQueueClosesFilesystem() throws IOException, InterruptedException, NoSuchFieldException, IllegalAccessException {
        Configuration conf = new Configuration();
        File file = new File("afile.txt");
        file.createNewFile();
        Path path = new Path(file.getAbsoluteFile().toURI());
        FileSystem.get((Configuration)conf);
        Assert.assertEquals((int)1, (int)this.getFileSystemCacheSize());
        CleanupQueue cleanupQueue = new CleanupQueue();
        CleanupQueue.PathDeletionContext context = new CleanupQueue.PathDeletionContext(path, conf, UserGroupInformation.getLoginUser(), null, null);
        cleanupQueue.addToQueue(new CleanupQueue.PathDeletionContext[]{context});
        while (this.getFileSystemCacheSize() > 0) {
            Thread.sleep(100L);
        }
        file.createNewFile();
        FileSystem.get((Configuration)conf);
        Assert.assertEquals((int)1, (int)this.getFileSystemCacheSize());
        context = new CleanupQueue.PathDeletionContext(path, conf);
        cleanupQueue.addToQueue(new CleanupQueue.PathDeletionContext[]{context});
        while (file.exists()) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((int)1, (int)this.getFileSystemCacheSize());
    }

    private int getFileSystemCacheSize() throws NoSuchFieldException, IllegalAccessException {
        Field f = FileSystem.class.getDeclaredField("CACHE");
        f.setAccessible(true);
        Object cache = f.get(FileSystem.class);
        f = cache.getClass().getDeclaredField("map");
        f.setAccessible(true);
        Map map = (Map)f.get(cache);
        return map.size();
    }
}

