/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.AccumulatingReducer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.IOMapperBase;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Test;

public class TestDFSIO
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(TestDFSIO.class);
    private static final int TEST_TYPE_READ = 0;
    private static final int TEST_TYPE_WRITE = 1;
    private static final int TEST_TYPE_CLEANUP = 2;
    private static final int TEST_TYPE_APPEND = 3;
    private static final int DEFAULT_BUFFER_SIZE = 1000000;
    private static final String BASE_FILE_NAME = "test_io_";
    private static final String DEFAULT_RES_FILE_NAME = "TestDFSIO_results.log";
    private static final long MEGA = ByteMultiple.MB.value();
    private static final String USAGE = "Usage: " + TestDFSIO.class.getSimpleName() + " [genericOptions]" + " -read | -write | -append | -clean [-nrFiles N]" + " [-fileSize Size[B|KB|MB|GB|TB]]" + " [-resFile resultFileName] [-bufferSize Bytes]" + " [-rootDir]";
    private Configuration config = new Configuration();

    private static String getBaseDir(Configuration conf) {
        return conf.get("test.build.data", "/benchmarks/TestDFSIO");
    }

    private static Path getControlDir(Configuration conf) {
        return new Path(TestDFSIO.getBaseDir(conf), "io_control");
    }

    private static Path getWriteDir(Configuration conf) {
        return new Path(TestDFSIO.getBaseDir(conf), "io_write");
    }

    private static Path getReadDir(Configuration conf) {
        return new Path(TestDFSIO.getBaseDir(conf), "io_read");
    }

    private static Path getAppendDir(Configuration conf) {
        return new Path(TestDFSIO.getBaseDir(conf), "io_append");
    }

    private static Path getDataDir(Configuration conf) {
        return new Path(TestDFSIO.getBaseDir(conf), "io_data");
    }

    @Test
    public void testIOs() throws Exception {
        TestDFSIO bench = new TestDFSIO();
        bench.testIOs(1, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIOs(int fileSize, int nrFiles) throws IOException {
        this.config.setBoolean("dfs.support.append", true);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster(this.config, 2, true, null);
            DistributedFileSystem fs = cluster.getFileSystem();
            this.createControlFile((FileSystem)fs, fileSize, nrFiles);
            long tStart = System.currentTimeMillis();
            this.writeTest((FileSystem)fs);
            long execTime = System.currentTimeMillis() - tStart;
            this.analyzeResult((FileSystem)fs, 1, execTime, DEFAULT_RES_FILE_NAME);
            tStart = System.currentTimeMillis();
            this.readTest((FileSystem)fs);
            execTime = System.currentTimeMillis() - tStart;
            this.analyzeResult((FileSystem)fs, 0, execTime, DEFAULT_RES_FILE_NAME);
            tStart = System.currentTimeMillis();
            this.appendTest((FileSystem)fs);
            execTime = System.currentTimeMillis() - tStart;
            this.analyzeResult((FileSystem)fs, 3, execTime, DEFAULT_RES_FILE_NAME);
            this.cleanup((FileSystem)fs);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void createControlFile(FileSystem fs, long fileSize, int nrFiles) throws IOException {
        LOG.info((Object)("creating control file: " + fileSize + " bytes, " + nrFiles + " files"));
        Path controlDir = TestDFSIO.getControlDir(this.config);
        fs.delete(controlDir, true);
        for (int i = 0; i < nrFiles; ++i) {
            String name = TestDFSIO.getFileName(i);
            Path controlFile = new Path(controlDir, "in_file_" + name);
            SequenceFile.Writer writer = null;
            try {
                writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.config, (Path)controlFile, Text.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
                writer.append((Writable)new Text(name), (Writable)new LongWritable(fileSize));
                continue;
            }
            catch (Exception e) {
                throw new IOException(e.getLocalizedMessage());
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                writer = null;
            }
        }
        LOG.info((Object)("created control files for: " + nrFiles + " files"));
    }

    private static String getFileName(int fIdx) {
        return BASE_FILE_NAME + Integer.toString(fIdx);
    }

    private void writeTest(FileSystem fs) throws IOException {
        Path writeDir = TestDFSIO.getWriteDir(this.config);
        fs.delete(TestDFSIO.getDataDir(this.config), true);
        fs.delete(writeDir, true);
        this.runIOTest(WriteMapper.class, writeDir);
    }

    private void runIOTest(Class<? extends Mapper<Text, LongWritable, Text, Text>> mapperClass, Path outputDir) throws IOException {
        JobConf job = new JobConf(this.config, TestDFSIO.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{TestDFSIO.getControlDir(this.config)});
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(mapperClass);
        job.setReducerClass(AccumulatingReducer.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputDir);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(1);
        JobClient.runJob((JobConf)job);
    }

    private void appendTest(FileSystem fs) throws IOException {
        Path appendDir = TestDFSIO.getAppendDir(this.config);
        fs.delete(appendDir, true);
        this.runIOTest(AppendMapper.class, appendDir);
    }

    private void readTest(FileSystem fs) throws IOException {
        Path readDir = TestDFSIO.getReadDir(this.config);
        fs.delete(readDir, true);
        this.runIOTest(ReadMapper.class, readDir);
    }

    private void sequentialTest(FileSystem fs, int testType, long fileSize, int nrFiles) throws Exception {
        IOStatMapper ioer = null;
        if (testType == 0) {
            ioer = new ReadMapper();
        } else if (testType == 1) {
            ioer = new WriteMapper();
        } else if (testType == 3) {
            ioer = new AppendMapper();
        } else {
            return;
        }
        for (int i = 0; i < nrFiles; ++i) {
            ioer.doIO(Reporter.NULL, BASE_FILE_NAME + Integer.toString(i), MEGA * fileSize);
        }
    }

    public static void main(String[] args) throws Exception {
        TestDFSIO bench = new TestDFSIO();
        int res = -1;
        try {
            res = ToolRunner.run((Tool)bench, (String[])args);
        }
        catch (Exception e) {
            System.err.print(StringUtils.stringifyException((Throwable)e));
            res = -2;
        }
        if (res == -1) {
            System.err.print(USAGE);
        }
        System.exit(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeResult(FileSystem fs, int testType, long execTime, String resFileName) throws IOException {
        Path reduceFile = testType == 1 ? new Path(TestDFSIO.getWriteDir(this.config), "part-00000") : (testType == 3 ? new Path(TestDFSIO.getAppendDir(this.config), "part-00000") : new Path(TestDFSIO.getReadDir(this.config), "part-00000"));
        long tasks = 0L;
        long size = 0L;
        long time = 0L;
        float rate = 0.0f;
        float sqrate = 0.0f;
        FilterInputStream in = null;
        BufferedReader lines = null;
        try {
            String line;
            in = new DataInputStream((InputStream)fs.open(reduceFile));
            lines = new BufferedReader(new InputStreamReader(in));
            while ((line = lines.readLine()) != null) {
                StringTokenizer tokens = new StringTokenizer(line, " \t\n\r\f%");
                String attr = tokens.nextToken();
                if (attr.endsWith(":tasks")) {
                    tasks = Long.parseLong(tokens.nextToken());
                    continue;
                }
                if (attr.endsWith(":size")) {
                    size = Long.parseLong(tokens.nextToken());
                    continue;
                }
                if (attr.endsWith(":time")) {
                    time = Long.parseLong(tokens.nextToken());
                    continue;
                }
                if (attr.endsWith(":rate")) {
                    rate = Float.parseFloat(tokens.nextToken());
                    continue;
                }
                if (!attr.endsWith(":sqrate")) continue;
                sqrate = Float.parseFloat(tokens.nextToken());
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (lines != null) {
                lines.close();
            }
        }
        double med = rate / 1000.0f / (float)tasks;
        double stdDev = Math.sqrt(Math.abs((double)(sqrate / 1000.0f / (float)tasks) - med * med));
        String[] resultLines = new String[]{"----- TestDFSIO ----- : " + (testType == 1 ? "write" : (testType == 0 ? "read" : (testType == 3 ? "append" : "unknown"))), "           Date & time: " + new Date(System.currentTimeMillis()), "       Number of files: " + tasks, "Total MBytes processed: " + TestDFSIO.toMB(size), "     Throughput mb/sec: " + (double)size * 1000.0 / (double)(time * MEGA), "Average IO rate mb/sec: " + med, " IO rate std deviation: " + stdDev, "    Test exec time sec: " + (float)execTime / 1000.0f, ""};
        try (PrintStream res = null;){
            res = new PrintStream(new FileOutputStream(new File(resFileName), true));
            for (int i = 0; i < resultLines.length; ++i) {
                LOG.info((Object)resultLines[i]);
                res.println(resultLines[i]);
            }
        }
    }

    private void cleanup(FileSystem fs) throws IOException {
        LOG.info((Object)"Cleaning up test files");
        fs.delete(new Path(TestDFSIO.getBaseDir(this.config)), true);
    }

    public int run(String[] args) throws Exception {
        int testType = 0;
        int bufferSize = 1000000;
        long fileSize = 1L * MEGA;
        int nrFiles = 1;
        String resFileName = DEFAULT_RES_FILE_NAME;
        String compressionClass = null;
        boolean isSequential = false;
        String version = TestDFSIO.class.getSimpleName() + ".0.0.6";
        LOG.info((Object)version);
        if (args.length == 0) {
            System.err.println("Missing arguments.");
            return -1;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-read")) {
                testType = 0;
                continue;
            }
            if (args[i].equals("-write")) {
                testType = 1;
                continue;
            }
            if (args[i].equals("-append")) {
                testType = 3;
                continue;
            }
            if (args[i].equals("-clean")) {
                testType = 2;
                continue;
            }
            if (args[i].startsWith("-seq")) {
                isSequential = true;
                continue;
            }
            if (args[i].startsWith("-compression")) {
                compressionClass = args[++i];
                continue;
            }
            if (args[i].equals("-nrFiles")) {
                nrFiles = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-fileSize")) {
                fileSize = TestDFSIO.parseSize(args[++i]);
                continue;
            }
            if (args[i].equals("-bufferSize")) {
                bufferSize = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-resFile")) {
                resFileName = args[++i];
                continue;
            }
            System.err.println("Illegal argument: " + args[i]);
            return -1;
        }
        LOG.info((Object)("nrFiles = " + nrFiles));
        LOG.info((Object)("fileSize (MB) = " + TestDFSIO.toMB(fileSize)));
        LOG.info((Object)("bufferSize = " + bufferSize));
        LOG.info((Object)("baseDir = " + TestDFSIO.getBaseDir(this.config)));
        if (compressionClass != null) {
            this.config.set("test.io.compression.class", compressionClass);
            LOG.info((Object)("compressionClass = " + compressionClass));
        }
        this.config.setInt("test.io.file.buffer.size", bufferSize);
        this.config.setBoolean("dfs.support.append", true);
        FileSystem fs = FileSystem.get((Configuration)this.config);
        if (isSequential) {
            long tStart = System.currentTimeMillis();
            this.sequentialTest(fs, testType, fileSize, nrFiles);
            long execTime = System.currentTimeMillis() - tStart;
            String resultLine = "Seq Test exec time sec: " + (float)execTime / 1000.0f;
            LOG.info((Object)resultLine);
            return 0;
        }
        if (testType == 2) {
            this.cleanup(fs);
            return 0;
        }
        this.createControlFile(fs, fileSize, nrFiles);
        long tStart = System.currentTimeMillis();
        if (testType == 1) {
            this.writeTest(fs);
        }
        if (testType == 0) {
            this.readTest(fs);
        }
        if (testType == 3) {
            this.appendTest(fs);
        }
        long execTime = System.currentTimeMillis() - tStart;
        this.analyzeResult(fs, testType, execTime, resFileName);
        return 0;
    }

    static long parseSize(String arg) {
        String[] args = arg.split("\\D", 2);
        assert (args.length <= 2);
        long fileSize = Long.parseLong(args[0]);
        String bytesMult = arg.substring(args[0].length());
        return fileSize * ByteMultiple.parseString(bytesMult).value();
    }

    static float toMB(long bytes) {
        return (float)bytes / (float)MEGA;
    }

    public Configuration getConf() {
        return this.config;
    }

    public void setConf(Configuration conf) {
        this.config = conf;
    }

    static {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
        Configuration.addDefaultResource((String)"mapred-default.xml");
        Configuration.addDefaultResource((String)"mapred-site.xml");
    }

    public static class ReadMapper
    extends IOStatMapper<Long> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long doIO(Reporter reporter, String name, long totalSize) throws IOException {
            FSDataInputStream in = this.fs.open(new Path(TestDFSIO.getDataDir(this.getConf()), name));
            if (this.compressionCodec != null) {
                in = this.compressionCodec.createInputStream((InputStream)in);
            }
            long actualSize = 0L;
            try {
                while (actualSize < totalSize) {
                    int curSize = in.read(this.buffer, 0, this.bufferSize);
                    if (curSize < 0) {
                        break;
                    }
                    reporter.setStatus("reading " + name + "@" + (actualSize += (long)curSize) + "/" + totalSize + " ::host = " + this.hostName);
                }
            }
            finally {
                in.close();
            }
            return actualSize;
        }
    }

    public static class AppendMapper
    extends IOStatMapper<Long> {
        public AppendMapper() {
            for (int i = 0; i < this.bufferSize; ++i) {
                this.buffer[i] = (byte)(48 + i % 50);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long doIO(Reporter reporter, String name, long totalSize) throws IOException {
            FSDataOutputStream out = this.fs.append(new Path(TestDFSIO.getDataDir(this.getConf()), name), this.bufferSize);
            if (this.compressionCodec != null) {
                out = this.compressionCodec.createOutputStream((OutputStream)out);
            }
            try {
                for (long nrRemaining = totalSize; nrRemaining > 0L; nrRemaining -= (long)this.bufferSize) {
                    int curSize = (long)this.bufferSize < nrRemaining ? this.bufferSize : (int)nrRemaining;
                    out.write(this.buffer, 0, curSize);
                    reporter.setStatus("writing " + name + "@" + (totalSize - nrRemaining) + "/" + totalSize + " ::host = " + this.hostName);
                }
            }
            finally {
                out.close();
            }
            return totalSize;
        }
    }

    public static class WriteMapper
    extends IOStatMapper<Long> {
        public WriteMapper() {
            for (int i = 0; i < this.bufferSize; ++i) {
                this.buffer[i] = (byte)(48 + i % 50);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long doIO(Reporter reporter, String name, long totalSize) throws IOException {
            FSDataOutputStream out = this.fs.create(new Path(TestDFSIO.getDataDir(this.getConf()), name), true, this.bufferSize);
            if (this.compressionCodec != null) {
                out = this.compressionCodec.createOutputStream((OutputStream)out);
            }
            try {
                for (long nrRemaining = totalSize; nrRemaining > 0L; nrRemaining -= (long)this.bufferSize) {
                    int curSize = (long)this.bufferSize < nrRemaining ? this.bufferSize : (int)nrRemaining;
                    out.write(this.buffer, 0, curSize);
                    reporter.setStatus("writing " + name + "@" + (totalSize - nrRemaining) + "/" + totalSize + " ::host = " + this.hostName);
                }
            }
            finally {
                out.close();
            }
            return totalSize;
        }
    }

    private static abstract class IOStatMapper<T>
    extends IOMapperBase<T> {
        IOStatMapper() {
        }

        @Override
        void collectStats(OutputCollector<Text, Text> output, String name, long execTime, Long objSize) throws IOException {
            long totalSize = objSize;
            float ioRateMbSec = (float)totalSize * 1000.0f / (float)(execTime * MEGA);
            LOG.info((Object)("Number of bytes processed = " + totalSize));
            LOG.info((Object)("Exec time = " + execTime));
            LOG.info((Object)("IO rate = " + ioRateMbSec));
            output.collect((Object)new Text("l:tasks"), (Object)new Text(String.valueOf(1)));
            output.collect((Object)new Text("l:size"), (Object)new Text(String.valueOf(totalSize)));
            output.collect((Object)new Text("l:time"), (Object)new Text(String.valueOf(execTime)));
            output.collect((Object)new Text("f:rate"), (Object)new Text(String.valueOf(ioRateMbSec * 1000.0f)));
            output.collect((Object)new Text("f:sqrate"), (Object)new Text(String.valueOf(ioRateMbSec * ioRateMbSec * 1000.0f)));
        }
    }

    static enum ByteMultiple {
        B(1L),
        KB(1024L),
        MB(0x100000L),
        GB(0x40000000L),
        TB(0x10000000000L);

        private long multiplier;

        private ByteMultiple(long mult) {
            this.multiplier = mult;
        }

        long value() {
            return this.multiplier;
        }

        static ByteMultiple parseString(String sMultiple) {
            if (sMultiple == null || sMultiple.isEmpty()) {
                return MB;
            }
            String sMU = sMultiple.toUpperCase();
            if (B.name().toUpperCase().endsWith(sMU)) {
                return B;
            }
            if (KB.name().toUpperCase().endsWith(sMU)) {
                return KB;
            }
            if (MB.name().toUpperCase().endsWith(sMU)) {
                return MB;
            }
            if (GB.name().toUpperCase().endsWith(sMU)) {
                return GB;
            }
            if (TB.name().toUpperCase().endsWith(sMU)) {
                return TB;
            }
            throw new IllegalArgumentException("Unsupported ByteMultiple " + sMultiple);
        }
    }
}

