/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;

public class TestCopyFiles
extends TestCase {
    private static final String JT_STAGING_AREA_ROOT = "mapreduce.jobtracker.staging.root.dir";
    private static final String JT_STAGING_AREA_ROOT_DEFAULT = "/tmp/hadoop/mapred/staging";
    private static final String FS_TRASH_INTERVAL_KEY = "fs.trash.interval";
    private static final String LOCAL_FS_STR = "file:///";
    private static final URI LOCAL_FS_URI = URI.create("file:///");
    private static final Random RAN = new Random();
    private static final int NFILES = 20;
    private static String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');
    static final long now = System.currentTimeMillis();

    public TestCopyFiles() {
        ((Log4JLogger)LogFactory.getLog((String)"org.apache.hadoop.hdfs.StateChange")).getLogger().setLevel(Level.OFF);
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.OFF);
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.OFF);
        ((Log4JLogger)DistCp.LOG).getLogger().setLevel(Level.ALL);
    }

    private static MyFile[] createFiles(URI fsname, String topdir) throws IOException {
        return TestCopyFiles.createFiles(FileSystem.get((URI)fsname, (Configuration)new Configuration()), topdir);
    }

    private static MyFile[] createFiles(FileSystem fs, String topdir) throws IOException {
        Path root = new Path(topdir);
        MyFile[] files = new MyFile[20];
        for (int i = 0; i < 20; ++i) {
            files[i] = TestCopyFiles.createFile(root, fs);
        }
        return files;
    }

    static MyFile createFile(Path root, FileSystem fs, int levels) throws IOException {
        MyFile f = levels < 0 ? new MyFile() : new MyFile(levels);
        Path p = new Path(root, f.getName());
        FSDataOutputStream out = fs.create(p);
        byte[] toWrite = new byte[f.getSize()];
        new Random(f.getSeed()).nextBytes(toWrite);
        out.write(toWrite);
        out.close();
        FileSystem.LOG.info((Object)("created: " + p + ", size=" + f.getSize()));
        return f;
    }

    static MyFile createFile(Path root, FileSystem fs) throws IOException {
        return TestCopyFiles.createFile(root, fs, -1);
    }

    private static boolean checkFiles(FileSystem fs, String topdir, MyFile[] files) throws IOException {
        return TestCopyFiles.checkFiles(fs, topdir, files, false);
    }

    private static boolean checkFiles(FileSystem fs, String topdir, MyFile[] files, boolean existingOnly) throws IOException {
        Path root = new Path(topdir);
        for (int idx = 0; idx < files.length; ++idx) {
            Path fPath = new Path(root, files[idx].getName());
            try {
                fs.getFileStatus(fPath);
                FSDataInputStream in = fs.open(fPath);
                byte[] toRead = new byte[files[idx].getSize()];
                byte[] toCompare = new byte[files[idx].getSize()];
                Random rb = new Random(files[idx].getSeed());
                rb.nextBytes(toCompare);
                TestCopyFiles.assertEquals((String)"Cannnot read file.", (int)toRead.length, (int)in.read(toRead));
                in.close();
                for (int i = 0; i < toRead.length; ++i) {
                    if (toRead[i] == toCompare[i]) continue;
                    return false;
                }
                toRead = null;
                toCompare = null;
                continue;
            }
            catch (FileNotFoundException fnfe) {
                if (existingOnly) continue;
                throw fnfe;
            }
        }
        return true;
    }

    private static void updateFiles(FileSystem fs, String topdir, MyFile[] files, int nupdate) throws IOException {
        assert (nupdate <= 20);
        Path root = new Path(topdir);
        for (int idx = 0; idx < nupdate; ++idx) {
            Path fPath = new Path(root, files[idx].getName());
            TestCopyFiles.assertTrue((String)(fPath.toString() + " does not exist"), (boolean)fs.exists(fPath));
            FSDataOutputStream out = fs.create(fPath);
            files[idx].reset();
            byte[] toWrite = new byte[files[idx].getSize()];
            Random rb = new Random(files[idx].getSeed());
            rb.nextBytes(toWrite);
            out.write(toWrite);
            out.close();
        }
    }

    private static FileStatus[] getFileStatus(FileSystem fs, String topdir, MyFile[] files) throws IOException {
        return TestCopyFiles.getFileStatus(fs, topdir, files, false);
    }

    private static FileStatus[] getFileStatus(FileSystem fs, String topdir, MyFile[] files, boolean existingOnly) throws IOException {
        Path root = new Path(topdir);
        ArrayList<FileStatus> statuses = new ArrayList<FileStatus>();
        for (int idx = 0; idx < 20; ++idx) {
            try {
                statuses.add(fs.getFileStatus(new Path(root, files[idx].getName())));
                continue;
            }
            catch (FileNotFoundException fnfe) {
                if (existingOnly) continue;
                throw fnfe;
            }
        }
        return statuses.toArray(new FileStatus[statuses.size()]);
    }

    private static boolean checkUpdate(FileSystem fs, FileStatus[] old, String topdir, MyFile[] upd, int nupdate) throws IOException {
        FileStatus stat;
        int idx;
        Path root = new Path(topdir);
        for (idx = 0; idx < nupdate; ++idx) {
            stat = fs.getFileStatus(new Path(root, upd[idx].getName()));
            if (stat.getModificationTime() > old[idx].getModificationTime()) continue;
            return false;
        }
        for (idx = nupdate; idx < 20; ++idx) {
            stat = fs.getFileStatus(new Path(root, upd[idx].getName()));
            if (stat.getModificationTime() == old[idx].getModificationTime()) continue;
            return false;
        }
        return true;
    }

    private static void deldir(FileSystem fs, String topdir) throws IOException {
        fs.delete(new Path(topdir), true);
    }

    public void testCopyFromLocalToLocal() throws Exception {
        Configuration conf = new Configuration();
        FileSystem localfs = FileSystem.get((URI)LOCAL_FS_URI, (Configuration)conf);
        MyFile[] files = TestCopyFiles.createFiles(LOCAL_FS_URI, TEST_ROOT_DIR + "/srcdat");
        ToolRunner.run((Tool)new DistCp(new Configuration()), (String[])new String[]{LOCAL_FS_STR + TEST_ROOT_DIR + "/srcdat", LOCAL_FS_STR + TEST_ROOT_DIR + "/destdat"});
        TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(localfs, TEST_ROOT_DIR + "/destdat", files));
        TestCopyFiles.deldir(localfs, TEST_ROOT_DIR + "/destdat");
        TestCopyFiles.deldir(localfs, TEST_ROOT_DIR + "/srcdat");
    }

    public void testCopyFromLocalToLocalUsingRelativePathName() throws Exception {
        Configuration conf = new Configuration();
        FileSystem localfs = FileSystem.get((URI)LOCAL_FS_URI, (Configuration)conf);
        MyFile[] files = TestCopyFiles.createFiles(LOCAL_FS_URI, TEST_ROOT_DIR + "/srcdat");
        Path src = new Path(TEST_ROOT_DIR + "/srcdat");
        Path srcRoot = new Path(".");
        FileStatus srcfilestat = localfs.getFileStatus(src);
        FileStatus srcRootfilestat = localfs.getFileStatus(srcRoot);
        String srcStr = srcfilestat.getPath().toString();
        String srcRootStr = srcRootfilestat.getPath().toString();
        String srcRelativePath = srcStr.substring(srcRootStr.length() + 1);
        String destRelativePath = srcRelativePath.substring(0, srcRelativePath.length() - "srcdat".length()) + "destdat";
        ToolRunner.run((Tool)new DistCp(new Configuration()), (String[])new String[]{srcRelativePath, destRelativePath});
        TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(localfs, TEST_ROOT_DIR + "/destdat", files));
        TestCopyFiles.deldir(localfs, TEST_ROOT_DIR + "/destdat");
        TestCopyFiles.deldir(localfs, TEST_ROOT_DIR + "/srcdat");
    }

    private static void addToArgList(List<String> argList, String ... args) {
        for (String arg : args) {
            argList.add(arg);
        }
    }

    private void addSrcDstToArgList(List<String> argList, boolean skipTmp, String dst, String ... srcs) {
        if (skipTmp) {
            argList.add("-skiptmp");
        }
        TestCopyFiles.addToArgList(argList, srcs);
        argList.add(dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCopyFromDfsToDfs(boolean skipTmp) throws Exception {
        String namenode = null;
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster(conf, 2, true, null);
            DistributedFileSystem hdfs = cluster.getFileSystem();
            namenode = FileSystem.getDefaultUri((Configuration)conf).toString();
            if (namenode.startsWith("hdfs://")) {
                MyFile[] files = TestCopyFiles.createFiles(URI.create(namenode), "/srcdat");
                ArrayList<String> argList = new ArrayList<String>();
                TestCopyFiles.addToArgList(argList, "-log", namenode + "/logs");
                this.addSrcDstToArgList(argList, skipTmp, namenode + "/destdat", namenode + "/srcdat");
                ToolRunner.run((Tool)new DistCp(conf), (String[])argList.toArray(new String[argList.size()]));
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)hdfs, "/destdat", files));
                FileSystem fs = FileSystem.get((URI)URI.create(namenode + "/logs"), (Configuration)conf);
                TestCopyFiles.assertTrue((String)"Log directory does not exist.", (boolean)fs.exists(new Path(namenode + "/logs")));
                TestCopyFiles.deldir((FileSystem)hdfs, "/destdat");
                TestCopyFiles.deldir((FileSystem)hdfs, "/srcdat");
                TestCopyFiles.deldir((FileSystem)hdfs, "/logs");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public void testCopyFromDfsToDfs() throws Exception {
        this.testCopyFromDfsToDfs(false);
    }

    public void testCopyFromDfsToDfsWithSkiptmp() throws Exception {
        this.testCopyFromDfsToDfs(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyFromLocalToDfs() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster(conf, 1, true, null);
            DistributedFileSystem hdfs = cluster.getFileSystem();
            String namenode = hdfs.getUri().toString();
            if (namenode.startsWith("hdfs://")) {
                MyFile[] files = TestCopyFiles.createFiles(LOCAL_FS_URI, TEST_ROOT_DIR + "/srcdat");
                ToolRunner.run((Tool)new DistCp(conf), (String[])new String[]{"-log", namenode + "/logs", LOCAL_FS_STR + TEST_ROOT_DIR + "/srcdat", namenode + "/destdat"});
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)cluster.getFileSystem(), "/destdat", files));
                TestCopyFiles.assertTrue((String)"Log directory does not exist.", (boolean)hdfs.exists(new Path(namenode + "/logs")));
                TestCopyFiles.deldir((FileSystem)hdfs, "/destdat");
                TestCopyFiles.deldir((FileSystem)hdfs, "/logs");
                TestCopyFiles.deldir(FileSystem.get((URI)LOCAL_FS_URI, (Configuration)conf), TEST_ROOT_DIR + "/srcdat");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyFromDfsToLocal() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            FileSystem localfs = FileSystem.get((URI)LOCAL_FS_URI, (Configuration)conf);
            cluster = new MiniDFSCluster(conf, 1, true, null);
            DistributedFileSystem hdfs = cluster.getFileSystem();
            String namenode = FileSystem.getDefaultUri((Configuration)conf).toString();
            if (namenode.startsWith("hdfs://")) {
                MyFile[] files = TestCopyFiles.createFiles(URI.create(namenode), "/srcdat");
                ToolRunner.run((Tool)new DistCp(conf), (String[])new String[]{"-log", "/logs", namenode + "/srcdat", LOCAL_FS_STR + TEST_ROOT_DIR + "/destdat"});
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(localfs, TEST_ROOT_DIR + "/destdat", files));
                TestCopyFiles.assertTrue((String)"Log directory does not exist.", (boolean)hdfs.exists(new Path("/logs")));
                TestCopyFiles.deldir(localfs, TEST_ROOT_DIR + "/destdat");
                TestCopyFiles.deldir((FileSystem)hdfs, "/logs");
                TestCopyFiles.deldir((FileSystem)hdfs, "/srcdat");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteLocal() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            FileSystem localfs = FileSystem.get((URI)LOCAL_FS_URI, (Configuration)conf);
            cluster = new MiniDFSCluster(conf, 1, true, null);
            DistributedFileSystem hdfs = cluster.getFileSystem();
            String namenode = FileSystem.getDefaultUri((Configuration)conf).toString();
            if (namenode.startsWith("hdfs://")) {
                MyFile[] files = TestCopyFiles.createFiles(URI.create(namenode), "/srcdat");
                String destdir = TEST_ROOT_DIR + "/destdat";
                MyFile[] localFiles = TestCopyFiles.createFiles(localfs, destdir);
                ToolRunner.run((Tool)new DistCp(conf), (String[])new String[]{"-delete", "-update", "-log", "/logs", namenode + "/srcdat", LOCAL_FS_STR + TEST_ROOT_DIR + "/destdat"});
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(localfs, destdir, files));
                TestCopyFiles.assertTrue((String)"Log directory does not exist.", (boolean)hdfs.exists(new Path("/logs")));
                TestCopyFiles.deldir(localfs, destdir);
                TestCopyFiles.deldir((FileSystem)hdfs, "/logs");
                TestCopyFiles.deldir((FileSystem)hdfs, "/srcdat");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCopyDfsToDfsUpdateOverwrite(boolean skipTmp) throws Exception {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster(conf, 2, true, null);
            DistributedFileSystem hdfs = cluster.getFileSystem();
            String namenode = hdfs.getUri().toString();
            if (namenode.startsWith("hdfs://")) {
                MyFile[] files = TestCopyFiles.createFiles(URI.create(namenode), "/srcdat");
                ArrayList<String> argList = new ArrayList<String>();
                TestCopyFiles.addToArgList(argList, "-p", "-log", namenode + "/logs");
                this.addSrcDstToArgList(argList, skipTmp, namenode + "/destdat", namenode + "/srcdat");
                ToolRunner.run((Tool)new DistCp(conf), (String[])argList.toArray(new String[argList.size()]));
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)hdfs, "/destdat", files));
                FileSystem fs = FileSystem.get((URI)URI.create(namenode + "/logs"), (Configuration)conf);
                TestCopyFiles.assertTrue((String)"Log directory does not exist.", (boolean)fs.exists(new Path(namenode + "/logs")));
                FileStatus[] dchkpoint = TestCopyFiles.getFileStatus((FileSystem)hdfs, "/destdat", files);
                int nupdate = 5;
                TestCopyFiles.updateFiles((FileSystem)cluster.getFileSystem(), "/srcdat", files, 5);
                TestCopyFiles.deldir((FileSystem)hdfs, "/logs");
                argList.clear();
                TestCopyFiles.addToArgList(argList, "-p", "-update", "-log", namenode + "/logs");
                this.addSrcDstToArgList(argList, skipTmp, namenode + "/destdat", namenode + "/srcdat");
                ToolRunner.run((Tool)new DistCp(conf), (String[])argList.toArray(new String[argList.size()]));
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)hdfs, "/destdat", files));
                TestCopyFiles.assertTrue((String)"Update failed to replicate all changes in src", (boolean)TestCopyFiles.checkUpdate((FileSystem)hdfs, dchkpoint, "/destdat", files, 5));
                TestCopyFiles.deldir((FileSystem)hdfs, "/logs");
                argList.clear();
                TestCopyFiles.addToArgList(argList, "-p", "-overwrite", "-log", namenode + "/logs");
                this.addSrcDstToArgList(argList, skipTmp, namenode + "/destdat", namenode + "/srcdat");
                ToolRunner.run((Tool)new DistCp(conf), (String[])argList.toArray(new String[argList.size()]));
                TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)hdfs, "/destdat", files));
                TestCopyFiles.assertTrue((String)"-overwrite didn't.", (boolean)TestCopyFiles.checkUpdate((FileSystem)hdfs, dchkpoint, "/destdat", files, 20));
                TestCopyFiles.deldir((FileSystem)hdfs, "/destdat");
                TestCopyFiles.deldir((FileSystem)hdfs, "/srcdat");
                TestCopyFiles.deldir((FileSystem)hdfs, "/logs");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public void testCopyDfsToDfsUpdateOverwrite() throws Exception {
        this.testCopyDfsToDfsUpdateOverwrite(false);
    }

    public void testCopyDfsToDfsUpdateOverwriteSkiptmp() throws Exception {
        this.testCopyDfsToDfsUpdateOverwrite(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCopyDfsToDfsUpdateWithSkipCRC(boolean skipTmp) throws Exception {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster(conf, 2, true, null);
            DistributedFileSystem hdfs = cluster.getFileSystem();
            String namenode = hdfs.getUri().toString();
            FileSystem fs = FileSystem.get((URI)URI.create(namenode), (Configuration)new Configuration());
            String testfilename = "test";
            String srcData = "act act act";
            String destData = "cat cat cat";
            if (namenode.startsWith("hdfs://")) {
                TestCopyFiles.deldir((FileSystem)hdfs, "/logs");
                Path srcPath = new Path("/srcdat", "test");
                Path destPath = new Path("/destdat", "test");
                FSDataOutputStream out = fs.create(srcPath, true);
                out.writeUTF("act act act");
                out.close();
                out = fs.create(destPath, true);
                out.writeUTF("cat cat cat");
                out.close();
                ArrayList<String> argList = new ArrayList<String>();
                TestCopyFiles.addToArgList(argList, "-p", "-update", "-skipcrccheck", "-log", namenode + "/logs");
                this.addSrcDstToArgList(argList, skipTmp, namenode + "/destdat", namenode + "/srcdat");
                ToolRunner.run((Tool)new DistCp(conf), (String[])argList.toArray(new String[argList.size()]));
                FSDataInputStream in = hdfs.open(destPath);
                String s = in.readUTF();
                System.out.println("Dest had: " + s);
                TestCopyFiles.assertTrue((String)"Dest got over written even with skip crc", (boolean)s.equalsIgnoreCase("cat cat cat"));
                in.close();
                TestCopyFiles.deldir((FileSystem)hdfs, "/logs");
                argList.clear();
                TestCopyFiles.addToArgList(argList, "-p", "-update", "-log", namenode + "/logs");
                this.addSrcDstToArgList(argList, skipTmp, namenode + "/destdat", namenode + "/srcdat");
                ToolRunner.run((Tool)new DistCp(conf), (String[])argList.toArray(new String[argList.size()]));
                in = hdfs.open(destPath);
                s = in.readUTF();
                System.out.println("Dest had: " + s);
                TestCopyFiles.assertTrue((String)"Dest did not get overwritten without skip crc", (boolean)s.equalsIgnoreCase("act act act"));
                in.close();
                TestCopyFiles.deldir((FileSystem)hdfs, "/destdat");
                TestCopyFiles.deldir((FileSystem)hdfs, "/srcdat");
                TestCopyFiles.deldir((FileSystem)hdfs, "/logs");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public void testCopyDfsToDfsUpdateWithSkipCRC() throws Exception {
        this.testCopyDfsToDfsUpdateWithSkipCRC(false);
    }

    public void testCopyDfsToDfsUpdateWithSkipCRCSkiptmp() throws Exception {
        this.testCopyDfsToDfsUpdateWithSkipCRC(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stagingAreaTest(FileSystem srcFs, FileSystem destFs, MiniDFSCluster cluster, Configuration conf, boolean skipTmp) throws Exception {
        try {
            String fileDir = "/files";
            String srcParent = "/srcdat";
            String destParent = "/destdata";
            String source = "/srcdat/files";
            String destination = "/destdata/files";
            String logs = "/logs";
            String logDir = TEST_ROOT_DIR + "/logs";
            URI srcUri = srcFs.getUri();
            URI destUri = destFs.getUri();
            boolean isSrcLocalFs = srcUri.getScheme().equals(LOCAL_FS_URI.getScheme());
            FileSystem localFs = FileSystem.get((URI)LOCAL_FS_URI, (Configuration)conf);
            String prevStagingArea = conf.get(JT_STAGING_AREA_ROOT, JT_STAGING_AREA_ROOT_DEFAULT);
            String newStagingArea = isSrcLocalFs ? "/srcdat/files" : "/destdata/files";
            newStagingArea = newStagingArea + "/STAGING";
            conf.set(JT_STAGING_AREA_ROOT, TEST_ROOT_DIR + newStagingArea);
            String srcParentPrefix = isSrcLocalFs ? TEST_ROOT_DIR : "";
            String destParentPrefix = isSrcLocalFs ? "" : TEST_ROOT_DIR;
            String createDelSrcParent = srcParentPrefix + "/srcdat";
            String createDelDestParent = destParentPrefix + "/destdata";
            String createDelSrc = createDelSrcParent + "/files";
            String createDelDest = createDelDestParent + "/files";
            MyFile[] srcFiles = TestCopyFiles.createFiles(srcUri, createDelSrc);
            TestCopyFiles.createFiles(destUri, createDelDest);
            String distcpSrc = String.valueOf(srcUri) + createDelSrc;
            String distcpDest = String.valueOf(destUri) + createDelDest;
            ArrayList<String> argList = new ArrayList<String>();
            TestCopyFiles.addToArgList(argList, "-log", LOCAL_FS_STR + logDir, "-update", "-delete");
            this.addSrcDstToArgList(argList, skipTmp, distcpDest, distcpSrc);
            ToolRunner.run((Tool)new DistCp(conf), (String[])argList.toArray(new String[argList.size()]));
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(destFs, createDelDest, srcFiles));
            TestCopyFiles.deldir(localFs, logDir);
            TestCopyFiles.deldir(srcFs, createDelSrcParent);
            TestCopyFiles.deldir(destFs, createDelDestParent);
            conf.set(JT_STAGING_AREA_ROOT, prevStagingArea);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void testCopyFromLocalToDfsWithStagingAreaInSrc(boolean skipTmp) throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 2, true, null);
        String namenode = FileSystem.getDefaultUri((Configuration)conf).toString();
        TestCopyFiles.assertTrue((String)"Name node doesn't start with hdfs://", (boolean)namenode.startsWith("hdfs://"));
        FileSystem srcFs = FileSystem.get((URI)LOCAL_FS_URI, (Configuration)conf);
        DistributedFileSystem destFs = cluster.getFileSystem();
        this.stagingAreaTest(srcFs, (FileSystem)destFs, cluster, conf, skipTmp);
    }

    public void testCopyFromLocalToDfsWithStagingAreaInSrcSkiptmp() throws Exception {
        this.testCopyFromLocalToDfsWithStagingAreaInSrc(true);
    }

    public void testCopyFromLocalToDfsWithStagingAreaInSrc() throws Exception {
        this.testCopyFromLocalToDfsWithStagingAreaInSrc(false);
    }

    public void testCopyFromDfsToLocalWithStagingAreaInDest(boolean skipTmp) throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 2, true, null);
        String namenode = FileSystem.getDefaultUri((Configuration)conf).toString();
        TestCopyFiles.assertTrue((String)"Name node doesn't start with hdfs://", (boolean)namenode.startsWith("hdfs://"));
        DistributedFileSystem srcFs = cluster.getFileSystem();
        FileSystem destFs = FileSystem.get((URI)LOCAL_FS_URI, (Configuration)conf);
        this.stagingAreaTest((FileSystem)srcFs, destFs, cluster, conf, skipTmp);
    }

    public void testCopyFromDfsToLocalWithStagingAreaInDestSkiptmp() throws Exception {
        this.testCopyFromDfsToLocalWithStagingAreaInDest(true);
    }

    public void testCopyFromDfsToLocalWithStagingAreaInDest() throws Exception {
        this.testCopyFromDfsToLocalWithStagingAreaInDest(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCopyDuplication(boolean skipTmp) throws Exception {
        FileSystem localfs = FileSystem.get((URI)LOCAL_FS_URI, (Configuration)new Configuration());
        try {
            MyFile[] files = TestCopyFiles.createFiles(localfs, TEST_ROOT_DIR + "/srcdat");
            ArrayList<String> argList = new ArrayList<String>();
            this.addSrcDstToArgList(argList, skipTmp, LOCAL_FS_STR + TEST_ROOT_DIR + "/src2/srcdat", LOCAL_FS_STR + TEST_ROOT_DIR + "/srcdat");
            ToolRunner.run((Tool)new DistCp(new Configuration()), (String[])argList.toArray(new String[argList.size()]));
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(localfs, TEST_ROOT_DIR + "/src2/srcdat", files));
            argList.clear();
            this.addSrcDstToArgList(argList, skipTmp, LOCAL_FS_STR + TEST_ROOT_DIR + "/destdat", LOCAL_FS_STR + TEST_ROOT_DIR + "/srcdat", LOCAL_FS_STR + TEST_ROOT_DIR + "/src2/srcdat");
            TestCopyFiles.assertEquals((int)-2, (int)ToolRunner.run((Tool)new DistCp(new Configuration()), (String[])argList.toArray(new String[argList.size()])));
        }
        finally {
            TestCopyFiles.deldir(localfs, TEST_ROOT_DIR + "/destdat");
            TestCopyFiles.deldir(localfs, TEST_ROOT_DIR + "/srcdat");
            TestCopyFiles.deldir(localfs, TEST_ROOT_DIR + "/src2");
        }
    }

    public void testCopyDuplication() throws Exception {
        this.testCopyDuplication(false);
    }

    public void testCopyDuplicationSkiptmp() throws Exception {
        this.testCopyDuplication(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oldtestCopyDuplication() throws Exception {
        FileSystem localfs = FileSystem.get((URI)LOCAL_FS_URI, (Configuration)new Configuration());
        try {
            MyFile[] files = TestCopyFiles.createFiles(localfs, TEST_ROOT_DIR + "/srcdat");
            ToolRunner.run((Tool)new DistCp(new Configuration()), (String[])new String[]{LOCAL_FS_STR + TEST_ROOT_DIR + "/srcdat", LOCAL_FS_STR + TEST_ROOT_DIR + "/src2/srcdat"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(localfs, TEST_ROOT_DIR + "/src2/srcdat", files));
            TestCopyFiles.assertEquals((int)-2, (int)ToolRunner.run((Tool)new DistCp(new Configuration()), (String[])new String[]{LOCAL_FS_STR + TEST_ROOT_DIR + "/srcdat", LOCAL_FS_STR + TEST_ROOT_DIR + "/src2/srcdat", LOCAL_FS_STR + TEST_ROOT_DIR + "/destdat"}));
        }
        finally {
            TestCopyFiles.deldir(localfs, TEST_ROOT_DIR + "/destdat");
            TestCopyFiles.deldir(localfs, TEST_ROOT_DIR + "/srcdat");
            TestCopyFiles.deldir(localfs, TEST_ROOT_DIR + "/src2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCopySingleFile(boolean skipTmp) throws Exception {
        FileSystem fs = FileSystem.get((URI)LOCAL_FS_URI, (Configuration)new Configuration());
        Path root = new Path(TEST_ROOT_DIR + "/srcdat");
        try {
            MyFile[] files = new MyFile[]{TestCopyFiles.createFile(root, fs)};
            ArrayList<String> argList = new ArrayList<String>();
            this.addSrcDstToArgList(argList, skipTmp, LOCAL_FS_STR + TEST_ROOT_DIR + "/destdat", LOCAL_FS_STR + TEST_ROOT_DIR + "/srcdat");
            ToolRunner.run((Tool)new DistCp(new Configuration()), (String[])argList.toArray(new String[argList.size()]));
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(fs, TEST_ROOT_DIR + "/destdat", files));
            argList.clear();
            String fname = files[0].getName();
            Path p = new Path(root, fname);
            FileSystem.LOG.info((Object)("fname=" + fname + ", exists? " + fs.exists(p)));
            this.addSrcDstToArgList(argList, skipTmp, LOCAL_FS_STR + TEST_ROOT_DIR + "/dest2/" + fname, LOCAL_FS_STR + TEST_ROOT_DIR + "/srcdat/" + fname);
            ToolRunner.run((Tool)new DistCp(new Configuration()), (String[])argList.toArray(new String[argList.size()]));
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(fs, TEST_ROOT_DIR + "/dest2", files));
            argList.clear();
            TestCopyFiles.deldir(fs, TEST_ROOT_DIR + "/dest2");
            fs.mkdirs(new Path(TEST_ROOT_DIR + "/dest2"));
            MyFile[] files2 = new MyFile[]{TestCopyFiles.createFile(root, fs, 0)};
            String sname = files2[0].getName();
            TestCopyFiles.addToArgList(argList, "-update");
            this.addSrcDstToArgList(argList, skipTmp, LOCAL_FS_STR + TEST_ROOT_DIR + "/dest2/", LOCAL_FS_STR + TEST_ROOT_DIR + "/srcdat/" + sname);
            ToolRunner.run((Tool)new DistCp(new Configuration()), (String[])argList.toArray(new String[argList.size()]));
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(fs, TEST_ROOT_DIR + "/dest2", files2));
            TestCopyFiles.updateFiles(fs, TEST_ROOT_DIR + "/srcdat", files2, 1);
            argList.clear();
            TestCopyFiles.addToArgList(argList, "-update");
            this.addSrcDstToArgList(argList, skipTmp, LOCAL_FS_STR + TEST_ROOT_DIR + "/dest2/", LOCAL_FS_STR + TEST_ROOT_DIR + "/srcdat/" + sname);
            ToolRunner.run((Tool)new DistCp(new Configuration()), (String[])argList.toArray(new String[argList.size()]));
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(fs, TEST_ROOT_DIR + "/dest2", files2));
        }
        finally {
            TestCopyFiles.deldir(fs, TEST_ROOT_DIR + "/destdat");
            TestCopyFiles.deldir(fs, TEST_ROOT_DIR + "/dest2");
            TestCopyFiles.deldir(fs, TEST_ROOT_DIR + "/srcdat");
        }
    }

    public void testCopySingleFile() throws Exception {
        this.testCopySingleFile(false);
    }

    public void testCopySingleFileWithSkiptmp() throws Exception {
        this.testCopySingleFile(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreserveOption() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            int i;
            cluster = new MiniDFSCluster(conf, 2, true, null);
            String nnUri = FileSystem.getDefaultUri((Configuration)conf).toString();
            FileSystem fs = FileSystem.get((URI)URI.create(nnUri), (Configuration)conf);
            MyFile[] files = TestCopyFiles.createFiles(URI.create(nnUri), "/srcdat");
            FileStatus[] srcstat = TestCopyFiles.getFileStatus(fs, "/srcdat", files);
            for (int i2 = 0; i2 < srcstat.length; ++i2) {
                fs.setOwner(srcstat[i2].getPath(), "u" + i2, null);
            }
            ToolRunner.run((Tool)new DistCp(conf), (String[])new String[]{"-pu", nnUri + "/srcdat", nnUri + "/destdat"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(fs, "/destdat", files));
            FileStatus[] dststat = TestCopyFiles.getFileStatus(fs, "/destdat", files);
            for (i = 0; i < dststat.length; ++i) {
                TestCopyFiles.assertEquals((String)("i=" + i), (String)("u" + i), (String)dststat[i].getOwner());
            }
            TestCopyFiles.deldir(fs, "/destdat");
            TestCopyFiles.deldir(fs, "/srcdat");
            files = TestCopyFiles.createFiles(URI.create(nnUri), "/srcdat");
            srcstat = TestCopyFiles.getFileStatus(fs, "/srcdat", files);
            for (int i3 = 0; i3 < srcstat.length; ++i3) {
                fs.setOwner(srcstat[i3].getPath(), null, "g" + i3);
            }
            ToolRunner.run((Tool)new DistCp(conf), (String[])new String[]{"-pg", nnUri + "/srcdat", nnUri + "/destdat"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(fs, "/destdat", files));
            dststat = TestCopyFiles.getFileStatus(fs, "/destdat", files);
            for (i = 0; i < dststat.length; ++i) {
                TestCopyFiles.assertEquals((String)("i=" + i), (String)("g" + i), (String)dststat[i].getGroup());
            }
            TestCopyFiles.deldir(fs, "/destdat");
            TestCopyFiles.deldir(fs, "/srcdat");
            files = TestCopyFiles.createFiles(URI.create(nnUri), "/srcdat");
            srcstat = TestCopyFiles.getFileStatus(fs, "/srcdat", files);
            FsPermission[] permissions = new FsPermission[srcstat.length];
            for (i = 0; i < srcstat.length; ++i) {
                permissions[i] = new FsPermission((short)(i & 0x1B6));
                fs.setPermission(srcstat[i].getPath(), permissions[i]);
            }
            ToolRunner.run((Tool)new DistCp(conf), (String[])new String[]{"-pp", nnUri + "/srcdat", nnUri + "/destdat"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles(fs, "/destdat", files));
            FileStatus[] dststat2 = TestCopyFiles.getFileStatus(fs, "/destdat", files);
            for (int i4 = 0; i4 < dststat2.length; ++i4) {
                TestCopyFiles.assertEquals((String)("i=" + i4), (Object)permissions[i4], (Object)dststat2[i4].getPermission());
            }
            TestCopyFiles.deldir(fs, "/destdat");
            TestCopyFiles.deldir(fs, "/srcdat");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMapCount() throws Exception {
        String namenode = null;
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        try {
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster(conf, 3, true, null);
            DistributedFileSystem fs = dfs.getFileSystem();
            FsShell shell = new FsShell(conf);
            namenode = fs.getUri().toString();
            mr = new MiniMRCluster(3, namenode, 1);
            MyFile[] files = TestCopyFiles.createFiles(fs.getUri(), "/srcdat");
            long totsize = 0L;
            for (MyFile f : files) {
                totsize += (long)f.getSize();
            }
            JobConf job = mr.createJobConf();
            job.setLong("distcp.bytes.per.map", totsize / 3L);
            ToolRunner.run((Tool)new DistCp((Configuration)job), (String[])new String[]{"-m", "100", "-log", namenode + "/logs", namenode + "/srcdat", namenode + "/destdat"});
            TestCopyFiles.assertTrue((String)"Source and destination directories do not match.", (boolean)TestCopyFiles.checkFiles((FileSystem)fs, "/destdat", files));
            String logdir = namenode + "/logs";
            System.out.println(TestCopyFiles.execCmd(shell, "-lsr", logdir));
            FileStatus[] logs = fs.listStatus(new Path(logdir));
            TestCopyFiles.assertTrue((String)("Unexpected map count, logs.length=" + logs.length), (logs.length == 5 || logs.length == 4 ? 1 : 0) != 0);
            TestCopyFiles.deldir((FileSystem)fs, "/destdat");
            TestCopyFiles.deldir((FileSystem)fs, "/logs");
            ToolRunner.run((Tool)new DistCp((Configuration)job), (String[])new String[]{"-m", "1", "-log", namenode + "/logs", namenode + "/srcdat", namenode + "/destdat"});
            System.out.println(TestCopyFiles.execCmd(shell, "-lsr", logdir));
            logs = fs.listStatus(new Path(namenode + "/logs"));
            TestCopyFiles.assertTrue((String)("Unexpected map count, logs.length=" + logs.length), (logs.length == 2 ? 1 : 0) != 0);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLimits() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster(conf, 2, true, null);
            String nnUri = FileSystem.getDefaultUri((Configuration)conf).toString();
            FileSystem fs = FileSystem.get((URI)URI.create(nnUri), (Configuration)conf);
            DistCp distcp = new DistCp(conf);
            FsShell shell = new FsShell(conf);
            String srcrootdir = "/src_root";
            Path srcrootpath = new Path("/src_root");
            String dstrootdir = "/dst_root";
            Path dstrootpath = new Path("/dst_root");
            MyFile[] files = TestCopyFiles.createFiles(URI.create(nnUri), "/src_root");
            int filelimit = files.length / 2;
            System.out.println("filelimit=" + filelimit);
            ToolRunner.run((Tool)distcp, (String[])new String[]{"-filelimit", "" + filelimit, nnUri + "/src_root", nnUri + "/dst_root"});
            String results = TestCopyFiles.execCmd(shell, "-lsr", "/dst_root");
            results = TestCopyFiles.removePrefix(results, "/dst_root");
            System.out.println("results=" + results);
            FileStatus[] dststat = TestCopyFiles.getFileStatus(fs, "/dst_root", files, true);
            TestCopyFiles.assertEquals((int)filelimit, (int)dststat.length);
            TestCopyFiles.deldir(fs, "/dst_root");
            TestCopyFiles.deldir(fs, "/src_root");
            TestCopyFiles.createFiles(URI.create(nnUri), "/src_root");
            long sizelimit = fs.getContentSummary(srcrootpath).getLength() / 2L;
            System.out.println("sizelimit=" + sizelimit);
            ToolRunner.run((Tool)distcp, (String[])new String[]{"-sizelimit", "" + sizelimit, nnUri + "/src_root", nnUri + "/dst_root"});
            ContentSummary summary = fs.getContentSummary(dstrootpath);
            System.out.println("summary=" + summary);
            TestCopyFiles.assertTrue((summary.getLength() <= sizelimit ? 1 : 0) != 0);
            TestCopyFiles.deldir(fs, "/dst_root");
            TestCopyFiles.deldir(fs, "/src_root");
            MyFile[] srcs = TestCopyFiles.createFiles(URI.create(nnUri), "/src_root");
            long totalsize = fs.getContentSummary(srcrootpath).getLength();
            System.out.println("src.length=" + srcs.length);
            System.out.println("totalsize =" + totalsize);
            fs.mkdirs(dstrootpath);
            int parts = RAN.nextInt(5) + 2;
            int filelimit2 = srcs.length / parts;
            long sizelimit2 = totalsize / (long)parts;
            System.out.println("filelimit=" + filelimit2);
            System.out.println("sizelimit=" + sizelimit2);
            System.out.println("parts    =" + parts);
            String[] args = new String[]{"-filelimit", "" + filelimit2, "-sizelimit", "" + sizelimit2, "-update", nnUri + "/src_root", nnUri + "/dst_root"};
            int dstfilecount = 0;
            long dstsize = 0L;
            for (int i = 0; i <= parts; ++i) {
                ToolRunner.run((Tool)distcp, (String[])args);
                FileStatus[] dststat2 = TestCopyFiles.getFileStatus(fs, "/dst_root", srcs, true);
                System.out.println(i + ") dststat.length=" + dststat2.length);
                TestCopyFiles.assertTrue((dststat2.length - dstfilecount <= filelimit2 ? 1 : 0) != 0);
                ContentSummary summary2 = fs.getContentSummary(dstrootpath);
                System.out.println(i + ") summary.getLength()=" + summary2.getLength());
                TestCopyFiles.assertTrue((summary2.getLength() - dstsize <= sizelimit2 ? 1 : 0) != 0);
                TestCopyFiles.assertTrue((boolean)TestCopyFiles.checkFiles(fs, "/dst_root", srcs, true));
                dstfilecount = dststat2.length;
                dstsize = summary2.getLength();
            }
            TestCopyFiles.deldir(fs, "/dst_root");
            TestCopyFiles.deldir(fs, "/src_root");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    static UserGroupInformation createUGI(String name, boolean issuper) {
        String username = name + now;
        String group = issuper ? "supergroup" : username;
        return UserGroupInformation.createUserForTesting((String)username, (String[])new String[]{group});
    }

    static Path createHomeDirectory(FileSystem fs, UserGroupInformation ugi) throws IOException {
        Path home = new Path("/user/" + ugi.getUserName());
        fs.mkdirs(home);
        fs.setOwner(home, ugi.getUserName(), ugi.getGroupNames()[0]);
        fs.setPermission(home, new FsPermission(448));
        return home;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHftpAccessControl() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            UserGroupInformation DFS_UGI = TestCopyFiles.createUGI("dfs", true);
            UserGroupInformation USER_UGI = TestCopyFiles.createUGI("user", false);
            final Configuration dfsConf = new Configuration();
            cluster = new MiniDFSCluster(dfsConf, 2, true, null);
            cluster.waitActive();
            String httpAdd = dfsConf.get("dfs.http.address");
            final URI nnURI = FileSystem.getDefaultUri((Configuration)dfsConf);
            String nnUri = nnURI.toString();
            FileSystem fs1 = (FileSystem)DFS_UGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws IOException {
                    return FileSystem.get((URI)nnURI, (Configuration)dfsConf);
                }
            });
            Path home = TestCopyFiles.createHomeDirectory(fs1, USER_UGI);
            final Configuration userConf = new Configuration();
            FileSystem fs = (FileSystem)USER_UGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws IOException {
                    return FileSystem.get((URI)nnURI, (Configuration)userConf);
                }
            });
            Path srcrootpath = new Path(home, "src_root");
            String srcrootdir = srcrootpath.toString();
            Path dstrootpath = new Path(home, "dst_root");
            String dstrootdir = dstrootpath.toString();
            final DistCp distcp = (DistCp)USER_UGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<DistCp>(){

                @Override
                public DistCp run() {
                    return new DistCp(userConf);
                }
            });
            FileSystem.mkdirs((FileSystem)fs, (Path)srcrootpath, (FsPermission)new FsPermission(448));
            final String[] args = new String[]{"hftp://" + httpAdd + srcrootdir, nnUri + dstrootdir};
            fs.setPermission(srcrootpath, new FsPermission(0));
            USER_UGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Assert.assertEquals((int)-3, (int)ToolRunner.run((Tool)distcp, (String[])args));
                    return null;
                }
            });
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDelete() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt(FS_TRASH_INTERVAL_KEY, 60);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster(conf, 2, true, null);
            URI nnURI = FileSystem.getDefaultUri((Configuration)conf);
            String nnUri = nnURI.toString();
            FileSystem fs = FileSystem.get((URI)URI.create(nnUri), (Configuration)conf);
            DistCp distcp = new DistCp(conf);
            FsShell shell = new FsShell(conf);
            String srcrootdir = "/src_root";
            String dstrootdir = "/dst_root";
            TestCopyFiles.createFiles(nnURI, "/src_root");
            String srcresults = TestCopyFiles.execCmd(shell, "-lsr", "/src_root");
            srcresults = TestCopyFiles.removePrefix(srcresults, "/src_root");
            System.out.println("srcresults=" + srcresults);
            TestCopyFiles.createFiles(nnURI, "/dst_root");
            System.out.println("dstrootdir=/dst_root");
            shell.run(new String[]{"-lsr", "/dst_root"});
            ToolRunner.run((Tool)distcp, (String[])new String[]{"-delete", "-update", "-log", "/log", nnUri + "/src_root", nnUri + "/dst_root"});
            String dstresults = TestCopyFiles.execCmd(shell, "-lsr", "/dst_root");
            dstresults = TestCopyFiles.removePrefix(dstresults, "/dst_root");
            System.out.println("first dstresults=" + dstresults);
            TestCopyFiles.assertEquals((String)srcresults, (String)dstresults);
            TestCopyFiles.create(fs, new Path("/dst_root", "foo"));
            TestCopyFiles.create(fs, new Path("/dst_root", "foobar"));
            ToolRunner.run((Tool)distcp, (String[])new String[]{"-delete", "-update", "-log", "/log2", nnUri + "/src_root", nnUri + "/dst_root"});
            dstresults = TestCopyFiles.execCmd(shell, "-lsr", "/dst_root");
            dstresults = TestCopyFiles.removePrefix(dstresults, "/dst_root");
            System.out.println("second dstresults=" + dstresults);
            TestCopyFiles.assertEquals((String)srcresults, (String)dstresults);
            TestCopyFiles.assertTrue((boolean)fs.exists(new Path(fs.getHomeDirectory(), ".Trash/Current/dst_root/foo")));
            TestCopyFiles.assertTrue((boolean)fs.exists(new Path(fs.getHomeDirectory(), ".Trash/Current/dst_root/foobar")));
            TestCopyFiles.deldir(fs, "/dst_root");
            TestCopyFiles.deldir(fs, "/src_root");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void create(FileSystem fs, Path f) throws IOException {
        try (FSDataOutputStream out = fs.create(f);){
            byte[] b = new byte[1024 + RAN.nextInt(1024)];
            RAN.nextBytes(b);
            out.write(b);
        }
    }

    static String execCmd(FsShell shell, String ... args) throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baout, true);
        PrintStream old = System.out;
        System.setOut(out);
        shell.run(args);
        out.close();
        System.setOut(old);
        return baout.toString();
    }

    private static String removePrefix(String lines, String prefix) {
        int prefixlen = prefix.length();
        StringTokenizer t = new StringTokenizer(lines, "\n");
        StringBuffer results = new StringBuffer();
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            results.append(s.substring(s.indexOf(prefix) + prefixlen) + "\n");
        }
        return results.toString();
    }

    private static class MyFile {
        private static Random gen = new Random();
        private static final int MAX_LEVELS = 3;
        private static final int MAX_SIZE = 8192;
        private static String[] dirNames = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
        private final String name;
        private int size = 0;
        private long seed = 0L;

        MyFile() {
            this(gen.nextInt(3));
        }

        MyFile(int nLevels) {
            String xname = "";
            if (nLevels != 0) {
                int[] levels = new int[nLevels];
                for (int idx = 0; idx < nLevels; ++idx) {
                    levels[idx] = gen.nextInt(10);
                }
                StringBuffer sb = new StringBuffer();
                for (int idx = 0; idx < nLevels; ++idx) {
                    sb.append(dirNames[levels[idx]]);
                    sb.append("/");
                }
                xname = sb.toString();
            }
            long fidx = gen.nextLong() & Long.MAX_VALUE;
            this.name = xname + Long.toString(fidx);
            this.reset();
        }

        void reset() {
            int oldsize = this.size;
            do {
                this.size = gen.nextInt(8192);
            } while (oldsize == this.size);
            long oldseed = this.seed;
            do {
                this.seed = gen.nextLong() & Long.MAX_VALUE;
            } while (oldseed == this.seed);
        }

        String getName() {
            return this.name;
        }

        int getSize() {
            return this.size;
        }

        long getSeed() {
            return this.seed;
        }
    }
}

