/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public enum StorageType {
    RAM_DISK(true),
    SSD(false),
    DISK(false),
    ARCHIVE(false);

    private final boolean isTransient;
    public static final StorageType DEFAULT;
    public static final StorageType[] EMPTY_ARRAY;
    private static final StorageType[] VALUES;

    private StorageType(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isMovable() {
        return !this.isTransient;
    }

    public static List<StorageType> asList() {
        return Arrays.asList(VALUES);
    }

    public static List<StorageType> getMovableTypes() {
        ArrayList<StorageType> movableTypes = new ArrayList<StorageType>();
        for (StorageType t : VALUES) {
            if (t.isTransient) continue;
            movableTypes.add(t);
        }
        return movableTypes;
    }

    static {
        DEFAULT = DISK;
        EMPTY_ARRAY = new StorageType[0];
        VALUES = StorageType.values();
    }
}

