/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.SignedBytes;
import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.net.SocketFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolTranslatorPB;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class DFSUtil {
    public static final Log LOG = LogFactory.getLog((String)DFSUtil.class.getName());
    public static final byte[] EMPTY_BYTES = new byte[0];
    private static final ThreadLocal<Random> RANDOM = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };
    private static final ThreadLocal<SecureRandom> SECURE_RANDOM = new ThreadLocal<SecureRandom>(){

        @Override
        protected SecureRandom initialValue() {
            return new SecureRandom();
        }
    };
    public static final Comparator<DatanodeInfo> DECOM_COMPARATOR = new Comparator<DatanodeInfo>(){

        @Override
        public int compare(DatanodeInfo a, DatanodeInfo b) {
            return a.isDecommissioned() == b.isDecommissioned() ? 0 : (a.isDecommissioned() ? 1 : -1);
        }
    };
    static final AddressMatcher LOCAL_ADDRESS_MATCHER = new AddressMatcher(){

        @Override
        public boolean match(InetSocketAddress s) {
            return NetUtils.isLocalAddress((InetAddress)s.getAddress());
        }
    };
    public static final Options helpOptions = new Options();
    public static final Option helpOpt = new Option("h", "help", false, "get help information");

    public static int compareBytes(byte[] left, byte[] right) {
        if (left == null) {
            left = EMPTY_BYTES;
        }
        if (right == null) {
            right = EMPTY_BYTES;
        }
        return SignedBytes.lexicographicalComparator().compare(left, right);
    }

    private DFSUtil() {
    }

    public static Random getRandom() {
        return RANDOM.get();
    }

    public static SecureRandom getSecureRandom() {
        return SECURE_RANDOM.get();
    }

    public static <T> T[] shuffle(T[] array) {
        if (array != null && array.length > 0) {
            Random random = DFSUtil.getRandom();
            int n = array.length;
            while (n > 1) {
                int randomIndex;
                if (--n == (randomIndex = random.nextInt(n))) continue;
                T tmp = array[randomIndex];
                array[randomIndex] = array[n];
                array[n] = tmp;
            }
        }
        return array;
    }

    public static boolean isValidName(String src) {
        if (!src.startsWith("/")) {
            return false;
        }
        String[] components = StringUtils.split((String)src, (char)'/');
        for (int i = 0; i < components.length; ++i) {
            String element = components[i];
            if (element.equals(".") || element.indexOf(":") >= 0 || element.indexOf("/") >= 0) {
                return false;
            }
            if (element.equals("..")) {
                if (components.length > 4 && components[1].equals(".reserved") && components[2].equals(".inodes")) continue;
                return false;
            }
            if (!element.isEmpty() || i == components.length - 1 || i == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidNameForComponent(String component) {
        if (component.equals(".") || component.equals("..") || component.indexOf(":") >= 0 || component.indexOf("/") >= 0) {
            return false;
        }
        return !DFSUtil.isReservedPathComponent(component);
    }

    public static boolean isReservedPathComponent(String component) {
        for (String reserved : HdfsConstants.RESERVED_PATH_COMPONENTS) {
            if (!component.equals(reserved)) continue;
            return true;
        }
        return false;
    }

    public static String bytes2String(byte[] bytes) {
        return DFSUtil.bytes2String(bytes, 0, bytes.length);
    }

    public static String bytes2String(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            assert (false) : "UTF8 encoding is not supported ";
            return null;
        }
    }

    public static byte[] string2Bytes(String str) {
        return str.getBytes(Charsets.UTF_8);
    }

    public static String byteArray2PathString(byte[][] pathComponents) {
        if (pathComponents.length == 0) {
            return "";
        }
        if (pathComponents.length == 1 && (pathComponents[0] == null || pathComponents[0].length == 0)) {
            return "/";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < pathComponents.length; ++i) {
            result.append(new String(pathComponents[i], Charsets.UTF_8));
            if (i >= pathComponents.length - 1) continue;
            result.append('/');
        }
        return result.toString();
    }

    public static String strings2PathString(String[] components) {
        if (components.length == 0) {
            return "";
        }
        if (components.length == 1 && (components[0] == null || components[0].isEmpty())) {
            return "/";
        }
        return Joiner.on((String)"/").join((Object[])components);
    }

    public static byte[] byteArray2bytes(byte[][] pathComponents) {
        if (pathComponents.length == 0) {
            return EMPTY_BYTES;
        }
        if (pathComponents.length == 1 && (pathComponents[0] == null || pathComponents[0].length == 0)) {
            return new byte[]{47};
        }
        int length = 0;
        for (int i = 0; i < pathComponents.length; ++i) {
            length += pathComponents[i].length;
            if (i >= pathComponents.length - 1) continue;
            ++length;
        }
        byte[] path = new byte[length];
        int index = 0;
        for (int i = 0; i < pathComponents.length; ++i) {
            System.arraycopy(pathComponents[i], 0, path, index, pathComponents[i].length);
            index += pathComponents[i].length;
            if (i >= pathComponents.length - 1) continue;
            path[index] = 47;
            ++index;
        }
        return path;
    }

    public static String path2String(Object path) {
        return path == null ? null : (path instanceof String ? (String)path : (path instanceof byte[][] ? DFSUtil.byteArray2PathString((byte[][])path) : path.toString()));
    }

    public static byte[][] bytes2byteArray(byte[] bytes, byte separator) {
        return DFSUtil.bytes2byteArray(bytes, bytes.length, separator);
    }

    public static byte[][] bytes2byteArray(byte[] bytes, int len, byte separator) {
        assert (len <= bytes.length);
        int splits = 0;
        if (len == 0) {
            return new byte[][]{null};
        }
        for (int i = 0; i < len; ++i) {
            if (bytes[i] != separator) continue;
            ++splits;
        }
        int last = len - 1;
        while (last > -1 && bytes[last--] == separator) {
            --splits;
        }
        if (splits == 0 && bytes[0] == separator) {
            return new byte[][]{null};
        }
        byte[][] result = new byte[++splits][];
        int startIndex = 0;
        int nextIndex = 0;
        for (int index = 0; index < splits; ++index) {
            while (nextIndex < len && bytes[nextIndex] != separator) {
                ++nextIndex;
            }
            result[index] = new byte[nextIndex - startIndex];
            System.arraycopy(bytes, startIndex, result[index], 0, nextIndex - startIndex);
            nextIndex = startIndex = nextIndex + 1;
        }
        return result;
    }

    public static BlockLocation[] locatedBlocks2Locations(LocatedBlocks blocks) {
        if (blocks == null) {
            return new BlockLocation[0];
        }
        return DFSUtil.locatedBlocks2Locations(blocks.getLocatedBlocks());
    }

    public static BlockLocation[] locatedBlocks2Locations(List<LocatedBlock> blocks) {
        if (blocks == null) {
            return new BlockLocation[0];
        }
        int nrBlocks = blocks.size();
        BlockLocation[] blkLocations = new BlockLocation[nrBlocks];
        if (nrBlocks == 0) {
            return blkLocations;
        }
        int idx = 0;
        for (LocatedBlock blk : blocks) {
            assert (idx < nrBlocks) : "Incorrect index";
            DatanodeInfo[] locations = blk.getLocations();
            String[] hosts = new String[locations.length];
            String[] xferAddrs = new String[locations.length];
            String[] racks = new String[locations.length];
            for (int hCnt = 0; hCnt < locations.length; ++hCnt) {
                hosts[hCnt] = locations[hCnt].getHostName();
                xferAddrs[hCnt] = locations[hCnt].getXferAddr();
                NodeBase node = new NodeBase(xferAddrs[hCnt], locations[hCnt].getNetworkLocation());
                racks[hCnt] = node.toString();
            }
            DatanodeInfo[] cachedLocations = blk.getCachedLocations();
            String[] cachedHosts = new String[cachedLocations.length];
            for (int i = 0; i < cachedLocations.length; ++i) {
                cachedHosts[i] = cachedLocations[i].getHostName();
            }
            blkLocations[idx] = new BlockLocation(xferAddrs, hosts, cachedHosts, racks, blk.getStorageIDs(), blk.getStartOffset(), blk.getBlockSize(), blk.isCorrupt());
            ++idx;
        }
        return blkLocations;
    }

    public static Collection<String> getNameServiceIds(Configuration conf) {
        return conf.getTrimmedStringCollection("dfs.nameservices");
    }

    private static Collection<String> emptyAsSingletonNull(Collection<String> coll) {
        if (coll == null || coll.isEmpty()) {
            return Collections.singletonList(null);
        }
        return coll;
    }

    public static Collection<String> getNameNodeIds(Configuration conf, String nsId) {
        String key = DFSUtil.addSuffix("dfs.ha.namenodes", nsId);
        return conf.getTrimmedStringCollection(key);
    }

    private static String getConfValue(String defaultValue, String keySuffix, Configuration conf, String ... keys) {
        String value = null;
        for (String key : keys) {
            value = conf.get(key = DFSUtil.addSuffix(key, keySuffix));
            if (value != null) break;
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private static String addSuffix(String key, String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return key;
        }
        assert (!suffix.startsWith(".")) : "suffix '" + suffix + "' should not already have '.' prepended.";
        return key + "." + suffix;
    }

    private static String concatSuffixes(String ... suffixes) {
        if (suffixes == null) {
            return null;
        }
        return Joiner.on((String)".").skipNulls().join((Object[])suffixes);
    }

    public static String addKeySuffixes(String key, String ... suffixes) {
        String keySuffix = DFSUtil.concatSuffixes(suffixes);
        return DFSUtil.addSuffix(key, keySuffix);
    }

    private static Map<String, Map<String, InetSocketAddress>> getAddresses(Configuration conf, String defaultAddress, String ... keys) {
        Collection<String> nameserviceIds = DFSUtil.getNameServiceIds(conf);
        return DFSUtil.getAddressesForNsIds(conf, nameserviceIds, defaultAddress, keys);
    }

    private static Map<String, Map<String, InetSocketAddress>> getAddressesForNsIds(Configuration conf, Collection<String> nsIds, String defaultAddress, String ... keys) {
        LinkedHashMap ret = Maps.newLinkedHashMap();
        for (String nsId : DFSUtil.emptyAsSingletonNull(nsIds)) {
            Map<String, InetSocketAddress> isas = DFSUtil.getAddressesForNameserviceId(conf, nsId, defaultAddress, keys);
            if (isas.isEmpty()) continue;
            ret.put(nsId, isas);
        }
        return ret;
    }

    public static Map<String, InetSocketAddress> getRpcAddressesForNameserviceId(Configuration conf, String nsId, String defaultValue) {
        return DFSUtil.getAddressesForNameserviceId(conf, nsId, defaultValue, "dfs.namenode.rpc-address");
    }

    private static Map<String, InetSocketAddress> getAddressesForNameserviceId(Configuration conf, String nsId, String defaultValue, String ... keys) {
        Collection<String> nnIds = DFSUtil.getNameNodeIds(conf, nsId);
        HashMap ret = Maps.newHashMap();
        for (String nnId : DFSUtil.emptyAsSingletonNull(nnIds)) {
            String suffix = DFSUtil.concatSuffixes(nsId, nnId);
            String address = DFSUtil.getConfValue(defaultValue, suffix, conf, keys);
            if (address == null) continue;
            InetSocketAddress isa = NetUtils.createSocketAddr((String)address);
            if (isa.isUnresolved()) {
                LOG.warn((Object)("Namenode for " + nsId + " remains unresolved for ID " + nnId + ".  Check your hdfs-site.xml file to " + "ensure namenodes are configured properly."));
            }
            ret.put(nnId, isa);
        }
        return ret;
    }

    public static Set<String> getAllNnPrincipals(Configuration conf) throws IOException {
        HashSet<String> principals = new HashSet<String>();
        for (String nsId : DFSUtil.getNameServiceIds(conf)) {
            if (HAUtil.isHAEnabled(conf, nsId)) {
                for (String nnId : DFSUtil.getNameNodeIds(conf, nsId)) {
                    Configuration confForNn = new Configuration(conf);
                    NameNode.initializeGenericKeys(confForNn, nsId, nnId);
                    String principal = SecurityUtil.getServerPrincipal((String)confForNn.get("dfs.namenode.kerberos.principal"), (String)NameNode.getAddress(confForNn).getHostName());
                    principals.add(principal);
                }
                continue;
            }
            Configuration confForNn = new Configuration(conf);
            NameNode.initializeGenericKeys(confForNn, nsId, null);
            String principal = SecurityUtil.getServerPrincipal((String)confForNn.get("dfs.namenode.kerberos.principal"), (String)NameNode.getAddress(confForNn).getHostName());
            principals.add(principal);
        }
        return principals;
    }

    public static Map<String, Map<String, InetSocketAddress>> getHaNnRpcAddresses(Configuration conf) {
        return DFSUtil.getAddresses(conf, null, "dfs.namenode.rpc-address");
    }

    public static Map<String, Map<String, InetSocketAddress>> getHaNnWebHdfsAddresses(Configuration conf, String scheme) {
        if ("webhdfs".equals(scheme)) {
            return DFSUtil.getAddresses(conf, null, "dfs.namenode.http-address");
        }
        if ("swebhdfs".equals(scheme)) {
            return DFSUtil.getAddresses(conf, null, "dfs.namenode.https-address");
        }
        throw new IllegalArgumentException("Unsupported scheme: " + scheme);
    }

    public static Map<String, Map<String, InetSocketAddress>> getBackupNodeAddresses(Configuration conf) throws IOException {
        Map<String, Map<String, InetSocketAddress>> addressList = DFSUtil.getAddresses(conf, null, "dfs.namenode.backup.address");
        if (addressList.isEmpty()) {
            throw new IOException("Incorrect configuration: backup node address dfs.namenode.backup.address is not configured.");
        }
        return addressList;
    }

    public static Map<String, Map<String, InetSocketAddress>> getSecondaryNameNodeAddresses(Configuration conf) throws IOException {
        Map<String, Map<String, InetSocketAddress>> addressList = DFSUtil.getAddresses(conf, null, "dfs.namenode.secondary.http-address");
        if (addressList.isEmpty()) {
            throw new IOException("Incorrect configuration: secondary namenode address dfs.namenode.secondary.http-address is not configured.");
        }
        return addressList;
    }

    public static Map<String, Map<String, InetSocketAddress>> getNNServiceRpcAddresses(Configuration conf) throws IOException {
        String defaultAddress;
        try {
            defaultAddress = NetUtils.getHostPortString((InetSocketAddress)NameNode.getAddress(conf));
        }
        catch (IllegalArgumentException e) {
            defaultAddress = null;
        }
        Map<String, Map<String, InetSocketAddress>> addressList = DFSUtil.getAddresses(conf, defaultAddress, "dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address");
        if (addressList.isEmpty()) {
            throw new IOException("Incorrect configuration: namenode address dfs.namenode.servicerpc-address or dfs.namenode.rpc-address is not configured.");
        }
        return addressList;
    }

    public static Map<String, Map<String, InetSocketAddress>> getNNServiceRpcAddressesForCluster(Configuration conf) throws IOException {
        String defaultAddress;
        try {
            defaultAddress = NetUtils.getHostPortString((InetSocketAddress)NameNode.getAddress(conf));
        }
        catch (IllegalArgumentException e) {
            defaultAddress = null;
        }
        Collection parentNameServices = conf.getTrimmedStringCollection("dfs.internal.nameservices");
        if (parentNameServices.isEmpty()) {
            parentNameServices = conf.getTrimmedStringCollection("dfs.nameservices");
        } else {
            HashSet availableNameServices = Sets.newHashSet((Iterable)conf.getTrimmedStringCollection("dfs.nameservices"));
            for (String nsId : parentNameServices) {
                if (availableNameServices.contains(nsId)) continue;
                throw new IOException("Unknown nameservice: " + nsId);
            }
        }
        Map<String, Map<String, InetSocketAddress>> addressList = DFSUtil.getAddressesForNsIds(conf, parentNameServices, defaultAddress, "dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address");
        if (addressList.isEmpty()) {
            throw new IOException("Incorrect configuration: namenode address dfs.namenode.servicerpc-address or dfs.namenode.rpc-address is not configured.");
        }
        return addressList;
    }

    public static List<ConfiguredNNAddress> flattenAddressMap(Map<String, Map<String, InetSocketAddress>> map) {
        ArrayList ret = Lists.newArrayList();
        for (Map.Entry<String, Map<String, InetSocketAddress>> entry : map.entrySet()) {
            String nsId = entry.getKey();
            Map<String, InetSocketAddress> nnMap = entry.getValue();
            for (Map.Entry<String, InetSocketAddress> e2 : nnMap.entrySet()) {
                String nnId = e2.getKey();
                InetSocketAddress addr = e2.getValue();
                ret.add(new ConfiguredNNAddress(nsId, nnId, addr));
            }
        }
        return ret;
    }

    public static String addressMapToString(Map<String, Map<String, InetSocketAddress>> map) {
        StringBuilder b = new StringBuilder();
        for (Map.Entry<String, Map<String, InetSocketAddress>> entry : map.entrySet()) {
            String nsId = entry.getKey();
            Map<String, InetSocketAddress> nnMap = entry.getValue();
            b.append("Nameservice <").append(nsId).append(">:").append("\n");
            for (Map.Entry<String, InetSocketAddress> e2 : nnMap.entrySet()) {
                b.append("  NN ID ").append(e2.getKey()).append(" => ").append(e2.getValue()).append("\n");
            }
        }
        return b.toString();
    }

    public static String nnAddressesAsString(Configuration conf) {
        Map<String, Map<String, InetSocketAddress>> addresses = DFSUtil.getHaNnRpcAddresses(conf);
        return DFSUtil.addressMapToString(addresses);
    }

    public static Collection<URI> getNsServiceRpcUris(Configuration conf) {
        return DFSUtil.getNameServiceUris(conf, "dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address");
    }

    public static Collection<URI> getNameServiceUris(Configuration conf, String ... keys) {
        HashSet<URI> ret = new HashSet<URI>();
        HashSet<URI> nonPreferredUris = new HashSet<URI>();
        for (String nsId : DFSUtil.getNameServiceIds(conf)) {
            if (HAUtil.isHAEnabled(conf, nsId)) {
                try {
                    ret.add(new URI("hdfs://" + nsId));
                    continue;
                }
                catch (URISyntaxException ue) {
                    throw new IllegalArgumentException(ue);
                }
            }
            boolean uriFound = false;
            for (String key : keys) {
                String addr = conf.get(DFSUtil.concatSuffixes(key, nsId));
                if (addr == null) continue;
                URI uri = DFSUtil.createUri("hdfs", NetUtils.createSocketAddr((String)addr));
                if (!uriFound) {
                    uriFound = true;
                    ret.add(uri);
                    continue;
                }
                nonPreferredUris.add(uri);
            }
        }
        boolean uriFound = false;
        for (String key : keys) {
            String addr = conf.get(key);
            if (addr == null) continue;
            URI uri = DFSUtil.createUri("hdfs", NetUtils.createSocketAddr((String)addr));
            if (!uriFound) {
                uriFound = true;
                ret.add(uri);
                continue;
            }
            nonPreferredUris.add(uri);
        }
        if (!uriFound) {
            URI defaultUri = FileSystem.getDefaultUri((Configuration)conf);
            if (defaultUri != null && defaultUri.getPort() != -1) {
                defaultUri = DFSUtil.createUri(defaultUri.getScheme(), NetUtils.createSocketAddr((String)defaultUri.getHost(), (int)defaultUri.getPort()));
            }
            if (defaultUri != null && "hdfs".equals(defaultUri.getScheme()) && !nonPreferredUris.contains(defaultUri)) {
                ret.add(defaultUri);
            }
        }
        return ret;
    }

    public static String getNameServiceIdFromAddress(Configuration conf, InetSocketAddress address, String ... keys) {
        String[] ids = DFSUtil.getSuffixIDs(conf, address, keys);
        return ids != null ? ids[0] : null;
    }

    public static URI getInfoServer(InetSocketAddress namenodeAddr, Configuration conf, String scheme) throws IOException {
        String authority;
        String[] suffixes = null;
        if (namenodeAddr != null) {
            suffixes = DFSUtil.getSuffixIDs(conf, namenodeAddr, "dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address");
        }
        if ("http".equals(scheme)) {
            authority = DFSUtil.getSuffixedConf(conf, "dfs.namenode.http-address", "0.0.0.0:50070", suffixes);
        } else if ("https".equals(scheme)) {
            authority = DFSUtil.getSuffixedConf(conf, "dfs.namenode.https-address", "0.0.0.0:50470", suffixes);
        } else {
            throw new IllegalArgumentException("Invalid scheme:" + scheme);
        }
        if (namenodeAddr != null) {
            authority = DFSUtil.substituteForWildcardAddress(authority, namenodeAddr.getHostName());
        }
        return URI.create(scheme + "://" + authority);
    }

    public static URI getInfoServerWithDefaultHost(String defaultHost, Configuration conf, String scheme) throws IOException {
        URI configuredAddr = DFSUtil.getInfoServer(null, conf, scheme);
        String authority = DFSUtil.substituteForWildcardAddress(configuredAddr.getAuthority(), defaultHost);
        return URI.create(scheme + "://" + authority);
    }

    public static String getHttpClientScheme(Configuration conf) {
        HttpConfig.Policy policy = DFSUtil.getHttpPolicy(conf);
        return policy == HttpConfig.Policy.HTTPS_ONLY ? "https" : "http";
    }

    @VisibleForTesting
    static String substituteForWildcardAddress(String configuredAddress, String defaultHost) {
        InetSocketAddress sockAddr = NetUtils.createSocketAddr((String)configuredAddress);
        InetAddress addr = sockAddr.getAddress();
        if (addr != null && addr.isAnyLocalAddress()) {
            return defaultHost + ":" + sockAddr.getPort();
        }
        return configuredAddress;
    }

    private static String getSuffixedConf(Configuration conf, String key, String defaultVal, String[] suffixes) {
        String ret = conf.get(DFSUtil.addKeySuffixes(key, suffixes));
        if (ret != null) {
            return ret;
        }
        return conf.get(key, defaultVal);
    }

    public static void setGenericConf(Configuration conf, String nameserviceId, String nnId, String ... keys) {
        for (String key : keys) {
            String value = conf.get(DFSUtil.addKeySuffixes(key, nameserviceId, nnId));
            if (value != null) {
                conf.set(key, value);
                continue;
            }
            value = conf.get(DFSUtil.addKeySuffixes(key, nameserviceId));
            if (value == null) continue;
            conf.set(key, value);
        }
    }

    public static float getPercentUsed(long used, long capacity) {
        return capacity <= 0L ? 100.0f : (float)used * 100.0f / (float)capacity;
    }

    public static float getPercentRemaining(long remaining, long capacity) {
        return capacity <= 0L ? 0.0f : (float)remaining * 100.0f / (float)capacity;
    }

    public static String percent2String(double percentage) {
        return StringUtils.format((String)"%.2f%%", (Object[])new Object[]{percentage});
    }

    public static int roundBytesToGB(long bytes) {
        return Math.round((float)bytes / 1024.0f / 1024.0f / 1024.0f);
    }

    public static ClientDatanodeProtocol createClientDatanodeProtocolProxy(DatanodeID datanodeid, Configuration conf, int socketTimeout, boolean connectToDnViaHostname, LocatedBlock locatedBlock) throws IOException {
        return new ClientDatanodeProtocolTranslatorPB(datanodeid, conf, socketTimeout, connectToDnViaHostname, locatedBlock);
    }

    public static ClientDatanodeProtocol createClientDatanodeProtocolProxy(DatanodeID datanodeid, Configuration conf, int socketTimeout, boolean connectToDnViaHostname) throws IOException {
        return new ClientDatanodeProtocolTranslatorPB(datanodeid, conf, socketTimeout, connectToDnViaHostname);
    }

    public static ClientDatanodeProtocol createClientDatanodeProtocolProxy(InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
        return new ClientDatanodeProtocolTranslatorPB(addr, ticket, conf, factory);
    }

    public static String getNamenodeNameServiceId(Configuration conf) {
        return DFSUtil.getNameServiceId(conf, "dfs.namenode.rpc-address");
    }

    public static String getBackupNameServiceId(Configuration conf) {
        return DFSUtil.getNameServiceId(conf, "dfs.namenode.backup.address");
    }

    public static String getSecondaryNameServiceId(Configuration conf) {
        return DFSUtil.getNameServiceId(conf, "dfs.namenode.secondary.http-address");
    }

    private static String getNameServiceId(Configuration conf, String addressKey) {
        String nameserviceId = conf.get("dfs.nameservice.id");
        if (nameserviceId != null) {
            return nameserviceId;
        }
        Collection<String> nsIds = DFSUtil.getNameServiceIds(conf);
        if (1 == nsIds.size()) {
            return nsIds.toArray(new String[1])[0];
        }
        String nnId = conf.get("dfs.ha.namenode.id");
        return DFSUtil.getSuffixIDs(conf, addressKey, null, nnId, LOCAL_ADDRESS_MATCHER)[0];
    }

    static String[] getSuffixIDs(Configuration conf, String addressKey, String knownNsId, String knownNNId, AddressMatcher matcher) {
        String nameserviceId = null;
        String namenodeId = null;
        int found = 0;
        Collection<String> nsIds = DFSUtil.getNameServiceIds(conf);
        for (String nsId : DFSUtil.emptyAsSingletonNull(nsIds)) {
            if (knownNsId != null && !knownNsId.equals(nsId)) continue;
            Collection<String> nnIds = DFSUtil.getNameNodeIds(conf, nsId);
            for (String nnId : DFSUtil.emptyAsSingletonNull(nnIds)) {
                String key;
                String addr;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)String.format("addressKey: %s nsId: %s nnId: %s", addressKey, nsId, nnId));
                }
                if (knownNNId != null && !knownNNId.equals(nnId) || (addr = conf.get(key = DFSUtil.addKeySuffixes(addressKey, nsId, nnId))) == null) continue;
                InetSocketAddress s = null;
                try {
                    s = NetUtils.createSocketAddr((String)addr);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Exception in creating socket address " + addr), (Throwable)e);
                    continue;
                }
                if (s.isUnresolved() || !matcher.match(s)) continue;
                nameserviceId = nsId;
                namenodeId = nnId;
                ++found;
            }
        }
        if (found > 1) {
            String msg = "Configuration has multiple addresses that match local node's address. Please configure the system with dfs.nameservice.id and dfs.ha.namenode.id";
            throw new HadoopIllegalArgumentException(msg);
        }
        return new String[]{nameserviceId, namenodeId};
    }

    static String[] getSuffixIDs(Configuration conf, final InetSocketAddress address, String ... keys) {
        AddressMatcher matcher = new AddressMatcher(){

            @Override
            public boolean match(InetSocketAddress s) {
                return address.equals(s);
            }
        };
        for (String key : keys) {
            String[] ids = DFSUtil.getSuffixIDs(conf, key, null, null, matcher);
            if (ids == null || ids[0] == null && ids[1] == null) continue;
            return ids;
        }
        return null;
    }

    public static URI createUri(String scheme, InetSocketAddress address) {
        try {
            return new URI(scheme, null, address.getHostName(), address.getPort(), null, null, null);
        }
        catch (URISyntaxException ue) {
            throw new IllegalArgumentException(ue);
        }
    }

    public static void addPBProtocol(Configuration conf, Class<?> protocol, BlockingService service, RPC.Server server) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, protocol, ProtobufRpcEngine.class);
        server.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, protocol, (Object)service);
    }

    public static String getNamenodeServiceAddr(Configuration conf, String nsId, String nnId) {
        if (nsId == null) {
            nsId = DFSUtil.getOnlyNameServiceIdOrNull(conf);
        }
        String serviceAddrKey = DFSUtil.concatSuffixes("dfs.namenode.servicerpc-address", nsId, nnId);
        String addrKey = DFSUtil.concatSuffixes("dfs.namenode.rpc-address", nsId, nnId);
        String serviceRpcAddr = conf.get(serviceAddrKey);
        if (serviceRpcAddr == null) {
            serviceRpcAddr = conf.get(addrKey);
        }
        return serviceRpcAddr;
    }

    public static String getOnlyNameServiceIdOrNull(Configuration conf) {
        Collection<String> nsIds = DFSUtil.getNameServiceIds(conf);
        if (1 == nsIds.size()) {
            return nsIds.toArray(new String[1])[0];
        }
        return null;
    }

    public static boolean parseHelpArgument(String[] args, String helpDescription, PrintStream out, boolean printGenericCommandUsage) {
        if (args.length == 1) {
            try {
                PosixParser parser = new PosixParser();
                CommandLine cmdLine = parser.parse(helpOptions, args);
                if (cmdLine.hasOption(helpOpt.getOpt()) || cmdLine.hasOption(helpOpt.getLongOpt())) {
                    out.println(helpDescription + "\n");
                    if (printGenericCommandUsage) {
                        ToolRunner.printGenericCommandUsage((PrintStream)out);
                    }
                    return true;
                }
            }
            catch (ParseException pe) {
                return false;
            }
        }
        return false;
    }

    public static float getInvalidateWorkPctPerIteration(Configuration conf) {
        float blocksInvalidateWorkPct = conf.getFloat("dfs.namenode.invalidate.work.pct.per.iteration", 0.32f);
        Preconditions.checkArgument((blocksInvalidateWorkPct > 0.0f && blocksInvalidateWorkPct <= 1.0f ? 1 : 0) != 0, (Object)("dfs.namenode.invalidate.work.pct.per.iteration = '" + blocksInvalidateWorkPct + "' is invalid. " + "It should be a positive, non-zero float value, not greater than 1.0f, " + "to indicate a percentage."));
        return blocksInvalidateWorkPct;
    }

    public static int getReplWorkMultiplier(Configuration conf) {
        int blocksReplWorkMultiplier = conf.getInt("dfs.namenode.replication.work.multiplier.per.iteration", 2);
        Preconditions.checkArgument((blocksReplWorkMultiplier > 0 ? 1 : 0) != 0, (Object)("dfs.namenode.replication.work.multiplier.per.iteration = '" + blocksReplWorkMultiplier + "' is invalid. " + "It should be a positive, non-zero integer value."));
        return blocksReplWorkMultiplier;
    }

    public static String getSpnegoKeytabKey(Configuration conf, String defaultKey) {
        String value = conf.get("dfs.web.authentication.kerberos.keytab");
        return value == null || value.isEmpty() ? defaultKey : "dfs.web.authentication.kerberos.keytab";
    }

    public static HttpConfig.Policy getHttpPolicy(Configuration conf) {
        String policyStr = conf.get("dfs.http.policy");
        if (policyStr == null) {
            boolean https = conf.getBoolean("dfs.https.enable", false);
            boolean hadoopSsl = conf.getBoolean("hadoop.ssl.enabled", false);
            if (hadoopSsl) {
                LOG.warn((Object)"hadoop.ssl.enabled is deprecated. Please use dfs.http.policy.");
            }
            if (https) {
                LOG.warn((Object)"dfs.https.enable is deprecated. Please use dfs.http.policy.");
            }
            return hadoopSsl || https ? HttpConfig.Policy.HTTP_AND_HTTPS : HttpConfig.Policy.HTTP_ONLY;
        }
        HttpConfig.Policy policy = HttpConfig.Policy.fromString((String)policyStr);
        if (policy == null) {
            throw new HadoopIllegalArgumentException("Unregonized value '" + policyStr + "' for " + "dfs.http.policy");
        }
        conf.set("dfs.http.policy", policy.name());
        return policy;
    }

    public static HttpServer2.Builder loadSslConfToHttpServerBuilder(HttpServer2.Builder builder, Configuration sslConf) {
        return builder.needsClientAuth(sslConf.getBoolean("dfs.client.https.need-auth", false)).keyPassword(DFSUtil.getPassword(sslConf, "ssl.server.keystore.keypassword")).keyStore(sslConf.get("ssl.server.keystore.location"), DFSUtil.getPassword(sslConf, "ssl.server.keystore.password"), sslConf.get("ssl.server.keystore.type", "jks")).trustStore(sslConf.get("ssl.server.truststore.location"), DFSUtil.getPassword(sslConf, "ssl.server.truststore.password"), sslConf.get("ssl.server.truststore.type", "jks"));
    }

    public static Configuration loadSslConfiguration(Configuration conf) {
        String[] reqSslProps;
        Configuration sslConf = new Configuration(false);
        sslConf.addResource(conf.get("dfs.https.server.keystore.resource", "ssl-server.xml"));
        for (String sslProp : reqSslProps = new String[]{"ssl.server.truststore.location", "ssl.server.keystore.location", "ssl.server.keystore.password", "ssl.server.keystore.keypassword"}) {
            if (sslConf.get(sslProp) != null) continue;
            LOG.warn((Object)("SSL config " + sslProp + " is missing. If " + "dfs.https.server.keystore.resource" + " is specified, make sure it is a relative path"));
        }
        boolean requireClientAuth = conf.getBoolean("dfs.client.https.need-auth", false);
        sslConf.setBoolean("dfs.client.https.need-auth", requireClientAuth);
        return sslConf;
    }

    public static HttpServer2.Builder httpServerTemplateForNNAndJN(Configuration conf, InetSocketAddress httpAddr, InetSocketAddress httpsAddr, String name, String spnegoUserNameKey, String spnegoKeytabFileKey) throws IOException {
        HttpConfig.Policy policy = DFSUtil.getHttpPolicy(conf);
        HttpServer2.Builder builder = new HttpServer2.Builder().setName(name).setConf(conf).setACL(new AccessControlList(conf.get("dfs.cluster.administrators", " "))).setSecurityEnabled(UserGroupInformation.isSecurityEnabled()).setUsernameConfKey(spnegoUserNameKey).setKeytabConfKey(DFSUtil.getSpnegoKeytabKey(conf, spnegoKeytabFileKey));
        if (UserGroupInformation.isSecurityEnabled()) {
            LOG.info((Object)("Starting web server as: " + SecurityUtil.getServerPrincipal((String)conf.get(spnegoUserNameKey), (String)httpAddr.getHostName())));
        }
        if (policy.isHttpEnabled()) {
            if (httpAddr.getPort() == 0) {
                builder.setFindPort(true);
            }
            URI uri = URI.create("http://" + NetUtils.getHostPortString((InetSocketAddress)httpAddr));
            builder.addEndpoint(uri);
            LOG.info((Object)("Starting Web-server for " + name + " at: " + uri));
        }
        if (policy.isHttpsEnabled() && httpsAddr != null) {
            Configuration sslConf = DFSUtil.loadSslConfiguration(conf);
            DFSUtil.loadSslConfToHttpServerBuilder(builder, sslConf);
            if (httpsAddr.getPort() == 0) {
                builder.setFindPort(true);
            }
            URI uri = URI.create("https://" + NetUtils.getHostPortString((InetSocketAddress)httpsAddr));
            builder.addEndpoint(uri);
            LOG.info((Object)("Starting Web-server for " + name + " at: " + uri));
        }
        return builder;
    }

    static String getPassword(Configuration conf, String alias) {
        String password = null;
        try {
            char[] passchars = conf.getPassword(alias);
            if (passchars != null) {
                password = new String(passchars);
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Setting password to null since IOException is caught when getting password", (Throwable)ioe);
            password = null;
        }
        return password;
    }

    public static String dateToIso8601String(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.ENGLISH);
        return df.format(date);
    }

    public static String durationToString(long durationMs) {
        boolean negative = false;
        if (durationMs < 0L) {
            negative = true;
            durationMs = -durationMs;
        }
        long durationSec = durationMs / 1000L;
        int secondsPerMinute = 60;
        int secondsPerHour = 3600;
        int secondsPerDay = 86400;
        long days = durationSec / 86400L;
        long hours = (durationSec -= days * 86400L) / 3600L;
        long minutes = (durationSec -= hours * 3600L) / 60L;
        long seconds = durationSec -= minutes * 60L;
        long milliseconds = durationMs % 1000L;
        String format = "%03d:%02d:%02d:%02d.%03d";
        if (negative) {
            format = "-" + format;
        }
        return String.format(format, days, hours, minutes, seconds, milliseconds);
    }

    public static long parseRelativeTime(String relTime) throws IOException {
        long ttl;
        if (relTime.length() < 2) {
            throw new IOException("Unable to parse relative time value of " + relTime + ": too short");
        }
        String ttlString = relTime.substring(0, relTime.length() - 1);
        try {
            ttl = Long.parseLong(ttlString);
        }
        catch (NumberFormatException e) {
            throw new IOException("Unable to parse relative time value of " + relTime + ": " + ttlString + " is not a number");
        }
        if (!relTime.endsWith("s")) {
            if (relTime.endsWith("m")) {
                ttl *= 60L;
            } else if (relTime.endsWith("h")) {
                ttl *= 3600L;
            } else if (relTime.endsWith("d")) {
                ttl *= 86400L;
            } else {
                throw new IOException("Unable to parse relative time value of " + relTime + ": unknown time unit " + relTime.charAt(relTime.length() - 1));
            }
        }
        return ttl * 1000L;
    }

    public static void assertAllResultsEqual(Collection<?> objects) throws AssertionError {
        if (objects.size() == 0 || objects.size() == 1) {
            return;
        }
        Object[] resultsArray = objects.toArray();
        for (int i = 1; i < resultsArray.length; ++i) {
            Object currElement = resultsArray[i];
            Object lastElement = resultsArray[i - 1];
            if (currElement == null && currElement != lastElement || currElement != null && !currElement.equals(lastElement)) {
                throw new AssertionError((Object)("Not all elements match in results: " + Arrays.toString(resultsArray)));
            }
        }
    }

    public static KeyProvider createKeyProvider(Configuration conf) throws IOException {
        URI providerUri;
        String providerUriStr = conf.getTrimmed("dfs.encryption.key.provider.uri", "");
        if (providerUriStr.isEmpty()) {
            return null;
        }
        try {
            providerUri = new URI(providerUriStr);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        KeyProvider keyProvider = KeyProviderFactory.get((URI)providerUri, (Configuration)conf);
        if (keyProvider == null) {
            throw new IOException("Could not instantiate KeyProvider from dfs.encryption.key.provider.uri setting of '" + providerUriStr + "'");
        }
        if (keyProvider.isTransient()) {
            throw new IOException("KeyProvider " + keyProvider.toString() + " was found but it is a transient provider.");
        }
        return keyProvider;
    }

    public static KeyProviderCryptoExtension createKeyProviderCryptoExtension(Configuration conf) throws IOException {
        KeyProvider keyProvider = DFSUtil.createKeyProvider(conf);
        if (keyProvider == null) {
            return null;
        }
        KeyProviderCryptoExtension cryptoProvider = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)keyProvider);
        return cryptoProvider;
    }

    public static boolean isHDFSEncryptionEnabled(Configuration conf) {
        return !conf.getTrimmed("dfs.encryption.key.provider.uri", "").isEmpty();
    }

    static {
        helpOptions.addOption(helpOpt);
    }

    private static interface AddressMatcher {
        public boolean match(InetSocketAddress var1);
    }

    public static class ConfiguredNNAddress {
        private final String nameserviceId;
        private final String namenodeId;
        private final InetSocketAddress addr;

        private ConfiguredNNAddress(String nameserviceId, String namenodeId, InetSocketAddress addr) {
            this.nameserviceId = nameserviceId;
            this.namenodeId = namenodeId;
            this.addr = addr;
        }

        public String getNameserviceId() {
            return this.nameserviceId;
        }

        public String getNamenodeId() {
            return this.namenodeId;
        }

        public InetSocketAddress getAddress() {
            return this.addr;
        }

        public String toString() {
            return "ConfiguredNNAddress[nsId=" + this.nameserviceId + ";" + "nnId=" + this.namenodeId + ";addr=" + this.addr + "]";
        }
    }

    @InterfaceAudience.Private
    public static class DecomStaleComparator
    implements Comparator<DatanodeInfo> {
        private final long staleInterval;

        public DecomStaleComparator(long interval) {
            this.staleInterval = interval;
        }

        @Override
        public int compare(DatanodeInfo a, DatanodeInfo b) {
            boolean bStale;
            if (a.isDecommissioned()) {
                return b.isDecommissioned() ? 0 : 1;
            }
            if (b.isDecommissioned()) {
                return -1;
            }
            boolean aStale = a.isStale(this.staleInterval);
            return aStale == (bStale = b.isStale(this.staleInterval)) ? 0 : (aStale ? 1 : -1);
        }
    }
}

