/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.org.apache.http.protocol;

import com.cloudera.org.apache.http.HttpException;
import com.cloudera.org.apache.http.HttpRequest;
import com.cloudera.org.apache.http.HttpRequestInterceptor;
import com.cloudera.org.apache.http.annotation.Immutable;
import com.cloudera.org.apache.http.protocol.HttpContext;
import java.io.IOException;

@Immutable
public class RequestConnControl
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

