/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.fasterxml.jackson.databind.deser.std;

import com.cloudera.com.fasterxml.jackson.annotation.JsonFormat;
import com.cloudera.com.fasterxml.jackson.core.JsonParser;
import com.cloudera.com.fasterxml.jackson.core.JsonProcessingException;
import com.cloudera.com.fasterxml.jackson.core.JsonToken;
import com.cloudera.com.fasterxml.jackson.databind.BeanProperty;
import com.cloudera.com.fasterxml.jackson.databind.DeserializationContext;
import com.cloudera.com.fasterxml.jackson.databind.JsonDeserializer;
import com.cloudera.com.fasterxml.jackson.databind.JsonMappingException;
import com.cloudera.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.cloudera.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.cloudera.com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.cloudera.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.cloudera.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.cloudera.com.fasterxml.jackson.databind.introspect.Annotated;
import com.cloudera.com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.TimeZone;

public class DateDeserializers {
    private static final HashSet<String> _classNames;

    @Deprecated
    public static StdDeserializer<?>[] all() {
        return new StdDeserializer[]{CalendarDeserializer.instance, DateDeserializer.instance, CalendarDeserializer.gregorianInstance, SqlDateDeserializer.instance, TimestampDeserializer.instance, TimeZoneDeserializer.instance};
    }

    public static JsonDeserializer<?> find(Class<?> clazz, String string) {
        if (!_classNames.contains(string)) {
            return null;
        }
        if (clazz == Calendar.class) {
            return CalendarDeserializer.instance;
        }
        if (clazz == java.util.Date.class) {
            return DateDeserializer.instance;
        }
        if (clazz == Date.class) {
            return SqlDateDeserializer.instance;
        }
        if (clazz == Timestamp.class) {
            return TimestampDeserializer.instance;
        }
        if (clazz == TimeZone.class) {
            return TimeZoneDeserializer.instance;
        }
        if (clazz == GregorianCalendar.class) {
            return CalendarDeserializer.gregorianInstance;
        }
        throw new IllegalArgumentException("Internal error: can't find deserializer for " + string);
    }

    static {
        Class[] classArray;
        _classNames = new HashSet();
        for (Class clazz : classArray = new Class[]{Calendar.class, GregorianCalendar.class, Date.class, java.util.Date.class, Timestamp.class, TimeZone.class}) {
            _classNames.add(clazz.getName());
        }
    }

    protected static class TimeZoneDeserializer
    extends FromStringDeserializer<TimeZone> {
        public static final TimeZoneDeserializer instance = new TimeZoneDeserializer();

        public TimeZoneDeserializer() {
            super(TimeZone.class);
        }

        @Override
        protected TimeZone _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
            return TimeZone.getTimeZone(string);
        }
    }

    public static class TimestampDeserializer
    extends DateBasedDeserializer<Timestamp> {
        public static final TimestampDeserializer instance = new TimestampDeserializer();

        public TimestampDeserializer() {
            super(Timestamp.class);
        }

        public TimestampDeserializer(TimestampDeserializer timestampDeserializer, DateFormat dateFormat, String string) {
            super(timestampDeserializer, dateFormat, string);
        }

        protected TimestampDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new TimestampDeserializer(this, dateFormat, string);
        }

        @Override
        public Timestamp deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return new Timestamp(this._parseDate(jsonParser, deserializationContext).getTime());
        }
    }

    public static class SqlDateDeserializer
    extends DateBasedDeserializer<Date> {
        public static final SqlDateDeserializer instance = new SqlDateDeserializer();

        public SqlDateDeserializer() {
            super(Date.class);
        }

        public SqlDateDeserializer(SqlDateDeserializer sqlDateDeserializer, DateFormat dateFormat, String string) {
            super(sqlDateDeserializer, dateFormat, string);
        }

        protected SqlDateDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new SqlDateDeserializer(this, dateFormat, string);
        }

        @Override
        public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            java.util.Date date = this._parseDate(jsonParser, deserializationContext);
            return date == null ? null : new Date(date.getTime());
        }
    }

    public static class DateDeserializer
    extends DateBasedDeserializer<java.util.Date> {
        public static final DateDeserializer instance = new DateDeserializer();

        public DateDeserializer() {
            super(java.util.Date.class);
        }

        public DateDeserializer(DateDeserializer dateDeserializer, DateFormat dateFormat, String string) {
            super(dateDeserializer, dateFormat, string);
        }

        protected DateDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new DateDeserializer(this, dateFormat, string);
        }

        @Override
        public java.util.Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return this._parseDate(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    public static class CalendarDeserializer
    extends DateBasedDeserializer<Calendar> {
        public static final CalendarDeserializer instance = new CalendarDeserializer();
        public static final CalendarDeserializer gregorianInstance = new CalendarDeserializer((Class<? extends Calendar>)GregorianCalendar.class);
        protected final Class<? extends Calendar> _calendarClass;

        public CalendarDeserializer() {
            super(Calendar.class);
            this._calendarClass = null;
        }

        public CalendarDeserializer(Class<? extends Calendar> clazz) {
            super(clazz);
            this._calendarClass = clazz;
        }

        public CalendarDeserializer(CalendarDeserializer calendarDeserializer, DateFormat dateFormat, String string) {
            super(calendarDeserializer, dateFormat, string);
            this._calendarClass = calendarDeserializer._calendarClass;
        }

        protected CalendarDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new CalendarDeserializer(this, dateFormat, string);
        }

        @Override
        public Calendar deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            java.util.Date date = this._parseDate(jsonParser, deserializationContext);
            if (date == null) {
                return null;
            }
            if (this._calendarClass == null) {
                return deserializationContext.constructCalendar(date);
            }
            try {
                Calendar calendar = this._calendarClass.newInstance();
                calendar.setTimeInMillis(date.getTime());
                TimeZone timeZone = deserializationContext.getTimeZone();
                if (timeZone != null) {
                    calendar.setTimeZone(timeZone);
                }
                return calendar;
            }
            catch (Exception exception) {
                throw deserializationContext.instantiationException(this._calendarClass, exception);
            }
        }
    }

    protected static abstract class DateBasedDeserializer<T>
    extends StdScalarDeserializer<T>
    implements ContextualDeserializer {
        protected final DateFormat _customFormat;
        protected final String _formatString;

        protected DateBasedDeserializer(Class<?> clazz) {
            super(clazz);
            this._customFormat = null;
            this._formatString = null;
        }

        protected DateBasedDeserializer(DateBasedDeserializer<T> dateBasedDeserializer, DateFormat dateFormat, String string) {
            super(dateBasedDeserializer._valueClass);
            this._customFormat = dateFormat;
            this._formatString = string;
        }

        protected abstract DateBasedDeserializer<T> withDateFormat(DateFormat var1, String var2);

        @Override
        public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
            JsonFormat.Value value;
            if (beanProperty != null && (value = deserializationContext.getAnnotationIntrospector().findFormat((Annotated)beanProperty.getMember())) != null) {
                TimeZone timeZone = value.getTimeZone();
                String string = value.getPattern();
                if (string.length() > 0) {
                    Locale locale = value.getLocale();
                    if (locale == null) {
                        locale = deserializationContext.getLocale();
                    }
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
                    if (timeZone == null) {
                        timeZone = deserializationContext.getTimeZone();
                    }
                    simpleDateFormat.setTimeZone(timeZone);
                    return this.withDateFormat(simpleDateFormat, string);
                }
                if (timeZone != null) {
                    DateFormat dateFormat = deserializationContext.getConfig().getDateFormat();
                    if (dateFormat.getClass() == StdDateFormat.class) {
                        dateFormat = ((StdDateFormat)dateFormat).withTimeZone(timeZone);
                    } else {
                        dateFormat = (DateFormat)dateFormat.clone();
                        dateFormat.setTimeZone(timeZone);
                    }
                    return this.withDateFormat(dateFormat, string);
                }
            }
            return this;
        }

        @Override
        protected java.util.Date _parseDate(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (this._customFormat != null && jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
                String string = jsonParser.getText().trim();
                if (string.length() == 0) {
                    return (java.util.Date)this.getEmptyValue();
                }
                DateFormat dateFormat = this._customFormat;
                synchronized (dateFormat) {
                    try {
                        return this._customFormat.parse(string);
                    }
                    catch (ParseException parseException) {
                        throw new IllegalArgumentException("Failed to parse Date value '" + string + "' (format: \"" + this._formatString + "\"): " + parseException.getMessage());
                    }
                }
            }
            return super._parseDate(jsonParser, deserializationContext);
        }
    }
}

