/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.internal;

import com.cloudera.com.amazonaws.annotation.NotThreadSafe;
import com.cloudera.com.amazonaws.internal.ServiceEndpointBuilder;
import com.cloudera.com.amazonaws.regions.Region;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@NotThreadSafe
public class DefaultServiceEndpointBuilder
extends ServiceEndpointBuilder {
    private static final Log log = LogFactory.getLog(DefaultServiceEndpointBuilder.class);
    private final String serviceName;
    private final String protocol;
    private Region region;

    public DefaultServiceEndpointBuilder(String serviceName, String protocol) {
        this.serviceName = serviceName;
        this.protocol = protocol;
    }

    @Override
    public DefaultServiceEndpointBuilder withRegion(Region region) {
        this.region = region;
        return this;
    }

    @Override
    public URI getServiceEndpoint() {
        String serviceEndpoint;
        if (this.region.isServiceSupported(this.serviceName)) {
            serviceEndpoint = this.stripProtocol(this.region.getServiceEndpoint(this.serviceName));
        } else {
            serviceEndpoint = String.format("%s.%s.%s", this.serviceName, this.region.getName(), this.region.getDomain());
            log.info((Object)("{" + this.serviceName + ", " + this.region.getName() + "} was not " + "found in region metadata, trying to construct an " + "endpoint using the standard pattern for this region: '" + serviceEndpoint + "'."));
        }
        return this.toURI(serviceEndpoint);
    }

    private String stripProtocol(String endpoint) {
        int protocolIndex = endpoint.indexOf("://");
        return protocolIndex >= 0 ? endpoint.substring(protocolIndex + "://".length()) : endpoint;
    }

    private URI toURI(String endpoint) throws IllegalArgumentException {
        try {
            return new URI(String.format("%s://%s", this.protocol, endpoint));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Region getRegion() {
        return this.region;
    }
}

