/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.api;

import java.net.InetSocketAddress;
import java.util.Properties;
import org.apache.flume.FlumeException;
import org.apache.flume.api.AbstractRpcClient;
import org.apache.flume.api.NettyAvroRpcClient;
import org.apache.flume.api.RpcClient;

public class RpcClientFactory {
    private static final String CONF_CLIENT_TYPE = "client.type";

    public static RpcClient getInstance(Properties properties) throws FlumeException {
        AbstractRpcClient client;
        Class<?> clazz;
        String type = null;
        type = properties.getProperty(CONF_CLIENT_TYPE);
        if (type == null || type.isEmpty()) {
            type = ClientType.DEFAULT.getClientClassName();
        }
        try {
            String clientClassType = type;
            ClientType clientType = null;
            try {
                clientType = ClientType.valueOf(type.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                clientType = ClientType.OTHER;
            }
            if (!clientType.equals((Object)ClientType.OTHER)) {
                clientClassType = clientType.getClientClassName();
            }
            clazz = Class.forName(clientClassType);
        }
        catch (ClassNotFoundException e) {
            throw new FlumeException("No such client!", e);
        }
        try {
            client = (AbstractRpcClient)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new FlumeException("Cannot instantiate client. Exception follows:", e);
        }
        catch (IllegalAccessException e) {
            throw new FlumeException("Cannot instantiate client. Exception follows:", e);
        }
        client.configure(properties);
        return client;
    }

    @Deprecated
    public static RpcClient getInstance(String hostname, Integer port) throws FlumeException {
        return RpcClientFactory.getDefaultInstance(hostname, port);
    }

    public static RpcClient getDefaultInstance(String hostname, Integer port) throws FlumeException {
        return RpcClientFactory.getDefaultInstance(hostname, port, 0);
    }

    @Deprecated
    public static RpcClient getInstance(String hostname, Integer port, Integer batchSize) throws FlumeException {
        return RpcClientFactory.getDefaultInstance(hostname, port, batchSize);
    }

    public static RpcClient getDefaultInstance(String hostname, Integer port, Integer batchSize) throws FlumeException {
        NettyAvroRpcClient client = new NettyAvroRpcClient(new InetSocketAddress(hostname, (int)port), batchSize);
        return client;
    }

    private static enum ClientType {
        OTHER(null),
        DEFAULT("org.apache.flume.api.NettyAvroRpcClient"),
        DEFAULT_FAILOVER("org.apache.flume.api.FailoverRpcClient");

        private final String clientClassName;

        private ClientType(String className) {
            this.clientClassName = className;
        }

        protected String getClientClassName() {
            return this.clientClassName;
        }
    }
}

