/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.api;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.avro.ipc.CallFuture;
import org.apache.avro.ipc.Callback;
import org.apache.avro.ipc.NettyTransceiver;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.api.AbstractRpcClient;
import org.apache.flume.api.RpcClient;
import org.apache.flume.source.avro.AvroFlumeEvent;
import org.apache.flume.source.avro.AvroSourceProtocol;
import org.apache.flume.source.avro.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyAvroRpcClient
extends AbstractRpcClient
implements RpcClient {
    private final ReentrantLock stateLock = new ReentrantLock();
    private static final long DEFAULT_CONNECT_TIMEOUT_MILLIS = TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    private static final long DEFAULT_REQUEST_TIMEOUT_MILLIS = TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    private ConnState connState;
    private InetSocketAddress address;
    private Transceiver transceiver;
    private AvroSourceProtocol.Callback avroClient;
    private static final Logger logger = LoggerFactory.getLogger(NettyAvroRpcClient.class);

    protected NettyAvroRpcClient(InetSocketAddress address, Integer batchSize) throws FlumeException {
        if (address == null) {
            logger.error("InetSocketAddress is null, cannot create client.");
            throw new NullPointerException("InetSocketAddress is null");
        }
        this.address = address;
        this.batchSize = batchSize == null || batchSize == 0 ? DEFAULT_BATCH_SIZE : batchSize;
        this.connect();
    }

    protected NettyAvroRpcClient() {
    }

    private void connect() throws FlumeException {
        this.connect(DEFAULT_CONNECT_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
    }

    private void connect(long timeout, TimeUnit tu) throws FlumeException {
        try {
            this.transceiver = new NettyTransceiver(this.address, Long.valueOf(tu.toMillis(timeout)));
            this.avroClient = (AvroSourceProtocol.Callback)SpecificRequestor.getClient(AvroSourceProtocol.Callback.class, (Transceiver)this.transceiver);
        }
        catch (IOException ex) {
            logger.error("RPC connection error :", (Throwable)ex);
            throw new FlumeException("RPC connection error. Exception follows.", ex);
        }
        this.setState(ConnState.READY);
    }

    @Override
    public void close() throws FlumeException {
        try {
            this.transceiver.close();
        }
        catch (IOException ex) {
            logger.error("Error closing transceiver. ", (Throwable)ex);
            throw new FlumeException("Error closing transceiver. Exception follows.", ex);
        }
        finally {
            this.setState(ConnState.DEAD);
        }
    }

    @Override
    public void append(Event event) throws EventDeliveryException {
        try {
            this.append(event, DEFAULT_REQUEST_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        }
        catch (EventDeliveryException e) {
            this.setState(ConnState.DEAD);
            throw e;
        }
    }

    private void append(Event event, long timeout, TimeUnit tu) throws EventDeliveryException {
        this.assertReady();
        CallFuture callFuture = new CallFuture();
        try {
            AvroFlumeEvent avroEvent = new AvroFlumeEvent();
            avroEvent.setBody(ByteBuffer.wrap(event.getBody()));
            avroEvent.setHeaders(NettyAvroRpcClient.toCharSeqMap(event.getHeaders()));
            this.avroClient.append(avroEvent, (Callback<Status>)callFuture);
        }
        catch (IOException ex) {
            logger.error("RPC request IO exception. ", (Throwable)ex);
            throw new EventDeliveryException("RPC request IO exception. Exception follows.", ex);
        }
        NettyAvroRpcClient.waitForStatusOK((CallFuture<Status>)callFuture, timeout, tu);
    }

    @Override
    public void appendBatch(List<Event> events) throws EventDeliveryException {
        try {
            this.appendBatch(events, DEFAULT_REQUEST_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        }
        catch (EventDeliveryException e) {
            this.setState(ConnState.DEAD);
            throw e;
        }
    }

    private void appendBatch(List<Event> events, long timeout, TimeUnit tu) throws EventDeliveryException {
        this.assertReady();
        Iterator<Event> iter = events.iterator();
        LinkedList<AvroFlumeEvent> avroEvents = new LinkedList<AvroFlumeEvent>();
        while (iter.hasNext()) {
            avroEvents.clear();
            for (int i = 0; i < this.batchSize && iter.hasNext(); ++i) {
                Event event = iter.next();
                AvroFlumeEvent avroEvent = new AvroFlumeEvent();
                avroEvent.setBody(ByteBuffer.wrap(event.getBody()));
                avroEvent.setHeaders(NettyAvroRpcClient.toCharSeqMap(event.getHeaders()));
                avroEvents.add(avroEvent);
            }
            CallFuture callFuture = new CallFuture();
            try {
                this.avroClient.appendBatch(avroEvents, (Callback<Status>)callFuture);
            }
            catch (IOException ex) {
                logger.error("RPC request IO exception. ", (Throwable)ex);
                throw new EventDeliveryException("RPC request IO exception. Exception follows.", ex);
            }
            NettyAvroRpcClient.waitForStatusOK((CallFuture<Status>)callFuture, timeout, tu);
        }
    }

    private static void waitForStatusOK(CallFuture<Status> callFuture, long timeout, TimeUnit tu) throws EventDeliveryException {
        try {
            Status status = (Status)((Object)callFuture.get(timeout, tu));
            if (status != Status.OK) {
                logger.error("Status (" + (Object)((Object)status) + ") is not OK");
                throw new EventDeliveryException("Status (" + (Object)((Object)status) + ") is not OK");
            }
        }
        catch (CancellationException ex) {
            logger.error("RPC future was cancelled.", (Throwable)ex);
            throw new EventDeliveryException("RPC future was cancelled. Exception follows.", ex);
        }
        catch (ExecutionException ex) {
            logger.error("Exception thrown from remote handler.", (Throwable)ex);
            throw new EventDeliveryException("Exception thrown from remote handler. Exception follows.", ex);
        }
        catch (TimeoutException ex) {
            logger.error("RPC request timed out.", (Throwable)ex);
            throw new EventDeliveryException("RPC request timed out. Exception follows.", ex);
        }
        catch (InterruptedException ex) {
            logger.error("RPC request interrupted.", (Throwable)ex);
            Thread.currentThread().interrupt();
            throw new EventDeliveryException("RPC request interrupted. Exception follows.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(ConnState newState) {
        this.stateLock.lock();
        try {
            if (this.connState == ConnState.DEAD && this.connState != newState) {
                logger.error("Cannot transition from CLOSED state.");
                throw new IllegalStateException("Cannot transition from CLOSED state.");
            }
            this.connState = newState;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertReady() throws EventDeliveryException {
        this.stateLock.lock();
        try {
            ConnState curState = this.connState;
            if (curState != ConnState.READY) {
                logger.error("RPC failed, client in an invalid state: " + (Object)((Object)curState));
                throw new EventDeliveryException("RPC failed, client in an invalid state: " + (Object)((Object)curState));
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private static Map<CharSequence, CharSequence> toCharSeqMap(Map<String, String> stringMap) {
        HashMap<CharSequence, CharSequence> charSeqMap = new HashMap<CharSequence, CharSequence>();
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            charSeqMap.put(entry.getKey(), entry.getValue());
        }
        return charSeqMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        this.stateLock.lock();
        try {
            boolean bl = this.connState == ConnState.READY;
            return bl;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void configure(Properties properties) throws FlumeException {
        this.stateLock.lock();
        try {
            if (this.connState == ConnState.READY || this.connState == ConnState.DEAD) {
                logger.error("This client was already configured, cannot reconfigure.");
                throw new FlumeException("This client was already configured, cannot reconfigure.");
            }
        }
        finally {
            this.stateLock.unlock();
        }
        String strbatchSize = properties.getProperty("batch-size");
        this.batchSize = DEFAULT_BATCH_SIZE;
        if (strbatchSize != null && !strbatchSize.isEmpty()) {
            try {
                this.batchSize = Integer.parseInt(strbatchSize);
            }
            catch (NumberFormatException e) {
                logger.warn("Batchsize is not valid for RpcClient: " + strbatchSize + ".Default value assigned.", (Throwable)e);
            }
        }
        String hostNames = properties.getProperty("hosts");
        String[] hosts = null;
        if (hostNames == null || hostNames.isEmpty()) {
            logger.error("Hosts list is invalid: " + hostNames);
            throw new FlumeException("Hosts list is invalid: " + hostNames);
        }
        hosts = hostNames.split("\\s+");
        String host = properties.getProperty("hosts." + hosts[0]);
        if (host == null || host.isEmpty()) {
            logger.error("Host not found: " + hosts[0]);
            throw new FlumeException("Host not found: " + hosts[0]);
        }
        String[] hostAndPort = host.split(":");
        if (hostAndPort.length != 2) {
            logger.error("Invalid hostname, " + hosts[0]);
            throw new FlumeException("Invalid hostname, " + hosts[0]);
        }
        Integer port = null;
        try {
            port = Integer.parseInt(hostAndPort[1]);
        }
        catch (NumberFormatException e) {
            logger.error("Invalid Port:" + hostAndPort[1], (Throwable)e);
            throw new FlumeException("Invalid Port:" + hostAndPort[1], e);
        }
        this.address = new InetSocketAddress(hostAndPort[0], (int)port);
        this.connect();
    }

    private static enum ConnState {
        INIT,
        READY,
        DEAD;

    }
}

