/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.api;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.api.AbstractRpcClient;
import org.apache.flume.api.RpcClient;
import org.apache.flume.api.RpcClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverRpcClient
extends AbstractRpcClient
implements RpcClient {
    private volatile RpcClient client = null;
    private List<InetSocketAddress> hosts;
    private Integer maxTries;
    private int lastCheckedhost = -1;
    private boolean isActive;
    private static final String CONFIG_MAX_ATTEMPTS = "max-attempts";
    private static final Logger logger = LoggerFactory.getLogger(FailoverRpcClient.class);

    protected FailoverRpcClient() {
    }

    private synchronized void configureHosts(Properties properties) throws FlumeException {
        Integer batchSize;
        String tries;
        if (this.isActive) {
            logger.error("This client was already configured, cannot reconfigure.");
            throw new FlumeException("This client was already configured, cannot reconfigure.");
        }
        this.hosts = new ArrayList<InetSocketAddress>();
        String hostNames = properties.getProperty("hosts");
        if (hostNames != null && !hostNames.isEmpty()) {
            String[] hostList = hostNames.split("\\s+");
            for (int i = 0; i < hostList.length; ++i) {
                String hostAndPortStr = properties.getProperty("hosts." + hostList[i]);
                if (hostAndPortStr == null) continue;
                String[] hostAndPort = hostAndPortStr.split(":");
                if (hostAndPort.length != 2) {
                    logger.error("Invalid host address" + hostAndPortStr);
                    throw new FlumeException("Invalid host address" + hostAndPortStr);
                }
                Integer port = null;
                try {
                    port = Integer.parseInt(hostAndPort[1]);
                }
                catch (NumberFormatException e) {
                    logger.error("Invalid port number" + hostAndPortStr, (Throwable)e);
                    throw new FlumeException("Invalid port number" + hostAndPortStr);
                }
                this.hosts.add(new InetSocketAddress(hostAndPort[0].trim(), (int)port));
            }
        }
        if ((tries = properties.getProperty(CONFIG_MAX_ATTEMPTS)) == null || tries.isEmpty()) {
            this.maxTries = this.hosts.size();
        } else {
            try {
                this.maxTries = Integer.parseInt(tries);
            }
            catch (NumberFormatException e) {
                this.maxTries = this.hosts.size();
            }
        }
        try {
            batchSize = Integer.parseInt(properties.getProperty("batch-size"));
            if (batchSize == null) {
                logger.warn("No batch size found - assigning default size");
                batchSize = DEFAULT_BATCH_SIZE;
            }
        }
        catch (NumberFormatException e) {
            logger.warn("Batch Size {} is invalid - assigning default size", (Object)properties.getProperty("batch-size"), (Object)e);
            batchSize = DEFAULT_BATCH_SIZE;
        }
        this.isActive = true;
    }

    protected Integer getMaxTries() {
        return this.maxTries;
    }

    private synchronized RpcClient getClient() {
        if (this.client == null || !this.client.isActive()) {
            this.client = this.getNextClient();
            return this.client;
        }
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(Event event) throws EventDeliveryException {
        RpcClient localClient = null;
        FailoverRpcClient failoverRpcClient = this;
        synchronized (failoverRpcClient) {
            if (!this.isActive) {
                logger.error("Attempting to append to an already closed client.");
                throw new EventDeliveryException("Attempting to append to an already closed client.");
            }
        }
        int tries = 0;
        while (tries < this.maxTries) {
            try {
                ++tries;
                localClient = this.getClient();
                localClient.append(event);
                return;
            }
            catch (EventDeliveryException e) {
                logger.warn("Client failed. Exception follows: ", (Throwable)e);
                localClient.close();
                localClient = null;
            }
            catch (Exception e2) {
                logger.error("Failed to send event: ", (Throwable)e2);
                throw new EventDeliveryException("Failed to send event. Exception follows: ", e2);
            }
        }
        logger.error("Tried many times, could not send event.");
        throw new EventDeliveryException("Failed to send the event!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendBatch(List<Event> events) throws EventDeliveryException {
        RpcClient localClient = null;
        FailoverRpcClient failoverRpcClient = this;
        synchronized (failoverRpcClient) {
            if (!this.isActive) {
                logger.error("Attempting to append to an already closed client.");
                throw new EventDeliveryException("Attempting to append to an already closed client!");
            }
        }
        int tries = 0;
        while (tries < this.maxTries) {
            try {
                ++tries;
                localClient = this.getClient();
                localClient.appendBatch(events);
                return;
            }
            catch (EventDeliveryException e) {
                logger.warn("Client failed. Exception follows: ", (Throwable)e);
                localClient.close();
                localClient = null;
            }
            catch (Exception e1) {
                logger.error("No clients active: ", (Throwable)e1);
                throw new EventDeliveryException("No clients currently active. Exception follows: ", e1);
            }
        }
        logger.error("Tried many times, could not send event.");
        throw new EventDeliveryException("Failed to send the event!");
    }

    @Override
    public synchronized boolean isActive() {
        return this.isActive;
    }

    @Override
    public synchronized void close() throws FlumeException {
        if (this.client != null) {
            this.client.close();
            this.isActive = false;
        }
    }

    protected InetSocketAddress getLastConnectedServerAddress() {
        return this.hosts.get(this.lastCheckedhost);
    }

    private RpcClient getNextClient() throws FlumeException {
        int count;
        this.lastCheckedhost = this.lastCheckedhost == this.hosts.size() - 1 ? -1 : this.lastCheckedhost;
        RpcClient localClient = null;
        int limit = this.hosts.size();
        for (count = this.lastCheckedhost + 1; count < limit; ++count) {
            try {
                localClient = RpcClientFactory.getDefaultInstance(this.hosts.get(count).getHostName(), this.hosts.get(count).getPort());
                this.lastCheckedhost = count;
                return localClient;
            }
            catch (FlumeException e) {
                logger.info("Could not connect to " + this.hosts.get(count).getHostName() + ":" + String.valueOf(this.hosts.get(count).getPort()), (Throwable)e);
                continue;
            }
        }
        for (count = 0; count <= this.lastCheckedhost; ++count) {
            try {
                localClient = RpcClientFactory.getDefaultInstance(this.hosts.get(count).getHostName(), this.hosts.get(count).getPort());
                this.lastCheckedhost = count;
                return localClient;
            }
            catch (FlumeException e) {
                logger.info("Could not connect to " + this.hosts.get(count).getHostName() + ":" + String.valueOf(this.hosts.get(count).getPort()), (Throwable)e);
                continue;
            }
        }
        if (localClient == null) {
            this.lastCheckedhost = -1;
            logger.error("No active client found.");
            throw new FlumeException("No active client.");
        }
        return localClient;
    }

    @Override
    public void configure(Properties properties) throws FlumeException {
        this.configureHosts(properties);
    }
}

