/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.recoverable.memory.wal;

import com.google.common.base.Throwables;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.apache.flume.tools.DirectMemoryUtils;
import org.apache.hadoop.util.IndexedSortable;
import org.apache.hadoop.util.QuickSort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceIDBuffer
implements IndexedSortable {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceIDBuffer.class);
    private static final int SIZE_OF_LONG = 8;
    private LongBuffer buffer;
    private ByteBuffer backingBuffer;

    public SequenceIDBuffer(int size) {
        int bytesRequired = size * 8;
        this.backingBuffer = DirectMemoryUtils.allocate((int)bytesRequired);
        this.buffer = this.backingBuffer.asLongBuffer();
    }

    public int compare(int leftIndex, int rightIndex) {
        long right;
        long left = this.get(leftIndex);
        return left < (right = this.get(rightIndex)) ? -1 : (left == right ? 0 : 1);
    }

    public boolean exists(long value) {
        return this.binarySearch(value) >= 0;
    }

    private int binarySearch(long value) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = this.get(mid);
            if (midVal < value) {
                low = mid + 1;
                continue;
            }
            if (midVal > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public void swap(int leftIndex, int rightIndex) {
        long left = this.get(leftIndex);
        long right = this.get(rightIndex);
        this.put(leftIndex, right);
        this.put(rightIndex, left);
    }

    public long get(int index) {
        return this.buffer.get(index);
    }

    public void put(int index, long value) {
        this.buffer.put(index, value);
    }

    public int size() {
        return this.buffer.limit();
    }

    public void close() {
        block2: {
            try {
                DirectMemoryUtils.clean((ByteBuffer)this.backingBuffer);
            }
            catch (Exception e) {
                LOG.warn("Error cleaning up buffer", (Throwable)e);
                if (!LOG.isDebugEnabled()) break block2;
                Throwables.propagate((Throwable)e);
            }
        }
    }

    public void sort() {
        QuickSort quickSort = new QuickSort();
        quickSort.sort((IndexedSortable)this, 0, this.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            System.out.println("SequenceIDBuffer");
            SequenceIDBuffer buffer = new SequenceIDBuffer(0xC80000);
            buffer.close();
            System.out.println("Array");
            long[] lArray = new long[0xC80000];
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            Thread.sleep(Long.MAX_VALUE);
        }
    }
}

